/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.routing;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.CommonHelper;
import schmoller.tubes.api.helpers.TubeHelper;
import schmoller.tubes.api.interfaces.ITubeConnectable;
import schmoller.tubes.api.interfaces.ITubeOverflowDestination;

public class BlockedRouter
extends BaseRouter {
    private TubeItem mItem;

    public BlockedRouter(IBlockAccess world, Position position, TubeItem item) {
        this.mItem = item.clone();
        this.setup(world, position);
    }

    @Override
    protected void getNextLocations(BaseRouter.PathLocation current) {
        this.mItem.colour = current.color;
        this.mItem.direction = current.dir;
        int conns = TubeHelper.getConnectivity(this.getWorld(), current.position);
        ITubeConnectable myCon = TubeHelper.getTubeConnectable(this.getWorld(), current.position.x, current.position.y, current.position.z);
        int allowed = myCon != null ? myCon.getRoutableDirections(this.mItem) : 63;
        conns &= allowed;
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(current, i);
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                this.mItem.direction = loc.dir;
                this.mItem.colour = loc.color;
                this.mItem.state = 2;
                if (!con.canItemEnter(this.mItem)) continue;
                myCon.simulateEffects(this.mItem);
                loc.color = this.mItem.colour;
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected void getInitialLocations(Position position) {
        int conns = TubeHelper.getConnectivity(this.getWorld(), position);
        ITubeConnectable myCon = TubeHelper.getTubeConnectable(this.getWorld(), position.x, position.y, position.z);
        int allowed = myCon != null ? myCon.getRoutableDirections(this.mItem) : 63;
        conns &= allowed;
        for (int i = 0; i < 6; ++i) {
            if ((conns & 1 << i) == 0) continue;
            BaseRouter.PathLocation loc = new BaseRouter.PathLocation(position, i);
            loc.color = this.mItem.colour;
            TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), loc.position);
            ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
            if (con != null) {
                this.mItem.direction = loc.dir;
                this.mItem.colour = loc.color;
                this.mItem.state = 2;
                if (!con.canItemEnter(this.mItem)) continue;
                myCon.simulateEffects(this.mItem);
                loc.color = this.mItem.colour;
                loc.dist += con.getRouteWeight() - 1;
            }
            this.addSearchPoint(loc);
        }
    }

    @Override
    protected boolean isTerminator(Position current, int side) {
        TileEntity ent = CommonHelper.getTileEntity(this.getWorld(), current);
        ITubeConnectable con = TubeHelper.getTubeConnectable(ent);
        return con instanceof ITubeOverflowDestination && ((ITubeOverflowDestination)((Object)con)).canAcceptOverflowFromSide(side);
    }
}

