/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import schmoller.tubes.ItemFilter;
import schmoller.tubes.ModTubes;
import schmoller.tubes.api.FilterRegistry;
import schmoller.tubes.api.Payload;
import schmoller.tubes.api.SizeMode;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.interfaces.IFilter;
import schmoller.tubes.api.interfaces.ITubeConnectable;

public class FilterTube
extends BaseTube {
    private IFilter[] mFilterStacks;
    private Mode mCurrentMode = Mode.Allow;
    private Comparison mCurrentComparison = Comparison.Any;
    private int mColor = -1;

    public FilterTube() {
        super("filter");
        this.mFilterStacks = new IFilter[16];
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        player.openGui((Object)ModTubes.instance, 1, this.world(), this.x(), this.y(), this.z());
        return true;
    }

    public void setFilter(int index, IFilter filter) {
        this.mFilterStacks[index] = filter;
    }

    public IFilter getFilter(int index) {
        return this.mFilterStacks[index];
    }

    public void setMode(Mode mode) {
        this.mCurrentMode = mode;
    }

    public Mode getMode() {
        return this.mCurrentMode;
    }

    public void setComparison(Comparison comp) {
        this.mCurrentComparison = comp;
    }

    public Comparison getComparison() {
        return this.mCurrentComparison;
    }

    public void setColour(short colour) {
        this.mColor = colour;
    }

    public int getColour() {
        return this.mColor;
    }

    private boolean doesMatchFilter(Payload item, int index) {
        if (this.mFilterStacks[index] == null || !this.mFilterStacks[index].matches(item, SizeMode.Max)) {
            return this.mCurrentMode == Mode.Deny;
        }
        boolean matches = false;
        switch (this.mCurrentComparison) {
            case Any: {
                matches = true;
                break;
            }
            case Exact: {
                matches = this.mFilterStacks[index].matches(item, SizeMode.Exact);
                break;
            }
            case Greater: {
                matches = !this.mFilterStacks[index].matches(item, SizeMode.LessEqual);
                break;
            }
            case Less: {
                boolean bl = matches = !this.mFilterStacks[index].matches(item, SizeMode.GreaterEqual);
            }
        }
        if (this.mCurrentMode == Mode.Deny) {
            matches = !matches;
        }
        return matches;
    }

    private boolean doesMatchFilter(TubeItem item, int index) {
        if (this.mFilterStacks[index] == null || !this.mFilterStacks[index].matches(item, SizeMode.Max)) {
            return this.mCurrentMode == Mode.Deny;
        }
        boolean matches = false;
        switch (this.mCurrentComparison) {
            case Any: {
                matches = true;
                break;
            }
            case Exact: {
                matches = this.mFilterStacks[index].matches(item, SizeMode.Exact);
                break;
            }
            case Greater: {
                matches = !this.mFilterStacks[index].matches(item, SizeMode.LessEqual);
                break;
            }
            case Less: {
                boolean bl = matches = !this.mFilterStacks[index].matches(item, SizeMode.GreaterEqual);
            }
        }
        if (this.mCurrentMode == Mode.Deny) {
            matches = !matches;
        }
        return matches;
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        boolean empty = true;
        for (int i = 0; i < this.mFilterStacks.length; ++i) {
            if (this.mFilterStacks[i] == null) continue;
            empty = false;
            if (this.mCurrentMode == Mode.Allow) {
                if (!this.doesMatchFilter(item, i)) continue;
                return true;
            }
            if (this.doesMatchFilter(item, i)) continue;
            return false;
        }
        if (empty) {
            return true;
        }
        return this.mCurrentMode == Mode.Deny;
    }

    @Override
    public boolean canAddItem(Payload item, int direction) {
        boolean empty = true;
        for (int i = 0; i < this.mFilterStacks.length; ++i) {
            if (this.mFilterStacks[i] == null) continue;
            empty = false;
            if (this.mCurrentMode == Mode.Allow) {
                if (!this.doesMatchFilter(item, i)) continue;
                return true;
            }
            if (this.doesMatchFilter(item, i)) continue;
            return false;
        }
        if (empty) {
            return true;
        }
        return this.mCurrentMode == Mode.Deny;
    }

    @Override
    public void simulateEffects(TubeItem item) {
        item.colour = this.mColor;
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        item.colour = this.mColor;
        return super.onItemJunction(item);
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return !(con instanceof FilterTube);
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.mFilterStacks.length; ++i) {
            if (this.mFilterStacks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            FilterRegistry.getInstance().writeFilter(this.mFilterStacks[i], tag);
            items.func_74742_a((NBTBase)tag);
        }
        root.func_74782_a("NewFilter", (NBTBase)items);
        root.func_74768_a("mode", this.mCurrentMode.ordinal());
        root.func_74768_a("comp", this.mCurrentComparison.ordinal());
        root.func_74777_a("Color", (short)this.mColor);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        if (root.func_74764_b("filter")) {
            NBTTagList items = root.func_74761_m("filter");
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)items.func_74743_b(i);
                int slot = tag.func_74762_e("Slot");
                this.mFilterStacks[slot] = new ItemFilter(ItemStack.func_77949_a((NBTTagCompound)tag), false);
            }
        } else {
            NBTTagList filters = root.func_74761_m("NewFilter");
            for (int i = 0; i < filters.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)filters.func_74743_b(i);
                int slot = tag.func_74762_e("Slot");
                this.mFilterStacks[slot] = FilterRegistry.getInstance().readFilter(tag);
            }
        }
        this.mCurrentMode = Mode.values()[root.func_74762_e("mode")];
        this.mCurrentComparison = Comparison.values()[root.func_74762_e("comp")];
        this.mColor = root.func_74765_d("Color");
    }

    @Override
    public void writeDesc(MCDataOutput output) {
        super.writeDesc(output);
        output.writeByte(this.mCurrentMode.ordinal());
        output.writeByte(this.mCurrentComparison.ordinal());
        for (int i = 0; i < this.mFilterStacks.length; ++i) {
            if (this.mFilterStacks[i] != null) {
                output.writeBoolean(true);
                FilterRegistry.getInstance().writeFilter(this.mFilterStacks[i], output);
                continue;
            }
            output.writeBoolean(false);
        }
        output.writeShort(this.mColor);
    }

    @Override
    public void readDesc(MCDataInput input) {
        super.readDesc(input);
        this.mCurrentMode = Mode.values()[input.readByte()];
        this.mCurrentComparison = Comparison.values()[input.readByte()];
        for (int i = 0; i < this.mFilterStacks.length; ++i) {
            if (!input.readBoolean()) continue;
            this.mFilterStacks[i] = FilterRegistry.getInstance().readFilter(input);
        }
        this.mColor = input.readShort();
    }

    public static enum Comparison {
        Any,
        Exact,
        Less,
        Greater;

    }

    public static enum Mode {
        Allow,
        Deny;

    }
}

