/*
 * Decompiled with CFR 0.152.
 */
package schmoller.tubes.types;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import schmoller.tubes.api.FluidPayload;
import schmoller.tubes.api.OverflowBuffer;
import schmoller.tubes.api.Position;
import schmoller.tubes.api.TubeItem;
import schmoller.tubes.api.helpers.BaseRouter;
import schmoller.tubes.api.helpers.BaseTube;
import schmoller.tubes.api.interfaces.ITubeConnectable;
import schmoller.tubes.api.interfaces.ITubeOverflowDestination;
import schmoller.tubes.routing.OutputRouter;

public class TankTube
extends BaseTube
implements IFluidHandler,
ITubeOverflowDestination {
    private FluidTank mTank = new FluidTank(1000);
    private OverflowBuffer mOverflow = new OverflowBuffer();
    public static final int CHANNEL_FLUID = 10;
    private long mLastUpdate = 0L;
    private boolean mHasUpdated = true;

    public TankTube() {
        super("tank");
    }

    @Override
    public boolean canAcceptOverflowFromSide(int side) {
        return true;
    }

    public FluidStack getFluid() {
        return this.mTank.getFluid();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.mTank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.onFluidChange();
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!resource.isFluidEqual(this.mTank.getFluid())) {
            return null;
        }
        FluidStack drained = this.mTank.drain(resource.amount, doDrain);
        if (drained != null && doDrain) {
            this.onFluidChange();
        }
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.mTank.drain(maxDrain, doDrain);
        if (drained != null && doDrain) {
            this.onFluidChange();
        }
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.mTank.getInfo()};
    }

    @Override
    public boolean canConnectToInventories() {
        return false;
    }

    @Override
    public boolean canConnectTo(ITubeConnectable con) {
        return !(con instanceof TankTube);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (item == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)item)) {
            if (player.field_70170_p.field_72995_K) {
                return true;
            }
            if (this.mTank.getFluidAmount() == 0) {
                return true;
            }
            ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)this.mTank.getFluid(), (ItemStack)item);
            if (filled != null) {
                FluidStack drained = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
                this.mTank.drain(drained.amount, true);
                this.onFluidChange();
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = filled;
                player.field_71071_by.func_70296_d();
                return true;
            }
        } else if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
            if (player.field_70170_p.field_72995_K) {
                return true;
            }
            FluidStack container = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (this.mTank.fill(container, false) == container.amount) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (item.func_77973_b().func_77634_r()) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = item.func_77973_b().getContainerItemStack(item);
                    } else {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                }
                this.mTank.fill(container, true);
                this.onFluidChange();
            }
            return true;
        }
        return false;
    }

    private void updateIfNeeded() {
        if (!this.mHasUpdated && System.currentTimeMillis() - this.mLastUpdate > 200L) {
            this.mLastUpdate = System.currentTimeMillis();
            this.mHasUpdated = true;
            this.openChannel(10).writeFluidStack(this.mTank.getFluid());
        }
    }

    private void onFluidChange() {
        this.mHasUpdated = false;
    }

    @Override
    protected boolean onItemJunction(TubeItem item) {
        if (item.state == 2) {
            if (!this.world().field_72995_K) {
                this.mOverflow.addItem(item);
            }
            return false;
        }
        return super.onItemJunction(item);
    }

    @Override
    public boolean canItemEnter(TubeItem item) {
        return item.state == 2;
    }

    @Override
    public int getTickRate() {
        return 10;
    }

    @Override
    public void onTick() {
        if (this.world().field_72995_K) {
            return;
        }
        this.updateIfNeeded();
        if (!this.mOverflow.isEmpty()) {
            TubeItem item = this.mOverflow.peekNext();
            BaseRouter.PathLocation loc = new OutputRouter((IBlockAccess)this.world(), new Position(this.x(), this.y(), this.z()), item).route();
            if (loc != null) {
                this.mOverflow.getNext();
                item.state = 0;
                item.lastDirection = 6;
                item.direction = 6;
                item.updated = false;
                item.setProgress(0.5f);
                this.addItem(item, false);
            }
        } else if (this.mTank.getFluidAmount() > 0 && this.getNumConnections() > 0) {
            this.addItem(new FluidPayload(this.mTank.getFluid()), -1);
            this.mTank.setFluid(null);
            this.onFluidChange();
        }
    }

    @Override
    public void save(NBTTagCompound root) {
        super.save(root);
        if (this.mTank.getFluidAmount() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            this.mTank.getFluid().writeToNBT(tag);
            root.func_74782_a("fluid", (NBTBase)tag);
        }
        this.mOverflow.save(root);
    }

    @Override
    public void load(NBTTagCompound root) {
        super.load(root);
        if (root.func_74764_b("fluid")) {
            this.mTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)root.func_74775_l("fluid")));
        }
        this.mOverflow.load(root);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeFluidStack(this.mTank.getFluid());
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.mTank.setFluid(packet.readFluidStack());
    }

    @Override
    protected void onRecieveDataClient(int channel, MCDataInput input) {
        if (channel == 10) {
            this.mTank.setFluid(input.readFluidStack());
        } else {
            super.onRecieveDataClient(channel, input);
        }
    }

    @Override
    public int getHollowSize(int side) {
        return 10;
    }

    @Override
    protected void onDropItems(List<ItemStack> itemsToDrop) {
        super.onDropItems(itemsToDrop);
        this.mOverflow.onDropItems(itemsToDrop);
    }
}

