/*
 * Decompiled with CFR 0.152.
 */
package net.foxgenesis.walkwaymod;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.foxgenesis.walkwaymod.CommonProxy;
import net.foxgenesis.walkwaymod.GuiHandler;
import net.foxgenesis.walkwaymod.blocks.ModBlocks;
import net.foxgenesis.walkwaymod.crafting.ModCrafting;
import net.foxgenesis.walkwaymod.event.BoneMealEvent;
import net.foxgenesis.walkwaymod.gen.TreeWorldGen;
import net.foxgenesis.walkwaymod.items.ModItems;
import net.foxgenesis.walkwaymod.web.WebValues;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="walkwaymod", name="Walkway Mod", version="1.0")
public class WalkwayMod {
    public static final String VERSION = "1.0";
    public static final String MODID = "walkwaymod";
    public static final String NAME = "Walkway Mod";
    public static final String DESCRIPTION = "";
    public static final String LOGO = "/logo.png";
    public static final String TEXTURE_FOLDER = "walkwaymod:textures/";
    public static final String MODEL_TEXTURE_FOLDER = "walkwaymod:textures/model/";
    @Mod.Instance(value="WalkwayMod")
    public static WalkwayMod instance;
    public static WebValues webvalues;
    @SidedProxy(clientSide="net.foxgenesis.walkwaymod.ClientProxy", serverSide="net.foxgenesis.walkwaymod.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabWalkwayMod;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModLogger.log = event.getModLog();
        event.getModMetadata().version = VERSION;
        event.getModMetadata().name = NAME;
        event.getModMetadata().description = DESCRIPTION;
        event.getModMetadata().authorList.add("fox_news");
        event.getModMetadata().logoFile = LOGO;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        instance = this;
        ModLogger.log.info("loading Walkway Mod version:[1.0] ...");
        proxy.registerRenderers();
        ModLogger.log.info("loading gui handler...");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ModLogger.log.info("loading bone meal event manager...");
        MinecraftForge.EVENT_BUS.register((Object)new BoneMealEvent());
        ModBlocks.init();
        ModItems.init();
        ModCrafting.init();
        ModLogger.log.info("loading world tree gen...");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TreeWorldGen(), (int)0);
        ModLogger.log.info("LOADED Walkway Mod version:[1.0]!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        webvalues = new WebValues();
        tabWalkwayMod = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return Item.func_150898_a((Block)ModBlocks.walkway);
            }
        };
    }

    public static final class ModLogger {
        public static Logger log;
    }
}

