package mods.immibis.autofood;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import mods.immibis.core.api.util.BaseContainer;

public class AutoFeederContainer extends BaseContainer<AutoFeederTile> {

	public AutoFeederContainer(EntityPlayer player, AutoFeederTile inv) {
		super(player, inv);
		
		for(int x = 0; x < 9; x++)
			addSlotToContainer(new Slot(player.inventory, x, 8+18*x, 142));
		
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlotToContainer(new Slot(player.inventory, x+y*9+9, 8+18*x, 84+18*y));
		
		addSlotToContainer(new Slot(inv, 0, 66, 33));
		addSlotToContainer(new Slot(inv, 1, 95, 33));
	}

	public int getRange() {
		return inv.getRange();
	}

}
