/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.packets;

import com.mrcrayfish.furniture.inventory.InventoryPresent;
import com.mrcrayfish.furniture.network.AbstractPacket;
import com.mrcrayfish.furniture.tileentity.TileEntityPresent;
import com.mrcrayfish.furniture.util.NBTHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketPresent
extends AbstractPacket {
    private ItemStack present;
    private int x;
    private int y;
    private int z;

    public PacketPresent() {
    }

    public PacketPresent(ItemStack present, int x, int y, int z) {
        this.present = present;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.present);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.present = ByteBufUtils.readItemStack((ByteBuf)buffer);
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        InventoryPresent presentInventory = new InventoryPresent(player, this.present);
        String author = NBTHelper.getString(this.present, "Author");
        TileEntity tile_entity = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (tile_entity instanceof TileEntityPresent) {
            TileEntityPresent tileEntityPresent = (TileEntityPresent)tile_entity;
            for (int i = 0; i < presentInventory.func_70302_i_(); ++i) {
                tileEntityPresent.setContents(i, presentInventory.func_70301_a(i));
            }
            tileEntityPresent.setOwner(author);
        }
    }
}

