/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import lotr.client.LOTRClientProxy;
import lotr.client.LOTRTickHandlerClient;
import lotr.client.gui.LOTRGui;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LOTRGuiAlignment
extends LOTRGui {
    private static int currentFactionIndex = 0;
    private LOTRFaction currentFaction = LOTRFaction.values()[currentFactionIndex];
    private static final int maxAlignmentsDisplayed = 5;

    @Override
    public void func_73866_w_() {
        this.xSize = 220;
        super.func_73866_w_();
        currentFactionIndex = Math.min(LOTRTickHandlerClient.currentAlignmentFaction.ordinal(), LOTRFaction.totalPlayerFactions - 5);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.updateCurrentFaction();
    }

    private void updateCurrentFaction() {
        this.currentFaction = LOTRFaction.values()[currentFactionIndex];
    }

    public void func_73863_a(int i, int j, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String s = StatCollector.func_74838_a((String)"lotr.gui.alignment.title");
        this.field_146289_q.func_78276_b(s, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(s) / 2, this.guiTop - 30, 0xFFFFFF);
        super.func_73863_a(i, j, f);
        int x = this.guiLeft + this.xSize / 2;
        int y = this.guiTop;
        for (int l = currentFactionIndex; l < currentFactionIndex + 5 && l < LOTRFaction.values().length; ++l) {
            LOTRFaction faction = LOTRFaction.values()[l];
            if (!faction.allowPlayer) continue;
            int alignment = LOTRLevelData.getAlignment((EntityPlayer)this.field_146297_k.field_71439_g, faction);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
            this.func_73729_b(x - 116, y, 0, 0, 232, 18);
            GL11.glColor4f((float)faction.factionColors[0], (float)faction.factionColors[1], (float)faction.factionColors[2], (float)1.0f);
            this.func_73729_b(x - 116, y, 0, 34, 232, 18);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x - 8 + LOTRTickHandlerClient.calculateAlignmentDisplay(alignment), y + 1, 0, 18, 16, 16);
            s = faction.factionName();
            LOTRTickHandlerClient.drawTextWithShadow(this.field_146289_q, x - this.field_146289_q.func_78256_a(s) / 2, y += 22, s, 1.0f);
            int max = LOTRTickHandlerClient.calculateMaxDisplayValue(alignment);
            String sMax = "+" + String.valueOf(max);
            String sMin = "-" + String.valueOf(max);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int xMax = x * 2 - 220 - this.field_146289_q.func_78256_a(sMax) / 2;
            int xMin = x * 2 + 220 - this.field_146289_q.func_78256_a(sMax) / 2;
            LOTRTickHandlerClient.drawTextWithShadow(this.field_146289_q, xMax, y *= 2, sMax, 1.0f);
            LOTRTickHandlerClient.drawTextWithShadow(this.field_146289_q, xMin, y, sMin, 1.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            y /= 2;
            y += this.field_146289_q.field_78288_b + 4;
            s = String.valueOf(alignment);
            if (alignment > 0) {
                s = "+" + s;
            }
            LOTRTickHandlerClient.drawTextWithShadow(this.field_146289_q, x - this.field_146289_q.func_78256_a(s) / 2, y, s, 1.0f);
            y += 20;
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (i == 208) {
            this.increaseFactionIndex();
            return;
        }
        if (i == 200) {
            this.decreaseFactionIndex();
            return;
        }
        super.func_73869_a(c, i);
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            if (i < 0) {
                this.increaseFactionIndex();
            }
            if (i > 0) {
                this.decreaseFactionIndex();
            }
        }
    }

    private void decreaseFactionIndex() {
        currentFactionIndex = Math.max(currentFactionIndex - 1, 0);
    }

    private void increaseFactionIndex() {
        currentFactionIndex = Math.min(currentFactionIndex + 1, LOTRFaction.totalPlayerFactions - 5);
    }
}

