/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lotr.client.LOTRKeyHandler;
import lotr.client.gui.LOTRGui;
import lotr.common.LOTRAbstractWaypoint;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.genlayer.LOTRGenLayerWorld;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.chunk.EmptyChunk;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LOTRGuiMap
extends LOTRGui {
    private static ResourceLocation mapTexture = new ResourceLocation("lotr:map/map.png");
    private static ResourceLocation borderTexture = new ResourceLocation("lotr:map/mapScreen.png");
    public static Map playerLocations = new HashMap();
    private static Map playerSkins = new HashMap();
    private static final int MIN_ZOOM = -3;
    private static final int MAX_ZOOM = 2;
    private static final int mapXSize = 256;
    private static final int mapYSize = 200;
    private static final int addWPButtonX = 240;
    private static final int addWPButtonY = 6;
    private static final int addWPButtonWidth = 10;
    private static final int delWPButtonX = 240;
    private static final int delWPButtonY = 18;
    private static final int delWPButtonWidth = 10;
    private static int zoom = 0;
    public boolean isPlayerOp = false;
    private double zoomPower;
    private int posX;
    private int posY;
    private int isMouseButtonDown;
    private int prevMouseX;
    private int prevMouseY;
    private int mouseXCoord;
    private int mouseZCoord;
    private boolean isMouseWithinMap;
    private LOTRAbstractWaypoint selectedWaypoint;
    private boolean hasOverlay;
    private String[] overlayDisplayString;
    private boolean canCreateWaypoint;
    private boolean creatingWaypoint;
    private GuiTextField nameWaypointTextField;
    private boolean deletingWaypoint;

    public LOTRGuiMap() {
        if (LOTRGenLayerWorld.biomeImageData == null) {
            new LOTRGenLayerWorld();
        }
    }

    @Override
    public void func_73866_w_() {
        this.xSize = 256;
        this.ySize = 256;
        super.func_73866_w_();
        this.posX = (int)this.field_146297_k.field_71439_g.field_70165_t / LOTRGenLayerWorld.scale + LOTRGenLayerWorld.originX;
        this.posY = (int)this.field_146297_k.field_71439_g.field_70161_v / LOTRGenLayerWorld.scale + LOTRGenLayerWorld.originZ;
        this.nameWaypointTextField = new GuiTextField(this.field_146289_q, this.guiLeft + 128 - 80, this.guiTop + 40, 160, 20);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.creatingWaypoint) {
            this.nameWaypointTextField.func_146178_a();
        }
    }

    public void func_73863_a(int i, int j, float f) {
        int y;
        int x;
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawCenteredString(StatCollector.func_74838_a((String)"lotr.gui.map.title"), this.guiLeft + 128, this.guiTop - 30, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(mapTexture);
        this.zoomPower = Math.pow(2.0, zoom);
        int zoomScaleX = (int)Math.round(256.0 / this.zoomPower);
        int zoomScaleY = (int)Math.round(200.0 / this.zoomPower);
        int i1 = this.guiLeft + 4;
        int i2 = this.guiLeft + 256 - 4;
        int j1 = this.guiTop + 4;
        int j2 = this.guiTop + 200 - 4;
        boolean bl = this.isMouseWithinMap = i >= i1 && i < i2 && j >= j1 && j < j2;
        if (!this.hasOverlay && Mouse.isButtonDown((int)0)) {
            if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && this.isMouseWithinMap) {
                if (this.isMouseButtonDown == 0) {
                    this.isMouseButtonDown = 1;
                } else {
                    int x2 = (int)((double)(i - this.prevMouseX) / this.zoomPower);
                    int y2 = (int)((double)(j - this.prevMouseY) / this.zoomPower);
                    this.posX -= x2;
                    this.posY -= y2;
                    if (x2 != 0 || y2 != 0) {
                        this.selectedWaypoint = null;
                    }
                }
                this.prevMouseX = i;
                this.prevMouseY = j;
            }
        } else {
            this.isMouseButtonDown = 0;
        }
        int minX = this.posX - zoomScaleX / 2;
        int maxX = this.posX + zoomScaleX / 2;
        if (minX < 0) {
            this.posX = 0 + zoomScaleX / 2;
        }
        if (maxX >= LOTRGenLayerWorld.imageWidth) {
            this.posX = LOTRGenLayerWorld.imageWidth - zoomScaleX / 2;
        }
        int minY = this.posY - zoomScaleY / 2;
        int maxY = this.posY + zoomScaleY / 2;
        if (minY < 0) {
            this.posY = 0 + zoomScaleY / 2;
        }
        if (maxY >= LOTRGenLayerWorld.imageHeight) {
            this.posY = LOTRGenLayerWorld.imageHeight - zoomScaleY / 2;
        }
        double minU = (double)(this.posX - zoomScaleX / 2) / (double)LOTRGenLayerWorld.imageWidth;
        double maxU = (double)(this.posX + zoomScaleX / 2) / (double)LOTRGenLayerWorld.imageWidth;
        double minV = (double)(this.posY - zoomScaleY / 2) / (double)LOTRGenLayerWorld.imageHeight;
        double maxV = (double)(this.posY + zoomScaleY / 2) / (double)LOTRGenLayerWorld.imageHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.guiLeft, (double)(this.guiTop + 200), (double)this.field_73735_i, minU, maxV);
        tessellator.func_78374_a((double)(this.guiLeft + 256), (double)(this.guiTop + 200), (double)this.field_73735_i, maxU, maxV);
        tessellator.func_78374_a((double)(this.guiLeft + 256), (double)this.guiTop, (double)this.field_73735_i, maxU, minV);
        tessellator.func_78374_a((double)this.guiLeft, (double)this.guiTop, (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
        if (!this.hasOverlay && this.isMiddleEarth() && this.selectedWaypoint != null) {
            String s;
            boolean hasUnlocked = this.selectedWaypoint.hasPlayerUnlocked((EntityPlayer)this.field_146297_k.field_71439_g);
            int fastTravel = LOTRLevelData.getFastTravelTimer((EntityPlayer)this.field_146297_k.field_71439_g);
            boolean canFastTravel = fastTravel <= 0 && hasUnlocked;
            int border = 3;
            int stringHeight = this.field_146289_q.field_78288_b;
            int x3 = this.guiLeft;
            int y3 = this.guiTop + 200 + 10;
            int rectWidth = 256;
            int rectHeight = border * 2 + stringHeight;
            if (canFastTravel) {
                rectHeight += (stringHeight + border) * 2;
            }
            LOTRGuiMap.func_73734_a((int)x3, (int)y3, (int)(x3 + rectWidth), (int)(y3 + rectHeight), (int)-1073741824);
            if (!hasUnlocked) {
                s = "If you can see this message, something has gone hideously wrong";
                s = !this.selectedWaypoint.isUnlockable((EntityPlayer)this.field_146297_k.field_71439_g) ? StatCollector.func_74838_a((String)"lotr.gui.map.waypointUnavailableEnemy") : StatCollector.func_74838_a((String)"lotr.gui.map.waypointUnavailableTravel");
                this.drawCenteredString(s, this.guiLeft + 128, y3 + border, 0xFFFFFF);
            } else if (canFastTravel) {
                s = StatCollector.func_74837_a((String)"lotr.gui.map.fastTravel", (Object[])new Object[]{GameSettings.func_74298_c((int)LOTRKeyHandler.keyBindingFastTravel.func_151463_i())});
                this.drawCenteredString(s, this.guiLeft + 128, y3 + border, 0xFFFFFF);
                s = StatCollector.func_74838_a((String)"lotr.gui.map.fastTravelTimeWarning");
                this.drawCenteredString(s, this.guiLeft + 128, y3 + (stringHeight + border) * 2, 0xFFFFFF);
            } else {
                s = StatCollector.func_74837_a((String)"lotr.gui.map.fastTravelTimeRemaining", (Object[])new Object[]{LOTRLevelData.getHoursMinutesTime(fastTravel)});
                this.drawCenteredString(s, this.guiLeft + 128, y3 + border, 0xFFFFFF);
            }
        } else if (!this.hasOverlay && this.isMouseWithinMap) {
            int biomePosX = this.posX + (int)Math.round((double)(i - this.guiLeft - 128) / this.zoomPower);
            int biomePosZ = this.posY + (int)Math.round((double)(j - this.guiTop - 100) / this.zoomPower);
            int biomeID = LOTRGenLayerWorld.biomeImageData[biomePosZ * LOTRGenLayerWorld.imageWidth + biomePosX];
            LOTRBiome biome = LOTRBiome.lotrBiomeList[biomeID];
            if (biome instanceof LOTRBiome) {
                String biomeName = biome.getBiomeDisplayName();
                int border = 3;
                int stringHeight = this.field_146289_q.field_78288_b;
                int x4 = this.guiLeft;
                int y4 = this.guiTop + 200 + 10;
                int rectWidth = 256;
                int rectHeight = border * 3 + stringHeight * 2;
                if (this.canTeleport()) {
                    rectHeight += (stringHeight + border) * 2;
                }
                LOTRGuiMap.func_73734_a((int)x4, (int)y4, (int)(x4 + rectWidth), (int)(y4 + rectHeight), (int)-1073741824);
                this.drawCenteredString(biomeName, this.guiLeft + 128, y4 + border, 0xFFFFFF);
                this.mouseXCoord = (biomePosX - LOTRGenLayerWorld.originX) * LOTRGenLayerWorld.scale;
                this.mouseZCoord = (biomePosZ - LOTRGenLayerWorld.originZ) * LOTRGenLayerWorld.scale;
                String coords = "x: " + this.mouseXCoord + ", z: " + this.mouseZCoord;
                int stringX = this.guiLeft + 128;
                int stringY = y4 + border * 2 + stringHeight;
                this.drawCenteredString(coords, stringX, stringY, 0xFFFFFF);
                if (this.canTeleport()) {
                    String teleport = StatCollector.func_74837_a((String)"lotr.gui.map.tp", (Object[])new Object[]{GameSettings.func_74298_c((int)LOTRKeyHandler.keyBindingMapTeleport.func_151463_i())});
                    this.drawCenteredString(teleport, stringX, stringY + (stringHeight + border) * 2, 0xFFFFFF);
                }
            }
        }
        for (UUID player : playerLocations.keySet()) {
            PlayerLocationInfo info = (PlayerLocationInfo)playerLocations.get(player);
            this.renderPlayer(player, info.name, info.posX, info.posZ, i, j);
        }
        if (this.isMiddleEarth()) {
            this.renderPlayer(this.field_146297_k.field_71439_g.func_110124_au(), this.field_146297_k.field_71439_g.func_70005_c_(), this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, i, j);
        }
        this.field_146297_k.func_110434_K().func_110577_a(borderTexture);
        List waypoints = LOTRWaypoint.getListOfAllWaypoints((EntityPlayer)this.field_146297_k.field_71439_g);
        for (int l = 0; l < waypoints.size(); ++l) {
            LOTRAbstractWaypoint waypoint = (LOTRAbstractWaypoint)waypoints.get(l);
            x = MathHelper.func_76128_c((double)((double)(waypoint.getX() - this.posX) * this.zoomPower)) + 128;
            y = MathHelper.func_76128_c((double)((double)(waypoint.getY() - this.posY) * this.zoomPower)) + 100;
            if (x - 2 < 0 || x + 2 > 256 || y - 2 < 0 || y + 2 > 200) continue;
            boolean flag = waypoint.hasPlayerUnlocked((EntityPlayer)this.field_146297_k.field_71439_g);
            this.func_73729_b(this.guiLeft + x - 2, this.guiTop + y - 2, flag ? 4 : 0, 200, 4, 4);
        }
        if (this.selectedWaypoint != null) {
            String name = this.selectedWaypoint.getDisplayName();
            String coords = "x: " + this.selectedWaypoint.getXCoord() + ", z: " + this.selectedWaypoint.getZCoord();
            x = MathHelper.func_76128_c((double)((double)(this.selectedWaypoint.getX() - this.posX) * this.zoomPower)) + 128;
            y = MathHelper.func_76128_c((double)((double)(this.selectedWaypoint.getY() - this.posY) * this.zoomPower)) + 100;
            y += 5;
            x += this.guiLeft;
            y += this.guiTop;
            int border = 3;
            int stringHeight = this.field_146289_q.field_78288_b;
            int rectWidth = Math.max(this.field_146289_q.func_78256_a(name), this.field_146289_q.func_78256_a(coords)) + border * 2;
            x -= rectWidth / 2;
            int rectHeight = border * 3 + stringHeight * 2;
            x = Math.max(x, this.guiLeft + 6);
            x = Math.min(x, this.guiLeft + 256 - 6 - rectWidth);
            y = Math.max(y, this.guiTop + 6);
            y = Math.min(y, this.guiTop + 200 - 6 - rectHeight);
            LOTRGuiMap.func_73734_a((int)x, (int)y, (int)(x + rectWidth), (int)(y + rectHeight), (int)-1073741824);
            int stringX = x + rectWidth / 2;
            int stringY = y + border;
            this.drawCenteredString(name, stringX, stringY, 0xFFFFFF);
            this.drawCenteredString(coords, stringX, stringY + stringHeight + border, 0xFFFFFF);
        }
        this.field_146297_k.func_110434_K().func_110577_a(borderTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 200);
        if (this.isMiddleEarth()) {
            this.func_73729_b(this.guiLeft + 240, this.guiTop + 6, 0, 204, 10, 10);
            if (this.selectedWaypoint instanceof LOTRWaypoint.Custom) {
                this.func_73729_b(this.guiLeft + 240, this.guiTop + 18, 0, 214, 10, 10);
            }
        }
        if (this.hasOverlay) {
            int x5 = this.guiLeft + 4;
            int y5 = this.guiTop + 4;
            int x1 = this.guiLeft + 256 - 4;
            int y1 = this.guiTop + 200 - 4;
            LOTRGuiMap.func_73734_a((int)x5, (int)y5, (int)x1, (int)y1, (int)-1073741824);
            if (this.overlayDisplayString != null) {
                int stringX = this.guiLeft + 128;
                int stringY = y5 + 3 + this.field_146297_k.field_71466_p.field_78288_b;
                for (String s : this.overlayDisplayString) {
                    this.drawCenteredString(s, stringX, stringY, 0xFFFFFF);
                    stringY += this.field_146297_k.field_71466_p.field_78288_b;
                }
            }
            if (this.creatingWaypoint) {
                GL11.glDisable((int)2896);
                this.nameWaypointTextField.func_146194_f();
                GL11.glEnable((int)2896);
            }
        }
        super.func_73863_a(i, j, f);
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (this.hasOverlay) {
            if (this.canCreateWaypoint && i == 28) {
                this.canCreateWaypoint = false;
                this.creatingWaypoint = true;
                this.overlayDisplayString = new String[]{StatCollector.func_74838_a((String)"lotr.gui.map.customWaypoint.create.1"), "", "", "", "", "", StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.create.2", (Object[])new Object[]{GameSettings.func_74298_c((int)28)})};
                return;
            }
            if (this.creatingWaypoint && !this.nameWaypointTextField.func_146179_b().isEmpty() && i == 28) {
                String waypointName = this.nameWaypointTextField.func_146179_b();
                ByteBuf data = Unpooled.buffer();
                data.writeInt(this.field_146297_k.field_71439_g.func_145782_y());
                data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
                byte[] bytes = waypointName.getBytes(Charsets.UTF_8);
                data.writeShort(bytes.length);
                data.writeBytes(bytes);
                C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.createCWP", data);
                this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
                this.closeOverlay();
                return;
            }
            if (this.creatingWaypoint && this.nameWaypointTextField.func_146201_a(c, i)) {
                return;
            }
            if (this.deletingWaypoint && i == 28) {
                ByteBuf data = Unpooled.buffer();
                data.writeInt(this.field_146297_k.field_71439_g.func_145782_y());
                data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
                data.writeInt(this.selectedWaypoint.getID());
                C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.deleteCWP", data);
                this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
                this.closeOverlay();
                this.selectedWaypoint = null;
                return;
            }
            if (i == 1 || i == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
                this.closeOverlay();
                return;
            }
        } else if (i == LOTRKeyHandler.keyBindingFastTravel.func_151463_i() && this.isMiddleEarth() && this.selectedWaypoint != null && this.selectedWaypoint.hasPlayerUnlocked((EntityPlayer)this.field_146297_k.field_71439_g) && LOTRLevelData.getFastTravelTimer((EntityPlayer)this.field_146297_k.field_71439_g) <= 0) {
            ByteBuf data = Unpooled.buffer();
            data.writeInt(this.field_146297_k.field_71439_g.func_145782_y());
            data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
            data.writeBoolean(this.selectedWaypoint instanceof LOTRWaypoint.Custom);
            data.writeInt(this.selectedWaypoint.getID());
            C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.fastTravel", data);
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.selectedWaypoint == null && i == LOTRKeyHandler.keyBindingMapTeleport.func_151463_i() && this.isMouseWithinMap && this.canTeleport()) {
            ByteBuf data = Unpooled.buffer();
            data.writeInt(this.field_146297_k.field_71439_g.func_145782_y());
            data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
            data.writeInt(this.mouseXCoord);
            data.writeInt(this.mouseZCoord);
            C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.mapTp", data);
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(c, i);
        }
    }

    private void closeOverlay() {
        this.hasOverlay = false;
        this.overlayDisplayString = null;
        this.canCreateWaypoint = false;
        this.creatingWaypoint = false;
        this.deletingWaypoint = false;
    }

    protected void func_73864_a(int i, int j, int k) {
        if (this.hasOverlay && this.creatingWaypoint) {
            this.nameWaypointTextField.func_146192_a(i, j, k);
        }
        if (!this.hasOverlay && k == 0 && this.isMiddleEarth() && this.selectedWaypoint instanceof LOTRWaypoint.Custom && i >= this.guiLeft + 240 && i < this.guiLeft + 240 + 10 && j >= this.guiTop + 18 && j < this.guiTop + 18 + 10) {
            this.hasOverlay = true;
            this.overlayDisplayString = new String[]{StatCollector.func_74838_a((String)"lotr.gui.map.customWaypoint.delete.1"), StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.delete.2", (Object[])new Object[]{this.selectedWaypoint.getDisplayName()}), "", StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.delete.3", (Object[])new Object[]{GameSettings.func_74298_c((int)28)})};
            this.deletingWaypoint = true;
            return;
        }
        if (!this.hasOverlay && k == 0 && this.isMiddleEarth() && i >= this.guiLeft + 240 && i < this.guiLeft + 240 + 10 && j >= this.guiTop + 6 && j < this.guiTop + 6 + 10) {
            this.hasOverlay = true;
            int maxWaypoints = LOTRWaypoint.Custom.MAX_CUSTOM;
            int waypoints = LOTRWaypoint.Custom.getWaypointList((EntityPlayer)this.field_146297_k.field_71439_g).size();
            int remaining = maxWaypoints - waypoints;
            if (remaining <= 0) {
                this.overlayDisplayString = new String[]{StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.allUsed.1", (Object[])new Object[]{maxWaypoints}), "", StatCollector.func_74838_a((String)"lotr.gui.map.customWaypoint.allUsed.2"), StatCollector.func_74838_a((String)"lotr.gui.map.customWaypoint.allUsed.3")};
            } else {
                this.overlayDisplayString = new String[]{StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.canCreate.1", (Object[])new Object[]{waypoints, maxWaypoints}), StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.canCreate.2", (Object[])new Object[]{remaining}), "", StatCollector.func_74837_a((String)"lotr.gui.map.customWaypoint.canCreate.3", (Object[])new Object[]{GameSettings.func_74298_c((int)28)}), StatCollector.func_74838_a((String)"lotr.gui.map.customWaypoint.canCreate.4")};
                this.canCreateWaypoint = true;
            }
            return;
        }
        if (!this.hasOverlay && k == 0 && this.isMouseWithinMap) {
            List waypoints = LOTRWaypoint.getListOfAllWaypoints((EntityPlayer)this.field_146297_k.field_71439_g);
            for (int l = 0; l < waypoints.size(); ++l) {
                LOTRAbstractWaypoint waypoint = (LOTRAbstractWaypoint)waypoints.get(l);
                int x = MathHelper.func_76128_c((double)((double)(waypoint.getX() - this.posX) * this.zoomPower)) + 128;
                int y = MathHelper.func_76128_c((double)((double)(waypoint.getY() - this.posY) * this.zoomPower)) + 100;
                if (Math.abs(x - (i - this.guiLeft)) > 3 || Math.abs(y - (j - this.guiTop)) > 3) continue;
                this.selectedWaypoint = waypoint;
                return;
            }
            this.selectedWaypoint = null;
        }
        super.func_73864_a(i, j, k);
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (!this.hasOverlay) {
            int i = Mouse.getEventDWheel();
            if (i < 0) {
                zoom = Math.max(zoom - 1, -3);
                this.selectedWaypoint = null;
            }
            if (i > 0) {
                zoom = Math.min(zoom + 1, 2);
                this.selectedWaypoint = null;
            }
        }
    }

    private void drawCenteredString(String s, int i, int j, int k) {
        this.field_146289_q.func_78276_b(s, i - this.field_146289_q.func_78256_a(s) / 2, j, k);
    }

    private boolean canTeleport() {
        if (!this.isMiddleEarth()) {
            return false;
        }
        int chunkX = MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70165_t) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70161_v) >> 4;
        if (this.field_146297_k.field_71441_e.func_72863_F().func_73154_d(chunkX, chunkZ) instanceof EmptyChunk) {
            return false;
        }
        this.requestIsOp();
        return this.isPlayerOp;
    }

    private void requestIsOp() {
        if (this.field_146297_k.func_71356_B()) {
            this.isPlayerOp = this.field_146297_k.func_71401_C().func_71203_ab().func_72353_e(this.field_146297_k.field_71439_g.func_70005_c_());
        } else {
            ByteBuf data = Unpooled.buffer();
            data.writeInt(this.field_146297_k.field_71439_g.func_145782_y());
            data.writeByte((int)((byte)this.field_146297_k.field_71439_g.field_71093_bK));
            C17PacketCustomPayload packet = new C17PacketCustomPayload("lotr.isOpReq", data);
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)packet);
        }
    }

    private void renderPlayer(UUID player, String playerName, double playerPosX, double playerPosZ, int mouseX, int mouseY) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int playerX = (int)playerPosX;
        int playerZ = (int)playerPosZ;
        playerX = playerX / LOTRGenLayerWorld.scale + LOTRGenLayerWorld.originX;
        playerZ = playerZ / LOTRGenLayerWorld.scale + LOTRGenLayerWorld.originZ;
        playerX -= this.posX;
        playerZ -= this.posY;
        playerX = (int)((double)playerX * this.zoomPower);
        playerZ = (int)((double)playerZ * this.zoomPower);
        playerX += this.guiLeft + 128;
        playerZ += this.guiTop + 100;
        int iconWidth = 4;
        int border = 4 + iconWidth + 1;
        playerX = Math.max(this.guiLeft + border, playerX);
        playerX = Math.min(this.guiLeft + 256 - border - 1, playerX);
        playerZ = Math.max(this.guiTop + border, playerZ);
        playerZ = Math.min(this.guiTop + 200 - border - 1, playerZ);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation texture = (ResourceLocation)playerSkins.get(player);
        if (texture == null) {
            texture = AbstractClientPlayer.func_110311_f((String)playerName);
            AbstractClientPlayer.func_110304_a((ResourceLocation)texture, (String)playerName);
            playerSkins.put(player, texture);
        }
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        double iconMinU = 0.125;
        double iconMaxU = 0.25;
        double iconMinV = 0.25;
        double iconMaxV = 0.5;
        double playerX_d = (double)playerX + 0.5;
        double playerZ_d = (double)playerZ + 0.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a(playerX_d - (double)iconWidth, playerZ_d + (double)iconWidth, (double)this.field_73735_i, iconMinU, iconMaxV);
        tessellator.func_78374_a(playerX_d + (double)iconWidth, playerZ_d + (double)iconWidth, (double)this.field_73735_i, iconMaxU, iconMaxV);
        tessellator.func_78374_a(playerX_d + (double)iconWidth, playerZ_d - (double)iconWidth, (double)this.field_73735_i, iconMaxU, iconMinV);
        tessellator.func_78374_a(playerX_d - (double)iconWidth, playerZ_d - (double)iconWidth, (double)this.field_73735_i, iconMinU, iconMinV);
        tessellator.func_78381_a();
        iconMinU = 0.625;
        iconMaxU = 0.75;
        iconMinV = 0.25;
        iconMaxV = 0.5;
        tessellator.func_78382_b();
        tessellator.func_78374_a(playerX_d - (double)iconWidth - 0.5, playerZ_d + (double)iconWidth + 0.5, (double)this.field_73735_i, iconMinU, iconMaxV);
        tessellator.func_78374_a(playerX_d + (double)iconWidth + 0.5, playerZ_d + (double)iconWidth + 0.5, (double)this.field_73735_i, iconMaxU, iconMaxV);
        tessellator.func_78374_a(playerX_d + (double)iconWidth + 0.5, playerZ_d - (double)iconWidth - 0.5, (double)this.field_73735_i, iconMaxU, iconMinV);
        tessellator.func_78374_a(playerX_d - (double)iconWidth - 0.5, playerZ_d - (double)iconWidth - 0.5, (double)this.field_73735_i, iconMinU, iconMinV);
        tessellator.func_78381_a();
        if (!this.hasOverlay && mouseX >= playerX - 4 && mouseX < playerX + 4 && mouseY >= playerZ - 4 && mouseY < playerZ + 4) {
            int stringWidth = this.field_146297_k.field_71466_p.func_78256_a(playerName);
            int stringHeight = this.field_146297_k.field_71466_p.field_78288_b;
            int stringBorder = 3;
            int x = this.guiLeft + 128 - stringWidth / 2 - stringBorder;
            int y = this.guiTop + 200 - 4 - stringHeight - stringBorder * 3;
            LOTRGuiMap.func_73734_a((int)x, (int)y, (int)(x + stringWidth + stringBorder * 2), (int)(y + stringHeight + stringBorder * 2), (int)-1073741824);
            this.field_146297_k.field_71466_p.func_78276_b(playerName, x + stringBorder, y + stringBorder, 0xFFFFFF);
        }
    }

    private boolean isMiddleEarth() {
        return this.field_146297_k.field_71439_g.field_71093_bK == LOTRMod.idDimension;
    }

    public static void addPlayerLocationInfo(UUID player, String name, double x, double z) {
        playerLocations.put(player, new PlayerLocationInfo(name, x, z));
    }

    private static class PlayerLocationInfo {
        public String name;
        public double posX;
        public double posZ;

        public PlayerLocationInfo(String s, double x, double z) {
            this.name = s;
            this.posX = x;
            this.posZ = z;
        }
    }
}

