/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import lotr.client.render.tileentity.LOTRRenderBeacon;
import lotr.client.render.tileentity.LOTRRenderTrollTotem;
import lotr.client.render.tileentity.LOTRTileEntityMobSpawnerRenderer;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockBeacon;
import lotr.common.block.LOTRBlockClover;
import lotr.common.block.LOTRBlockDwarvenDoor;
import lotr.common.block.LOTRBlockFlowerPot;
import lotr.common.block.LOTRBlockSaplingBase;
import lotr.common.tileentity.LOTRTileEntityBeacon;
import lotr.common.tileentity.LOTRTileEntityMobSpawner;
import lotr.common.tileentity.LOTRTileEntityTrollTotem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LOTRRenderBlocks
implements ISimpleBlockRenderingHandler {
    private boolean renderInvIn3D;

    public LOTRRenderBlocks(boolean flag) {
        this.renderInvIn3D = flag;
    }

    public boolean renderWorldBlock(IBlockAccess world, int i, int j, int k, Block block, int id, RenderBlocks renderblocks) {
        if (id == LOTRMod.proxy.getBeaconRenderID()) {
            this.renderBeacon(world, i, j, k, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getBarrelRenderID()) {
            this.renderBarrel(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getOrcBombRenderID()) {
            this.renderOrcBomb(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getOrcTorchRenderID()) {
            this.renderOrcTorch(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getMobSpawnerRenderID()) {
            return renderblocks.func_147784_q(block, i, j, k);
        }
        if (id == LOTRMod.proxy.getPlateRenderID()) {
            this.renderPlate(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getStalactiteRenderID()) {
            this.renderStalactite(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getFlowerPotRenderID()) {
            this.renderFlowerPot(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getCloverRenderID()) {
            LOTRRenderBlocks.renderClover(world, i, j, k, block, renderblocks, world.func_72805_g(i, j, k) == 1 ? 4 : 3, true);
            return true;
        }
        if (id == LOTRMod.proxy.getEntJarRenderID()) {
            this.renderEntJar(world, i, j, k, block, renderblocks);
            return true;
        }
        if (id == LOTRMod.proxy.getFenceRenderID()) {
            return renderblocks.func_147735_a((BlockFence)block, i, j, k);
        }
        return false;
    }

    public void renderInventoryBlock(Block block, int meta, int id, RenderBlocks renderblocks) {
        if (id == LOTRMod.proxy.getBeaconRenderID()) {
            ((LOTRRenderBeacon)TileEntityRendererDispatcher.field_147556_a.func_147546_a(LOTRTileEntityBeacon.class)).renderInvBeacon();
        }
        if (id == LOTRMod.proxy.getBarrelRenderID()) {
            this.renderInvBarrel(block, renderblocks);
        }
        if (id == LOTRMod.proxy.getOrcBombRenderID()) {
            this.renderInvOrcBomb(block, meta, renderblocks);
        }
        if (id == LOTRMod.proxy.getMobSpawnerRenderID()) {
            LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            ((LOTRTileEntityMobSpawnerRenderer)TileEntityRendererDispatcher.field_147556_a.func_147546_a(LOTRTileEntityMobSpawner.class)).renderInvMobSpawner(meta);
        }
        if (id == LOTRMod.proxy.getStalactiteRenderID()) {
            this.renderInvStalactite(block, meta, renderblocks);
        }
        if (id == LOTRMod.proxy.getCloverRenderID()) {
            LOTRRenderBlocks.renderInvClover(block, renderblocks, meta == 1 ? 4 : 3);
        }
        if (id == LOTRMod.proxy.getEntJarRenderID()) {
            this.renderInvEntJar(block, renderblocks);
        }
        if (id == LOTRMod.proxy.getTrollTotemRenderID()) {
            ((LOTRRenderTrollTotem)TileEntityRendererDispatcher.field_147556_a.func_147546_a(LOTRTileEntityTrollTotem.class)).renderInvTrollTotem(meta);
        }
        if (id == LOTRMod.proxy.getFenceRenderID()) {
            this.renderInvFence(block, meta, renderblocks);
        }
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return this.renderInvIn3D;
    }

    public int getRenderId() {
        return 0;
    }

    private void renderBeacon(IBlockAccess world, int i, int j, int k, RenderBlocks renderblocks) {
        if (LOTRBlockBeacon.isLit(world, i, j, k) && LOTRBlockBeacon.getLitCounter(world, i, j, k) == 100) {
            renderblocks.func_147801_a(Blocks.field_150480_ab, i, j, k);
        }
    }

    private void renderBarrel(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int ao = LOTRRenderBlocks.getAO();
        LOTRRenderBlocks.setAO(0);
        renderblocks.field_147837_f = true;
        renderblocks.func_147782_a(0.125, 0.0, 0.125, 0.25, 0.8125, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.75, 0.0, 0.125, 0.875, 0.8125, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0, 0.125, 0.75, 0.8125, 0.25);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0, 0.75, 0.75, 0.8125, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0625, 0.25, 0.75, 0.75, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147757_a(block.func_149733_h(-1));
        int meta = world.func_72805_g(i, j, k);
        if (meta == 2) {
            renderblocks.func_147782_a(0.4375, 0.25, 0.0, 0.5625, 0.375, 0.125);
            renderblocks.func_147784_q(block, i, j, k);
            renderblocks.func_147782_a(0.46875, 0.125, 0.0, 0.53125, 0.25, 0.0625);
            renderblocks.func_147784_q(block, i, j, k);
        } else if (meta == 3) {
            renderblocks.func_147782_a(0.4375, 0.25, 0.875, 0.5625, 0.375, 1.0);
            renderblocks.func_147784_q(block, i, j, k);
            renderblocks.func_147782_a(0.46875, 0.125, 0.9375, 0.53125, 0.25, 1.0);
            renderblocks.func_147784_q(block, i, j, k);
        } else if (meta == 4) {
            renderblocks.func_147782_a(0.0, 0.25, 0.4375, 0.125, 0.375, 0.5625);
            renderblocks.func_147784_q(block, i, j, k);
            renderblocks.func_147782_a(0.0, 0.125, 0.46875, 0.0625, 0.25, 0.53125);
            renderblocks.func_147784_q(block, i, j, k);
        } else if (meta == 5) {
            renderblocks.func_147782_a(0.875, 0.25, 0.4375, 1.0, 0.375, 0.5625);
            renderblocks.func_147784_q(block, i, j, k);
            renderblocks.func_147782_a(0.9375, 0.125, 0.46875, 1.0, 0.25, 0.53125);
            renderblocks.func_147784_q(block, i, j, k);
        }
        renderblocks.func_147771_a();
        renderblocks.field_147837_f = false;
        LOTRRenderBlocks.setAO(ao);
    }

    private void renderInvBarrel(Block block, RenderBlocks renderblocks) {
        renderblocks.field_147837_f = true;
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.125f, 0.0f, 0.125f, 0.25f, 0.8125f, 0.875f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.75f, 0.0f, 0.125f, 0.875f, 0.8125f, 0.875f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0f, 0.125f, 0.75f, 0.8125f, 0.25f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0f, 0.75f, 0.75f, 0.8125f, 0.875f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0625f, 0.25f, 0.75f, 0.75f, 0.75f);
        renderblocks.func_147757_a(block.func_149733_h(-1));
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.875f, 0.25f, 0.4375f, 1.0f, 0.375f, 0.5625f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.9375f, 0.125f, 0.46875f, 1.0f, 0.25f, 0.53125f);
        renderblocks.func_147771_a();
        renderblocks.field_147837_f = false;
    }

    private void renderOrcBomb(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int ao = LOTRRenderBlocks.getAO();
        LOTRRenderBlocks.setAO(0);
        renderblocks.field_147837_f = true;
        renderblocks.func_147782_a(0.125, 0.1875, 0.125, 0.875, 0.9375, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.375, 0.9375, 0.375, 0.625, 1.0, 0.625);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.9375, 0.375, 0.3125, 1.0, 0.4375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.9375, 0.5625, 0.3125, 1.0, 0.625);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.6875, 0.9375, 0.375, 0.75, 1.0, 0.4375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.6875, 0.9375, 0.5625, 0.75, 1.0, 0.625);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.375, 0.9375, 0.25, 0.4375, 1.0, 0.3125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.5625, 0.9375, 0.25, 0.625, 1.0, 0.3125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.375, 0.9375, 0.6875, 0.4375, 1.0, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.5625, 0.9375, 0.6875, 0.625, 1.0, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.125, 0.0, 0.25, 0.1875, 0.1875, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.8125, 0.0, 0.25, 0.875, 0.1875, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0, 0.125, 0.75, 0.1875, 0.1875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0, 0.8125, 0.75, 0.1875, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147757_a(block.func_149691_a(-1, world.func_72805_g(i, j, k)));
        renderblocks.func_147782_a(0.0, 0.625, 0.3125, 0.0625, 0.6875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.0625, 0.625, 0.3125, 0.125, 0.6875, 0.375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.0625, 0.625, 0.625, 0.125, 0.6875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.9375, 0.625, 0.3125, 1.0, 0.6875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.875, 0.625, 0.3125, 0.9375, 0.6875, 0.375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.875, 0.625, 0.625, 0.9375, 0.6875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.3125, 0.625, 0.0, 0.6875, 0.6875, 0.0625);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.3125, 0.625, 0.0625, 0.375, 0.6875, 0.125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.625, 0.625, 0.0625, 0.6875, 0.6875, 0.125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.3125, 0.625, 0.9375, 0.6875, 0.6875, 1.0);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.3125, 0.625, 0.875, 0.375, 0.6875, 0.9375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.625, 0.625, 0.875, 0.6875, 0.6875, 0.9375);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147771_a();
        renderblocks.field_147837_f = false;
        LOTRRenderBlocks.setAO(ao);
    }

    private void renderInvOrcBomb(Block block, int meta, RenderBlocks renderblocks) {
        renderblocks.field_147837_f = true;
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.125f, 0.1875f, 0.125f, 0.875f, 0.9375f, 0.875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.375f, 0.9375f, 0.375f, 0.625f, 1.0f, 0.625f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.9375f, 0.375f, 0.3125f, 1.0f, 0.4375f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.9375f, 0.5625f, 0.3125f, 1.0f, 0.625f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.6875f, 0.9375f, 0.375f, 0.75f, 1.0f, 0.4375f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.6875f, 0.9375f, 0.5625f, 0.75f, 1.0f, 0.625f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.375f, 0.9375f, 0.25f, 0.4375f, 1.0f, 0.3125f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.5625f, 0.9375f, 0.25f, 0.625f, 1.0f, 0.3125f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.375f, 0.9375f, 0.6875f, 0.4375f, 1.0f, 0.75f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.5625f, 0.9375f, 0.6875f, 0.625f, 1.0f, 0.75f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.125f, 0.0f, 0.25f, 0.1875f, 0.1875f, 0.75f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.8125f, 0.0f, 0.25f, 0.875f, 0.1875f, 0.75f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0f, 0.125f, 0.75f, 0.1875f, 0.1875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0f, 0.8125f, 0.75f, 0.1875f, 0.875f, meta);
        renderblocks.func_147757_a(block.func_149691_a(-1, meta));
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.0f, 0.625f, 0.3125f, 0.0625f, 0.6875f, 0.6875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.0625f, 0.625f, 0.3125f, 0.125f, 0.6875f, 0.375f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.0625f, 0.625f, 0.625f, 0.125f, 0.6875f, 0.6875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.9375f, 0.625f, 0.3125f, 1.0f, 0.6875f, 0.6875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.875f, 0.625f, 0.3125f, 0.9375f, 0.6875f, 0.375f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.875f, 0.625f, 0.625f, 0.9375f, 0.6875f, 0.6875f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.3125f, 0.625f, 0.0f, 0.6875f, 0.6875f, 0.0625f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.3125f, 0.625f, 0.0625f, 0.375f, 0.6875f, 0.125f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.625f, 0.625f, 0.0625f, 0.6875f, 0.6875f, 0.125f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.3125f, 0.625f, 0.9375f, 0.6875f, 0.6875f, 1.0f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.3125f, 0.625f, 0.875f, 0.375f, 0.6875f, 0.9375f, meta);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.625f, 0.625f, 0.875f, 0.6875f, 0.6875f, 0.9375f, meta);
        renderblocks.func_147771_a();
        renderblocks.field_147837_f = false;
    }

    private void renderOrcTorch(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int meta = world.func_72805_g(i, j, k);
        if (meta == 0) {
            renderblocks.func_147782_a(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
            renderblocks.func_147784_q(block, i, j, k);
        } else if (meta == 1) {
            renderblocks.func_147782_a(0.4375, 0.0, 0.4375, 0.5625, 0.5, 0.5625);
            renderblocks.func_147784_q(block, i, j, k);
        }
    }

    private void renderPlate(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int ao = LOTRRenderBlocks.getAO();
        LOTRRenderBlocks.setAO(0);
        renderblocks.field_147837_f = true;
        renderblocks.func_147782_a(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.125, 0.0625, 0.125, 0.875, 0.125, 0.875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.field_147837_f = false;
        LOTRRenderBlocks.setAO(ao);
    }

    public static void renderEntityPlate(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        renderblocks.field_147837_f = true;
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.1875f, 0.0f, 0.1875f, 0.8125f, 0.0625f, 0.8125f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.125f, 0.0625f, 0.125f, 0.875f, 0.125f, 0.875f);
        renderblocks.field_147837_f = false;
    }

    private void renderStalactite(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int ao = LOTRRenderBlocks.getAO();
        LOTRRenderBlocks.setAO(0);
        renderblocks.field_147837_f = true;
        int metadata = world.func_72805_g(i, j, k);
        for (int l = 0; l < 16; ++l) {
            if (metadata == 0) {
                renderblocks.func_147782_a((double)(0.5f - (float)l / 16.0f * 0.25f), (double)((float)l / 16.0f), (double)(0.5f - (float)l / 16.0f * 0.25f), (double)(0.5f + (float)l / 16.0f * 0.25f), (double)((float)(l + 1) / 16.0f), (double)(0.5f + (float)l / 16.0f * 0.25f));
                renderblocks.func_147784_q(block, i, j, k);
                continue;
            }
            if (metadata != 1) continue;
            renderblocks.func_147782_a((double)(0.25f + (float)l / 16.0f * 0.25f), (double)((float)l / 16.0f), (double)(0.25f + (float)l / 16.0f * 0.25f), (double)(0.75f - (float)l / 16.0f * 0.25f), (double)((float)(l + 1) / 16.0f), (double)(0.75f - (float)l / 16.0f * 0.25f));
            renderblocks.func_147784_q(block, i, j, k);
        }
        renderblocks.field_147837_f = false;
        LOTRRenderBlocks.setAO(ao);
    }

    private void renderInvStalactite(Block block, int metadata, RenderBlocks renderblocks) {
        renderblocks.field_147837_f = true;
        for (int l = 0; l < 16; ++l) {
            if (metadata == 0) {
                LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.5f - (float)l / 16.0f * 0.25f, (float)l / 16.0f, 0.5f - (float)l / 16.0f * 0.25f, 0.5f + (float)l / 16.0f * 0.25f, (float)(l + 1) / 16.0f, 0.5f + (float)l / 16.0f * 0.25f);
                continue;
            }
            if (metadata != 1) continue;
            LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f + (float)l / 16.0f * 0.25f, (float)l / 16.0f, 0.25f + (float)l / 16.0f * 0.25f, 0.75f - (float)l / 16.0f * 0.25f, (float)(l + 1) / 16.0f, 0.75f - (float)l / 16.0f * 0.25f);
        }
        renderblocks.field_147837_f = false;
    }

    private void renderFlowerPot(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        float f4;
        renderblocks.func_147784_q(block, i, j, k);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, i, j, k));
        float f = 1.0f;
        int l = block.func_149720_d(world, i, j, k);
        IIcon icon = renderblocks.func_147777_a(block, 0);
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        f4 = 0.1865f;
        renderblocks.func_147764_f(block, (double)((float)i - 0.5f + f4), (double)j, (double)k, icon);
        renderblocks.func_147798_e(block, (double)((float)i + 0.5f - f4), (double)j, (double)k, icon);
        renderblocks.func_147734_d(block, (double)i, (double)j, (double)((float)k - 0.5f + f4), icon);
        renderblocks.func_147761_c(block, (double)i, (double)j, (double)((float)k + 0.5f - f4), icon);
        renderblocks.func_147806_b(block, (double)i, (double)((float)j - 0.5f + f4 + 0.1875f), (double)k, renderblocks.func_147745_b(Blocks.field_150346_d));
        ItemStack plant = LOTRBlockFlowerPot.getPlant(world, i, j, k);
        if (plant == null) {
            return;
        }
        Block plantBlock = Block.func_149634_a((Item)plant.func_77973_b());
        tessellator.func_78372_c(0.0f, 0.25f, 0.0f);
        if (plantBlock instanceof LOTRBlockSaplingBase || plantBlock == LOTRMod.pipeweedPlant || plantBlock == LOTRMod.athelas || plantBlock == LOTRMod.mordorThorn) {
            renderblocks.func_147765_a(plantBlock.func_149691_a(2, plant.func_77960_j()), (double)i, (double)j, (double)k, 0.75f);
        } else if (plantBlock == LOTRMod.shireHeather) {
            renderblocks.func_147765_a(plantBlock.func_149691_a(2, plant.func_77960_j()), (double)i, (double)j, (double)k, 0.6f);
        } else if (plantBlock == LOTRMod.clover) {
            LOTRRenderBlocks.renderClover(world, i, j, k, plantBlock, renderblocks, plant.func_77960_j() == 1 ? 4 : 3, false);
        } else {
            renderblocks.func_147805_b(plantBlock, i, j, k);
        }
        tessellator.func_78372_c(0.0f, -0.25f, 0.0f);
    }

    private static void renderClover(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks, int petalCount, boolean randomTranslation) {
        double scale = 0.5;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(world, i, j, k));
        int l = block.func_149720_d(world, i, j, k);
        float f = 1.0f;
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        renderblocks.func_147757_a(LOTRBlockClover.stemIcon);
        double posX = i;
        double posY = j;
        double posZ = k;
        if (randomTranslation) {
            long seed = (long)(i * 3129871) ^ (long)k * 116129781L ^ (long)j;
            seed = seed * seed * 42317861L + seed * 11L;
            posX += ((double)((float)(seed >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            posZ += ((double)((float)(seed >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        renderblocks.func_147765_a(block.func_149691_a(2, 0), posX, posY, posZ, (float)scale);
        renderblocks.func_147771_a();
        for (int petal = 0; petal < petalCount; ++petal) {
            float rotation = (float)petal / (float)petalCount * (float)Math.PI * 2.0f;
            IIcon icon = LOTRBlockClover.petalIcon;
            double d = icon.func_94209_e();
            double d1 = icon.func_94206_g();
            double d2 = icon.func_94212_f();
            double d3 = icon.func_94210_h();
            double d4 = posX + 0.5;
            double d5 = posY + 0.5 * scale + (double)petal * 0.0025;
            double d6 = posZ + 0.5;
            Vec3[] vecs = new Vec3[]{world.func_82732_R().func_72345_a(0.5 * scale, 0.0, -0.5 * scale), world.func_82732_R().func_72345_a(-0.5 * scale, 0.0, -0.5 * scale), world.func_82732_R().func_72345_a(-0.5 * scale, 0.0, 0.5 * scale), world.func_82732_R().func_72345_a(0.5 * scale, 0.0, 0.5 * scale)};
            for (int l1 = 0; l1 < vecs.length; ++l1) {
                vecs[l1].func_72442_b(rotation);
                vecs[l1].field_72450_a += d4;
                vecs[l1].field_72448_b += d5;
                vecs[l1].field_72449_c += d6;
            }
            tessellator.func_78374_a(vecs[0].field_72450_a, vecs[0].field_72448_b, vecs[0].field_72449_c, d, d1);
            tessellator.func_78374_a(vecs[1].field_72450_a, vecs[1].field_72448_b, vecs[1].field_72449_c, d, d3);
            tessellator.func_78374_a(vecs[2].field_72450_a, vecs[2].field_72448_b, vecs[2].field_72449_c, d2, d3);
            tessellator.func_78374_a(vecs[3].field_72450_a, vecs[3].field_72448_b, vecs[3].field_72449_c, d2, d1);
        }
    }

    private static void renderInvClover(Block block, RenderBlocks renderblocks, int petalCount) {
        GL11.glDisable((int)2896);
        double scale = 1.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        int l = block.func_149741_i(0);
        float f = 1.0f;
        float f1 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(l & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        renderblocks.func_147757_a(LOTRBlockClover.stemIcon);
        tessellator.func_78382_b();
        renderblocks.func_147765_a(block.func_149691_a(2, 0), -scale * 0.5, -scale * 0.5, -scale * 0.5, (float)scale);
        tessellator.func_78381_a();
        renderblocks.func_147771_a();
        for (int petal = 0; petal < petalCount; ++petal) {
            float rotation = (float)petal / (float)petalCount * (float)Math.PI * 2.0f;
            IIcon icon = LOTRBlockClover.petalIcon;
            double d = icon.func_94209_e();
            double d1 = icon.func_94206_g();
            double d2 = icon.func_94212_f();
            double d3 = icon.func_94210_h();
            double d4 = 0.0;
            double d5 = (double)petal * 0.0025;
            double d6 = 0.0;
            Vec3[] vecs = new Vec3[]{Minecraft.func_71410_x().field_71441_e.func_82732_R().func_72345_a(0.5 * scale, 0.0, -0.5 * scale), Minecraft.func_71410_x().field_71441_e.func_82732_R().func_72345_a(-0.5 * scale, 0.0, -0.5 * scale), Minecraft.func_71410_x().field_71441_e.func_82732_R().func_72345_a(-0.5 * scale, 0.0, 0.5 * scale), Minecraft.func_71410_x().field_71441_e.func_82732_R().func_72345_a(0.5 * scale, 0.0, 0.5 * scale)};
            for (int l1 = 0; l1 < vecs.length; ++l1) {
                vecs[l1].func_72442_b(rotation);
                vecs[l1].field_72450_a += d4;
                vecs[l1].field_72448_b += d5;
                vecs[l1].field_72449_c += d6;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a(vecs[0].field_72450_a, vecs[0].field_72448_b, vecs[0].field_72449_c, d, d1);
            tessellator.func_78374_a(vecs[1].field_72450_a, vecs[1].field_72448_b, vecs[1].field_72449_c, d, d3);
            tessellator.func_78374_a(vecs[2].field_72450_a, vecs[2].field_72448_b, vecs[2].field_72449_c, d2, d3);
            tessellator.func_78374_a(vecs[3].field_72450_a, vecs[3].field_72448_b, vecs[3].field_72449_c, d2, d1);
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)2896);
    }

    public static void renderDwarvenDoorGlow(RenderBlocks renderblocks, int i, int j, int k) {
        LOTRBlockDwarvenDoor block = (LOTRBlockDwarvenDoor)LOTRMod.dwarvenDoor;
        Tessellator tessellator = Tessellator.field_78398_a;
        int l = renderblocks.field_147845_a.func_72805_g(i, j, k);
        if ((l & 8) != 0 ? renderblocks.field_147845_a.func_147439_a(i, j - 1, k) != block : renderblocks.field_147845_a.func_147439_a(i, j + 1, k) != block) {
            return;
        }
        block.func_149719_a(renderblocks.field_147845_a, i, j, k);
        renderblocks.func_147775_a((Block)block);
        IIcon icon = renderblocks.func_147758_b(block.getGlowTexture(renderblocks.field_147845_a, i, j, k, 2));
        tessellator.func_78382_b();
        renderblocks.func_147761_c((Block)block, 0.0, 0.0, -0.01, icon);
        tessellator.func_78381_a();
        renderblocks.field_147842_e = false;
        icon = renderblocks.func_147758_b(block.getGlowTexture(renderblocks.field_147845_a, i, j, k, 3));
        tessellator.func_78382_b();
        renderblocks.func_147734_d((Block)block, 0.0, 0.0, 0.01, icon);
        tessellator.func_78381_a();
        renderblocks.field_147842_e = false;
        icon = renderblocks.func_147758_b(block.getGlowTexture(renderblocks.field_147845_a, i, j, k, 4));
        tessellator.func_78382_b();
        renderblocks.func_147798_e((Block)block, -0.01, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        renderblocks.field_147842_e = false;
        icon = renderblocks.func_147758_b(block.getGlowTexture(renderblocks.field_147845_a, i, j, k, 5));
        tessellator.func_78382_b();
        renderblocks.func_147764_f((Block)block, 0.01, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        renderblocks.field_147842_e = false;
    }

    private void renderEntJar(IBlockAccess world, int i, int j, int k, Block block, RenderBlocks renderblocks) {
        int ao = LOTRRenderBlocks.getAO();
        LOTRRenderBlocks.setAO(0);
        renderblocks.field_147837_f = true;
        renderblocks.func_147782_a(0.25, 0.0, 0.25, 0.75, 0.0625, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0625, 0.25, 0.75, 0.875, 0.3125);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0625, 0.6875, 0.75, 0.875, 0.75);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.25, 0.0625, 0.3125, (double)0.31255f, 0.875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.func_147782_a(0.6875, 0.0625, 0.3125, 0.75, 0.875, 0.6875);
        renderblocks.func_147784_q(block, i, j, k);
        renderblocks.field_147837_f = false;
        LOTRRenderBlocks.setAO(ao);
    }

    private void renderInvEntJar(Block block, RenderBlocks renderblocks) {
        renderblocks.field_147837_f = true;
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0f, 0.25f, 0.75f, 0.0625f, 0.75f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0625f, 0.25f, 0.75f, 0.875f, 0.3125f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0625f, 0.6875f, 0.75f, 0.875f, 0.75f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.25f, 0.0625f, 0.3125f, 0.31255f, 0.875f, 0.6875f);
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, 0.6875f, 0.0625f, 0.3125f, 0.75f, 0.875f, 0.6875f);
        renderblocks.field_147837_f = false;
    }

    private void renderInvFence(Block block, int meta, RenderBlocks renderblocks) {
        for (int k = 0; k < 4; ++k) {
            float f = 0.125f;
            float f1 = 0.0625f;
            if (k == 0) {
                renderblocks.func_147782_a((double)(0.5f - f), 0.0, 0.0, (double)(0.5f + f), 1.0, (double)(f * 2.0f));
            }
            if (k == 1) {
                renderblocks.func_147782_a((double)(0.5f - f), 0.0, (double)(1.0f - f * 2.0f), (double)(0.5f + f), 1.0, 1.0);
            }
            if (k == 2) {
                renderblocks.func_147782_a((double)(0.5f - f1), (double)(1.0f - f1 * 3.0f), (double)(-f1 * 2.0f), (double)(0.5f + f1), (double)(1.0f - f1), (double)(1.0f + f1 * 2.0f));
            }
            if (k == 3) {
                renderblocks.func_147782_a((double)(0.5f - f1), (double)(0.5f - f1 * 3.0f), (double)(-f1 * 2.0f), (double)(0.5f + f1), (double)(0.5f - f1), (double)(1.0f + f1 * 2.0f));
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 0, meta));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 1, meta));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 2, meta));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 3, meta));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 4, meta));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 5, meta));
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        renderblocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private static void renderStandardInvBlock(RenderBlocks renderblocks, Block block, float f, float f1, float f2, float f3, float f4, float f5) {
        LOTRRenderBlocks.renderStandardInvBlock(renderblocks, block, f, f1, f2, f3, f4, f5, 0);
    }

    private static void renderStandardInvBlock(RenderBlocks renderblocks, Block block, float f, float f1, float f2, float f3, float f4, float f5, int metadata) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderblocks.func_147782_a((double)f, (double)f1, (double)f2, (double)f3, (double)f4, (double)f5);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, renderblocks.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private static int getAO() {
        return Minecraft.func_71410_x().field_71474_y.field_74348_k;
    }

    private static void setAO(int i) {
        Minecraft.func_71410_x().field_71474_y.field_74348_k = i;
    }
}

