/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import java.util.List;
import java.util.Random;
import lotr.client.render.entity.LOTRRandomSkins;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class LOTRSkyRenderer
extends IRenderHandler {
    private static final ResourceLocation moonTexture = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation sunTexture = new ResourceLocation("textures/environment/sun.png");
    private List skyTextures;
    private ResourceLocation currentSkyTexture;
    private Random skyRand = new Random();
    private int glSkyList;
    private int glSkyList2;

    public LOTRSkyRenderer() {
        int k;
        int j;
        this.skyTextures = LOTRRandomSkins.loadSkinsList("lotr:sky");
        Tessellator tessellator = Tessellator.field_78398_a;
        this.glSkyList = GLAllocation.func_74526_a((int)3);
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int b2 = 64;
        int i = 256 / b2 + 2;
        float f = 16.0f;
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + 0));
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + 0));
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + b2));
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.glSkyList + 1;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.func_78382_b();
        for (j = -b2 * i; j <= b2 * i; j += b2) {
            for (k = -b2 * i; k <= b2 * i; k += b2) {
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + 0));
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + 0));
                tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + b2));
                tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    private ResourceLocation getRandomSkyTexture(World world) {
        return (ResourceLocation)this.skyTextures.get(this.skyRand.nextInt(this.skyTextures.size()));
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float f10;
        float f9;
        float f8;
        float f7;
        world.field_72984_F.func_76320_a("lotrSky");
        boolean renderSkyFeatures = true;
        int i = MathHelper.func_76128_c((double)mc.field_71451_h.field_70165_t);
        int k = MathHelper.func_76128_c((double)mc.field_71451_h.field_70161_v);
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome) {
            renderSkyFeatures = ((LOTRBiome)biome).hasSky();
        }
        GL11.glDisable((int)3553);
        Vec3 skyColor = world.func_72833_a((Entity)mc.field_71451_h, partialTicks);
        float skyR = (float)skyColor.field_72450_a;
        float skyG = (float)skyColor.field_72448_b;
        float skyB = (float)skyColor.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            float newSkyR = (skyR * 30.0f + skyG * 59.0f + skyB * 11.0f) / 100.0f;
            float newSkyG = (skyR * 30.0f + skyG * 70.0f) / 100.0f;
            float newSkyB = (skyR * 30.0f + skyB * 70.0f) / 100.0f;
            skyR = newSkyR;
            skyG = newSkyG;
            skyB = newSkyB;
        }
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            float f11;
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f4 = afloat[0];
            f7 = afloat[1];
            f8 = afloat[2];
            if (mc.field_71474_y.field_74337_g) {
                f9 = (f4 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                f10 = (f4 * 30.0f + f7 * 70.0f) / 100.0f;
                f11 = (f4 * 30.0f + f8 * 70.0f) / 100.0f;
                f4 = f9;
                f7 = f10;
                f8 = f11;
            }
            tessellator.func_78371_b(6);
            tessellator.func_78369_a(f4, f7, f8, afloat[3]);
            tessellator.func_78377_a(0.0, 100.0, 0.0);
            int b0 = 16;
            tessellator.func_78369_a(afloat[0], afloat[1], afloat[2], 0.0f);
            for (int j = 0; j <= b0; ++j) {
                f11 = (float)j * (float)Math.PI * 2.0f / (float)b0;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                tessellator.func_78377_a((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3]));
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glPushMatrix();
        if (renderSkyFeatures) {
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)1);
            float rainBrightness = 1.0f - world.func_72867_j(partialTicks);
            f7 = 0.0f;
            f8 = 0.0f;
            f9 = 0.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainBrightness);
            GL11.glTranslatef((float)f7, (float)f8, (float)f9);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float starBrightness = world.func_72880_h(partialTicks) * rainBrightness;
            if (starBrightness > 0.0f) {
                if (this.currentSkyTexture == null) {
                    this.currentSkyTexture = this.getRandomSkyTexture((World)world);
                }
                mc.field_71446_o.func_110577_a(this.currentSkyTexture);
                GL11.glPushMatrix();
                GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderSide(tessellator, 4);
                GL11.glPushMatrix();
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.renderSide(tessellator, 1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.renderSide(tessellator, 0);
                GL11.glPopMatrix();
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderSide(tessellator, 5);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderSide(tessellator, 2);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderSide(tessellator, 3);
                GL11.glPopMatrix();
            } else if (this.currentSkyTexture != null) {
                this.currentSkyTexture = null;
            }
            GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainBrightness);
            f10 = 30.0f;
            mc.field_71446_o.func_110577_a(sunTexture);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-f10), 100.0, (double)(-f10), 0.0, 0.0);
            tessellator.func_78374_a((double)f10, 100.0, (double)(-f10), 1.0, 0.0);
            tessellator.func_78374_a((double)f10, 100.0, (double)f10, 1.0, 1.0);
            tessellator.func_78374_a((double)(-f10), 100.0, (double)f10, 0.0, 1.0);
            tessellator.func_78381_a();
            f10 = 20.0f;
            mc.field_71446_o.func_110577_a(moonTexture);
            int moonPhase = world.func_72853_d();
            int l = moonPhase % 4;
            int i1 = moonPhase / 4 % 2;
            float f14 = (float)(l + 0) / 4.0f;
            float f15 = (float)(i1 + 0) / 2.0f;
            float f16 = (float)(l + 1) / 4.0f;
            float f17 = (float)(i1 + 1) / 2.0f;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-f10), -100.0, (double)f10, (double)f16, (double)f17);
            tessellator.func_78374_a((double)f10, -100.0, (double)f10, (double)f14, (double)f17);
            tessellator.func_78374_a((double)f10, -100.0, (double)(-f10), (double)f14, (double)f15);
            tessellator.func_78374_a((double)(-f10), -100.0, (double)(-f10), (double)f16, (double)f15);
            tessellator.func_78381_a();
            GL11.glDisable((int)3553);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_70666_h((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
            f8 = 1.0f;
            f9 = -((float)(d0 + 65.0));
            f10 = -f8;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)skyR, (float)skyG, (float)skyB);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        world.field_72984_F.func_76319_b();
    }

    private void renderSide(Tessellator tessellator, int side) {
        double u = (double)(side % 3) / 3.0;
        double v = (double)(side / 3) / 2.0;
        tessellator.func_78382_b();
        tessellator.func_78374_a(-100.0, -100.0, -100.0, u, v);
        tessellator.func_78374_a(-100.0, -100.0, 100.0, u, v + 0.5);
        tessellator.func_78374_a(100.0, -100.0, 100.0, u + 0.3333333333333333, v + 0.5);
        tessellator.func_78374_a(100.0, -100.0, -100.0, u + 0.3333333333333333, v);
        tessellator.func_78381_a();
    }
}

