/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.tileentity;

import java.util.HashMap;
import lotr.common.entity.LOTREntities;
import lotr.common.tileentity.LOTRTileEntityMobSpawner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class LOTRTileEntityMobSpawnerRenderer
extends TileEntitySpecialRenderer {
    private int tempID;
    private HashMap initialisedItemEntities = new HashMap();
    public static double itemYaw;
    public static double prevItemYaw;

    public static void onRenderTick() {
        prevItemYaw = itemYaw;
        itemYaw = (itemYaw + 0.75) % 360.0;
    }

    public void func_147496_a(World world) {
        this.loadEntities(world);
    }

    private void loadEntities(World world) {
        this.unloadEntities();
        if (world != null) {
            for (LOTREntities.SpawnEggInfo info : LOTREntities.creatures.values()) {
                Entity entity = LOTREntities.createEntityByID(info.spawnedID, world);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_110161_a(null);
                }
                this.initialisedItemEntities.put(info.spawnedID, entity);
            }
        }
    }

    private void unloadEntities() {
        this.initialisedItemEntities.clear();
    }

    public void func_147500_a(TileEntity tileentity, double d, double d1, double d2, float f) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        LOTRTileEntityMobSpawner mobSpawner = (LOTRTileEntityMobSpawner)tileentity;
        if (mobSpawner != null && !mobSpawner.isActive()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.5f), (float)((float)d1), (float)((float)d2 + 0.5f));
        Entity entity = null;
        double yaw = 0.0;
        double prevYaw = 0.0;
        if (mobSpawner != null) {
            entity = mobSpawner.getMobEntity((World)world);
            yaw = mobSpawner.yaw;
            prevYaw = mobSpawner.prevYaw;
        } else {
            entity = (Entity)this.initialisedItemEntities.get(this.tempID);
            yaw = itemYaw;
            prevYaw = prevItemYaw;
        }
        if (entity != null) {
            float f1 = 0.4375f;
            GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.0f);
            GL11.glRotatef((float)((float)(prevYaw + (yaw - prevYaw) * (double)f) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
            GL11.glScalef((float)f1, (float)f1, (float)f1);
            entity.func_70012_b(d, d1, d2, 0.0f, 0.0f);
            RenderManager.field_78727_a.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, f);
        }
        GL11.glPopMatrix();
    }

    public void renderInvMobSpawner(int i) {
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.tempID = i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147500_a(null, 0.0, 0.0, 0.0, 0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tempID = 0;
        GL11.glPopMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
    }
}

