/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRCapes;
import lotr.common.LOTRFaction;
import lotr.common.LOTRGuiMessageTypes;
import lotr.common.LOTROptions;
import lotr.common.LOTRWaypoint;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class LOTRLevelData {
    public static int madePortal;
    public static int madeMiddleEarthPortal;
    public static int overworldPortalX;
    public static int overworldPortalY;
    public static int overworldPortalZ;
    public static int middleEarthPortalX;
    public static int middleEarthPortalY;
    public static int middleEarthPortalZ;
    public static int beaconState;
    public static int structuresBanned;
    public static int timeUntilElvenTrader;
    public static int hasGollum;
    public static int gollumRespawnTime;
    public static List beaconTowerLocations;
    public static List gondorFortressLocations;
    public static List dwarvenTowerLocations;
    public static List urukCampLocations;
    public static List rohanFortressLocations;
    public static List woodElvenTowerLocations;
    public static List mordorTowerLocations;
    public static List nurnFarmLocations;
    public static List gundabadCampLocations;
    public static List dunlandHillFortLocations;
    public static List blueMountainsStrongholdLocations;
    public static List rangerCampLocations;
    private static Map alignments;
    private static Map achievements;
    private static Map capes;
    private static Map capesEnabled;
    private static Map friendlyFire;
    private static Map hiredDeathMessages;
    public static Map playerDeathPoints;
    public static Map fastTravelTimers;
    public static Map viewingFactions;
    public static Set playersCheckedAchievements;
    public static Set playersCheckedAlignments;
    public static Set bannedStructurePlayers;
    private static Set melonFinders;
    private static Set hiddenAlignments;
    private static Set hiddenMapPlayers;
    public static boolean needsLoad;
    public static boolean needsSave;
    private static Random rand;

    public static void save() {
        try {
            FileOutputStream outputStream;
            File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "LOTR.dat");
            if (!file.exists()) {
                outputStream = new FileOutputStream(file);
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)outputStream);
                outputStream.close();
            }
            outputStream = new FileOutputStream(file);
            NBTTagCompound levelData = new NBTTagCompound();
            levelData.func_74768_a("MadePortal", madePortal);
            levelData.func_74768_a("MadeMiddlePortal", madeMiddleEarthPortal);
            levelData.func_74768_a("OverworldX", overworldPortalX);
            levelData.func_74768_a("OverworldY", overworldPortalY);
            levelData.func_74768_a("OverworldZ", overworldPortalZ);
            levelData.func_74768_a("MiddleEarthX", middleEarthPortalX);
            levelData.func_74768_a("MiddleEarthY", middleEarthPortalY);
            levelData.func_74768_a("MiddleEarthZ", middleEarthPortalZ);
            levelData.func_74768_a("BeaconState", beaconState);
            levelData.func_74768_a("StructuresBanned", structuresBanned);
            levelData.func_74768_a("ElvenTraderTime", timeUntilElvenTrader);
            levelData.func_74768_a("HasGollum", hasGollum);
            levelData.func_74768_a("GollumRespawnTime", gollumRespawnTime);
            NBTTagCompound structureLocations = new NBTTagCompound();
            LOTRLevelData.saveStructureLocations(structureLocations, beaconTowerLocations, "BeaconTower");
            LOTRLevelData.saveStructureLocations(structureLocations, gondorFortressLocations, "GondorFortress");
            LOTRLevelData.saveStructureLocations(structureLocations, dwarvenTowerLocations, "DwarvenTower");
            LOTRLevelData.saveStructureLocations(structureLocations, urukCampLocations, "UrukCamp");
            LOTRLevelData.saveStructureLocations(structureLocations, rohanFortressLocations, "RohanFortress");
            LOTRLevelData.saveStructureLocations(structureLocations, woodElvenTowerLocations, "WoodElvenTower");
            LOTRLevelData.saveStructureLocations(structureLocations, mordorTowerLocations, "MordorTower");
            LOTRLevelData.saveStructureLocations(structureLocations, nurnFarmLocations, "NurnFarm");
            LOTRLevelData.saveStructureLocations(structureLocations, gundabadCampLocations, "GundabadCamp");
            LOTRLevelData.saveStructureLocations(structureLocations, dunlandHillFortLocations, "DunlandFort");
            LOTRLevelData.saveStructureLocations(structureLocations, blueMountainsStrongholdLocations, "BlueMountainsStronghold");
            LOTRLevelData.saveStructureLocations(structureLocations, rangerCampLocations, "RangerCamp");
            levelData.func_74782_a("StructureLocations", (NBTBase)structureLocations);
            NBTTagList alignmentTags = new NBTTagList();
            for (Object obj : alignments.keySet()) {
                if (!(obj instanceof UUID) || !(alignments.get(obj) instanceof Map)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                Map playerAlignmments = (Map)alignments.get(obj);
                NBTTagList list = new NBTTagList();
                for (LOTRFaction faction : playerAlignmments.keySet()) {
                    int alignment = (Integer)playerAlignmments.get((Object)faction);
                    NBTTagCompound nbt1 = new NBTTagCompound();
                    nbt1.func_74778_a("Faction", faction.name());
                    nbt1.func_74768_a("Alignment", alignment);
                    list.func_74742_a((NBTBase)nbt1);
                }
                nbt.func_74782_a("AlignmentMap", (NBTBase)list);
                alignmentTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("Alignments", (NBTBase)alignmentTags);
            NBTTagList achievementTags = new NBTTagList();
            for (Object obj : achievements.keySet()) {
                if (!(obj instanceof UUID) || !(achievements.get(obj) instanceof ArrayList)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                ArrayList playerAchievements = (ArrayList)achievements.get(obj);
                NBTTagList list = new NBTTagList();
                for (LOTRAchievement achievement : playerAchievements) {
                    NBTTagCompound nbt1 = new NBTTagCompound();
                    nbt1.func_74778_a("Category", achievement.category.name());
                    nbt1.func_74768_a("ID", achievement.ID);
                    list.func_74742_a((NBTBase)nbt1);
                }
                nbt.func_74782_a("List", (NBTBase)list);
                achievementTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("Achievements", (NBTBase)achievementTags);
            NBTTagList capeTags = new NBTTagList();
            for (Object obj : capes.keySet()) {
                if (!(obj instanceof UUID) || !(capes.get(obj) instanceof LOTRCapes)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74778_a("Cape", ((LOTRCapes)((Object)capes.get(obj))).name());
                boolean flag = true;
                if (capesEnabled.get(obj) instanceof Boolean) {
                    flag = (Boolean)capesEnabled.get(obj);
                }
                nbt.func_74757_a("Enabled", flag);
                capeTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("Capes", (NBTBase)capeTags);
            NBTTagList friendlyFireTags = new NBTTagList();
            for (Object obj : friendlyFire.keySet()) {
                if (!(obj instanceof UUID) || !(friendlyFire.get(obj) instanceof Boolean)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74757_a("Enabled", ((Boolean)friendlyFire.get(obj)).booleanValue());
                friendlyFireTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("FriendlyFire", (NBTBase)friendlyFireTags);
            NBTTagList hiredDeathMessagesTags = new NBTTagList();
            for (Object obj : hiredDeathMessages.keySet()) {
                if (!(obj instanceof UUID) || !(hiredDeathMessages.get(obj) instanceof Boolean)) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74757_a("Enabled", ((Boolean)hiredDeathMessages.get(obj)).booleanValue());
                hiredDeathMessagesTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("HiredDeathMessages", (NBTBase)hiredDeathMessagesTags);
            NBTTagList playerDeathPointsTags = new NBTTagList();
            for (Object obj : playerDeathPoints.keySet()) {
                if (!(obj instanceof UUID) || !(playerDeathPoints.get(obj) instanceof ChunkCoordinates)) continue;
                ChunkCoordinates coords = (ChunkCoordinates)playerDeathPoints.get(obj);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74768_a("XPos", coords.field_71574_a);
                nbt.func_74768_a("YPos", coords.field_71572_b);
                nbt.func_74768_a("ZPos", coords.field_71573_c);
                playerDeathPointsTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("PlayerDeathPoints", (NBTBase)playerDeathPointsTags);
            NBTTagList fastTravelTimersTags = new NBTTagList();
            for (Object obj : fastTravelTimers.keySet()) {
                if (!(obj instanceof UUID) || !(fastTravelTimers.get(obj) instanceof Integer)) continue;
                int timer = (Integer)fastTravelTimers.get(obj);
                if (timer < 0) {
                    timer = 0;
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74768_a("Timer", timer);
                fastTravelTimersTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("FastTravelTimers", (NBTBase)fastTravelTimersTags);
            NBTTagList viewingFactionsTags = new NBTTagList();
            for (Object obj : viewingFactions.keySet()) {
                if (!(obj instanceof UUID) || !(viewingFactions.get(obj) instanceof LOTRFaction)) continue;
                LOTRFaction faction = (LOTRFaction)((Object)viewingFactions.get(obj));
                if (!faction.allowPlayer) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
                nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
                nbt.func_74768_a("Faction", faction.ordinal());
                viewingFactionsTags.func_74742_a((NBTBase)nbt);
            }
            levelData.func_74782_a("ViewingFactions", (NBTBase)viewingFactionsTags);
            levelData.func_74782_a("PlayersCheckedAchievements", (NBTBase)LOTRLevelData.savePlayerSet(playersCheckedAchievements));
            levelData.func_74782_a("PlayersCheckedAlignments", (NBTBase)LOTRLevelData.savePlayerSet(playersCheckedAlignments));
            levelData.func_74782_a("BannedStructurePlayers", (NBTBase)LOTRLevelData.savePlayerSet(bannedStructurePlayers));
            levelData.func_74782_a("MelonFinders", (NBTBase)LOTRLevelData.savePlayerSet(melonFinders));
            levelData.func_74782_a("HiddenAlignments", (NBTBase)LOTRLevelData.savePlayerSet(hiddenAlignments));
            levelData.func_74782_a("HiddenMapPlayers", (NBTBase)LOTRLevelData.savePlayerSet(hiddenMapPlayers));
            LOTRGuiMessageTypes.saveAll(levelData);
            LOTRWaypoint.save(levelData);
            CompressedStreamTools.func_74799_a((NBTTagCompound)levelData, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void saveStructureLocations(NBTTagCompound structureLocations, List structures, String name) {
        NBTTagList tags = new NBTTagList();
        for (Object obj : structures) {
            if (!(obj instanceof ChunkCoordinates)) continue;
            ChunkCoordinates coords = (ChunkCoordinates)obj;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("XPos", coords.field_71574_a);
            nbt.func_74768_a("YPos", coords.field_71572_b);
            nbt.func_74768_a("ZPos", coords.field_71573_c);
            tags.func_74742_a((NBTBase)nbt);
        }
        structureLocations.func_74782_a(name, (NBTBase)tags);
    }

    private static NBTTagList savePlayerSet(Set playerSet) {
        NBTTagList tags = new NBTTagList();
        for (Object obj : playerSet) {
            if (!(obj instanceof UUID)) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("UUIDMost", ((UUID)obj).getMostSignificantBits());
            nbt.func_74772_a("UUIDLeast", ((UUID)obj).getLeastSignificantBits());
            tags.func_74742_a((NBTBase)nbt);
        }
        return tags;
    }

    public static void load() {
        try {
            File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "LOTR.dat");
            if (!file.exists()) {
                FileOutputStream outputStream = new FileOutputStream(file);
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)outputStream);
                outputStream.close();
            }
            FileInputStream inputStream = new FileInputStream(file);
            NBTTagCompound levelData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            madePortal = levelData.func_74762_e("MadePortal");
            madeMiddleEarthPortal = levelData.func_74762_e("MadeMiddlePortal");
            overworldPortalX = levelData.func_74762_e("OverworldX");
            overworldPortalY = levelData.func_74762_e("OverworldY");
            overworldPortalZ = levelData.func_74762_e("OverworldZ");
            middleEarthPortalX = levelData.func_74762_e("MiddleEarthX");
            middleEarthPortalY = levelData.func_74762_e("MiddleEarthY");
            middleEarthPortalZ = levelData.func_74762_e("MiddleEarthZ");
            beaconState = levelData.func_74762_e("BeaconState");
            structuresBanned = levelData.func_74762_e("StructuresBanned");
            timeUntilElvenTrader = levelData.func_74764_b("ElvenTraderTime") ? levelData.func_74762_e("ElvenTraderTime") : LOTRLevelData.getRandomElvenTraderTime();
            hasGollum = levelData.func_74762_e("HasGollum");
            gollumRespawnTime = levelData.func_74764_b("GollumRespawnTime") ? levelData.func_74762_e("GollumRespawnTime") : 12000;
            LOTRLevelData.loadStructureLocations(levelData, beaconTowerLocations, "BeaconTower");
            LOTRLevelData.loadStructureLocations(levelData, gondorFortressLocations, "GondorFortress");
            LOTRLevelData.loadStructureLocations(levelData, dwarvenTowerLocations, "DwarvenTower");
            LOTRLevelData.loadStructureLocations(levelData, urukCampLocations, "UrukCamp");
            LOTRLevelData.loadStructureLocations(levelData, rohanFortressLocations, "RohanFortress");
            LOTRLevelData.loadStructureLocations(levelData, woodElvenTowerLocations, "WoodElvenTower");
            LOTRLevelData.loadStructureLocations(levelData, mordorTowerLocations, "MordorTower");
            LOTRLevelData.loadStructureLocations(levelData, nurnFarmLocations, "NurnFarm");
            LOTRLevelData.loadStructureLocations(levelData, gundabadCampLocations, "GundabadCamp");
            LOTRLevelData.loadStructureLocations(levelData, dunlandHillFortLocations, "DunlandFort");
            LOTRLevelData.loadStructureLocations(levelData, blueMountainsStrongholdLocations, "BlueMountainsStronghold");
            LOTRLevelData.loadStructureLocations(levelData, rangerCampLocations, "RangerCamp");
            alignments.clear();
            NBTTagList alignmentTags = levelData.func_150295_c("Alignments", (int)new NBTTagCompound().func_74732_a());
            if (alignmentTags != null) {
                for (int i = 0; i < alignmentTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = alignmentTags.func_150305_b(i);
                    HashMap<LOTRFaction, Integer> playerAlignmments = new HashMap<LOTRFaction, Integer>();
                    NBTTagList list = nbt.func_150295_c("AlignmentMap", (int)new NBTTagCompound().func_74732_a());
                    if (list != null) {
                        for (int j = 0; j < list.func_74745_c(); ++j) {
                            NBTTagCompound nbt1 = list.func_150305_b(j);
                            String factionName = nbt1.func_74779_i("Faction");
                            LOTRFaction faction = LOTRFaction.forName(factionName);
                            if (faction == null) continue;
                            int alignment = nbt1.func_74762_e("Alignment");
                            playerAlignmments.put(faction, alignment);
                        }
                    }
                    alignments.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), playerAlignmments);
                }
            }
            achievements.clear();
            NBTTagList achievementTags = levelData.func_150295_c("Achievements", (int)new NBTTagCompound().func_74732_a());
            if (achievementTags != null) {
                for (int i = 0; i < achievementTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = achievementTags.func_150305_b(i);
                    ArrayList<LOTRAchievement> playerAchievements = new ArrayList<LOTRAchievement>();
                    NBTTagList list = nbt.func_150295_c("List", (int)new NBTTagCompound().func_74732_a());
                    if (list != null) {
                        for (int j = 0; j < list.func_74745_c(); ++j) {
                            int ID;
                            LOTRAchievement achievement;
                            NBTTagCompound nbt1 = list.func_150305_b(j);
                            String categoryName = nbt1.func_74779_i("Category");
                            LOTRAchievement.Category category = LOTRAchievement.categoryForName(categoryName);
                            if (category == null || (achievement = LOTRAchievement.achievementForCategoryAndID(category, ID = nbt1.func_74762_e("ID"))) == null) continue;
                            playerAchievements.add(achievement);
                        }
                    }
                    achievements.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), playerAchievements);
                }
            }
            capes.clear();
            NBTTagList capeTags = levelData.func_150295_c("Capes", (int)new NBTTagCompound().func_74732_a());
            if (capeTags != null) {
                for (int i = 0; i < capeTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = capeTags.func_150305_b(i);
                    UUID player = new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast"));
                    String capeName = nbt.func_74779_i("Cape");
                    LOTRCapes cape = LOTRCapes.capeForName(capeName);
                    if (cape == null) continue;
                    capes.put(player, cape);
                    if (!nbt.func_74764_b("Enabled")) continue;
                    capesEnabled.put(player, nbt.func_74767_n("Enabled"));
                }
            }
            friendlyFire.clear();
            NBTTagList friendlyFireTags = levelData.func_150295_c("FriendlyFire", (int)new NBTTagCompound().func_74732_a());
            if (friendlyFireTags != null) {
                for (int i = 0; i < friendlyFireTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = friendlyFireTags.func_150305_b(i);
                    friendlyFire.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), nbt.func_74767_n("Enabled"));
                }
            }
            hiredDeathMessages.clear();
            NBTTagList hiredDeathMessagesTags = levelData.func_150295_c("HiredDeathMessages", (int)new NBTTagCompound().func_74732_a());
            if (hiredDeathMessagesTags != null) {
                for (int i = 0; i < hiredDeathMessagesTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = hiredDeathMessagesTags.func_150305_b(i);
                    hiredDeathMessages.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), nbt.func_74767_n("Enabled"));
                }
            }
            playerDeathPoints.clear();
            NBTTagList playerDeathPointsTags = levelData.func_150295_c("PlayerDeathPoints", (int)new NBTTagCompound().func_74732_a());
            if (playerDeathPointsTags != null) {
                for (int i = 0; i < playerDeathPointsTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = playerDeathPointsTags.func_150305_b(i);
                    ChunkCoordinates coords = new ChunkCoordinates(nbt.func_74762_e("XPos"), nbt.func_74762_e("YPos"), nbt.func_74762_e("ZPos"));
                    playerDeathPoints.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), coords);
                }
            }
            fastTravelTimers.clear();
            NBTTagList fastTravelTimersTags = levelData.func_150295_c("FastTravelTimers", (int)new NBTTagCompound().func_74732_a());
            if (fastTravelTimersTags != null) {
                for (int i = 0; i < fastTravelTimersTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = fastTravelTimersTags.func_150305_b(i);
                    int timer = nbt.func_74762_e("Timer");
                    if (timer < 0) {
                        timer = 0;
                    }
                    fastTravelTimers.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), timer);
                }
            }
            viewingFactions.clear();
            NBTTagList viewingFactionsTags = levelData.func_150295_c("ViewingFactions", (int)new NBTTagCompound().func_74732_a());
            if (viewingFactionsTags != null) {
                for (int i = 0; i < viewingFactionsTags.func_74745_c(); ++i) {
                    NBTTagCompound nbt = viewingFactionsTags.func_150305_b(i);
                    int factionID = nbt.func_74762_e("Faction");
                    LOTRFaction faction = LOTRFaction.forID(factionID);
                    if (faction == null || !faction.allowPlayer) continue;
                    viewingFactions.put(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")), faction);
                }
            }
            LOTRLevelData.loadPlayerSet(levelData, playersCheckedAchievements, "PlayersCheckedAchievements");
            LOTRLevelData.loadPlayerSet(levelData, playersCheckedAlignments, "PlayersCheckedAlignments");
            LOTRLevelData.loadPlayerSet(levelData, bannedStructurePlayers, "BannedStructurePlayers");
            LOTRLevelData.loadPlayerSet(levelData, melonFinders, "MelonFinders");
            LOTRLevelData.loadPlayerSet(levelData, hiddenAlignments, "HiddenAlignments");
            LOTRLevelData.loadPlayerSet(levelData, hiddenMapPlayers, "HiddenMapPlayers");
            LOTRGuiMessageTypes.loadAll(levelData);
            LOTRWaypoint.load(levelData);
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void loadStructureLocations(NBTTagCompound levelData, List structures, String name) {
        structures.clear();
        NBTTagList tags = null;
        NBTTagCompound structureLocations = levelData.func_74775_l("StructureLocations");
        if (structureLocations.func_74764_b(name)) {
            tags = structureLocations.func_150295_c(name, (int)new NBTTagCompound().func_74732_a());
        } else if (levelData.func_74764_b(name + "Locations")) {
            tags = levelData.func_150295_c(name + "Locations", (int)new NBTTagCompound().func_74732_a());
        }
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound nbt = tags.func_150305_b(i);
                int posX = nbt.func_74762_e("XPos");
                int posY = nbt.func_74762_e("YPos");
                int posZ = nbt.func_74762_e("ZPos");
                ChunkCoordinates coords = new ChunkCoordinates(posX, posY, posZ);
                structures.add(coords);
            }
        }
    }

    private static void loadPlayerSet(NBTTagCompound levelData, Set playerSet, String name) {
        playerSet.clear();
        NBTTagList tags = levelData.func_150295_c(name, (int)new NBTTagCompound().func_74732_a());
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound nbt = tags.func_150305_b(i);
                playerSet.add(new UUID(nbt.func_74763_f("UUIDMost"), nbt.func_74763_f("UUIDLeast")));
            }
        }
    }

    public static void setMadePortal(int i) {
        madePortal = i;
        needsSave = true;
    }

    public static void setMadeMiddleEarthPortal(int i) {
        madeMiddleEarthPortal = i;
        needsSave = true;
    }

    public static void markOverworldPortalLocation(int i, int j, int k) {
        overworldPortalX = i;
        overworldPortalY = j;
        overworldPortalZ = k;
        needsSave = true;
    }

    public static void markMiddleEarthPortalLocation(int i, int j, int k) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(i);
        data.writeInt(j);
        data.writeInt(k);
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.portalPos", data);
        MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
        needsSave = true;
    }

    public static void setBeaconState(int i) {
        beaconState = i;
        needsSave = true;
    }

    public static Packet getLoginPacket(EntityPlayer entityplayer) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(middleEarthPortalX);
        data.writeInt(middleEarthPortalY);
        data.writeInt(middleEarthPortalZ);
        data.writeByte((int)((byte)beaconState));
        data.writeBoolean(LOTRLevelData.getPlayerFoundMelon(entityplayer));
        data.writeBoolean(LOTRLevelData.getFriendlyFire(entityplayer));
        data.writeBoolean(LOTRLevelData.getEnableHiredDeathMessages(entityplayer));
        data.writeInt(LOTRLevelData.getFastTravelTimer(entityplayer));
        data.writeInt(LOTRLevelData.getViewingFactionID(entityplayer));
        data.writeBoolean(LOTRLevelData.getShowMapLocation(entityplayer));
        return new S3FPacketCustomPayload("lotr.login", data);
    }

    private static Map getAlignmentMap(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignmentMap(entityplayer.func_110124_au());
    }

    private static Map getAlignmentMap(UUID player) {
        HashMap map = (HashMap)alignments.get(player);
        if (map == null) {
            map = new HashMap();
            alignments.put(player, map);
        }
        return map;
    }

    public static int getAlignment(EntityPlayer entityplayer, LOTRFaction faction) {
        if (faction == LOTRFaction.UNALIGNED) {
            return 0;
        }
        if (!faction.allowPlayer) {
            return -1;
        }
        Object obj = LOTRLevelData.getAlignmentMap(entityplayer).get((Object)faction);
        return obj != null ? (Integer)obj : 0;
    }

    public static void addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.Bonus alignmentSource, LOTRFaction faction, Entity entity) {
        LOTRLevelData.addAlignment(entityplayer, alignmentSource, faction, entity.field_70165_t, entity.field_70121_D.field_72338_b + (double)entity.field_70131_O / 1.5, entity.field_70161_v);
    }

    public static void addAlignment(EntityPlayer entityplayer, LOTRAlignmentValues.Bonus alignmentSource, LOTRFaction faction, double posX, double posY, double posZ) {
        if (!faction.allowPlayer) {
            return;
        }
        int bonus = alignmentSource.bonus;
        if (alignmentSource.isKill) {
            int factionBonus;
            int alignment;
            for (LOTRFaction nextFaction : faction.killPositives) {
                alignment = LOTRLevelData.getAlignment(entityplayer, nextFaction);
                factionBonus = Math.abs(bonus);
                LOTRLevelData.getAlignmentMap(entityplayer).put(nextFaction, alignment += factionBonus);
                needsSave = true;
                LOTRLevelData.checkAlignmentAchievements(entityplayer, nextFaction);
                LOTRLevelData.sendAlignmentBonusPacket(entityplayer, alignmentSource, factionBonus, nextFaction, posX, posY, posZ);
            }
            for (LOTRFaction nextFaction : faction.killNegatives) {
                alignment = LOTRLevelData.getAlignment(entityplayer, nextFaction);
                factionBonus = -Math.abs(bonus);
                factionBonus = LOTRAlignmentValues.Bonus.scalePenalty(factionBonus, alignment);
                LOTRLevelData.getAlignmentMap(entityplayer).put(nextFaction, alignment += factionBonus);
                needsSave = true;
                LOTRLevelData.checkAlignmentAchievements(entityplayer, nextFaction);
                LOTRLevelData.sendAlignmentBonusPacket(entityplayer, alignmentSource, factionBonus, nextFaction, posX, posY, posZ);
            }
        } else {
            int alignment = LOTRLevelData.getAlignment(entityplayer, faction);
            LOTRLevelData.getAlignmentMap(entityplayer).put(faction, alignment += bonus);
            needsSave = true;
            LOTRLevelData.checkAlignmentAchievements(entityplayer, faction);
            LOTRLevelData.sendAlignmentBonusPacket(entityplayer, alignmentSource, bonus, faction, posX, posY, posZ);
        }
        LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
    }

    private static void sendAlignmentBonusPacket(EntityPlayer entityplayer, LOTRAlignmentValues.Bonus alignmentSource, int bonus, LOTRFaction faction, double posX, double posY, double posZ) {
        ByteBuf data = Unpooled.buffer();
        byte[] nameData = alignmentSource.name.getBytes(Charsets.UTF_8);
        data.writeInt(bonus);
        data.writeDouble(posX);
        data.writeDouble(posY);
        data.writeDouble(posZ);
        data.writeByte((int)((byte)faction.ordinal()));
        data.writeBoolean(alignmentSource.needsTranslation);
        data.writeBoolean(alignmentSource.isKill);
        data.writeShort(nameData.length);
        data.writeBytes(nameData);
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.alignBonus", data);
        ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
    }

    public static void addAlignmentFromCommand(EntityPlayer entityplayer, LOTRFaction faction, int add) {
        if (!faction.allowPlayer) {
            return;
        }
        int alignment = LOTRLevelData.getAlignment(entityplayer, faction);
        LOTRLevelData.getAlignmentMap(entityplayer).put(faction, alignment += add);
        needsSave = true;
        LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
        LOTRLevelData.checkAlignmentAchievements(entityplayer, faction);
    }

    private static void checkAlignmentAchievements(EntityPlayer entityplayer, LOTRFaction faction) {
        int alignment = LOTRLevelData.getAlignment(entityplayer, faction);
        if (alignment >= 10) {
            if (faction == LOTRFaction.HOBBIT) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_HOBBIT);
            }
            if (faction == LOTRFaction.RANGER_NORTH) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_RANGER_NORTH);
            }
            if (faction == LOTRFaction.HIGH_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_HIGH_ELF);
            }
            if (faction == LOTRFaction.GUNDABAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_GUNDABAD);
            }
            if (faction == LOTRFaction.ANGMAR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_ANGMAR);
            }
            if (faction == LOTRFaction.WOOD_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_WOOD_ELF);
            }
            if (faction == LOTRFaction.DOL_GULDUR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_DOL_GULDUR);
            }
            if (faction == LOTRFaction.DWARF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_DWARF);
            }
            if (faction == LOTRFaction.GALADHRIM) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_GALADHRIM);
            }
            if (faction == LOTRFaction.DUNLAND) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_DUNLAND);
            }
            if (faction == LOTRFaction.FANGORN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_FANGORN);
            }
            if (faction == LOTRFaction.ROHAN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_ROHAN);
            }
            if (faction == LOTRFaction.URUK_HAI) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_URUK_HAI);
            }
            if (faction == LOTRFaction.GONDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_GONDOR);
            }
            if (faction == LOTRFaction.MORDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_MORDOR);
            }
            if (faction == LOTRFaction.NEAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_NEAR_HARAD);
            }
            if (faction == LOTRFaction.FAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_FAR_HARAD);
            }
            if (faction == LOTRFaction.HALF_TROLL) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood10_HALF_TROLL);
            }
        }
        if (alignment >= 100) {
            if (faction == LOTRFaction.HOBBIT) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_HOBBIT);
            }
            if (faction == LOTRFaction.RANGER_NORTH) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_RANGER_NORTH);
            }
            if (faction == LOTRFaction.HIGH_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_HIGH_ELF);
            }
            if (faction == LOTRFaction.GUNDABAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_GUNDABAD);
            }
            if (faction == LOTRFaction.ANGMAR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_ANGMAR);
            }
            if (faction == LOTRFaction.WOOD_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_WOOD_ELF);
            }
            if (faction == LOTRFaction.DOL_GULDUR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_DOL_GULDUR);
            }
            if (faction == LOTRFaction.DWARF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_DWARF);
            }
            if (faction == LOTRFaction.GALADHRIM) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_GALADHRIM);
            }
            if (faction == LOTRFaction.DUNLAND) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_DUNLAND);
            }
            if (faction == LOTRFaction.FANGORN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_FANGORN);
            }
            if (faction == LOTRFaction.ROHAN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_ROHAN);
            }
            if (faction == LOTRFaction.URUK_HAI) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_URUK_HAI);
            }
            if (faction == LOTRFaction.GONDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_GONDOR);
            }
            if (faction == LOTRFaction.MORDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_MORDOR);
            }
            if (faction == LOTRFaction.NEAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_NEAR_HARAD);
            }
            if (faction == LOTRFaction.FAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_FAR_HARAD);
            }
            if (faction == LOTRFaction.HALF_TROLL) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood100_HALF_TROLL);
            }
        }
        if (alignment >= 1000) {
            if (faction == LOTRFaction.HOBBIT) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_HOBBIT);
            }
            if (faction == LOTRFaction.RANGER_NORTH) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_RANGER_NORTH);
            }
            if (faction == LOTRFaction.HIGH_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_HIGH_ELF);
            }
            if (faction == LOTRFaction.GUNDABAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_GUNDABAD);
            }
            if (faction == LOTRFaction.ANGMAR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_ANGMAR);
            }
            if (faction == LOTRFaction.WOOD_ELF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_WOOD_ELF);
            }
            if (faction == LOTRFaction.DOL_GULDUR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_DOL_GULDUR);
            }
            if (faction == LOTRFaction.DWARF) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_DWARF);
            }
            if (faction == LOTRFaction.GALADHRIM) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_GALADHRIM);
            }
            if (faction == LOTRFaction.DUNLAND) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_DUNLAND);
            }
            if (faction == LOTRFaction.FANGORN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_FANGORN);
            }
            if (faction == LOTRFaction.ROHAN) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_ROHAN);
            }
            if (faction == LOTRFaction.URUK_HAI) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_URUK_HAI);
            }
            if (faction == LOTRFaction.GONDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_GONDOR);
            }
            if (faction == LOTRFaction.MORDOR) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_MORDOR);
            }
            if (faction == LOTRFaction.NEAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_NEAR_HARAD);
            }
            if (faction == LOTRFaction.FAR_HARAD) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_FAR_HARAD);
            }
            if (faction == LOTRFaction.HALF_TROLL) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.alignmentGood1000_HALF_TROLL);
            }
        }
    }

    public static void setClientAlignment(UUID player, int alignment, LOTRFaction faction) {
        LOTRLevelData.getAlignmentMap(player).put(faction, alignment);
    }

    public static void sendAlignmentToAllPlayersInWorld(EntityPlayer entityplayer, World world) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer worldPlayer = (EntityPlayer)world.field_73010_i.get(i);
            ByteBuf data = Unpooled.buffer();
            data.writeLong(entityplayer.func_110124_au().getMostSignificantBits());
            data.writeLong(entityplayer.func_110124_au().getLeastSignificantBits());
            for (LOTRFaction faction : LOTRFaction.values()) {
                int alignment = LOTRLevelData.getAlignment(entityplayer, faction);
                data.writeInt(alignment);
            }
            data.writeBoolean(LOTRLevelData.getHideAlignment(entityplayer));
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.alignment", data);
            ((EntityPlayerMP)worldPlayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static void sendAllAlignmentsInWorldToPlayer(EntityPlayer entityplayer, World world) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer worldPlayer = (EntityPlayer)world.field_73010_i.get(i);
            ByteBuf data = Unpooled.buffer();
            data.writeLong(worldPlayer.func_110124_au().getMostSignificantBits());
            data.writeLong(worldPlayer.func_110124_au().getLeastSignificantBits());
            for (LOTRFaction faction : LOTRFaction.values()) {
                int alignment = LOTRLevelData.getAlignment(worldPlayer, faction);
                data.writeInt(alignment);
            }
            data.writeBoolean(LOTRLevelData.getHideAlignment(worldPlayer));
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.alignment", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static void clearClientAlignments() {
        alignments.clear();
        hiddenAlignments.clear();
    }

    public static Packet getLoginAchievementsPacket(EntityPlayer entityplayer) {
        int achievementCount = 0;
        ArrayList<LOTRAchievement> achievementsToSend = new ArrayList<LOTRAchievement>();
        if (achievements.get(entityplayer.func_110124_au()) == null) {
            return null;
        }
        ArrayList playerAchievements = (ArrayList)achievements.get(entityplayer.func_110124_au());
        for (LOTRAchievement achievement : playerAchievements) {
            ++achievementCount;
            achievementsToSend.add(achievement);
        }
        if (achievementCount == 0) {
            return null;
        }
        ByteBuf data = Unpooled.buffer();
        for (int i = 0; i < achievementCount; ++i) {
            LOTRAchievement achievement;
            achievement = (LOTRAchievement)achievementsToSend.get(i);
            data.writeByte((int)((byte)achievement.category.ordinal()));
            data.writeByte((int)((byte)achievement.ID));
        }
        return new S3FPacketCustomPayload("lotr.loginAch", data);
    }

    public static void addAchievement(EntityPlayer entityplayer, LOTRAchievement achievement) {
        if (LOTRLevelData.hasAchievement(entityplayer, achievement)) {
            return;
        }
        if (achievements.get(entityplayer.func_110124_au()) == null) {
            achievements.put(entityplayer.func_110124_au(), new ArrayList());
        }
        if (achievement.canPlayerEarn(entityplayer)) {
            ArrayList playerAchievements = (ArrayList)achievements.get(entityplayer.func_110124_au());
            playerAchievements.add(achievement);
            needsSave = true;
            ByteBuf data = Unpooled.buffer();
            data.writeByte((int)((byte)achievement.category.ordinal()));
            data.writeByte((int)((byte)achievement.ID));
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.achieve", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentTranslation("chat.lotr.achievement", new Object[]{entityplayer.func_145748_c_(), achievement.getChatComponentForEarn()}));
            ArrayList earnedAchievements = LOTRLevelData.getPlayerEarnedAchievements(entityplayer);
            int biomes = 0;
            for (int i = 0; i < earnedAchievements.size(); ++i) {
                LOTRAchievement earnedAchievement = (LOTRAchievement)earnedAchievements.get(i);
                if (!earnedAchievement.isBiomeAchievement) continue;
                ++biomes;
            }
            if (biomes >= 10) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.travel10);
            }
            if (biomes >= 20) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.travel20);
            }
            if (biomes >= 30) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.travel30);
            }
            if (biomes >= 40) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.travel40);
            }
            if (biomes >= 50) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.travel50);
            }
        }
    }

    public static ArrayList getPlayerAchievements(EntityPlayer entityplayer) {
        if (achievements.get(entityplayer.func_110124_au()) == null) {
            achievements.put(entityplayer.func_110124_au(), new ArrayList());
        }
        return (ArrayList)achievements.get(entityplayer.func_110124_au());
    }

    public static ArrayList getPlayerEarnedAchievements(EntityPlayer entityplayer) {
        ArrayList<LOTRAchievement> earnedAchievements = new ArrayList<LOTRAchievement>();
        for (LOTRAchievement achievement : LOTRLevelData.getPlayerAchievements(entityplayer)) {
            if (!achievement.canPlayerEarn(entityplayer)) continue;
            earnedAchievements.add(achievement);
        }
        return earnedAchievements;
    }

    public static void addClientAchievement(EntityPlayer entityplayer, LOTRAchievement achievement) {
        if (LOTRLevelData.hasAchievement(entityplayer, achievement)) {
            return;
        }
        if (achievements.get(entityplayer.func_110124_au()) == null) {
            achievements.put(entityplayer.func_110124_au(), new ArrayList());
        }
        ArrayList playerAchievements = (ArrayList)achievements.get(entityplayer.func_110124_au());
        playerAchievements.add(achievement);
    }

    public static boolean hasAchievement(EntityPlayer entityplayer, LOTRAchievement achievement) {
        if (achievements.get(entityplayer.func_110124_au()) != null) {
            ArrayList playerAchievements = (ArrayList)achievements.get(entityplayer.func_110124_au());
            for (LOTRAchievement a : playerAchievements) {
                if (a.category != achievement.category || a.ID != achievement.ID) continue;
                return true;
            }
        }
        return false;
    }

    public static void clearClientAchievements() {
        achievements.clear();
    }

    public static LOTRCapes getCape(EntityPlayer entityplayer) {
        return (LOTRCapes)((Object)capes.get(entityplayer.func_110124_au()));
    }

    public static void setCape(EntityPlayer entityplayer, LOTRCapes cape) {
        capes.put(entityplayer.func_110124_au(), cape);
        needsSave = true;
    }

    public static void setClientCape(UUID player, LOTRCapes cape) {
        capes.put(player, cape);
    }

    public static boolean getEnableCape(EntityPlayer entityplayer) {
        Object obj = capesEnabled.get(entityplayer.func_110124_au());
        return obj == null ? true : (Boolean)obj;
    }

    public static void setEnableCape(EntityPlayer entityplayer, boolean flag) {
        capesEnabled.put(entityplayer.func_110124_au(), flag);
        needsSave = true;
    }

    public static void setClientEnableCape(UUID player, boolean flag) {
        capesEnabled.put(player, flag);
    }

    public static void selectDefaultCapeForPlayer(EntityPlayer entityplayer) {
        if (LOTRLevelData.getCape(entityplayer) == null) {
            for (LOTRCapes cape : LOTRCapes.values()) {
                if (!cape.canPlayerWearCape(entityplayer)) continue;
                LOTRLevelData.setCape(entityplayer, cape);
                return;
            }
        }
    }

    public static void sendCapeToAllPlayersInWorld(EntityPlayer entityplayer, World world) {
        LOTRCapes cape = LOTRLevelData.getCape(entityplayer);
        if (cape != null) {
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer worldPlayer = (EntityPlayer)world.field_73010_i.get(i);
                ByteBuf data = Unpooled.buffer();
                data.writeLong(entityplayer.func_110124_au().getMostSignificantBits());
                data.writeLong(entityplayer.func_110124_au().getLeastSignificantBits());
                data.writeByte((int)((byte)cape.capeID));
                data.writeByte((int)((byte)cape.capeType.ordinal()));
                data.writeBoolean(LOTRLevelData.getEnableCape(entityplayer));
                S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.updateCape", data);
                ((EntityPlayerMP)worldPlayer).field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public static void sendAllCapesInWorldToPlayer(EntityPlayer entityplayer, World world) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer worldPlayer = (EntityPlayer)world.field_73010_i.get(i);
            LOTRCapes cape = LOTRLevelData.getCape(worldPlayer);
            if (cape == null) continue;
            ByteBuf data = Unpooled.buffer();
            data.writeLong(worldPlayer.func_110124_au().getMostSignificantBits());
            data.writeLong(worldPlayer.func_110124_au().getLeastSignificantBits());
            data.writeByte((int)((byte)cape.capeID));
            data.writeByte((int)((byte)cape.capeType.ordinal()));
            data.writeBoolean(LOTRLevelData.getEnableCape(worldPlayer));
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.updateCape", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static void clearClientCapes() {
        capes.clear();
        capesEnabled.clear();
    }

    public static boolean getFriendlyFire(EntityPlayer entityplayer) {
        Object obj = friendlyFire.get(entityplayer.func_110124_au());
        return obj != null ? (Boolean)obj : false;
    }

    public static void setFriendlyFire(EntityPlayer entityplayer, boolean flag) {
        friendlyFire.put(entityplayer.func_110124_au(), flag);
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
            LOTRLevelData.sendOptionsPacket(entityplayer, LOTROptions.FRIENDLY_FIRE, flag);
        }
    }

    public static boolean getEnableHiredDeathMessages(EntityPlayer entityplayer) {
        Object obj = hiredDeathMessages.get(entityplayer.func_110124_au());
        return obj != null ? (Boolean)obj : true;
    }

    public static void setEnableHiredDeathMessages(EntityPlayer entityplayer, boolean flag) {
        hiredDeathMessages.put(entityplayer.func_110124_au(), flag);
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
            LOTRLevelData.sendOptionsPacket(entityplayer, LOTROptions.HIRED_DEATH_MESSAGES, flag);
        }
    }

    private static void sendOptionsPacket(EntityPlayer entityplayer, int option, boolean flag) {
        ByteBuf data = Unpooled.buffer();
        data.writeByte((int)((byte)option));
        data.writeBoolean(flag);
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.options", data);
        ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
    }

    public static boolean getPlayerFoundMelon(EntityPlayer entityplayer) {
        return melonFinders.contains(entityplayer.func_110124_au());
    }

    public static void setPlayerFoundMelon(EntityPlayer entityplayer) {
        melonFinders.add(entityplayer.func_110124_au());
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.findMelon", Unpooled.buffer((int)0));
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static boolean getHideAlignment(EntityPlayer entityplayer) {
        return hiddenAlignments.contains(entityplayer.func_110124_au());
    }

    public static void setHideAlignment(EntityPlayer entityplayer, boolean flag) {
        if (flag) {
            hiddenAlignments.add(entityplayer.func_110124_au());
        } else {
            hiddenAlignments.remove(entityplayer.func_110124_au());
        }
        needsSave = true;
        LOTRLevelData.sendAlignmentToAllPlayersInWorld(entityplayer, entityplayer.field_70170_p);
    }

    public static void setClientHideAlignment(UUID player, boolean flag) {
        if (flag) {
            hiddenAlignments.add(player);
        } else {
            hiddenAlignments.remove(player);
        }
    }

    public static int getFastTravelTimer(EntityPlayer entityplayer) {
        Object obj = fastTravelTimers.get(entityplayer.func_110124_au());
        return obj != null ? (Integer)obj : 0;
    }

    public static void setFastTravelTimer(EntityPlayer entityplayer, int i) {
        if (i < 0) {
            i = 0;
        }
        fastTravelTimers.put(entityplayer.func_110124_au(), i);
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
            ByteBuf data = Unpooled.buffer();
            data.writeInt(i);
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.ftTimer", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static int getViewingFactionID(EntityPlayer entityplayer) {
        Object obj = viewingFactions.get(entityplayer.func_110124_au());
        return obj != null ? ((LOTRFaction)((Object)obj)).ordinal() : -1;
    }

    public static void setViewingFaction(EntityPlayer entityplayer, LOTRFaction faction) {
        if (!faction.allowPlayer) {
            return;
        }
        viewingFactions.put(entityplayer.func_110124_au(), faction);
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
        }
    }

    public static boolean getShowMapLocation(EntityPlayer entityplayer) {
        return !hiddenMapPlayers.contains(entityplayer.func_110124_au());
    }

    public static void setShowMapLocation(EntityPlayer entityplayer, boolean flag) {
        if (!flag) {
            hiddenMapPlayers.add(entityplayer.func_110124_au());
        } else {
            hiddenMapPlayers.remove(entityplayer.func_110124_au());
        }
        if (!entityplayer.field_70170_p.field_72995_K) {
            needsSave = true;
            ByteBuf data = Unpooled.buffer();
            data.writeBoolean(flag);
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.showPos", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static void sendPlayerLocationsToPlayer(EntityPlayer entityplayer, World world) {
        ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.clearMap", Unpooled.buffer((int)0)));
        boolean isOp = MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(entityplayer.func_70005_c_());
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer worldPlayer = (EntityPlayer)world.field_73010_i.get(i);
            if (worldPlayer == entityplayer || !isOp && !LOTRLevelData.getShowMapLocation(worldPlayer)) continue;
            ByteBuf data = Unpooled.buffer();
            data.writeLong(worldPlayer.func_110124_au().getMostSignificantBits());
            data.writeLong(worldPlayer.func_110124_au().getLeastSignificantBits());
            data.writeDouble(worldPlayer.field_70165_t);
            data.writeDouble(worldPlayer.field_70161_v);
            String username = worldPlayer.func_70005_c_();
            byte[] usernameData = username.getBytes(Charsets.UTF_8);
            data.writeShort(usernameData.length);
            data.writeBytes(usernameData);
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.playerPos", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    public static String getHoursMinutesTime(int i) {
        return i / 72000 + "h " + i % 72000 / 1200 + "m";
    }

    public static int getRandomElvenTraderTime() {
        return 50000 + rand.nextInt(250000);
    }

    static {
        beaconTowerLocations = new ArrayList();
        gondorFortressLocations = new ArrayList();
        dwarvenTowerLocations = new ArrayList();
        urukCampLocations = new ArrayList();
        rohanFortressLocations = new ArrayList();
        woodElvenTowerLocations = new ArrayList();
        mordorTowerLocations = new ArrayList();
        nurnFarmLocations = new ArrayList();
        gundabadCampLocations = new ArrayList();
        dunlandHillFortLocations = new ArrayList();
        blueMountainsStrongholdLocations = new ArrayList();
        rangerCampLocations = new ArrayList();
        alignments = new HashMap();
        achievements = new HashMap();
        capes = new HashMap();
        capesEnabled = new HashMap();
        friendlyFire = new HashMap();
        hiredDeathMessages = new HashMap();
        playerDeathPoints = new HashMap();
        fastTravelTimers = new HashMap();
        viewingFactions = new HashMap();
        playersCheckedAchievements = new HashSet();
        playersCheckedAlignments = new HashSet();
        bannedStructurePlayers = new HashSet();
        melonFinders = new HashSet();
        hiddenAlignments = new HashSet();
        hiddenMapPlayers = new HashSet();
        needsLoad = true;
        needsSave = false;
        rand = new Random();
    }
}

