/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRReflection;
import lotr.common.block.LOTRBlockCraftingTable;
import lotr.common.block.LOTRBlockPortal;
import lotr.common.entity.item.LOTREntityPortal;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.entity.npc.LOTREntityDunlendingArcher;
import lotr.common.entity.npc.LOTREntityDunlendingWarrior;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityDwarfAxeThrower;
import lotr.common.entity.npc.LOTREntityDwarfWarrior;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.entity.npc.LOTREntityGollum;
import lotr.common.entity.npc.LOTREntityGondorArcher;
import lotr.common.entity.npc.LOTREntityGondorSoldier;
import lotr.common.entity.npc.LOTREntityGundabadOrc;
import lotr.common.entity.npc.LOTREntityGundabadOrcArcher;
import lotr.common.entity.npc.LOTREntityMordorOrc;
import lotr.common.entity.npc.LOTREntityNurnSlave;
import lotr.common.entity.npc.LOTREntityRanger;
import lotr.common.entity.npc.LOTREntityRangerNorth;
import lotr.common.entity.npc.LOTREntityRohirrim;
import lotr.common.entity.npc.LOTREntityRohirrimArcher;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTREntityUrukHaiCrossbower;
import lotr.common.entity.npc.LOTREntityWoodElf;
import lotr.common.entity.npc.LOTREntityWoodElfScout;
import lotr.common.entity.npc.LOTREntityWoodElfWarrior;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.item.LOTRItemStructureSpawner;
import lotr.common.world.LOTRDerivedWorldInfo;
import lotr.common.world.LOTRSpawnerNPCs;
import lotr.common.world.LOTRStructureSpawningInfo;
import lotr.common.world.LOTRTeleporter;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.biome.LOTRBiomeGenMistyMountains;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.oredict.OreDictionary;

public class LOTRTickHandlerServer {
    public static List structureSpawning = new ArrayList();
    public static HashMap playersInPortals;
    public static HashMap playersInElvenPortals;
    public static HashMap playersInMorgulPortals;
    private int fireworkDisplay;

    public LOTRTickHandlerServer() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (world == DimensionManager.getWorld((int)0)) {
            if (LOTRLevelData.needsLoad) {
                LOTRLevelData.load();
                LOTRLevelData.needsLoad = false;
            }
            if (LOTRLevelData.needsSave) {
                LOTRLevelData.save();
                LOTRLevelData.needsSave = false;
            }
            if (world.func_72820_D() % 600L == 0L) {
                LOTRLevelData.save();
            }
            if (LOTRItemStructureSpawner.lastStructureSpawnTick > 0) {
                --LOTRItemStructureSpawner.lastStructureSpawnTick;
            }
        }
        if (world == DimensionManager.getWorld((int)LOTRMod.idDimension)) {
            int i;
            if (world.func_72912_H().getClass() != LOTRDerivedWorldInfo.class) {
                LOTRReflection.setWorldInfo((World)((WorldServer)world), (WorldInfo)new LOTRDerivedWorldInfo(DimensionManager.getWorld((int)0).func_72912_H()));
                System.out.println("Replaced LOTR world info");
            }
            if (!world.field_73010_i.isEmpty()) {
                int k;
                EntityPlayer entityplayer;
                EntityPlayer entityplayer2;
                if (LOTRLevelData.timeUntilElvenTrader > 0) {
                    --LOTRLevelData.timeUntilElvenTrader;
                } else {
                    block0: for (int players = 0; players < world.field_73010_i.size(); ++players) {
                        entityplayer2 = (EntityPlayer)world.field_73010_i.get(players);
                        for (int attempts = 0; attempts < 16; ++attempts) {
                            int j;
                            int k2;
                            float angle = world.field_73012_v.nextFloat() * 360.0f;
                            int i2 = MathHelper.func_76128_c((double)entityplayer2.field_70165_t) + MathHelper.func_76128_c((double)(MathHelper.func_76126_a((float)angle) * (float)(48 + world.field_73012_v.nextInt(33))));
                            BiomeGenBase biome = world.func_72807_a(i2, k2 = MathHelper.func_76128_c((double)entityplayer2.field_70161_v) + MathHelper.func_76128_c((double)(MathHelper.func_76134_b((float)angle) * (float)(48 + world.field_73012_v.nextInt(33)))));
                            if (!(biome instanceof LOTRBiome) || !((LOTRBiome)biome).canElvenTraderVisit || (j = world.func_72976_f(i2, k2)) <= 62 || world.func_147439_a(i2, j - 1, k2) != Blocks.field_150349_c || world.func_147439_a(i2, j, k2).func_149721_r() || world.func_147439_a(i2, j + 1, k2).func_149721_r()) continue;
                            LOTREntityElvenTrader trader = new LOTREntityElvenTrader(world);
                            trader.func_70012_b((double)i2 + 0.5, j, (double)k2 + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            if (!trader.func_70601_bi()) continue;
                            world.func_72838_d((Entity)trader);
                            trader.startVisiting(entityplayer2);
                            LOTRLevelData.timeUntilElvenTrader = LOTRLevelData.getRandomElvenTraderTime();
                            LOTRLevelData.needsSave = true;
                            break block0;
                        }
                    }
                }
                if (LOTRLevelData.gollumRespawnTime > 0) {
                    --LOTRLevelData.gollumRespawnTime;
                } else if (LOTRLevelData.hasGollum == 0 && (entityplayer = world.func_72924_a(LOTREntityGollum.OWNER_NAME)) != null) {
                    for (int attempts = 0; attempts < 16; ++attempts) {
                        int j;
                        int i3 = MathHelper.func_76128_c((double)entityplayer.field_70165_t) - 8 + world.field_73012_v.nextInt(17);
                        if (!world.func_147439_a(i3, (j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b) - 4 + world.field_73012_v.nextInt(9)) - 1, k = MathHelper.func_76128_c((double)entityplayer.field_70161_v) - 8 + world.field_73012_v.nextInt(17)).func_149721_r() || world.func_147439_a(i3, j, k).func_149721_r() || world.func_147439_a(i3, j + 1, k).func_149721_r()) continue;
                        LOTREntityGollum gollum = new LOTREntityGollum(world);
                        gollum.func_70012_b((double)i3 + 0.5, j, (double)k + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (!gollum.func_70601_bi()) continue;
                        world.func_72838_d((Entity)gollum);
                        gollum.setGollumOwnerName(LOTREntityGollum.OWNER_NAME);
                        gollum.func_70642_aH();
                        entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)gollum, "gollum_spawn", entityplayer));
                        LOTRLevelData.hasGollum = 1;
                        LOTRLevelData.needsSave = true;
                        break;
                    }
                }
                if (LOTRMod.isNewYearsDay()) {
                    if (this.fireworkDisplay == 0 && world.field_73012_v.nextInt(4000) == 0) {
                        this.fireworkDisplay = 100 + world.field_73012_v.nextInt(300);
                    }
                    if (this.fireworkDisplay > 0) {
                        --this.fireworkDisplay;
                        if (world.field_73012_v.nextInt(50) == 0) {
                            int launches = 1 + world.field_73012_v.nextInt(7 + world.field_73010_i.size() / 2);
                            for (int l = 0; l < launches; ++l) {
                                int j;
                                EntityPlayer entityplayer3 = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
                                int i4 = MathHelper.func_76128_c((double)entityplayer3.field_70165_t) - 64 + world.field_73012_v.nextInt(129);
                                if (!world.func_147439_a(i4, (j = world.func_72976_f(i4, k = MathHelper.func_76128_c((double)entityplayer3.field_70161_v) - 64 + world.field_73012_v.nextInt(129))) - 1, k).func_149721_r()) continue;
                                int fireworks = 1 + world.field_73012_v.nextInt(4);
                                for (int l1 = 0; l1 < fireworks; ++l1) {
                                    int k1;
                                    int j1;
                                    int i1 = i4 - world.field_73012_v.nextInt(8) + world.field_73012_v.nextInt(8);
                                    if (!world.func_147439_a(i1, (j1 = world.func_72976_f(i1, k1 = k - world.field_73012_v.nextInt(8) + world.field_73012_v.nextInt(8))) - 1, k1).func_149721_r()) continue;
                                    ItemStack itemstack = new ItemStack(Items.field_151152_bP);
                                    NBTTagCompound itemData = new NBTTagCompound();
                                    NBTTagCompound fireworkData = new NBTTagCompound();
                                    NBTTagList explosionsList = new NBTTagList();
                                    int explosions = 1 + world.field_73012_v.nextInt(3);
                                    for (int l2 = 0; l2 < explosions; ++l2) {
                                        NBTTagCompound explosionData = new NBTTagCompound();
                                        if (world.field_73012_v.nextBoolean()) {
                                            explosionData.func_74757_a("Flicker", true);
                                        }
                                        if (world.field_73012_v.nextBoolean()) {
                                            explosionData.func_74757_a("Trail", true);
                                        }
                                        int[] colors = new int[1 + world.field_73012_v.nextInt(3)];
                                        for (int l3 = 0; l3 < colors.length; ++l3) {
                                            colors[l3] = ItemDye.field_150922_c[world.field_73012_v.nextInt(ItemDye.field_150922_c.length)];
                                        }
                                        explosionData.func_74783_a("Colors", colors);
                                        int effectType = world.field_73012_v.nextInt(5);
                                        if (effectType == 3) {
                                            effectType = 0;
                                        }
                                        explosionData.func_74774_a("Type", (byte)effectType);
                                        explosionsList.func_74742_a((NBTBase)explosionData);
                                    }
                                    fireworkData.func_74782_a("Explosions", (NBTBase)explosionsList);
                                    int flight = 1 + world.field_73012_v.nextInt(3);
                                    fireworkData.func_74774_a("Flight", (byte)flight);
                                    itemData.func_74782_a("Fireworks", (NBTBase)fireworkData);
                                    itemstack.func_77982_d(itemData);
                                    EntityFireworkRocket firework = new EntityFireworkRocket(world, (double)i1 + 0.5, (double)j1 + 0.5, (double)k1 + 0.5, itemstack);
                                    world.func_72838_d((Entity)firework);
                                }
                            }
                        }
                    }
                }
                if (world.func_72820_D() % 20L == 0L) {
                    for (i = 0; i < world.field_73010_i.size(); ++i) {
                        entityplayer2 = (EntityPlayer)world.field_73010_i.get(i);
                        LOTRLevelData.sendPlayerLocationsToPlayer(entityplayer2, world);
                    }
                }
            }
            if (world.func_82736_K().func_82766_b("doMobSpawning")) {
                LOTRSpawnerNPCs.performSpawning(world);
                for (i = 0; i < structureSpawning.size(); ++i) {
                    LOTRStructureSpawningInfo obj = (LOTRStructureSpawningInfo)structureSpawning.get(i);
                    obj.performSpawning(world);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world == null || world.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (player != null && player instanceof EntityPlayerMP) {
            EntityItem item;
            List items;
            EntityPlayerMP entityplayer = (EntityPlayerMP)player;
            this.runAchievementChecks((EntityPlayer)entityplayer);
            int fastTravelTimer = LOTRLevelData.getFastTravelTimer((EntityPlayer)entityplayer);
            if (fastTravelTimer > 0) {
                LOTRLevelData.setFastTravelTimer((EntityPlayer)entityplayer, --fastTravelTimer);
            }
            if (entityplayer.field_71093_bK == LOTRMod.idDimension) {
                if (!LOTRLevelData.playersCheckedAchievements.contains(entityplayer.func_110124_au())) {
                    entityplayer.field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.promptAch", Unpooled.buffer((int)0)));
                } else if (!LOTRLevelData.playersCheckedAlignments.contains(entityplayer.func_110124_au())) {
                    entityplayer.field_71135_a.func_147359_a((Packet)new S3FPacketCustomPayload("lotr.promptAl", Unpooled.buffer((int)0)));
                }
            }
            if (entityplayer.field_71093_bK == 0 && LOTRLevelData.madePortal == 0) {
                items = world.func_72872_a(EntityItem.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                for (Object obj : items) {
                    item = (EntityItem)obj;
                    if (LOTRLevelData.madePortal != 0 || item.func_92059_d() == null || item.func_92059_d().func_77973_b() != LOTRMod.goldRing || !item.func_70027_ad()) continue;
                    LOTRLevelData.setMadePortal(1);
                    LOTRLevelData.markOverworldPortalLocation(MathHelper.func_76128_c((double)item.field_70165_t), MathHelper.func_76128_c((double)item.field_70163_u), MathHelper.func_76128_c((double)item.field_70161_v));
                    item.func_70106_y();
                    world.func_72876_a((Entity)entityplayer, item.field_70165_t, item.field_70163_u + 3.0, item.field_70161_v, 3.0f, true);
                    LOTREntityPortal portal = new LOTREntityPortal(world);
                    portal.func_70012_b(item.field_70165_t, item.field_70163_u + 3.0, item.field_70161_v, 0.0f, 0.0f);
                    world.func_72838_d((Entity)portal);
                }
            }
            if (entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRMod.idDimension) {
                items = world.func_72872_a(EntityItem.class, entityplayer.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                for (Object obj : items) {
                    int k1;
                    int i1;
                    int[] portalLocation;
                    boolean foundPortalLocation;
                    item = (EntityItem)obj;
                    if (item.func_92059_d() == null) continue;
                    int i = MathHelper.func_76128_c((double)item.field_70165_t);
                    int j = MathHelper.func_76128_c((double)item.field_70163_u);
                    int k = MathHelper.func_76128_c((double)item.field_70161_v);
                    ItemStack itemstack = item.func_92059_d();
                    if (LOTRLevelData.getAlignment((EntityPlayer)entityplayer, LOTRFaction.GALADHRIM) > LOTRAlignmentValues.USE_PORTAL && (itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.elanor) || itemstack.func_77973_b() == Item.func_150898_a((Block)LOTRMod.niphredil))) {
                        foundPortalLocation = false;
                        portalLocation = new int[3];
                        for (i1 = i - 2; !foundPortalLocation && i1 <= i + 2; ++i1) {
                            for (k1 = k - 2; !foundPortalLocation && k1 <= k + 2; ++k1) {
                                if (!((LOTRBlockPortal)LOTRMod.elvenPortal).isValidPortalLocation(world, i1, j, k1, false)) continue;
                                foundPortalLocation = true;
                                portalLocation = new int[]{i1, j, k1};
                            }
                        }
                        if (foundPortalLocation) {
                            item.func_70106_y();
                            for (i1 = -1; i1 <= 1; ++i1) {
                                for (k1 = -1; k1 <= 1; ++k1) {
                                    world.func_147465_d(portalLocation[0] + i1, portalLocation[1], portalLocation[2] + k1, LOTRMod.elvenPortal, 0, 2);
                                }
                            }
                        }
                    }
                    if (LOTRLevelData.getAlignment((EntityPlayer)entityplayer, LOTRFaction.MORDOR) <= LOTRAlignmentValues.USE_PORTAL && LOTRLevelData.getAlignment((EntityPlayer)entityplayer, LOTRFaction.ANGMAR) <= LOTRAlignmentValues.USE_PORTAL || !OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemstack)).equals("bone")) continue;
                    foundPortalLocation = false;
                    portalLocation = new int[3];
                    for (i1 = i - 2; !foundPortalLocation && i1 <= i + 2; ++i1) {
                        for (k1 = k - 2; !foundPortalLocation && k1 <= k + 2; ++k1) {
                            if (!((LOTRBlockPortal)LOTRMod.morgulPortal).isValidPortalLocation(world, i1, j, k1, false)) continue;
                            foundPortalLocation = true;
                            portalLocation = new int[]{i1, j, k1};
                        }
                    }
                    if (!foundPortalLocation) continue;
                    item.func_70106_y();
                    for (i1 = -1; i1 <= 1; ++i1) {
                        for (k1 = -1; k1 <= 1; ++k1) {
                            world.func_147465_d(portalLocation[0] + i1, portalLocation[1], portalLocation[2] + k1, LOTRMod.morgulPortal, 0, 2);
                        }
                    }
                }
            }
            if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRMod.idDimension) && playersInPortals.containsKey(entityplayer)) {
                int i;
                List portals = world.func_72872_a(LOTREntityPortal.class, entityplayer.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
                boolean inPortal = false;
                for (i = 0; i < portals.size(); ++i) {
                    LOTREntityPortal portal = (LOTREntityPortal)((Object)portals.get(i));
                    if (!portal.field_70121_D.func_72326_a(entityplayer.field_70121_D)) continue;
                    inPortal = true;
                    break;
                }
                if (inPortal) {
                    i = (Integer)playersInPortals.get(entityplayer);
                    playersInPortals.put(entityplayer, ++i);
                    if (i >= 100) {
                        int dimension = 0;
                        if (entityplayer.field_71093_bK == 0) {
                            dimension = LOTRMod.idDimension;
                        } else if (entityplayer.field_71093_bK == LOTRMod.idDimension) {
                            dimension = 0;
                        }
                        if (world instanceof WorldServer) {
                            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(entityplayer, dimension, (Teleporter)new LOTRTeleporter(DimensionManager.getWorld((int)dimension)));
                        }
                        playersInPortals.remove(entityplayer);
                    }
                } else {
                    playersInPortals.remove(entityplayer);
                }
            }
            this.updatePlayerInPortal(entityplayer, playersInElvenPortals, (LOTRBlockPortal)LOTRMod.elvenPortal);
            this.updatePlayerInPortal(entityplayer, playersInMorgulPortals, (LOTRBlockPortal)LOTRMod.morgulPortal);
        }
    }

    private void updatePlayerInPortal(EntityPlayerMP entityplayer, HashMap players, LOTRBlockPortal portalBlock) {
        if ((entityplayer.field_71093_bK == 0 || entityplayer.field_71093_bK == LOTRMod.idDimension) && players.containsKey(entityplayer)) {
            boolean inPortal;
            boolean bl = inPortal = entityplayer.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entityplayer.field_70165_t), MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)entityplayer.field_70161_v)) == portalBlock;
            if (inPortal) {
                int i = (Integer)players.get(entityplayer);
                players.put(entityplayer, ++i);
                if (i >= entityplayer.func_82145_z()) {
                    int dimension = 0;
                    if (entityplayer.field_71093_bK == 0) {
                        dimension = LOTRMod.idDimension;
                    } else if (entityplayer.field_71093_bK == LOTRMod.idDimension) {
                        dimension = 0;
                    }
                    WorldServer newWorld = MinecraftServer.func_71276_C().func_71218_a(dimension);
                    MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(entityplayer, dimension, portalBlock.getPortalTeleporter(newWorld));
                    players.remove(entityplayer);
                }
            } else {
                players.remove(entityplayer);
            }
        }
    }

    private void runAchievementChecks(EntityPlayer entityplayer) {
        World world = entityplayer.field_70170_p;
        int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityplayer.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome) {
            LOTRBiome lotrbiome = (LOTRBiome)biome;
            if (lotrbiome.getBiomeAchievement() != null) {
                LOTRLevelData.addAchievement(entityplayer, lotrbiome.getBiomeAchievement());
            }
            if (lotrbiome.getBiomeWaypoints() != null) {
                lotrbiome.getBiomeWaypoints().unlockForPlayer(entityplayer);
            }
        }
        if (entityplayer.field_71093_bK == LOTRMod.idDimension) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.enterMiddleEarth);
        }
        if (entityplayer.field_71071_by.func_146028_b(LOTRMod.pouch)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.getPouch);
        }
        HashSet<Block> tables = new HashSet<Block>();
        int crossbowBolts = 0;
        for (ItemStack item : entityplayer.field_71071_by.field_70462_a) {
            Block block;
            if (item != null && item.func_77973_b() instanceof ItemBlock && (block = Block.func_149634_a((Item)item.func_77973_b())) instanceof LOTRBlockCraftingTable) {
                tables.add(block);
            }
            if (item == null || item.func_77973_b() != LOTRMod.crossbowBolt) continue;
            crossbowBolts += item.field_77994_a;
        }
        if (tables.size() >= 5) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.collectCraftingTables);
        }
        if (crossbowBolts >= 128) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.collectCrossbowBolts);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorMithril)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullMithril);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorWarg)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullWargFur);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorHighElven)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullHighElven);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorRanger)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullRanger);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorAngmar)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullAngmar);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorWoodElvenScout)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullWoodElvenScout);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorWoodElven)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullWoodElven);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorDwarven)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullDwarven);
        }
        if (biome instanceof LOTRBiomeGenMistyMountains && entityplayer.field_70163_u > 192.0) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.climbMistyMountains);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorElven)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullElven);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorUruk)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullUruk);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorRohan)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullRohirric);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorDunlending)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullDunlending);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorGondor)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullGondorian);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorOrc)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullOrc);
        }
        if (this.isPlayerWearingFull(entityplayer, LOTRMod.armorNearHarad)) {
            LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.wearFullNearHarad);
        }
    }

    private boolean isPlayerWearingFull(EntityPlayer entityplayer, ItemArmor.ArmorMaterial material) {
        for (ItemStack itemstack : entityplayer.field_71071_by.field_70460_b) {
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemstack.func_77973_b()).func_82812_d() == material) continue;
            return false;
        }
        return true;
    }

    static {
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.beaconTowerLocations).setCheckInfo(16, -12, 12, LOTREntityGondorSoldier.class, 4).setSpawnInfo(2, -2, 2, LOTREntityGondorSoldier.class, LOTREntityGondorArcher.class, 16).addSpawnBlock(LOTRMod.slabDouble, 2).addSpecialEquipment(4, new ItemStack(LOTRMod.helmetGondorWinged)));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.gondorFortressLocations).setCheckInfo(24, -8, 18, LOTREntityGondorSoldier.class, 12).setSpawnInfo(4, 2, 17, LOTREntityGondorSoldier.class, LOTREntityGondorArcher.class, 32).addSpawnBlock(LOTRMod.brick, 1).addSpawnBlock(LOTRMod.brick, 2).addSpawnBlock(LOTRMod.brick, 3));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.dwarvenTowerLocations).setCheckInfo(8, -8, 42, LOTREntityDwarf.class, 16).setSpawnInfo(4, 1, 41, LOTREntityDwarfWarrior.class, LOTREntityDwarfAxeThrower.class, 12).setHomePosFromSpawn().addSpawnBlock(Blocks.field_150344_f, 1));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.urukCampLocations).setCheckInfo(24, -12, 12, LOTREntityUrukHai.class, 12).setSpawnInfo(8, -4, 4, LOTREntityUrukHai.class, LOTREntityUrukHaiCrossbower.class, 16).addSpawnBlock((Block)Blocks.field_150349_c));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.rohanFortressLocations).setCheckInfo(16, -8, 10, LOTREntityRohirrim.class, 12).setSpawnInfo(11, 1, 6, LOTREntityRohirrim.class, LOTREntityRohirrimArcher.class, 20).addSpawnBlock((Block)Blocks.field_150349_c).addSpawnBlock(Blocks.field_150344_f, 0).addSpawnBlock(LOTRMod.brick, 4));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.woodElvenTowerLocations).setCheckInfo(8, -16, 40, LOTREntityWoodElf.class, 12).setSpawnInfo(5, 1, 40, LOTREntityWoodElfWarrior.class, LOTREntityWoodElfScout.class, 12).setHomePosFromSpawn().addSpawnBlock(LOTRMod.planks, 2));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.mordorTowerLocations).setCheckInfo(8, -8, 50, LOTREntityMordorOrc.class, 20).setSpawnInfo(5, 1, 40, LOTREntityMordorOrc.class, LOTREntityMordorOrc.class, 16).setHomePosFromSpawn().addSpawnBlock(LOTRMod.slabSingle, 8));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.nurnFarmLocations).setCheckInfo(10, -8, 8, LOTREntityNurnSlave.class, 8).setSpawnInfo(6, -2, 2, LOTREntityNurnSlave.class, LOTREntityNurnSlave.class, 8).addSpawnBlock(LOTRMod.slabSingle, 1));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.gundabadCampLocations).setCheckInfo(24, -12, 12, LOTREntityGundabadOrc.class, 12).setSpawnInfo(8, -4, 4, LOTREntityGundabadOrc.class, LOTREntityGundabadOrcArcher.class, 16).addSpawnBlock((Block)Blocks.field_150349_c));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.dunlandHillFortLocations).setCheckInfo(12, -8, 10, LOTREntityDunlending.class, 8).setSpawnInfo(6, 1, 6, LOTREntityDunlendingWarrior.class, LOTREntityDunlendingArcher.class, 16).addSpawnBlock((Block)Blocks.field_150349_c).addSpawnBlock(Blocks.field_150344_f, 0).addSpawnBlock(Blocks.field_150344_f, 1));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.blueMountainsStrongholdLocations).setCheckInfo(8, -8, 16, LOTREntityDwarf.class, 8).setSpawnInfo(8, 1, 10, LOTREntityDwarfWarrior.class, LOTREntityDwarfAxeThrower.class, 16).setHomePosFromSpawn().addSpawnBlock(Blocks.field_150344_f, 1).addSpawnBlock(LOTRMod.slabSingle3, 0));
        structureSpawning.add(new LOTRStructureSpawningInfo(LOTRLevelData.rangerCampLocations).setCheckInfo(24, -12, 12, LOTREntityRanger.class, 12).setSpawnInfo(8, -4, 4, LOTREntityRangerNorth.class, LOTREntityRangerNorth.class, 16).addSpawnBlock((Block)Blocks.field_150349_c));
        playersInPortals = new HashMap();
        playersInElvenPortals = new HashMap();
        playersInMorgulPortals = new HashMap();
    }
}

