/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.List;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTRNames;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityAIHobbitMarry
extends EntityAIBase {
    private LOTREntityHobbit theHobbit;
    private World theWorld;
    private LOTREntityHobbit theSpouse;
    private int marryDelay = 0;
    private double moveSpeed;

    public LOTREntityAIHobbitMarry(LOTREntityHobbit hobbit, double d) {
        this.theHobbit = hobbit;
        this.theWorld = hobbit.field_70170_p;
        this.moveSpeed = d;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (((Object)((Object)this.theHobbit)).getClass() != LOTREntityHobbit.class || this.theHobbit.hobbitSpouseUniqueID != null || this.theHobbit.getHobbitAge() != 0 || this.theHobbit.func_71124_b(4) != null || this.theHobbit.func_71124_b(0) == null) {
            return false;
        }
        List list = this.theHobbit.field_70170_p.func_72872_a(LOTREntityHobbit.class, this.theHobbit.field_70121_D.func_72314_b(16.0, 4.0, 16.0));
        LOTREntityHobbit hobbit = null;
        double distanceSq = Double.MAX_VALUE;
        for (LOTREntityHobbit hobbitCandidate : list) {
            double d;
            if (!this.theHobbit.canMarryHobbit(hobbitCandidate) || !hobbitCandidate.canMarryHobbit(this.theHobbit) || !((d = this.theHobbit.func_70068_e((Entity)hobbitCandidate)) <= distanceSq)) continue;
            distanceSq = d;
            hobbit = hobbitCandidate;
        }
        if (hobbit == null) {
            return false;
        }
        this.theSpouse = hobbit;
        return true;
    }

    public boolean func_75253_b() {
        return this.theSpouse != null && this.theSpouse.func_70089_S() && this.theHobbit.canMarryHobbit(this.theSpouse) && this.theSpouse.canMarryHobbit(this.theHobbit);
    }

    public void func_75251_c() {
        this.theSpouse = null;
        this.marryDelay = 0;
    }

    public void func_75246_d() {
        this.theHobbit.func_70671_ap().func_75651_a((Entity)this.theSpouse, 10.0f, (float)this.theHobbit.func_70646_bf());
        this.theHobbit.func_70661_as().func_75497_a((Entity)this.theSpouse, this.moveSpeed);
        ++this.marryDelay;
        if (this.marryDelay % 5 == 0) {
            this.theWorld.func_72960_a((Entity)this.theHobbit, (byte)15);
        }
        if (this.marryDelay >= 60 && this.theHobbit.func_70068_e((Entity)this.theSpouse) < 9.0) {
            this.marry();
        }
    }

    private void marry() {
        int maxChildren;
        this.theHobbit.hobbitSpouseUniqueID = this.theSpouse.getPersistentID();
        this.theSpouse.hobbitSpouseUniqueID = this.theHobbit.getPersistentID();
        this.theHobbit.func_70062_b(0, null);
        this.theHobbit.func_70062_b(4, new ItemStack(LOTRMod.hobbitRing));
        this.theSpouse.func_70062_b(0, null);
        this.theSpouse.func_70062_b(4, new ItemStack(LOTRMod.hobbitRing));
        if (this.theHobbit.isHobbitMale()) {
            LOTRNames.changeHobbitSurnameForMarriage(this.theHobbit, this.theSpouse);
        } else {
            LOTRNames.changeHobbitSurnameForMarriage(this.theSpouse, this.theHobbit);
        }
        this.theHobbit.maxChildren = maxChildren = 1 + this.theWorld.field_73012_v.nextInt(4);
        this.theSpouse.maxChildren = maxChildren;
        this.theHobbit.setHobbitAge(24000);
        this.theSpouse.setHobbitAge(24000);
        for (int i = 0; i < 7; ++i) {
            this.theWorld.func_72960_a((Entity)this.theHobbit, (byte)15);
            this.theWorld.func_72960_a((Entity)this.theSpouse, (byte)15);
        }
        if (this.theHobbit.getRingGivingPlayer() != null) {
            LOTRLevelData.addAlignment(this.theHobbit.getRingGivingPlayer(), LOTRAlignmentValues.HOBBIT_MARRIAGE_BONUS, this.theHobbit.getFaction(), (Entity)this.theHobbit);
            LOTRLevelData.addAchievement(this.theHobbit.getRingGivingPlayer(), LOTRAchievement.marryHobbit);
        }
        if (this.theSpouse.getRingGivingPlayer() != null) {
            LOTRLevelData.addAlignment(this.theSpouse.getRingGivingPlayer(), LOTRAlignmentValues.HOBBIT_MARRIAGE_BONUS, this.theHobbit.getFaction(), (Entity)this.theSpouse);
            LOTRLevelData.addAchievement(this.theSpouse.getRingGivingPlayer(), LOTRAchievement.marryHobbit);
        }
        this.theWorld.func_72838_d((Entity)new EntityXPOrb(this.theWorld, this.theHobbit.field_70165_t, this.theHobbit.field_70163_u, this.theHobbit.field_70161_v, this.theHobbit.func_70681_au().nextInt(8) + 2));
    }
}

