/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.entity.ai.LOTRNPCTargetSelector;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.world.biome.LOTRBiomeGenMordor;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityAIOrcAvoidGoodPlayer
extends EntityAIBase {
    private LOTREntityOrc theOrc;
    private double speed;
    private EntityLivingBase closestLivingEntity;
    private float distanceFromEntity;
    private PathEntity entityPathEntity;
    private PathNavigate entityPathNavigate;

    public LOTREntityAIOrcAvoidGoodPlayer(LOTREntityOrc orc, float f, double d) {
        this.theOrc = orc;
        this.distanceFromEntity = f;
        this.speed = d;
        this.entityPathNavigate = orc.func_70661_as();
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.theOrc.isWeakOrc || this.theOrc.hiredNPCInfo.isActive) {
            return false;
        }
        BiomeGenBase biome = this.theOrc.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.theOrc.field_70165_t), MathHelper.func_76128_c((double)this.theOrc.field_70161_v));
        if (biome instanceof LOTRBiomeGenMordor) {
            return false;
        }
        ArrayList<EntityPlayer> validPlayers = new ArrayList<EntityPlayer>();
        List nearbyPlayers = this.theOrc.field_70170_p.func_72872_a(EntityPlayer.class, this.theOrc.field_70121_D.func_72314_b((double)this.distanceFromEntity, (double)this.distanceFromEntity / 2.0, (double)this.distanceFromEntity));
        if (nearbyPlayers.isEmpty()) {
            return false;
        }
        List nearbyEvilNPCs = this.theOrc.field_70170_p.func_82733_a(EntityLiving.class, this.theOrc.field_70121_D.func_72314_b((double)this.distanceFromEntity, (double)this.distanceFromEntity / 2.0, (double)this.distanceFromEntity), (IEntitySelector)new LOTRNPCTargetSelector((EntityLiving)this.theOrc));
        block0: for (int i = 0; i < nearbyPlayers.size(); ++i) {
            int alignment;
            EntityPlayer entityplayer = (EntityPlayer)nearbyPlayers.get(i);
            if (entityplayer.field_71075_bZ.field_75098_d || this.theOrc.func_70643_av() == entityplayer || (alignment = LOTRLevelData.getAlignment(entityplayer, this.theOrc.getFaction())) > LOTRAlignmentValues.ORC_FLEE) continue;
            for (int j = 0; j < nearbyEvilNPCs.size(); ++j) {
                EntityLiving npc = (EntityLiving)nearbyEvilNPCs.get(j);
                if (npc.func_70643_av() == entityplayer) continue block0;
            }
            validPlayers.add(entityplayer);
        }
        if (validPlayers.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (EntityLivingBase)validPlayers.get(0);
        Vec3 fleePath = RandomPositionGenerator.func_75461_b((EntityCreature)this.theOrc, (int)16, (int)7, (Vec3)this.theOrc.field_70170_p.func_82732_R().func_72345_a(this.closestLivingEntity.field_70165_t, this.closestLivingEntity.field_70163_u, this.closestLivingEntity.field_70161_v));
        if (fleePath == null) {
            return false;
        }
        if (this.closestLivingEntity.func_70092_e(fleePath.field_72450_a, fleePath.field_72448_b, fleePath.field_72449_c) < this.closestLivingEntity.func_70068_e((Entity)this.theOrc)) {
            return false;
        }
        this.entityPathEntity = this.entityPathNavigate.func_75488_a(fleePath.field_72450_a, fleePath.field_72448_b, fleePath.field_72449_c);
        return this.entityPathEntity == null ? false : this.entityPathEntity.func_75880_b(fleePath);
    }

    public boolean func_75253_b() {
        return !this.entityPathNavigate.func_75500_f() && this.theOrc.func_70643_av() != this.closestLivingEntity;
    }

    public void func_75249_e() {
        this.entityPathNavigate.func_75484_a(this.entityPathEntity, this.speed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }
}

