/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityDunlendingBartender
extends LOTREntityDunlending
implements LOTRTradeable {
    public LOTREntityDunlendingBartender(World world) {
        super(world);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        String name = this.getDunlendingName();
        this.npcLocationName = name.endsWith("s") ? name + "' Tavern" : name + "'s Tavern";
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.DUNLENDING_BARTENDER_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.DUNLENDING_BARTENDER_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(0, null);
        return data;
    }

    @Override
    public void dropDunlendingItems(boolean flag, int i) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block6: for (int k = 0; k < j; ++k) {
            int l = this.field_70146_Z.nextInt(7);
            switch (l) {
                case 0: 
                case 1: 
                case 2: {
                    Item food = LOTRFoods.DUNLENDING.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(food), 0.0f);
                    continue block6;
                }
                case 3: {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl, 2 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block6;
                }
                case 4: 
                case 5: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block6;
                }
                case 6: {
                    Item drink = LOTRFoods.DUNLENDING_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.DUNLENDING_BARTENDER_BONUS;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.DUNLENDING_BARTENDER_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeDunlendingBartender);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeDunlendingBartender);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return "dunlendingBartender_friendly";
        }
        return "dunlending_hostile";
    }
}

