/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiomeGenBlueMountains;
import lotr.common.world.biome.LOTRBiomeGenIronHills;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityDwarf
extends LOTREntityNPC {
    private int weaponChangeCooldown = 0;

    public LOTREntityDwarf(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.5f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.getDwarfAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.2f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(4);
    }

    public EntityAIBase getDwarfAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.4, false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)1);
        this.field_70180_af.func_75682_a(18, (Object)LOTRNames.getRandomDwarfName(this.isDwarfMale(), this.field_70146_Z));
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.DWARF;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getDwarfName();
    }

    public boolean isDwarfMale() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setDwarfMale(boolean flag) {
        this.field_70180_af.func_75692_b(16, (Object)(flag ? (byte)1 : 0));
    }

    public String getDwarfName() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setDwarfName(String name) {
        this.field_70180_af.func_75692_b(18, (Object)name);
    }

    public int getEatingTick() {
        return this.field_70180_af.func_75683_a(19);
    }

    public void setEatingTick(int i) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)i));
    }

    public int getDrinkingTick() {
        return this.field_70180_af.func_75683_a(20);
    }

    public void setDrinkingTick(int i) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)i));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("DwarfGender", this.isDwarfMale());
        nbt.func_74778_a("DwarfName", this.getDwarfName());
        nbt.func_74774_a("DwarfEating", (byte)this.getEatingTick());
        nbt.func_74774_a("DwarfDrinking", (byte)this.getDrinkingTick());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("DwarfGender")) {
            this.setDwarfMale(nbt.func_74767_n("DwarfGender"));
        }
        if (nbt.func_74764_b("DwarfName")) {
            this.setDwarfName(nbt.func_74779_i("DwarfName"));
        }
        this.setEatingTick(nbt.func_74771_c("DwarfEating"));
        this.setDrinkingTick(nbt.func_74771_c("DwarfDrinking"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.onDwarfUpdate();
    }

    public void onDwarfUpdate() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack weapon = this.func_71124_b(0);
            if (this.func_70638_az() != null) {
                if (weapon == null || weapon.func_77973_b() != LOTRMod.daggerDwarven) {
                    this.func_70062_b(0, new ItemStack(LOTRMod.daggerDwarven));
                    this.setEatingTick(0);
                    this.setDrinkingTick(0);
                    this.weaponChangeCooldown = 20;
                }
            } else if (weapon != null && weapon.func_77973_b() == LOTRMod.daggerDwarven) {
                if (this.weaponChangeCooldown > 0) {
                    --this.weaponChangeCooldown;
                } else {
                    this.func_70062_b(0, null);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(10000) == 0) {
            this.func_70062_b(0, LOTRFoods.DWARF.getRandomFood(this.field_70146_Z));
            this.setEatingTick(32);
        }
        if (this.getEatingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEatingTick(this.getEatingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getEatingTick() % 4 == 0) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 vec1 = this.field_70170_p.func_82732_R().func_72345_a(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec1.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec1.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    Vec3 vec2 = this.field_70170_p.func_82732_R().func_72345_a(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3, 0.6);
                    vec2.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec2.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    vec2 = vec2.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)this.func_71124_b(0).func_77973_b()), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, vec1.field_72450_a, vec1.field_72448_b + 0.05, vec1.field_72449_c);
                }
                this.func_85030_a("random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.getEatingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(4.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(10000) == 0) {
            this.func_70062_b(0, LOTRFoods.DWARF_DRINK.getRandomFood(this.field_70146_Z));
            this.setDrinkingTick(32);
        }
        if (this.getDrinkingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setDrinkingTick(this.getDrinkingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getDrinkingTick() % 4 == 0) {
                this.func_85030_a("random.drink", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            }
            if (this.getDrinkingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(2.0f);
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killDwarf;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.DWARF_BONUS;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.dwarfBone, 1);
        }
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block13: for (int k = 0; k < count; ++k) {
            j = this.field_70146_Z.nextInt(10);
            switch (j) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.func_70099_a(LOTRFoods.DWARF.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block13;
                }
                case 4: {
                    Item drink = LOTRFoods.DWARF_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block13;
                }
                case 5: 
                case 6: {
                    this.func_70099_a(new ItemStack(Items.field_151044_h), 0.0f);
                    continue block13;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.func_70099_a(new ItemStack(Blocks.field_150478_aa, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                }
            }
        }
        if (flag) {
            int rareDropChance = 20 - i * 4;
            if (rareDropChance < 1) {
                rareDropChance = 1;
            }
            if (this.field_70146_Z.nextInt(rareDropChance) == 0) {
                j = this.field_70146_Z.nextInt(4);
                switch (j) {
                    case 0: {
                        this.func_70099_a(new ItemStack(Items.field_151042_j), 0.0f);
                        break;
                    }
                    case 1: {
                        this.func_70099_a(new ItemStack(LOTRMod.dwarfSteel), 0.0f);
                        break;
                    }
                    case 2: {
                        this.func_70099_a(new ItemStack(Items.field_151074_bl, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                        break;
                    }
                    case 3: {
                        this.func_70099_a(new ItemStack(LOTRMod.silverNugget, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    }
                }
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            return (biome instanceof LOTRBiomeGenIronHills || biome instanceof LOTRBiomeGenBlueMountains) && j < 60 && this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o() == Material.field_151576_e && !this.field_70170_p.func_72937_j(i, j, k) && this.field_70170_p.func_72972_b(EnumSkyBlock.Block, i, j, k) >= 10;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenIronHills || biome instanceof LOTRBiomeGenBlueMountains) {
            f += 20.0f;
        }
        return f;
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean isConsuming() {
        return this.getEatingTick() > 0 || this.getDrinkingTick() > 0;
    }

    protected float func_70647_i() {
        float f = super.func_70647_i();
        if (!this.isDwarfMale()) {
            f *= 1.4f;
        }
        return f;
    }

    public String func_70621_aR() {
        return "lotr:dwarf.hurt";
    }

    public String func_70673_aS() {
        return "lotr:dwarf.hurt";
    }

    @Override
    public String getAttackSound() {
        return "lotr:dwarf.attack";
    }

    @Override
    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        this.func_85030_a("lotr:dwarf.kill", this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    protected LOTRAchievement getTalkAchievement() {
        if (!this.isDwarfMale()) {
            return LOTRAchievement.talkDwarfWoman;
        }
        return super.getTalkAchievement();
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "dwarf_hired";
            }
            return "dwarf_friendly";
        }
        return "dwarf_hostile";
    }

    @Override
    public void onArtificalSpawn() {
        if (((Object)((Object)this)).getClass() == LOTREntityDwarf.class && this.field_70146_Z.nextInt(4) == 0) {
            this.setDwarfMale(false);
            this.setDwarfName(LOTRNames.getRandomDwarfName(this.isDwarfMale(), this.field_70146_Z));
        }
    }
}

