/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.npc.LOTREntityElvenTrader;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityWoodElf;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiomeGenLothlorien;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityElf
extends LOTREntityNPC
implements IRangedAttackMob {
    protected EntityAIBase rangedAttackAI = this.createElfRangedAttackAI();
    protected EntityAIBase meleeAttackAI = this.createElfMeleeAttackAI();
    protected int weaponChangeCooldown = 0;

    public LOTREntityElf(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(4);
    }

    public EntityAIBase createElfRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 40, 60, 16.0f);
    }

    public EntityAIBase createElfMeleeAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)((byte)this.field_70146_Z.nextInt(2)));
        this.field_70180_af.func_75682_a(15, (Object)LOTRNames.getRandomElfName(this.isElfMale(), this.field_70146_Z));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.GALADHRIM;
    }

    public boolean isElfMale() {
        return this.field_70180_af.func_75683_a(13) == 1;
    }

    public void setElfMale(boolean flag) {
        this.field_70180_af.func_75692_b(13, (Object)(flag ? (byte)1 : 0));
    }

    public String getElfName() {
        return this.field_70180_af.func_75681_e(15);
    }

    public void setElfName(String name) {
        this.field_70180_af.func_75692_b(15, (Object)name);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("ElfGender", this.isElfMale());
        nbt.func_74778_a("ElfName", this.getElfName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setElfMale(nbt.func_74767_n("ElfGender"));
        if (nbt.func_74764_b("ElfName")) {
            this.setElfName(nbt.func_74779_i("ElfName"));
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getElfName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.onElfUpdate();
    }

    public void onElfUpdate() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack weapon = this.func_71124_b(0);
            if (this.func_70638_az() != null) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                if (d < 16.0) {
                    if (weapon == null || weapon.func_77973_b() != this.getElfSwordId()) {
                        this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                        this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
                        this.func_70062_b(0, new ItemStack(this.getElfSwordId(), 1, 0));
                        this.weaponChangeCooldown = 20;
                    }
                } else if (d < this.getWeaponChangeThresholdRangeSq() && (weapon == null || weapon.func_77973_b() != this.getElfBowId())) {
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
                    this.func_70062_b(0, new ItemStack(this.getElfBowId(), 1, 0));
                    this.weaponChangeCooldown = 20;
                }
            } else if (weapon != null) {
                if (this.weaponChangeCooldown > 0) {
                    --this.weaponChangeCooldown;
                } else {
                    this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.func_70062_b(0, null);
                }
            }
        }
    }

    public Item getElfSwordId() {
        return LOTRMod.swordMallorn;
    }

    public Item getElfBowId() {
        return LOTRMod.mallornBow;
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.5f, 0.5f);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killElf;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.GALADHRIM_BONUS;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int k;
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.elfBone, 1);
        }
        if (this.field_70146_Z.nextBoolean()) {
            j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151032_g, 1);
            }
        }
        if (flag) {
            int dropChance = 60 - i * 12;
            if (dropChance < 1) {
                dropChance = 1;
            }
            if (this.field_70146_Z.nextInt(dropChance) == 0) {
                this.func_145779_a(LOTRMod.lembas, 1);
            }
            if (!(this instanceof LOTREntityWoodElf)) {
                dropChance = 20 - i * 4;
                if (dropChance < 1) {
                    dropChance = 1;
                }
                if (this.field_70146_Z.nextInt(dropChance) == 0) {
                    this.func_70099_a(new ItemStack(LOTRMod.mugMiruvor, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            return this.liftSpawnRestrictions || this.canElfSpawnHere();
        }
        return false;
    }

    public boolean canElfSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c) {
            if (this instanceof LOTREntityElvenTrader) {
                return true;
            }
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            return biome instanceof LOTRBiomeGenLothlorien;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenLothlorien && !(this instanceof LOTREntityElvenTrader)) {
            f += 20.0f;
        }
        return f;
    }

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }

    public boolean shouldRenderHair() {
        return true;
    }

    public String func_70639_aQ() {
        if (this.func_70638_az() == null && this.field_70146_Z.nextInt(10) == 0 && this.isElfMale()) {
            return "lotr:elf.male.say";
        }
        return super.func_70639_aQ();
    }

    @Override
    public String getAttackSound() {
        return this.isElfMale() ? "lotr:elf.male.attack" : super.getAttackSound();
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "elf_hired";
            }
            return "elf_friendly";
        }
        return "elf_hostile";
    }
}

