/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityHighElf;
import lotr.common.item.LOTRItemSpear;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityHighElfWarrior
extends LOTREntityHighElf {
    public LOTREntityHighElfWarrior(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
        this.spawnRidingHorse = this.field_70146_Z.nextInt(4) == 0;
    }

    @Override
    public EntityAIBase createElfRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 25, 40, 24.0f);
    }

    @Override
    public EntityAIBase createElfMeleeAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, false).setSpearReplacement(LOTRMod.swordHighElven);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70062_b(0, new ItemStack(LOTRMod.spearHighElven));
        } else {
            this.func_70062_b(0, new ItemStack(this.getElfSwordId(), 1, 0));
        }
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsHighElven));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsHighElven));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyHighElven));
        if (this.field_70146_Z.nextInt(10) != 0) {
            this.func_70062_b(4, new ItemStack(LOTRMod.helmetHighElven));
        }
        return data;
    }

    @Override
    public Item getElfSwordId() {
        return LOTRMod.swordHighElven;
    }

    @Override
    public Item getElfBowId() {
        return LOTRMod.elvenBow;
    }

    @Override
    public void onElfUpdate() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack weapon = this.func_71124_b(0);
            if (weapon != null && weapon.func_77973_b() instanceof LOTRItemSpear) {
                return;
            }
            if (this.func_70638_az() != null) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                if (d < 16.0) {
                    if (weapon == null || weapon.func_77973_b() != this.getElfSwordId()) {
                        this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                        this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
                        this.func_70062_b(0, new ItemStack(this.getElfSwordId(), 1, 0));
                        this.weaponChangeCooldown = 20;
                    }
                } else if (d < this.getWeaponChangeThresholdRangeSq() && (weapon == null || weapon.func_77973_b() != this.getElfBowId())) {
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
                    this.func_70062_b(0, new ItemStack(this.getElfBowId(), 1, 0));
                    this.weaponChangeCooldown = 20;
                }
            } else if (weapon == null || weapon.func_77973_b() != this.getElfSwordId()) {
                if (this.weaponChangeCooldown > 0) {
                    --this.weaponChangeCooldown;
                } else {
                    this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                    this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
                    this.func_70062_b(0, new ItemStack(this.getElfSwordId(), 1, 0));
                }
            }
        }
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.HIGH_ELF_WARRIOR_BONUS;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.3f + this.func_70032_d((Entity)target) / 24.0f * 0.3f, 0.5f);
        arrow.func_70239_b(arrow.func_70242_d() + 1.0);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "highElf_hired";
            }
            return "highElfWarrior_friendly";
        }
        return "highElfWarrior_hostile";
    }
}

