/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIHobbitAvoidEvilPlayer;
import lotr.common.entity.ai.LOTREntityAIHobbitChildFollowGoodPlayer;
import lotr.common.entity.ai.LOTREntityAIHobbitFollowParent;
import lotr.common.entity.ai.LOTREntityAIHobbitFollowSpouse;
import lotr.common.entity.ai.LOTREntityAIHobbitMarry;
import lotr.common.entity.ai.LOTREntityAIHobbitMate;
import lotr.common.entity.npc.LOTREntityDarkHuorn;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntitySpiderBase;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.projectile.LOTREntitySmokeRing;
import lotr.common.world.biome.LOTRBiomeGenShire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityHobbit
extends LOTREntityNPC {
    public UUID hobbitSpouseUniqueID;
    public int children;
    public int maxChildren;
    public UUID parentToFollowUniqueID;
    private UUID ringGivingPlayer;
    private float hobbitWidth = -1.0f;
    private float hobbitHeight;

    public LOTREntityHobbit(World world) {
        super(world);
        this.func_70105_a(0.45f, 0.9f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityOrc.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityWarg.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityTroll.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntitySpiderBase.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityDarkHuorn.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIHobbitAvoidEvilPlayer(this, 8.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIHobbitChildFollowGoodPlayer(this, 12.0f, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new LOTREntityAIHobbitMarry(this, 1.3));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIHobbitMate(this, 1.3));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new LOTREntityAIHobbitFollowParent(this, 1.4));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new LOTREntityAIHobbitFollowSpouse(this, 1.1));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.2f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)((byte)this.field_70146_Z.nextInt(2)));
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)LOTRNames.getRandomHobbitName(this.isHobbitMale(), this.field_70146_Z));
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOBBIT;
    }

    @Override
    public String getNPCName() {
        return this.getHobbitName();
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean isHobbitMale() {
        return this.field_70180_af.func_75683_a(15) == 1;
    }

    public void setHobbitMale(boolean flag) {
        this.field_70180_af.func_75692_b(15, (Object)(flag ? (byte)1 : 0));
    }

    public String getHobbitName() {
        return this.field_70180_af.func_75681_e(19);
    }

    public void setHobbitName(String name) {
        this.field_70180_af.func_75692_b(19, (Object)name);
    }

    public int getEatingTick() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setEatingTick(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    public int getDrinkingTick() {
        return this.field_70180_af.func_75683_a(17);
    }

    public void setDrinkingTick(int i) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)i));
    }

    public int getSmokingTick() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setSmokingTick(int i) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)i));
    }

    public int getHobbitAge() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setHobbitAge(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    public boolean func_70631_g_() {
        return this.getHobbitAge() < 0;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("HobbitEating", (byte)this.getEatingTick());
        nbt.func_74774_a("HobbitDrinking", (byte)this.getDrinkingTick());
        nbt.func_74774_a("HobbitSmoking", (byte)this.getSmokingTick());
        nbt.func_74778_a("HobbitName", this.getHobbitName());
        nbt.func_74757_a("HobbitGender", this.isHobbitMale());
        nbt.func_74768_a("HobbitAge", this.getHobbitAge());
        if (this.hobbitSpouseUniqueID != null) {
            nbt.func_74772_a("HobbitSpouseUUIDMost", this.hobbitSpouseUniqueID.getMostSignificantBits());
            nbt.func_74772_a("HobbitSpouseUUIDLeast", this.hobbitSpouseUniqueID.getLeastSignificantBits());
        }
        nbt.func_74768_a("HobbitChildren", this.children);
        nbt.func_74768_a("HobbitMaxChildren", this.maxChildren);
        if (this.parentToFollowUniqueID != null) {
            nbt.func_74772_a("HobbitParentUUIDMost", this.parentToFollowUniqueID.getMostSignificantBits());
            nbt.func_74772_a("HobbitParentUUIDLeast", this.parentToFollowUniqueID.getLeastSignificantBits());
        }
        if (this.ringGivingPlayer != null) {
            nbt.func_74772_a("RingGivingPlayerUUIDMost", this.ringGivingPlayer.getMostSignificantBits());
            nbt.func_74772_a("RingGivingPlayerUUIDLeast", this.ringGivingPlayer.getLeastSignificantBits());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setEatingTick(nbt.func_74771_c("HobbitEating"));
        this.setDrinkingTick(nbt.func_74771_c("HobbitDrinking"));
        this.setSmokingTick(nbt.func_74771_c("HobbitSmoking"));
        if (nbt.func_74764_b("HobbitName")) {
            this.setHobbitName(nbt.func_74779_i("HobbitName"));
        }
        this.setHobbitMale(nbt.func_74767_n("HobbitGender"));
        this.setHobbitAge(nbt.func_74762_e("HobbitAge"));
        if (nbt.func_74764_b("HobbitSpouseUUIDMost") && nbt.func_74764_b("HobbitSpouseUUIDLeast")) {
            this.hobbitSpouseUniqueID = new UUID(nbt.func_74763_f("HobbitSpouseUUIDMost"), nbt.func_74763_f("HobbitSpouseUUIDLeast"));
        }
        this.children = nbt.func_74762_e("HobbitChildren");
        this.maxChildren = nbt.func_74762_e("HobbitMaxChildren");
        if (nbt.func_74764_b("HobbitParentUUIDMost") && nbt.func_74764_b("HobbitParentUUIDLeast")) {
            this.parentToFollowUniqueID = new UUID(nbt.func_74763_f("HobbitParentUUIDMost"), nbt.func_74763_f("HobbitParentUUIDLeast"));
        }
        if (nbt.func_74764_b("RingGivingPlayer")) {
            this.ringGivingPlayer = new UUID(nbt.func_74763_f("RingGivingPlayerUUIDMost"), nbt.func_74763_f("RingGivingPlayerUUIDLeast"));
        }
    }

    public LOTREntityHobbit getHobbitSpouse() {
        if (this.hobbitSpouseUniqueID == null) {
            return null;
        }
        List list = this.field_70170_p.func_72872_a(LOTREntityHobbit.class, this.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof LOTREntityHobbit) || entity == this || !entity.getPersistentID().equals(this.hobbitSpouseUniqueID)) continue;
            LOTREntityHobbit hobbit = (LOTREntityHobbit)entity;
            if (hobbit.hobbitSpouseUniqueID == null || !this.getPersistentID().equals(hobbit.hobbitSpouseUniqueID)) continue;
            return hobbit;
        }
        return null;
    }

    public boolean canMarryHobbit(LOTREntityHobbit hobbit) {
        if (((Object)((Object)hobbit)).getClass() != LOTREntityHobbit.class || hobbit.hobbitSpouseUniqueID != null || hobbit.getHobbitAge() != 0 || hobbit.func_71124_b(4) != null) {
            return false;
        }
        if (hobbit == this || hobbit.isHobbitMale() == this.isHobbitMale() || LOTRNames.doHobbitsHaveSameSurname(this, hobbit)) {
            return false;
        }
        ItemStack heldItem = hobbit.func_71124_b(0);
        return heldItem != null && heldItem.func_77973_b() == LOTRMod.hobbitRing;
    }

    public EntityPlayer getRingGivingPlayer() {
        if (this.ringGivingPlayer != null) {
            for (Object obj : this.field_70170_p.field_73010_i) {
                EntityPlayer entityplayer = (EntityPlayer)obj;
                if (!entityplayer.func_110124_au().equals(this.ringGivingPlayer)) continue;
                return entityplayer;
            }
        }
        return null;
    }

    public LOTREntityHobbit getParentToFollow() {
        List list = this.field_70170_p.func_72872_a(LOTREntityHobbit.class, this.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof LOTREntityHobbit) || entity == this || this.parentToFollowUniqueID == null || !entity.getPersistentID().equals(this.parentToFollowUniqueID)) continue;
            return (LOTREntityHobbit)entity;
        }
        return null;
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == LOTRMod.hobbitRing && LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.HOBBIT_MARRY && this.field_70717_bb != entityplayer && ((Object)((Object)this)).getClass() == LOTREntityHobbit.class && this.getHobbitAge() == 0 && this.func_71124_b(0) == null && this.func_71124_b(4) == null && this.hobbitSpouseUniqueID == null) {
            if (!entityplayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, null);
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70062_b(0, new ItemStack(LOTRMod.hobbitRing));
                this.ringGivingPlayer = entityplayer.func_110124_au();
            }
            this.isNPCPersistent = true;
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getHobbitAge() < 0) {
            this.setHobbitAge(this.getHobbitAge() + 1);
        } else if (this.getHobbitAge() > 0) {
            this.setHobbitAge(this.getHobbitAge() - 1);
        }
        this.onHobbitUpdate();
        this.rescaleHobbit(this.func_70631_g_() ? 0.5f : 1.0f);
    }

    public void onHobbitUpdate() {
        if (this.getHobbitAge() < 0) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            this.func_70062_b(0, LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z));
            this.setEatingTick(32);
        }
        if (this.getEatingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEatingTick(this.getEatingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getEatingTick() % 4 == 0) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 vec1 = this.field_70170_p.func_82732_R().func_72345_a(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec1.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec1.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    Vec3 vec2 = this.field_70170_p.func_82732_R().func_72345_a(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3, 0.6);
                    vec2.func_72440_a(-this.field_70125_A * (float)Math.PI / 180.0f);
                    vec2.func_72442_b(-this.field_70177_z * (float)Math.PI / 180.0f);
                    vec2 = vec2.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    this.field_70170_p.func_72869_a("iconcrack_" + Item.func_150891_b((Item)this.func_71124_b(0).func_77973_b()), vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, vec1.field_72450_a, vec1.field_72448_b + 0.05, vec1.field_72449_c);
                }
                this.func_85030_a("random.eat", 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.getEatingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(4.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
            this.func_70062_b(0, new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)));
            this.setDrinkingTick(32);
        }
        if (this.getDrinkingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setDrinkingTick(this.getDrinkingTick() - 1);
            }
            if (this.func_71124_b(0) != null && this.getDrinkingTick() % 4 == 0) {
                this.func_85030_a("random.drink", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            }
            if (this.getDrinkingTick() == 0) {
                this.func_70062_b(0, null);
                this.func_70691_i(2.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(0) == null && this.field_70146_Z.nextInt(4000) == 0) {
            this.func_70062_b(0, new ItemStack(LOTRMod.hobbitPipe));
            this.setSmokingTick(32);
        }
        if (this.getSmokingTick() > 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSmokingTick(this.getSmokingTick() - 1);
            }
            if (this.getSmokingTick() == 0) {
                this.func_70062_b(0, null);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new LOTREntitySmokeRing(this.field_70170_p, (EntityLivingBase)this));
                }
                this.func_85030_a("lotr:item.puff", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_70691_i(2.0f);
            }
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killHobbit;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.HOBBIT_BONUS;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int k = 0; k < j; ++k) {
            this.func_145779_a(LOTRMod.hobbitBone, 1);
        }
        this.dropHobbitItems(flag, i);
    }

    public void dropHobbitItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block12: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(14);
            switch (j) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.func_70099_a(LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block12;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(Items.field_151007_F, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block12;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(Items.field_151121_aF, 2 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block12;
                }
                case 6: {
                    this.func_70099_a(new ItemStack(Items.field_151122_aG, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block12;
                }
                case 7: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block12;
                }
                case 8: {
                    this.func_70099_a(new ItemStack(Items.field_151017_I, 1, this.field_70146_Z.nextInt(30)), 0.0f);
                    continue block12;
                }
                case 9: {
                    this.func_70099_a(new ItemStack(LOTRMod.hobbitPipe, 1, this.field_70146_Z.nextInt(100)), 0.0f);
                    continue block12;
                }
                case 10: 
                case 11: {
                    this.func_70099_a(new ItemStack(LOTRMod.pipeweed, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block12;
                }
                case 12: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block12;
                }
                case 13: {
                    Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, this.field_70146_Z.nextInt(4)), 0.0f);
                }
            }
        }
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 1 + this.field_70146_Z.nextInt(3);
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            return biome instanceof LOTRBiomeGenShire && j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c;
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenShire) {
            f += 20.0f;
        }
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 15) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a("heart", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2);
        } else {
            super.func_70103_a(b);
        }
    }

    public boolean isConsuming() {
        return this.getEatingTick() > 0 || this.getDrinkingTick() > 0 || this.getSmokingTick() > 0;
    }

    protected final void func_70105_a(float f, float f1) {
        boolean flag = this.hobbitWidth > 0.0f;
        this.hobbitWidth = f;
        this.hobbitHeight = f1;
        if (!flag) {
            this.rescaleHobbit(1.0f);
        }
    }

    private void rescaleHobbit(float f) {
        super.func_70105_a(this.hobbitWidth * f, this.hobbitHeight * f);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return this.func_70631_g_() ? "hobbitChild_friendly" : "hobbit_friendly";
        }
        return this.func_70631_g_() ? "hobbitChild_unfriendly" : "hobbit_unfriendly";
    }

    @Override
    public void onArtificalSpawn() {
        if (((Object)((Object)this)).getClass() == LOTREntityHobbit.class && this.field_70146_Z.nextInt(10) == 0) {
            this.setHobbitAge(-48000);
        }
    }
}

