/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbitShirriff;
import lotr.common.entity.npc.LOTRUnitTradeEntry;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.item.LOTRItemLeatherHat;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityHobbitShirriffChief
extends LOTREntityHobbitShirriff
implements LOTRUnitTradeable {
    public LOTREntityHobbitShirriffChief(World world) {
        super(world);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        ItemStack hat = new ItemStack(LOTRMod.leatherHat);
        LOTRItemLeatherHat.setHatColor(hat, LOTRItemLeatherHat.HAT_SHIRRIFF_CHIEF);
        LOTRItemLeatherHat.setFeatherColor(hat, LOTRItemLeatherHat.FEATHER_SHIRRIFF_CHIEF);
        this.func_70062_b(4, hat);
        return data;
    }

    @Override
    public Item getHobbitMeleeWeaponId() {
        return Items.field_151040_l;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.HOBBIT_SHIRRIFF_CHIEF_BONUS;
    }

    @Override
    public LOTRUnitTradeEntry[] getUnits() {
        return LOTRUnitTradeEntry.HOBBIT_SHIRRIFF_CHIEF;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.HOBBIT_SHIRRIFF_CHIEF_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onUnitTrade(EntityPlayer entityplayer) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeHobbitShirriffChief);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "hobbitShirriffChief_friendly";
            }
            return "hobbitShirriffChief_neutral";
        }
        return "hobbitShirriff_hostile";
    }
}

