/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.UUID;
import lotr.common.LOTRFaction;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.projectile.LOTREntityMarshWraithBall;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityMarshWraith
extends LOTREntityNPC
implements IRangedAttackMob {
    public static double VERTICAL_OFFSET = 2.0;
    public UUID attackTargetUUID;
    private boolean checkedForAttackTarget;
    private int timeSinceTargetLeftWater = -1;

    public LOTREntityMarshWraith(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.6, 40, 6.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public int getSpawnFadeTime() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setSpawnFadeTime(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    public int getDeathFadeTime() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setDeathFadeTime(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOSTILE;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("SpawnFadeTime", this.getSpawnFadeTime());
        nbt.func_74768_a("DeathFadeTime", this.getDeathFadeTime());
        if (this.attackTargetUUID != null) {
            nbt.func_74772_a("TargetUUIDMost", this.attackTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("TargetUUIDLeast", this.attackTargetUUID.getLeastSignificantBits());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSpawnFadeTime(nbt.func_74762_e("SpawnFadeTime"));
        this.setDeathFadeTime(nbt.func_74762_e("DeathFadeTime"));
        if (nbt.func_74764_b("TargetUUIDMost") && nbt.func_74764_b("TargetUUIDLeast")) {
            this.attackTargetUUID = new UUID(nbt.func_74763_f("TargetUUIDMost"), nbt.func_74763_f("TargetUUIDLeast"));
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70090_H()) {
            this.field_70163_u += 0.05;
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + VERTICAL_OFFSET + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            int i;
            if (this.func_70638_az() == null && this.attackTargetUUID != null && !this.checkedForAttackTarget) {
                for (i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (!(entity instanceof EntityLiving) || !entity.getPersistentID().equals(this.attackTargetUUID)) continue;
                    this.func_70624_b((EntityLivingBase)((EntityLiving)entity));
                    break;
                }
                this.checkedForAttackTarget = true;
            }
            if (this.getSpawnFadeTime() < 30) {
                this.setSpawnFadeTime(this.getSpawnFadeTime() + 1);
            }
            if (this.getDeathFadeTime() > 0) {
                this.setDeathFadeTime(this.getDeathFadeTime() - 1);
            }
            if (this.getSpawnFadeTime() == 30 && this.getDeathFadeTime() == 0) {
                if (this.func_70638_az() == null || this.func_70638_az().field_70128_L) {
                    this.setDeathFadeTime(30);
                } else {
                    int k;
                    int j;
                    i = MathHelper.func_76128_c((double)this.func_70638_az().field_70165_t);
                    if (!(this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)this.func_70638_az().field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.func_70638_az().field_70161_v)).func_149688_o() == Material.field_151586_h || this.field_70170_p.func_147437_c(i, j, k) && this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o() == Material.field_151586_h)) {
                        if (this.timeSinceTargetLeftWater == -1) {
                            this.timeSinceTargetLeftWater = 80;
                        } else {
                            --this.timeSinceTargetLeftWater;
                            if (this.timeSinceTargetLeftWater == 0) {
                                this.setDeathFadeTime(30);
                                this.func_70624_b(null);
                            }
                        }
                    } else {
                        this.timeSinceTargetLeftWater = -1;
                    }
                }
            }
            if (this.getDeathFadeTime() == 1) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        if (this.getSpawnFadeTime() == 30 && this.getDeathFadeTime() == 0) {
            LOTREntityMarshWraithBall ball = new LOTREntityMarshWraithBall(this.field_70170_p, (EntityLivingBase)this, target);
            this.func_85030_a("lotr:wraith.marshWraith_shoot", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
    }
}

