/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.ai.LOTREntityAIBurningPanic;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.ai.LOTRNPCTargetSelector;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.item.LOTREntityTraderRespawn;
import lotr.common.entity.npc.LOTRBannerBearer;
import lotr.common.entity.npc.LOTRHiredNPCInfo;
import lotr.common.entity.npc.LOTRSpeech;
import lotr.common.entity.npc.LOTRTradeable;
import lotr.common.entity.npc.LOTRTraderNPCInfo;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.entity.projectile.LOTREntityPebble;
import lotr.common.entity.projectile.LOTREntityPlate;
import lotr.common.inventory.LOTRContainerTrade;
import lotr.common.inventory.LOTRContainerUnitTrade;
import lotr.common.item.LOTRItemBanner;
import lotr.common.item.LOTRItemLeatherHat;
import lotr.common.item.LOTRItemPouch;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class LOTREntityNPC
extends EntityCreature {
    public static IAttribute npcAttackDamage = new RangedAttribute("lotr.npcAttackDamage", 2.0, 0.0, Double.MAX_VALUE).func_111117_a("LOTR NPC Attack Damage");
    public static IAttribute horseAttackSpeed = new RangedAttribute("lotr.horseAttackSpeed", 1.7, 0.0, Double.MAX_VALUE).func_111117_a("LOTR Horse Attack Speed");
    public boolean isNPCPersistent = false;
    public int npcTalkTick = 0;
    public boolean liftSpawnRestrictions = false;
    public LOTRHiredNPCInfo hiredNPCInfo = new LOTRHiredNPCInfo(this);
    private EntityLivingBase prevAttackTarget;
    public String npcLocationName;
    private boolean hasSpecificLocationName;
    private boolean hurtOnlyByPlates = true;
    public boolean spawnRidingHorse;
    private boolean ridingHorse;
    public int spawnCountValue = 1;
    private ItemStack[] festiveItems = new ItemStack[5];
    private Random festiveRand = new Random();
    private boolean initFestiveItems = false;
    public LOTRTraderNPCInfo traderNPCInfo = new LOTRTraderNPCInfo(this);
    public boolean isPassive = false;
    public boolean isImmuneToFrost = false;
    protected boolean spawnsInDarkness = false;

    public LOTREntityNPC(World world) {
        super(world);
        if (this.isTrader() || this instanceof IBossDisplayData) {
            this.isNPCPersistent = true;
        }
    }

    public final boolean isTrader() {
        return this instanceof LOTRTradeable || this instanceof LOTRUnitTradeable;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(npcAttackDamage);
        this.func_110140_aT().func_111150_b(horseAttackSpeed);
    }

    public void addTargetTasks(int i) {
        this.addTargetTasks(i, LOTREntityAINearestAttackableTargetBasic.class);
    }

    public void addTargetTasks(int i, Class c) {
        LOTREntityNPC.addTargetTasks(this, i, c);
    }

    public static void addTargetTasks(EntityCreature entity, int i, Class c) {
        try {
            Constructor constructor = c.getConstructor(EntityCreature.class, Class.class, Integer.TYPE, Boolean.TYPE, IEntitySelector.class);
            entity.field_70715_bh.func_75776_a(i, (EntityAIBase)constructor.newInstance(entity, EntityPlayer.class, 0, true, null));
            entity.field_70715_bh.func_75776_a(i, (EntityAIBase)constructor.newInstance(entity, EntityLiving.class, 0, true, new LOTRNPCTargetSelector((EntityLiving)entity)));
        }
        catch (Exception e) {
            System.out.println("Error adding LOTR target tasks to entity " + entity.toString());
            e.printStackTrace();
        }
    }

    public void func_110123_P() {
        super.func_110123_P();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LOTREntityAIBurningPanic(this, 1.5));
    }

    public IEntityLivingData initCreatureForHire(IEntityLivingData data) {
        this.spawnRidingHorse = false;
        return this.func_110161_a(data);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K && this.spawnRidingHorse && !(this instanceof LOTRBannerBearer)) {
            LOTREntityHorse horse = this.createHorseToRide();
            horse.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            if (this.field_70170_p.func_147461_a(horse.field_70121_D).isEmpty()) {
                horse.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)horse);
                this.func_70078_a((Entity)horse);
                this.setRidingHorse(true);
                horse.setBelongsToNPC(true);
                horse.setNavigatorRangeFrom(this);
            }
        }
        return data;
    }

    public LOTREntityHorse createHorseToRide() {
        return new LOTREntityHorse(this.field_70170_p);
    }

    public void setRidingHorse(boolean flag) {
        this.ridingHorse = flag;
        double d = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        d = flag ? (d *= 1.5) : (d /= 1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(d);
    }

    public String func_70005_c_() {
        String entityName = this.getEntityClassName();
        String npcName = this.getNPCName();
        if (LOTRMod.isAprilFools()) {
            npcName = "Gandalf";
        }
        if (npcName.equals(entityName)) {
            return entityName;
        }
        return StatCollector.func_74837_a((String)"entity.lotr.generic.entityName", (Object[])new Object[]{npcName, entityName});
    }

    public final String getEntityClassName() {
        return super.func_70005_c_();
    }

    public String getNPCName() {
        return super.func_70005_c_();
    }

    public LOTRFaction getFaction() {
        return LOTRFaction.UNALIGNED;
    }

    public int getNPCTalkInterval() {
        return 40;
    }

    public boolean canNPCTalk() {
        return this.func_70089_S() && this.npcTalkTick == this.getNPCTalkInterval();
    }

    public void markNPCSpoken() {
        this.npcTalkTick = 0;
    }

    public void func_70624_b(EntityLivingBase target) {
        super.func_70624_b(target);
        if (target != null && target != this.prevAttackTarget) {
            this.prevAttackTarget = target;
            if (this.getAttackSound() != null) {
                this.field_70170_p.func_72956_a((Entity)this, this.getAttackSound(), this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public String getAttackSound() {
        return null;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected void func_70623_bb() {
        if (this.isNPCPersistent || this.hiredNPCInfo.isActive) {
            this.field_70708_bq = 0;
        } else {
            super.func_70623_bb();
        }
    }

    public void func_70636_d() {
        EntityLivingBase entity;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && (this.isTrader() || this.hiredNPCInfo.isActive) && (this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) && this.func_110143_aJ() < this.func_110138_aP()) {
            int banners;
            boolean timeHeal = this.field_70170_p.func_72820_D() % 40L == 20L;
            boolean bannersHeal = false;
            if (this.hiredNPCInfo.isActive && (banners = this.nearbyBanners()) > 0) {
                boolean bl = bannersHeal = this.field_70170_p.func_72820_D() % (200L - (long)banners * 30L) == 0L;
            }
            if (timeHeal || bannersHeal) {
                this.func_70691_i(1.0f);
                if (this.field_70154_o instanceof EntityLivingBase && !(this.field_70154_o instanceof LOTREntityNPC)) {
                    ((EntityLivingBase)this.field_70154_o).func_70691_i(1.0f);
                }
            }
        }
        this.hiredNPCInfo.onUpdate();
        if (!(this.field_70170_p.field_72995_K || !this.func_70089_S() || this.func_70638_az() != null && this.func_70638_az().func_70089_S())) {
            Container container;
            int i;
            boolean flag = false;
            if (this instanceof LOTRTradeable) {
                for (i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
                    EntityPlayer entityplayer = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
                    container = entityplayer.field_71070_bA;
                    if (container == null || !(container instanceof LOTRContainerTrade) || ((LOTRContainerTrade)container).theTrader != this) continue;
                    flag = true;
                    break;
                }
            }
            if (this instanceof LOTRUnitTradeable) {
                for (i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
                    EntityPlayer entityplayer = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
                    container = entityplayer.field_71070_bA;
                    if (container == null || !(container instanceof LOTRContainerUnitTrade) || ((LOTRContainerUnitTrade)container).theUnitTrader != this) continue;
                    flag = true;
                    break;
                }
            }
            if (this.hiredNPCInfo.isActive && this.hiredNPCInfo.isGuiOpen) {
                flag = true;
            }
            if (flag) {
                this.func_70661_as().func_75499_g();
                if (this.field_70154_o instanceof LOTREntityHorse) {
                    ((LOTREntityHorse)this.field_70154_o).func_70661_as().func_75499_g();
                }
            }
        }
        if (!this.isNPCPersistent && !this.hiredNPCInfo.isActive && this.spawnsInDarkness) {
            float f = this.func_70013_c(1.0f);
            if (f > 0.5f) {
                this.field_70708_bq += 2;
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
        }
        this.func_82168_bl();
        if (this.npcTalkTick < this.getNPCTalkInterval()) {
            ++this.npcTalkTick;
        }
        if (!this.field_70170_p.field_72995_K && this.func_110175_bO()) {
            if (this.hiredNPCInfo.isActive && this.hiredNPCInfo.isGuardMode()) {
                if (!this.func_110173_bK() && this.func_70638_az() == null) {
                    int homeX = this.func_110172_bL().field_71574_a;
                    int homeY = this.func_110172_bL().field_71572_b;
                    int homeZ = this.func_110172_bL().field_71573_c;
                    int homeRange = this.hiredNPCInfo.getGuardRange();
                    this.func_110177_bN();
                    Vec3 vec3 = null;
                    for (int i = 0; i < 16 && vec3 == null; ++i) {
                        vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this, (int)16, (int)7, (Vec3)this.field_70170_p.func_82732_R().func_72345_a((double)homeX, (double)homeY, (double)homeZ));
                    }
                    if (vec3 != null) {
                        this.func_70661_as().func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 1.0);
                    }
                    this.func_110171_b(homeX, homeY, homeZ, homeRange);
                }
            } else {
                double maxDistance;
                double distanceSq = this.func_110172_bL().func_71569_e(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
                if (distanceSq > (maxDistance = (double)this.func_110174_bM() + 8.0) * maxDistance) {
                    this.func_110177_bN();
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && (!(entity = this.func_70638_az()).func_70089_S() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean isRidingHorseNow;
            boolean bl = isRidingHorseNow = this.field_70154_o instanceof EntityLiving && this.field_70154_o.func_70089_S() && !(this.field_70154_o instanceof LOTREntityNPC);
            if (this.ridingHorse != isRidingHorseNow) {
                this.setRidingHorse(isRidingHorseNow);
            }
        }
        if (!this.field_70170_p.field_72995_K && this instanceof LOTRBannerBearer) {
            LOTRBannerBearer thisAsBannerBearer = (LOTRBannerBearer)((Object)this);
            ItemStack weapon = this.func_71124_b(0);
            if (this.func_70638_az() == null) {
                if (weapon == null || weapon.func_77973_b() != LOTRMod.banner) {
                    this.func_70062_b(0, new ItemStack(LOTRMod.banner, 1, LOTRItemBanner.getSubtypeForFaction(this.getFaction())));
                }
            } else if (weapon == null || weapon.func_77973_b() != thisAsBannerBearer.getWeaponItem()) {
                this.func_70062_b(0, new ItemStack(thisAsBannerBearer.getWeaponItem()));
            }
        }
    }

    protected double getWeaponChangeThresholdRange() {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        return d * 0.95;
    }

    protected double getWeaponChangeThresholdRangeSq() {
        double d = this.getWeaponChangeThresholdRange();
        return d * d;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.hiredNPCInfo.writeToNBT(nbt);
        this.traderNPCInfo.writeToNBT(nbt);
        nbt.func_74768_a("NPCHomeX", this.func_110172_bL().field_71574_a);
        nbt.func_74768_a("NPCHomeY", this.func_110172_bL().field_71572_b);
        nbt.func_74768_a("NPCHomeZ", this.func_110172_bL().field_71573_c);
        nbt.func_74768_a("NPCHomeRadius", (int)this.func_110174_bM());
        nbt.func_74757_a("NPCPersistent", this.isNPCPersistent);
        if (this.npcLocationName != null) {
            nbt.func_74778_a("NPCLocationName", this.npcLocationName);
        }
        nbt.func_74757_a("SpecificLocationName", this.hasSpecificLocationName);
        nbt.func_74757_a("HurtOnlyByPlates", this.hurtOnlyByPlates);
        nbt.func_74757_a("RidingHorse", this.ridingHorse);
        nbt.func_74757_a("NPCPassive", this.isPassive);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.hiredNPCInfo.readFromNBT(nbt);
        this.traderNPCInfo.readFromNBT(nbt);
        this.func_110171_b(nbt.func_74762_e("NPCHomeX"), nbt.func_74762_e("NPCHomeY"), nbt.func_74762_e("NPCHomeZ"), nbt.func_74762_e("NPCHomeRadius"));
        this.isNPCPersistent = nbt.func_74767_n("NPCPersistent");
        if (nbt.func_74764_b("NPCLocationName")) {
            this.npcLocationName = nbt.func_74779_i("NPCLocationName");
        }
        this.hasSpecificLocationName = nbt.func_74767_n("SpecificLocationName");
        this.hurtOnlyByPlates = nbt.func_74767_n("HurtOnlyByPlates");
        this.ridingHorse = nbt.func_74767_n("RidingHorse");
        this.isPassive = nbt.func_74767_n("NPCPassive");
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        int id = LOTREntities.getEntityID((Entity)this);
        if (id > 0 && LOTREntities.creatures.containsKey(id)) {
            return new ItemStack(LOTRMod.spawnEgg, 1, id);
        }
        return null;
    }

    public boolean func_70652_k(Entity entity) {
        Item weaponItem;
        Multimap weaponAttributes;
        float damage = (float)this.func_110148_a(npcAttackDamage).func_111126_e();
        float weaponDamage = 0.0f;
        ItemStack weapon = this.func_71124_b(0);
        if (weapon != null && (weaponAttributes = (weaponItem = weapon.func_77973_b()).func_111205_h()) != null) {
            for (Object key : weaponAttributes.keySet()) {
                if (!key.equals(SharedMonsterAttributes.field_111264_e.func_111108_a())) continue;
                Collection values = weaponAttributes.get(key);
                for (Object obj : values) {
                    if (!(obj instanceof AttributeModifier)) continue;
                    AttributeModifier mod = (AttributeModifier)obj;
                    weaponDamage += (float)mod.func_111164_d() * 0.75f;
                }
            }
        }
        if (weaponDamage > 0.0f) {
            damage = weaponDamage;
        }
        int knockbackModifier = 0;
        if (entity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            knockbackModifier += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        int banners = this.nearbyBanners();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage += (float)banners * 0.5f);
        if (flag) {
            int fireAspectModifier;
            if (weapon != null && entity instanceof EntityLivingBase) {
                int weaponItemDamage = weapon.func_77960_j();
                weapon.func_77973_b().func_77644_a(weapon, (EntityLivingBase)entity, (EntityLivingBase)this);
                weapon.func_77964_b(weaponItemDamage);
            }
            if (knockbackModifier > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockbackModifier * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(fireAspectModifier * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return flag;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        this.hiredNPCInfo.onKillEntity(entity);
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean flag;
        if (this.field_70153_n != null && damagesource.func_76346_g() == this.field_70153_n) {
            return false;
        }
        int banners = this.nearbyBanners();
        if (banners > 0) {
            int i = 12 - banners;
            float f1 = f * (float)i;
            f = f1 / 12.0f;
        }
        if ((flag = super.func_70097_a(damagesource, f)) && damagesource.func_76346_g() instanceof LOTREntityNPC) {
            LOTREntityNPC attacker = (LOTREntityNPC)damagesource.func_76346_g();
            if (attacker.hiredNPCInfo.isActive && attacker.hiredNPCInfo.getHiringPlayer() != null) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (flag && !this.field_70170_p.field_72995_K && this.hurtOnlyByPlates) {
            this.hurtOnlyByPlates = damagesource.func_76364_f() instanceof LOTREntityPlate;
        }
        return flag;
    }

    protected void func_70628_a(boolean flag, int i) {
        this.dropNPCEquipment(flag, i);
    }

    public void dropNPCEquipment(boolean flag, int i) {
        if (flag) {
            int j;
            int equipmentCount = 0;
            for (j = 0; j < 5; ++j) {
                if (this.func_71124_b(j) == null) continue;
                ++equipmentCount;
            }
            if (equipmentCount > 0) {
                for (j = 0; j < 5; ++j) {
                    boolean dropGuaranteed;
                    ItemStack equipmentDrop = this.func_71124_b(j);
                    if (equipmentDrop == null) continue;
                    boolean bl = dropGuaranteed = this.field_82174_bp[j] >= 1.0f;
                    if (!dropGuaranteed) {
                        int chance = 20 * equipmentCount - i * 4 * equipmentCount;
                        if (chance < 1) {
                            chance = 1;
                        }
                        if (this.field_70146_Z.nextInt(chance) != 0) continue;
                    }
                    if (!dropGuaranteed) {
                        int dropDamage = MathHelper.func_76128_c((double)((float)equipmentDrop.func_77973_b().func_77612_l() * (0.5f + this.field_70146_Z.nextFloat() * 0.25f)));
                        equipmentDrop.func_77964_b(dropDamage);
                    }
                    this.func_70099_a(equipmentDrop, 0.0f);
                    this.func_70062_b(j, null);
                }
            }
        }
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        this.hiredNPCInfo.onDeath(damagesource);
        if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityPlayer) {
            int alignment;
            float size;
            EntityPlayer entityplayer = (EntityPlayer)damagesource.func_76346_g();
            if (this.canDropPouch() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && this.field_70146_Z.nextInt(50) == 0) {
                int pouchSize = LOTRItemPouch.getRandomPouchSize(this.field_70146_Z);
                this.func_70099_a(new ItemStack(LOTRMod.pouch, 1, pouchSize), 0.0f);
            }
            if (this.hurtOnlyByPlates && damagesource.func_76364_f() instanceof LOTREntityPlate) {
                if (LOTRLevelData.getAlignment(entityplayer, this.getFaction()) < 0) {
                    // empty if block
                }
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.killUsingOnlyPlates);
            }
            if (damagesource.func_76364_f() instanceof LOTREntityPebble && (size = this.field_70130_N * this.field_70130_N * this.field_70131_O) > 5.0f && (alignment = LOTRLevelData.getAlignment(entityplayer, this.getFaction())) < 0) {
                LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.killLargeMobWithSlingshot);
            }
            if (this.getKillAchievement() != null) {
                LOTRLevelData.addAchievement(entityplayer, this.getKillAchievement());
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = false;
            if (this instanceof LOTRTradeable) {
                flag = ((LOTRTradeable)((Object)this)).shouldTraderRespawn();
            } else if (this instanceof LOTRUnitTradeable) {
                flag = ((LOTRUnitTradeable)((Object)this)).shouldTraderRespawn();
            }
            if (flag) {
                LOTREntityTraderRespawn entity = new LOTREntityTraderRespawn(this.field_70170_p);
                entity.func_70012_b(this.field_70165_t, this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 0.0f, 0.0f);
                entity.copyTraderDataFrom(this);
                this.field_70170_p.func_72838_d((Entity)entity);
                entity.onSpawn();
            }
        }
    }

    protected LOTRAchievement getKillAchievement() {
        return null;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70725_aQ == 0 && this.field_70154_o != null) {
            this.field_70154_o.func_70106_y();
        }
    }

    public boolean canDropPouch() {
        return !this.hiredNPCInfo.isActive;
    }

    public int getAlignmentBonus() {
        return 0;
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        return 4 + this.field_70146_Z.nextInt(3);
    }

    public float func_70783_a(int i, int j, int k) {
        BiomeGenBase biome;
        if (this.liftSpawnRestrictions) {
            return 1.0f;
        }
        if (this.spawnsInDarkness && (biome = this.field_70170_p.func_72807_a(i, k)) instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
            return 1.0f;
        }
        if (this.spawnsInDarkness) {
            return 0.5f - this.field_70170_p.func_72801_o(i, j, k);
        }
        return super.func_70783_a(i, j, k);
    }

    protected boolean isValidLightLevel() {
        BiomeGenBase biome;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.spawnsInDarkness && (biome = this.field_70170_p.func_72807_a(i, k)) instanceof LOTRBiome && ((LOTRBiome)biome).canSpawnHostilesInDay()) {
            return true;
        }
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j, k) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return (!this.spawnsInDarkness || this.liftSpawnRestrictions || this.isValidLightLevel()) && super.func_70601_bi();
    }

    public final int getSpawnCountValue() {
        if (this.isNPCPersistent || this.hiredNPCInfo.isActive) {
            return 0;
        }
        int multiplier = 1;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
        if (biome instanceof LOTRBiome) {
            multiplier = ((LOTRBiome)biome).spawnCountMultiplier();
        }
        return this.spawnCountValue * multiplier;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        String speechBank;
        if (!this.field_70170_p.field_72995_K && this.canNPCTalk() && (speechBank = this.getSpeechBank(entityplayer)) != null) {
            if (this.npcLocationName != null) {
                entityplayer.func_145747_a(LOTRSpeech.getNamedLocationSpeechForPlayer((EntityLivingBase)this, this.npcLocationName, speechBank, entityplayer));
            } else {
                entityplayer.func_145747_a(LOTRSpeech.getNamedSpeechForPlayer((EntityLivingBase)this, speechBank, entityplayer));
            }
            this.markNPCSpoken();
            if (this.getTalkAchievement() != null) {
                LOTRLevelData.addAchievement(entityplayer, this.getTalkAchievement());
            }
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    protected LOTRAchievement getTalkAchievement() {
        return null;
    }

    public boolean isFriendly(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= 0 && this.func_70638_az() != entityplayer && this.field_70717_bb != entityplayer;
    }

    public String getSpeechBank(EntityPlayer entityplayer) {
        return null;
    }

    public void onArtificalSpawn() {
    }

    public boolean isDrunkard() {
        return false;
    }

    public void setSpecificLocationName(String name) {
        this.npcLocationName = name;
        this.hasSpecificLocationName = true;
    }

    public boolean getHasSpecificLocationName() {
        return this.hasSpecificLocationName;
    }

    public int nearbyBanners() {
        if (this.getFaction() == LOTRFaction.UNALIGNED) {
            return 0;
        }
        int banners = 0;
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
        for (int i = 0; i < entities.size(); ++i) {
            ItemStack item;
            LOTRFaction faction;
            EntityLivingBase entity = (EntityLivingBase)entities.get(i);
            if (!entity.func_70089_S() || entity.func_71124_b(0) == null || (faction = LOTRItemBanner.getFaction(item = entity.func_71124_b(0))) != this.getFaction()) continue;
            ++banners;
        }
        return Math.min(banners, 4);
    }

    public ItemStack func_71124_b(int i) {
        if (this.field_70170_p.field_72995_K) {
            if (!this.initFestiveItems) {
                this.festiveRand.setSeed((long)this.func_145782_y() * 341873128712L);
                if (LOTRMod.isHalloween()) {
                    if (this.festiveRand.nextInt(4) == 0) {
                        this.festiveItems[4] = this.festiveRand.nextInt(10) == 0 ? new ItemStack(Blocks.field_150428_aP) : new ItemStack(Blocks.field_150423_aK);
                    }
                } else if (LOTRMod.isChristmas()) {
                    ItemStack hat = new ItemStack(LOTRMod.leatherHat);
                    LOTRItemLeatherHat.setHatColor(hat, 0xFF0000);
                    LOTRItemLeatherHat.setFeatherColor(hat, 0xFFFFFF);
                    this.festiveItems[4] = hat;
                }
                this.initFestiveItems = true;
            }
            if (this.festiveItems[i] != null) {
                return this.festiveItems[i];
            }
        }
        return super.func_71124_b(i);
    }

    public boolean func_110164_bC() {
        return false;
    }

    public void func_94058_c(String name) {
    }

    public void func_110163_bv() {
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }
}

