/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNames;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class LOTREntityRanger
extends LOTREntityNPC
implements IRangedAttackMob {
    public EntityAIBase rangedAttackAI = this.createRangerRangedAttackAI();
    public EntityAIBase meleeAttackAI = this.createRangerMeleeAttackAI();
    public int weaponChangeCooldown = 0;
    private int sneakCooldown = 0;
    private EntityLivingBase prevRangerTarget;

    public LOTREntityRanger(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 10.0f, 0.1f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(2);
        this.spawnCountValue = 5;
    }

    public EntityAIBase createRangerRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 20, 40, 20.0f);
    }

    public EntityAIBase createRangerMeleeAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, true);
    }

    public abstract Item getRangerSwordId();

    public abstract Item getRangerBowId();

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)LOTRNames.getRandomGondorName(this.field_70146_Z));
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public String getRangerName() {
        return this.field_70180_af.func_75681_e(16);
    }

    public void setRangerName(String name) {
        this.field_70180_af.func_75692_b(16, (Object)name);
    }

    public boolean isRangerSneaking() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public void setRangerSneaking(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)(flag ? (byte)1 : 0));
        if (flag) {
            this.sneakCooldown = 20;
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsRanger));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsRanger));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyRanger));
        this.func_70062_b(4, new ItemStack(LOTRMod.helmetRanger));
        return data;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public String getNPCName() {
        return this.getRangerName();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("RangerName", this.getRangerName());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("RangerName")) {
            this.setRangerName(nbt.func_74779_i("RangerName"));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            ItemStack weapon = this.func_71124_b(0);
            if (this.func_70638_az() != null) {
                double d = this.func_70068_e((Entity)this.func_70638_az());
                if (d < 16.0) {
                    if (weapon == null || weapon.func_77973_b() != this.getRangerSwordId()) {
                        this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                        this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
                        this.func_70062_b(0, new ItemStack(this.getRangerSwordId()));
                        this.weaponChangeCooldown = 20;
                    }
                } else if (d < this.getWeaponChangeThresholdRangeSq() && (weapon == null || weapon.func_77973_b() != this.getRangerBowId())) {
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
                    this.func_70062_b(0, new ItemStack(this.getRangerBowId()));
                    this.weaponChangeCooldown = 20;
                }
            } else if (weapon != null) {
                if (this.weaponChangeCooldown > 0) {
                    --this.weaponChangeCooldown;
                } else {
                    this.field_70714_bg.func_85156_a(this.rangedAttackAI);
                    this.field_70714_bg.func_85156_a(this.meleeAttackAI);
                    this.func_70062_b(0, null);
                }
            }
            if (this.isRangerSneaking()) {
                if (this.func_70638_az() == null) {
                    if (this.sneakCooldown > 0) {
                        --this.sneakCooldown;
                    } else {
                        this.setRangerSneaking(false);
                    }
                } else {
                    this.sneakCooldown = 20;
                }
            } else {
                this.sneakCooldown = 0;
            }
        }
    }

    @Override
    public void func_70624_b(EntityLivingBase target) {
        super.func_70624_b(target);
        if (target != null && target != this.prevRangerTarget) {
            this.prevRangerTarget = target;
            if (!this.field_70170_p.field_72995_K && !this.isRangerSneaking()) {
                this.setRangerSneaking(true);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        boolean flag = super.func_70097_a(damagesource, f);
        if (flag && !this.field_70170_p.field_72995_K && this.isRangerSneaking()) {
            this.setRangerSneaking(false);
        }
        return flag;
    }

    public void func_71038_i() {
        super.func_71038_i();
        if (!this.field_70170_p.field_72995_K && this.isRangerSneaking()) {
            this.setRangerSneaking(false);
        }
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.3f + this.func_70032_d((Entity)target) / 24.0f * 0.3f, 0.5f);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
        if (!this.field_70170_p.field_72995_K && this.isRangerSneaking() && this.func_70068_e((Entity)target) < 100.0) {
            this.setRangerSneaking(false);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int k;
        super.func_70628_a(flag, i);
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        if (this.field_70146_Z.nextBoolean()) {
            j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151032_g, 1);
            }
        }
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
            return j > 62 && (block == Blocks.field_150349_c || block == Blocks.field_150354_m);
        }
        return false;
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        if (!this.isRangerSneaking()) {
            super.func_145780_a(i, j, k, block);
        }
    }

    public String getRangerCape() {
        return null;
    }
}

