/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRMod;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class LOTREntityScorpion
extends EntityMob {
    private float scorpionWidth = -1.0f;
    private float scorpionHeight;

    public LOTREntityScorpion(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide((EntityCreature)this, 1.2, false, 0.8f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, LOTREntityNPC.class, 0, true));
    }

    protected int getRandomScorpionScale() {
        return this.field_70146_Z.nextInt(3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)((byte)this.getRandomScorpionScale()));
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public int getScorpionScale() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setScorpionScale(int i) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)i));
    }

    public float getScorpionScaleAmount() {
        return 0.5f + (float)this.getScorpionScale() / 2.0f;
    }

    public int getStrikeTime() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setStrikeTime(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0 + (double)this.getScorpionScale() * 6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35 - (double)this.getScorpionScale() * 0.05);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 + (double)this.getScorpionScale());
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("ScorpionScale", (byte)this.getScorpionScale());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setScorpionScale(nbt.func_74771_c("ScorpionScale"));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 + (double)this.getScorpionScale());
    }

    public void func_70636_d() {
        int i;
        super.func_70636_d();
        this.rescaleScorpion(this.getScorpionScaleAmount());
        if (!this.field_70170_p.field_72995_K && (i = this.getStrikeTime()) > 0) {
            this.setStrikeTime(i - 1);
        }
    }

    protected void func_70105_a(float f, float f1) {
        boolean flag = this.scorpionWidth > 0.0f;
        this.scorpionWidth = f;
        this.scorpionHeight = f1;
        if (!flag) {
            this.rescaleScorpion(1.0f);
        }
    }

    private void rescaleScorpion(float f) {
        super.func_70105_a(this.scorpionWidth * f, this.scorpionHeight * f);
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151069_bo) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a == 1) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, new ItemStack(LOTRMod.bottlePoison));
            } else if (!entityplayer.field_71071_by.func_70441_a(new ItemStack(LOTRMod.bottlePoison)) && !entityplayer.field_71075_bZ.field_75098_d) {
                entityplayer.func_71019_a(new ItemStack(LOTRMod.bottlePoison), false);
            }
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (!this.field_70170_p.field_72995_K) {
                this.setStrikeTime(20);
            }
            if (entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.EASY) {
                    duration = 3;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected String func_70639_aQ() {
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean flag, int i) {
        int k = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int j = 0; j < k; ++j) {
            this.func_145779_a(Items.field_151078_bh, 1);
        }
    }

    protected int func_70693_a(EntityPlayer entityplayer) {
        int i = this.getScorpionScale();
        return 2 + i + this.field_70146_Z.nextInt(i + 2);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect effect) {
        if (effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        return super.func_70687_e(effect);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(LOTRMod.spawnEgg, 1, LOTREntities.getEntityID((Entity)this));
    }
}

