/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class LOTREntitySpiderBase
extends LOTREntityNPC {
    public static int VENOM_NONE = 0;
    public static int VENOM_SLOWNESS = 1;
    public static int VENOM_POISON = 2;
    private float spiderWidth = -1.0f;
    private float spiderHeight;

    public LOTREntitySpiderBase(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.func_70661_as().func_75491_a(true);
        this.spawnsInDarkness = true;
    }

    protected abstract int getRandomSpiderScale();

    protected abstract int getRandomSpiderType();

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)((byte)this.getRandomSpiderScale()));
        this.setSpiderType(this.getRandomSpiderType());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0 + (double)this.getSpiderScale() * 6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35 - (double)this.getSpiderScale() * 0.05);
        this.func_110148_a(npcAttackDamage).func_111128_a(2.0 + (double)this.getSpiderScale());
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean flag) {
        byte b = this.field_70180_af.func_75683_a(16);
        b = flag ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b);
    }

    public int getSpiderType() {
        return this.field_70180_af.func_75683_a(17);
    }

    public void setSpiderType(int i) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)i));
    }

    public int getSpiderScale() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setSpiderScale(int i) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)i));
    }

    public float getSpiderScaleAmount() {
        return 0.5f + (float)this.getSpiderScale() / 2.0f;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("SpiderType", (byte)this.getSpiderType());
        nbt.func_74774_a("SpiderScale", (byte)this.getSpiderScale());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSpiderType(nbt.func_74771_c("SpiderType"));
        this.setSpiderScale(nbt.func_74771_c("SpiderScale"));
        this.func_110148_a(npcAttackDamage).func_111128_a(2.0 + (double)this.getSpiderScale());
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
        this.rescaleSpider(this.getSpiderScaleAmount());
    }

    protected void func_70105_a(float f, float f1) {
        boolean flag = this.spiderWidth > 0.0f;
        this.spiderWidth = f;
        this.spiderHeight = f1;
        if (!flag) {
            this.rescaleSpider(1.0f);
        }
    }

    private void rescaleSpider(float f) {
        super.func_70105_a(this.spiderWidth * f, this.spiderHeight * f);
    }

    public double func_70042_X() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (double)this.field_70131_O * 0.95;
        }
        if (this.field_70153_n instanceof LOTREntityNPC) {
            return (double)this.field_70131_O * 0.55;
        }
        return super.func_70042_X();
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (this.getSpiderType() == VENOM_POISON && itemstack != null && itemstack.func_77973_b() == Items.field_151069_bo) {
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a == 1) {
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, new ItemStack(LOTRMod.bottlePoison));
            } else if (!entityplayer.field_71071_by.func_70441_a(new ItemStack(LOTRMod.bottlePoison)) && !entityplayer.field_71075_bZ.field_75098_d) {
                entityplayer.func_71019_a(new ItemStack(LOTRMod.bottlePoison), false);
            }
            return true;
        }
        return super.func_70085_c(entityplayer);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.EASY) {
                    duration = 3;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    if (this.getSpiderType() == VENOM_SLOWNESS) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration * 20, 0));
                    } else if (this.getSpiderType() == VENOM_POISON) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration * 20, 0));
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected String func_70639_aQ() {
        return "mob.spider.say";
    }

    protected String func_70621_aR() {
        return "mob.spider.say";
    }

    protected String func_70673_aS() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        int string = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int j = 0; j < string; ++j) {
            this.func_145779_a(Items.field_151007_F, 1);
        }
        if (flag && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + i) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    @Override
    public boolean canDropPouch() {
        return false;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        int i = this.getSpiderScale();
        return 2 + i + this.field_70146_Z.nextInt(i + 2);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect effect) {
        if (this.getSpiderType() == VENOM_SLOWNESS && effect.func_76456_a() == Potion.field_76421_d.field_76415_H) {
            return false;
        }
        if (this.getSpiderType() == VENOM_POISON && effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        return super.func_70687_e(effect);
    }
}

