/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityUrukHai;
import lotr.common.entity.npc.LOTRTradeEntry;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityUrukHaiTrader
extends LOTREntityUrukHai
implements LOTRTradeable {
    public LOTREntityUrukHaiTrader(World world) {
        super(world);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        if (!this.field_70170_p.field_72995_K) {
            this.traderNPCInfo.setBuyTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.URUK_HAI_TRADER_BUY, this.field_70146_Z, true));
            this.traderNPCInfo.setSellTrades(LOTRTradeEntry.getRandomTrades(LOTRTradeEntry.URUK_HAI_TRADER_SELL, this.field_70146_Z, false));
        }
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.func_70062_b(0, new ItemStack(LOTRMod.daggerUrukPoisoned));
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsWarg));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsWarg));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyWarg));
        this.func_70062_b(4, new ItemStack(LOTRMod.helmetWarg));
        return data;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.URUK_HAI_TRADER_BONUS;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.URUK_HAI_TRADER_TRADE && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerBuyItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeUrukTrader);
    }

    @Override
    public void onPlayerSellItem(EntityPlayer entityplayer, ItemStack itemstack) {
        LOTRLevelData.addAchievement(entityplayer, LOTRAchievement.tradeUrukTrader);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "urukHaiTrader_friendly";
            }
            return "urukHaiTrader_neutral";
        }
        return "orc_hostile";
    }
}

