/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRAlignmentValues;
import lotr.common.LOTRFaction;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtByTarget;
import lotr.common.entity.ai.LOTREntityAIHiringPlayerHurtTarget;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetWoodElf;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityWoodElf
extends LOTREntityElf {
    public LOTREntityWoodElf(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiringPlayerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new LOTREntityAIHiringPlayerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.addTargetTasks(4, LOTREntityAINearestAttackableTargetWoodElf.class);
        this.spawnCountValue = 2;
    }

    @Override
    public EntityAIBase createElfMeleeAttackAI() {
        return this.createElfRangedAttackAI();
    }

    @Override
    public EntityAIBase createElfRangedAttackAI() {
        return new EntityAIArrowAttack((IRangedAttackMob)this, 1.25, 30, 50, 16.0f);
    }

    @Override
    public Item getElfSwordId() {
        return this.getElfBowId();
    }

    @Override
    public Item getElfBowId() {
        return LOTRMod.mirkwoodBow;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.WOOD_ELF;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killWoodElf;
    }

    @Override
    public int getAlignmentBonus() {
        return LOTRAlignmentValues.WOOD_ELF_BONUS;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        if (flag) {
            int dropChance = 20 - i * 4;
            if (dropChance < 1) {
                dropChance = 1;
            }
            if (this.field_70146_Z.nextInt(dropChance) == 0) {
                this.func_70099_a(new ItemStack(LOTRMod.mugRedWine, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
            }
        }
    }

    @Override
    public boolean canElfSpawnHere() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        return biome == LOTRBiome.mirkwood && j > 62 && (this.field_70170_p.func_147439_a(i, j - 1, k) == Blocks.field_150349_c || this.field_70170_p.func_147439_a(i, j - 1, k) == LOTRMod.planks && this.field_70170_p.func_72805_g(i, j - 1, k) == 2);
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome == LOTRBiome.mirkwood) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "woodElf_hired";
            }
            if (LOTRLevelData.getAlignment(entityplayer, this.getFaction()) >= LOTRAlignmentValues.WOOD_ELF_TRUST) {
                return "woodElf_friendly";
            }
            return "woodElf_neutral";
        }
        return "woodElf_hostile";
    }
}

