/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.inventory.LOTRInventoryHiredNPC;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class LOTRHiredNPCInfo {
    private LOTREntityNPC theEntity;
    public boolean isActive;
    public int alignmentRequiredToCommand;
    private boolean canMove = true;
    public int mobKills;
    public boolean obeyHornHaltReady = true;
    public boolean obeyHornSummon = true;
    public boolean teleportAutomatically = true;
    public boolean inCombat;
    private boolean prevInCombat;
    public boolean isGuiOpen;
    public boolean guardMode;
    public static int GUARD_RANGE_MIN = 8;
    public static int GUARD_RANGE_MAX = 64;
    private int guardRange = GUARD_RANGE_MIN;
    private Task task = Task.WARRIOR;
    private LOTRInventoryHiredNPC hiredInventory;

    public LOTRHiredNPCInfo(LOTREntityNPC npc) {
        this.theEntity = npc;
        this.theEntity.func_70096_w().func_75682_a(28, (Object)"");
    }

    public String getHiringPlayerName() {
        return this.theEntity.func_70096_w().func_75681_e(28);
    }

    public void setHiringPlayerName(String s) {
        this.theEntity.func_70096_w().func_75692_b(28, (Object)s);
    }

    public EntityPlayer getHiringPlayer() {
        return this.theEntity.field_70170_p.func_72924_a(this.getHiringPlayerName());
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task t) {
        this.task = t;
        if (this.task == Task.FARMER) {
            this.hiredInventory = new LOTRInventoryHiredNPC(this.theEntity, 3);
        }
    }

    public LOTRInventoryHiredNPC getHiredInventory() {
        return this.hiredInventory;
    }

    public void onUpdate() {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            if (this.isActive && this.getHiringPlayer() != null) {
                int alignment = LOTRLevelData.getAlignment(this.getHiringPlayer(), this.theEntity.getFaction());
                if (this.alignmentRequiredToCommand < 0 && alignment > this.alignmentRequiredToCommand || this.alignmentRequiredToCommand >= 0 && alignment < this.alignmentRequiredToCommand) {
                    this.dismissUnit();
                }
            }
            boolean bl = this.inCombat = this.theEntity.func_70638_az() != null;
            if (this.inCombat != this.prevInCombat) {
                this.sendClientPacket(false);
            }
            this.prevInCombat = this.inCombat;
        }
    }

    public void dismissUnit() {
        this.getHiringPlayer().func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.desert", new Object[]{this.theEntity.func_70005_c_()}));
        this.isActive = false;
        this.setHiringPlayerName("");
        this.canMove = true;
    }

    public void onDeath(DamageSource damagesource) {
        EntityPlayer hiringPlayer;
        if (!this.theEntity.field_70170_p.field_72995_K && this.isActive && this.getHiringPlayer() != null && LOTRLevelData.getEnableHiredDeathMessages(hiringPlayer = this.getHiringPlayer())) {
            hiringPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.death", new Object[]{this.theEntity.func_110142_aN().func_151521_b()}));
        }
        if (!this.theEntity.field_70170_p.field_72995_K && this.hiredInventory != null) {
            this.hiredInventory.dropAllItems();
        }
    }

    public void halt() {
        this.canMove = false;
        this.theEntity.func_70624_b(null);
        this.sendClientPacket(false);
    }

    public void ready() {
        this.canMove = true;
        this.sendClientPacket(false);
    }

    public boolean isHalted() {
        return !this.guardMode && !this.canMove;
    }

    public boolean shouldFollowPlayer() {
        return !this.guardMode && this.canMove;
    }

    public boolean getObeyHornHaltReady() {
        if (this.task != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode && this.obeyHornHaltReady;
    }

    public boolean getObeyHornSummon() {
        if (this.task != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode && this.obeyHornSummon;
    }

    public boolean getObeyCommandSword() {
        if (this.task != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode && this.canMove;
    }

    public boolean isGuardMode() {
        return this.guardMode;
    }

    public void setGuardMode(boolean flag) {
        this.guardMode = flag;
        if (flag) {
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
            this.theEntity.func_110171_b(i, j, k, this.guardRange);
        } else {
            this.theEntity.func_110177_bN();
        }
    }

    public int getGuardRange() {
        return this.guardRange;
    }

    public void setGuardRange(int range) {
        this.guardRange = MathHelper.func_76125_a((int)range, (int)GUARD_RANGE_MIN, (int)GUARD_RANGE_MAX);
        if (this.guardMode) {
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
            this.theEntity.func_110171_b(i, j, k, this.guardRange);
        }
    }

    public String getStatusString() {
        String s = StatCollector.func_74838_a((String)"lotr.hiredNPC.status") + ": ";
        if (this.task == Task.WARRIOR) {
            s = this.inCombat ? s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.combat") : (this.isHalted() ? s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.halted") : (this.guardMode ? s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.guard") : s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.ready")));
        } else if (this.task == Task.FARMER) {
            s = this.guardMode ? s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.farming") : s + StatCollector.func_74838_a((String)"lotr.hiredNPC.status.following");
        }
        return s;
    }

    public void onKillEntity(EntityLivingBase entity) {
        if (!this.theEntity.field_70170_p.field_72995_K && this.isActive) {
            ++this.mobKills;
            this.sendClientPacket(false);
        }
    }

    public boolean tryTeleportToHiringPlayer() {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            EntityPlayer entityplayer = this.getHiringPlayer();
            if (this.isActive && entityplayer != null && this.theEntity.field_70153_n == null) {
                int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
                int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                float f = this.theEntity.field_70130_N / 2.0f;
                float f1 = this.theEntity.field_70131_O;
                AxisAlignedBB npcBoundingBox = AxisAlignedBB.func_72332_a().func_72299_a(entityplayer.field_70165_t - (double)f, entityplayer.field_70163_u - (double)this.theEntity.field_70129_M + (double)this.theEntity.field_70139_V, entityplayer.field_70161_v - (double)f, entityplayer.field_70165_t + (double)f, entityplayer.field_70163_u - (double)this.theEntity.field_70129_M + (double)this.theEntity.field_70139_V + (double)f1, entityplayer.field_70161_v + (double)f);
                if (this.theEntity.field_70170_p.func_147461_a(npcBoundingBox).isEmpty() && this.theEntity.field_70170_p.func_147439_a(i, j - 1, k).isSideSolid((IBlockAccess)this.theEntity.field_70170_p, i, j - 1, k, ForgeDirection.UP)) {
                    if (this.theEntity.field_70154_o != null && this.theEntity.field_70154_o instanceof EntityLiving) {
                        EntityLiving mount = (EntityLiving)this.theEntity.field_70154_o;
                        float f2 = mount.field_70130_N / 2.0f;
                        float f3 = mount.field_70131_O;
                        AxisAlignedBB mountBoundingBox = AxisAlignedBB.func_72332_a().func_72299_a(entityplayer.field_70165_t - (double)f2, entityplayer.field_70163_u - (double)mount.field_70129_M + (double)mount.field_70139_V, entityplayer.field_70161_v - (double)f2, entityplayer.field_70165_t + (double)f2, entityplayer.field_70163_u - (double)mount.field_70129_M + (double)mount.field_70139_V + (double)f3, entityplayer.field_70161_v + (double)f2);
                        if (this.theEntity.field_70170_p.func_147461_a(mountBoundingBox).isEmpty() && this.theEntity.field_70170_p.func_147439_a(i, j - 1, k).isSideSolid((IBlockAccess)this.theEntity.field_70170_p, i, j - 1, k, ForgeDirection.UP)) {
                            mount.func_70012_b(entityplayer.field_70165_t, entityplayer.field_70121_D.field_72338_b, entityplayer.field_70161_v, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                            mount.field_70143_R = 0.0f;
                            mount.func_70661_as().func_75499_g();
                            mount.func_70624_b(null);
                            this.theEntity.field_70143_R = 0.0f;
                            this.theEntity.func_70661_as().func_75499_g();
                            this.theEntity.func_70624_b(null);
                            return true;
                        }
                    } else {
                        this.theEntity.func_70012_b(entityplayer.field_70165_t, entityplayer.field_70121_D.field_72338_b, entityplayer.field_70161_v, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                        this.theEntity.field_70143_R = 0.0f;
                        this.theEntity.func_70661_as().func_75499_g();
                        this.theEntity.func_70624_b(null);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74757_a("IsActive", this.isActive);
        data.func_74778_a("HiringPlayerName", this.getHiringPlayerName());
        data.func_74768_a("AlignmentRequired", this.alignmentRequiredToCommand);
        data.func_74757_a("CanMove", this.canMove);
        data.func_74757_a("ObeyHornHaltReady", this.obeyHornHaltReady);
        data.func_74757_a("ObeyHornSummon", this.obeyHornSummon);
        data.func_74757_a("TeleportAutomatically", this.teleportAutomatically);
        data.func_74768_a("MobKills", this.mobKills);
        data.func_74757_a("GuardMode", this.guardMode);
        data.func_74768_a("GuardRange", this.guardRange);
        data.func_74768_a("Task", this.task.ordinal());
        if (this.hiredInventory != null) {
            this.hiredInventory.writeToNBT(data);
        }
        nbt.func_74782_a("HiredNPCInfo", (NBTBase)data);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("HiredNPCInfo");
        if (data != null) {
            this.isActive = data.func_74767_n("IsActive");
            this.setHiringPlayerName(data.func_74779_i("HiringPlayerName"));
            this.alignmentRequiredToCommand = data.func_74762_e("AlignmentRequired");
            this.canMove = data.func_74767_n("CanMove");
            if (data.func_74764_b("ObeyHornHaltReady")) {
                this.obeyHornHaltReady = data.func_74767_n("ObeyHornHaltReady");
                this.obeyHornSummon = data.func_74767_n("ObeyHornSummon");
                this.teleportAutomatically = data.func_74767_n("TeleportAutomatically");
                this.mobKills = data.func_74762_e("MobKills");
                this.setGuardMode(data.func_74767_n("GuardMode"));
                this.setGuardRange(data.func_74762_e("GuardRange"));
            }
            this.setTask(Task.forID(data.func_74762_e("Task")));
            if (this.hiredInventory != null) {
                this.hiredInventory.readFromNBT(data);
            }
        }
    }

    public void sendClientPacket(boolean shouldOpenGui) {
        if (this.theEntity.field_70170_p.field_72995_K || this.getHiringPlayer() == null) {
            return;
        }
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.theEntity.func_145782_y());
        data.writeBoolean(shouldOpenGui);
        data.writeBoolean(this.isActive);
        data.writeBoolean(this.canMove);
        data.writeBoolean(this.obeyHornHaltReady);
        data.writeBoolean(this.obeyHornSummon);
        data.writeBoolean(this.teleportAutomatically);
        data.writeInt(this.mobKills);
        data.writeInt(this.alignmentRequiredToCommand);
        data.writeBoolean(this.inCombat);
        data.writeBoolean(this.guardMode);
        data.writeInt(this.guardRange);
        data.writeByte((int)((byte)this.task.ordinal()));
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.hiredGui", data);
        ((EntityPlayerMP)this.getHiringPlayer()).field_71135_a.func_147359_a((Packet)packet);
        if (shouldOpenGui) {
            this.isGuiOpen = true;
        }
    }

    public void receiveClientPacket(ByteBuf data) {
        this.isActive = data.readBoolean();
        this.canMove = data.readBoolean();
        this.obeyHornHaltReady = data.readBoolean();
        this.obeyHornSummon = data.readBoolean();
        this.teleportAutomatically = data.readBoolean();
        this.mobKills = data.readInt();
        this.alignmentRequiredToCommand = data.readInt();
        this.inCombat = data.readBoolean();
        this.guardMode = data.readBoolean();
        this.guardRange = data.readInt();
        this.setTask(Task.forID(data.readByte()));
    }

    public static enum Task {
        WARRIOR,
        FARMER;


        public static Task forID(int id) {
            for (Task task : Task.values()) {
                if (task.ordinal() != id) continue;
                return task;
            }
            return WARRIOR;
        }
    }
}

