/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lotr.common.LOTRMod;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class LOTRSpeech {
    private static Map allSpeechBanks = new HashMap();
    private static Random rand = new Random();

    public static void loadAllSpeechBanks() {
        HashMap<String, BufferedReader> speechBankNamesAndReaders = new HashMap<String, BufferedReader>();
        ZipFile zip = null;
        try {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)LOTRMod.instance);
            if (mc.getSource().isFile()) {
                zip = new ZipFile(mc.getSource());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    ZipEntry entry = entries.nextElement();
                    String s = entry.getName();
                    if (!s.startsWith(path = "assets/lotr/speech/") || !s.endsWith(".txt")) continue;
                    s = s.substring(path.length());
                    int i = s.indexOf(".txt");
                    try {
                        s = s.substring(0, i);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), "utf-8"));
                        speechBankNamesAndReaders.put(s, reader);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load LOTR speech bank " + s + "from zip file");
                        e.printStackTrace();
                    }
                }
            } else {
                File speechBankDir = new File(LOTRMod.class.getResource("/assets/lotr/speech").toURI());
                for (File file : speechBankDir.listFiles()) {
                    String s = file.getName();
                    int i = s.indexOf(".txt");
                    if (i < 0) {
                        System.out.println("Failed to load LOTR speech bank " + s + " from MCP folder; speech bank files must be in .txt format");
                        continue;
                    }
                    try {
                        s = s.substring(0, i);
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                        speechBankNamesAndReaders.put(s, reader);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to load LOTR speech bank " + s + " from MCP folder");
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to load LOTR speech banks");
            e.printStackTrace();
        }
        for (String speechBankName : speechBankNamesAndReaders.keySet()) {
            BufferedReader reader = (BufferedReader)speechBankNamesAndReaders.get(speechBankName);
            try {
                String line;
                ArrayList<String> list = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    list.add(line);
                }
                reader.close();
                if (list.isEmpty()) {
                    System.out.println("LOTR speech bank " + speechBankName + " is empty!");
                    continue;
                }
                String[] speechBank = new String[list.size()];
                for (int j = 0; j < list.size(); ++j) {
                    speechBank[j] = (String)list.get(j);
                }
                allSpeechBanks.put(speechBankName, speechBank);
                System.out.println("Succesfully loaded LOTR speech bank " + speechBankName);
            }
            catch (Exception e) {
                System.out.println("Failed to load LOTR speech bank " + speechBankName);
                e.printStackTrace();
            }
        }
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getSpeechBank(String speechBankName) {
        if (allSpeechBanks.get(speechBankName) != null && allSpeechBanks.get(speechBankName) instanceof String[]) {
            return (String[])allSpeechBanks.get(speechBankName);
        }
        return new String[]{"Speech bank " + speechBankName + " could not be found"};
    }

    public static String getRandomSpeech(String speechBankName) {
        String[] speechBank = LOTRSpeech.getSpeechBank(speechBankName);
        return speechBank[rand.nextInt(speechBank.length)];
    }

    public static IChatComponent getNamedSpeech(EntityLivingBase entity, String speechBankName) {
        String s = EnumChatFormatting.YELLOW + "<" + entity.func_70005_c_() + ">" + EnumChatFormatting.WHITE + " " + LOTRSpeech.getRandomSpeech(speechBankName);
        return new ChatComponentText(s);
    }

    public static IChatComponent getNamedSpeechForPlayer(EntityLivingBase entity, String speechBankName, EntityPlayer entityplayer) {
        String s = EnumChatFormatting.YELLOW + "<" + entity.func_70005_c_() + ">" + EnumChatFormatting.WHITE + " " + LOTRSpeech.getRandomSpeech(speechBankName);
        s = s.replace("#", entityplayer.func_70005_c_());
        return new ChatComponentText(s);
    }

    public static IChatComponent getNamedLocationSpeechForPlayer(EntityLivingBase entity, String locationName, String speechBankName, EntityPlayer entityplayer) {
        String s = EnumChatFormatting.YELLOW + "<" + entity.func_70005_c_() + ">" + EnumChatFormatting.WHITE + " " + LOTRSpeech.getRandomSpeech(speechBankName);
        s = s.replace("#", entityplayer.func_70005_c_()).replace("@", locationName);
        return new ChatComponentText(s);
    }

    public static void messageAllPlayers(IChatComponent message) {
        if (MinecraftServer.func_71276_C() == null) {
            return;
        }
        for (Object player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            ((EntityPlayer)player).func_145747_a(message);
        }
    }
}

