/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTradeEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S3FPacketCustomPayload;

public class LOTRTraderNPCInfo {
    private LOTREntityNPC theEntity;
    private LOTRTradeEntry[] buyTrades;
    private LOTRTradeEntry[] sellTrades;

    public LOTRTraderNPCInfo(LOTREntityNPC npc) {
        this.theEntity = npc;
    }

    public LOTRTradeEntry[] getBuyTrades() {
        return this.buyTrades;
    }

    public LOTRTradeEntry[] getSellTrades() {
        return this.sellTrades;
    }

    public void setBuyTrades(LOTRTradeEntry[] trades) {
        this.buyTrades = trades;
    }

    public void setSellTrades(LOTRTradeEntry[] trades) {
        this.sellTrades = trades;
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagCompound nbt;
        if (this.buyTrades != null) {
            NBTTagList buyTradesTrags = new NBTTagList();
            for (LOTRTradeEntry trade : this.buyTrades) {
                nbt = new NBTTagCompound();
                trade.item.func_77955_b(nbt);
                nbt.func_74768_a("Cost", trade.cost);
                buyTradesTrags.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound buyTradesData = new NBTTagCompound();
            buyTradesData.func_74782_a("Trades", (NBTBase)buyTradesTrags);
            data.func_74782_a("LOTRBuyTrades", (NBTBase)buyTradesData);
        }
        if (this.sellTrades != null) {
            NBTTagList sellTradesTrags = new NBTTagList();
            for (LOTRTradeEntry trade : this.sellTrades) {
                nbt = new NBTTagCompound();
                trade.item.func_77955_b(nbt);
                nbt.func_74768_a("Cost", trade.cost);
                sellTradesTrags.func_74742_a((NBTBase)nbt);
            }
            NBTTagCompound sellTradesData = new NBTTagCompound();
            sellTradesData.func_74782_a("Trades", (NBTBase)sellTradesTrags);
            data.func_74782_a("LOTRSellTrades", (NBTBase)sellTradesData);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTTagCompound sellTradesData;
        int tradeCost;
        ItemStack tradeItem;
        NBTTagCompound nbt;
        int i;
        NBTTagCompound buyTradesData;
        if (data.func_74764_b("LOTRBuyTrades") && (buyTradesData = data.func_74775_l("LOTRBuyTrades")).func_74764_b("Trades")) {
            NBTTagList buyTradesTrags = buyTradesData.func_150295_c("Trades", (int)new NBTTagCompound().func_74732_a());
            this.buyTrades = new LOTRTradeEntry[buyTradesTrags.func_74745_c()];
            for (i = 0; i < buyTradesTrags.func_74745_c(); ++i) {
                nbt = buyTradesTrags.func_150305_b(i);
                tradeItem = ItemStack.func_77949_a((NBTTagCompound)nbt);
                tradeCost = nbt.func_74762_e("Cost");
                this.buyTrades[i] = new LOTRTradeEntry(tradeItem, tradeCost);
            }
        }
        if (data.func_74764_b("LOTRSellTrades") && (sellTradesData = data.func_74775_l("LOTRSellTrades")).func_74764_b("Trades")) {
            NBTTagList sellTradesTrags = sellTradesData.func_150295_c("Trades", (int)new NBTTagCompound().func_74732_a());
            this.sellTrades = new LOTRTradeEntry[sellTradesTrags.func_74745_c()];
            for (i = 0; i < sellTradesTrags.func_74745_c(); ++i) {
                nbt = sellTradesTrags.func_150305_b(i);
                tradeItem = ItemStack.func_77949_a((NBTTagCompound)nbt);
                tradeCost = nbt.func_74762_e("Cost");
                this.sellTrades[i] = new LOTRTradeEntry(tradeItem, tradeCost);
            }
        }
    }

    public void sendClientPacket(EntityPlayer entityplayer) {
        try {
            ByteBuf data = Unpooled.buffer();
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            LOTRTraderNPCInfo.writeNBTTagCompound(nbt, data);
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("lotr.trades", data);
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receiveClientPacket(S3FPacketCustomPayload packet) {
        try {
            ByteBuf data = Unpooled.wrappedBuffer((byte[])packet.func_149168_d());
            NBTTagCompound nbt = LOTRTraderNPCInfo.readNBTTagCompound(data);
            this.readFromNBT(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static NBTTagCompound readNBTTagCompound(ByteBuf data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        return CompressedStreamTools.func_74792_a((byte[])bytes);
    }

    private static void writeNBTTagCompound(NBTTagCompound nbt, ByteBuf data) throws IOException {
        if (nbt == null) {
            data.writeInt(-1);
        } else {
            byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            data.writeShort((int)((short)bytes.length));
            data.writeBytes(bytes);
        }
    }
}

