/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRCommonProxy;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.inventory.LOTRInventoryPouch;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class LOTRItemPouch
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] pouchIcons;
    private String[] pouchTypes = new String[]{"small", "medium", "large"};

    public LOTRItemPouch() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(LOTRCreativeTabs.tabMisc);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LOTRMod.instance, LOTRCommonProxy.GUI_ID_POUCH, world, 0, 0, 0);
        return itemstack;
    }

    public static int getCapacity(ItemStack itemstack) {
        return (itemstack.func_77960_j() + 1) * 9;
    }

    public static int getRandomPouchSize(Random random) {
        float f = random.nextFloat();
        if (f < 0.6f) {
            return 0;
        }
        if (f < 0.9f) {
            return 1;
        }
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int i) {
        if (i >= this.pouchIcons.length) {
            i = 0;
        }
        return this.pouchIcons[i];
    }

    public String func_77667_c(ItemStack itemstack) {
        return super.func_77658_a() + "." + itemstack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.pouchIcons = new IIcon[this.pouchTypes.length];
        for (int i = 0; i < this.pouchTypes.length; ++i) {
            this.pouchIcons[i] = iconregister.func_94245_a(this.func_111208_A() + "_" + this.pouchTypes[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j <= 2; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        int slotsFull = 0;
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("LOTRPouchData")) {
            NBTTagCompound nbt = itemstack.func_77978_p().func_74775_l("LOTRPouchData");
            NBTTagList items = nbt.func_150295_c("Items", (int)new NBTTagCompound().func_74732_a());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                ++slotsFull;
            }
        }
        int slots = LOTRItemPouch.getCapacity(itemstack);
        list.add(slotsFull + "/" + slots + " slots in use");
    }

    public static void tryAddItemToPouch(ItemStack pouch, ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a > 0) {
            LOTRInventoryPouch tempInventory = new LOTRInventoryPouch(pouch);
            for (int i = 0; i < tempInventory.func_70302_i_() && itemstack.field_77994_a > 0; ++i) {
                int difference;
                ItemStack itemInSlot = tempInventory.func_70301_a(i);
                if (itemInSlot == null || itemInSlot.func_77973_b() != itemstack.func_77973_b() || !itemInSlot.func_77985_e() || itemInSlot.func_77981_g() && itemInSlot.func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemInSlot, (ItemStack)itemstack)) continue;
                int maxStackSize = itemInSlot.func_77976_d();
                if (tempInventory.func_70297_j_() < maxStackSize) {
                    maxStackSize = tempInventory.func_70297_j_();
                }
                if ((difference = maxStackSize - itemInSlot.field_77994_a) > itemstack.field_77994_a) {
                    difference = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= difference;
                itemInSlot.field_77994_a += difference;
                tempInventory.func_70299_a(i, itemInSlot);
            }
        }
    }
}

