/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRTileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    private String mobID = "";
    public double yaw;
    public double prevYaw = 0.0;
    private Entity spawnedMob;
    public int active = 1;
    public boolean spawnsPersistentNPCs = false;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int nearbyMobLimit = 6;
    public int nearbyMobCheckRange = 8;
    public int requiredPlayerRange = 16;
    public int maxSpawnCount = 4;
    public int maxSpawnRange = 4;
    public int maxSpawnRangeVertical = 1;
    public int maxHealth = 20;
    public int navigatorRange = 16;
    public float moveSpeed = 0.2f;
    public int attackDamage = 2;
    private NBTTagCompound customSpawnData;

    public String getMobID() {
        return this.mobID;
    }

    public void setMobID(int i) {
        this.setMobID(LOTREntities.getStringFromID(i));
    }

    public void setMobID(String s) {
        Entity entity;
        this.mobID = s;
        if (!this.field_145850_b.field_72995_K && (entity = EntityList.func_75620_a((String)LOTREntities.getFullEntityName(this.getMobID()), (World)this.field_145850_b)) != null && entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.maxHealth = (int)entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            }
            if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b) != null) {
                this.navigatorRange = (int)entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111125_b();
            }
            if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.moveSpeed = (float)entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            }
            if (entityliving.func_110140_aT().func_111151_a(LOTREntityNPC.npcAttackDamage) != null) {
                this.attackDamage = (int)entityliving.func_110140_aT().func_111151_a(LOTREntityNPC.npcAttackDamage).func_111125_b();
            }
        }
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)this.requiredPlayerRange) != null;
    }

    public boolean isActive() {
        if (this.active == 1) {
            return true;
        }
        if (this.active == 2) {
            return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return false;
    }

    public void func_145845_h() {
        if (this.anyPlayerInRange() && this.isActive()) {
            if (this.field_145850_b.field_72995_K) {
                double d = (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat();
                double d1 = (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat();
                double d2 = (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_72869_a("smoke", d, d1, d2, 0.0, 0.0, 0.0);
                this.field_145850_b.func_72869_a("flame", d, d1, d2, 0.0, 0.0, 0.0);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.prevYaw = this.yaw;
                this.yaw = (this.yaw + (double)(1000.0f / ((float)this.delay + 200.0f))) % 360.0;
            } else {
                if (this.delay == -1) {
                    this.updateDelay();
                }
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                boolean needsDelayUpdate = false;
                for (int i = 0; i < this.maxSpawnCount; ++i) {
                    Entity entity = EntityList.func_75620_a((String)LOTREntities.getFullEntityName(this.getMobID()), (World)this.field_145850_b);
                    if (entity == null) {
                        return;
                    }
                    List nearbyEntitiesList = this.field_145850_b.func_72872_a(entity.getClass(), AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b((double)this.nearbyMobCheckRange, (double)this.nearbyMobCheckRange, (double)this.nearbyMobCheckRange));
                    ArrayList<Entity> nearbySameEntitiesList = new ArrayList<Entity>();
                    for (int l = 0; l < nearbyEntitiesList.size(); ++l) {
                        Entity nearbyEntity = (Entity)nearbyEntitiesList.get(l);
                        if (nearbyEntity.getClass() != entity.getClass()) continue;
                        nearbySameEntitiesList.add(nearbyEntity);
                    }
                    int nearbyEntities = nearbySameEntitiesList.size();
                    if (nearbyEntities >= this.nearbyMobLimit) {
                        this.updateDelay();
                        return;
                    }
                    if (entity == null) continue;
                    double d = (double)this.field_145851_c + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.maxSpawnRange;
                    double d1 = (double)this.field_145848_d + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.maxSpawnRangeVertical;
                    double d2 = (double)this.field_145849_e + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.maxSpawnRange;
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b(d, d1, d2, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving instanceof LOTREntityNPC) {
                        ((LOTREntityNPC)entityliving).isNPCPersistent = this.spawnsPersistentNPCs;
                        ((LOTREntityNPC)entityliving).liftSpawnRestrictions = true;
                    }
                    if (entityliving != null && !entityliving.func_70601_bi()) continue;
                    if (entityliving instanceof LOTREntityNPC) {
                        ((LOTREntityNPC)entityliving).liftSpawnRestrictions = false;
                    }
                    this.writeNBTTagsTo(entity);
                    if (entity instanceof LOTREntityNPC) {
                        ((LOTREntityNPC)entity).onArtificalSpawn();
                    }
                    this.field_145850_b.func_72838_d(entity);
                    this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                    }
                    needsDelayUpdate = true;
                    if (++nearbyEntities >= this.nearbyMobLimit) break;
                }
                if (needsDelayUpdate) {
                    this.updateDelay();
                }
            }
            super.func_145845_h();
        }
    }

    public void writeNBTTagsTo(Entity entity) {
        if (entity instanceof EntityLiving && entity.field_70170_p != null) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (!this.field_145850_b.field_72995_K) {
                if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a) != null) {
                    entityliving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHealth);
                }
                if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b) != null) {
                    entityliving.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.navigatorRange);
                }
                if (entityliving.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d) != null) {
                    entityliving.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.moveSpeed);
                }
                if (entityliving.func_110140_aT().func_111151_a(LOTREntityNPC.npcAttackDamage) != null) {
                    entityliving.func_110148_a(LOTREntityNPC.npcAttackDamage).func_111128_a((double)this.attackDamage);
                }
            }
            entityliving.func_110161_a(null);
            if (this.customSpawnData != null) {
                entityliving.func_70020_e(this.customSpawnData);
            }
        }
    }

    private void updateDelay() {
        this.delay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.field_145850_b.field_73012_v.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("EntityID", 3)) {
            int id = nbt.func_74762_e("EntityID");
            this.mobID = LOTREntities.getStringFromID(id);
        } else {
            this.mobID = nbt.func_74779_i("EntityID");
        }
        this.delay = nbt.func_74765_d("Delay");
        if (nbt.func_74764_b("MinSpawnDelay")) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.maxSpawnCount = nbt.func_74765_d("MaxSpawnCount");
        }
        if (nbt.func_74764_b("NearbyMobLimit")) {
            this.nearbyMobLimit = nbt.func_74765_d("NearbyMobLimit");
            this.requiredPlayerRange = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_74764_b("MaxSpawnRange")) {
            this.maxSpawnRange = nbt.func_74765_d("MaxSpawnRange");
        }
        if (nbt.func_74764_b("MaxSpawnRangeVertical")) {
            this.maxSpawnRangeVertical = nbt.func_74765_d("MaxSpawnRangeVertical");
        }
        if (nbt.func_74764_b("SpawnsPersistentNPCs")) {
            this.spawnsPersistentNPCs = nbt.func_74767_n("SpawnsPersistentNPCs");
            this.active = nbt.func_74771_c("ActiveMode");
            this.nearbyMobCheckRange = nbt.func_74765_d("MobCheckRange");
        }
        if (nbt.func_74764_b("MaxHealth")) {
            this.maxHealth = nbt.func_74765_d("MaxHealth");
            this.navigatorRange = nbt.func_74765_d("NavigatorRange");
            this.moveSpeed = nbt.func_74760_g("MoveSpeed");
            this.attackDamage = nbt.func_74765_d("AttackDamage");
        }
        if (nbt.func_74764_b("CustomSpawnData")) {
            this.customSpawnData = nbt.func_74775_l("CustomSpawnData");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.spawnedMob = null;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("EntityID", this.getMobID());
        nbt.func_74777_a("Delay", (short)this.delay);
        nbt.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        nbt.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nbt.func_74777_a("MaxSpawnCount", (short)this.maxSpawnCount);
        nbt.func_74777_a("NearbyMobLimit", (short)this.nearbyMobLimit);
        nbt.func_74777_a("RequiredPlayerRange", (short)this.requiredPlayerRange);
        nbt.func_74777_a("MaxSpawnRange", (short)this.maxSpawnRange);
        nbt.func_74777_a("MaxSpawnRangeVertical", (short)this.maxSpawnRangeVertical);
        nbt.func_74757_a("SpawnsPersistentNPCs", this.spawnsPersistentNPCs);
        nbt.func_74774_a("ActiveMode", (byte)this.active);
        nbt.func_74777_a("MobCheckRange", (short)this.nearbyMobCheckRange);
        nbt.func_74777_a("MaxHealth", (short)this.maxHealth);
        nbt.func_74777_a("NavigatorRange", (short)this.navigatorRange);
        nbt.func_74776_a("MoveSpeed", this.moveSpeed);
        nbt.func_74777_a("AttackDamage", (short)this.attackDamage);
        if (this.customSpawnData != null) {
            nbt.func_74782_a("CustomSpawnData", (NBTBase)this.customSpawnData);
        }
    }

    public Entity getMobEntity(World world) {
        if (this.spawnedMob == null) {
            Entity entity = EntityList.func_75620_a((String)LOTREntities.getFullEntityName(this.getMobID()), (World)world);
            if (entity instanceof LOTREntityNPC) {
                ((LOTREntityNPC)entity).onArtificalSpawn();
            }
            this.writeNBTTagsTo(entity);
            this.spawnedMob = entity;
        }
        return this.spawnedMob;
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_145841_b(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, data);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound data = packet.func_148857_g();
        this.func_145839_a(data);
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1 && this.field_145850_b.field_72995_K) {
            this.delay = this.minSpawnDelay;
            return true;
        }
        if (i == 2 && this.field_145850_b.field_72995_K) {
            this.delay = -1;
            return true;
        }
        return false;
    }
}

