/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRSpawnerNPCs {
    private static int MAX_SPAWN_COUNT = 100;
    private static HashMap eligibleChunksForSpawning = new HashMap();

    public static ChunkPosition getRandomSpawningPointInChunk(World world, int i, int k) {
        Chunk chunk = world.func_72964_e(i, k);
        int i1 = i * 16 + world.field_73012_v.nextInt(16);
        int k1 = k * 16 + world.field_73012_v.nextInt(16);
        int j = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(i1, j, k1);
    }

    public static void performSpawning(World world) {
        int maxSpawnCountValue;
        eligibleChunksForSpawning.clear();
        for (int l = 0; l < world.field_73010_i.size(); ++l) {
            EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(l);
            int i = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int range = 8;
            for (int i1 = -range; i1 <= range; ++i1) {
                for (int k1 = -range; k1 <= range; ++k1) {
                    boolean onEdge = i1 == -range || i1 == range || k1 == -range || k1 == range;
                    ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i + i1, k + k1);
                    if (!onEdge) {
                        eligibleChunksForSpawning.put(chunkcoordintpair, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(chunkcoordintpair)) continue;
                    eligibleChunksForSpawning.put(chunkcoordintpair, true);
                }
            }
        }
        ChunkCoordinates spawnPointCoords = world.func_72861_E();
        int totalSpawnCountValue = LOTRSpawnerNPCs.countNPCs(world);
        if (totalSpawnCountValue <= (maxSpawnCountValue = MAX_SPAWN_COUNT * eligibleChunksForSpawning.size() / 256)) {
            ArrayList tmp = new ArrayList(eligibleChunksForSpawning.keySet());
            Collections.shuffle(tmp);
            block5: for (ChunkCoordIntPair chunkcoordintpair : tmp) {
                if (((Boolean)eligibleChunksForSpawning.get(chunkcoordintpair)).booleanValue()) continue;
                ChunkPosition chunkposition = LOTRSpawnerNPCs.getRandomSpawningPointInChunk(world, chunkcoordintpair.field_77276_a, chunkcoordintpair.field_77275_b);
                int i = chunkposition.field_151329_a;
                int j = chunkposition.field_151327_b;
                int k = chunkposition.field_151328_c;
                if (world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j, k).func_149688_o() != Material.field_151579_a) continue;
                int entitiesSpawnedInChunk = 0;
                block6: for (int groupsSpawnedInChunk = 0; groupsSpawnedInChunk < 3; ++groupsSpawnedInChunk) {
                    int i1 = i;
                    int j1 = j;
                    int k1 = k;
                    int range = 6;
                    BiomeGenBase.SpawnListEntry spawnlistentry = null;
                    IEntityLivingData IEntityLivingData2 = null;
                    for (int groupSpawnAttempts = 0; groupSpawnAttempts < 4; ++groupSpawnAttempts) {
                        EntityLiving entityliving;
                        float f5;
                        float f4;
                        float f3;
                        float distSq;
                        float f2;
                        float f1;
                        float f;
                        if (!LOTRSpawnerNPCs.canEntityGroupSpawnAtLocation(world, i1 += world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range), j1 += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), k1 += world.field_73012_v.nextInt(range) - world.field_73012_v.nextInt(range)) || world.func_72977_a((double)(f = (float)i1 + 0.5f), (double)(f1 = (float)j1), (double)(f2 = (float)k1 + 0.5f), 24.0) != null || !((distSq = (f3 = f - (float)spawnPointCoords.field_71574_a) * f3 + (f4 = f1 - (float)spawnPointCoords.field_71572_b) * f4 + (f5 = f2 - (float)spawnPointCoords.field_71573_c) * f5) >= 576.0f)) continue;
                        if (spawnlistentry == null && (spawnlistentry = LOTRSpawnerNPCs.getRandomSpawnListEntry(world, i1, j1, k1)) == null) continue block6;
                        try {
                            entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                        entityliving.func_70012_b((double)f, (double)f1, (double)f2, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)world, (float)f, (float)f1, (float)f2);
                        if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entityliving.func_70601_bi())) continue;
                        ++entitiesSpawnedInChunk;
                        world.func_72838_d((Entity)entityliving);
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)world, (float)f, (float)f1, (float)f2)) {
                            IEntityLivingData2 = entityliving.func_110161_a(IEntityLivingData2);
                        }
                        if (entitiesSpawnedInChunk >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block5;
                    }
                }
            }
        }
    }

    private static int countNPCs(World world) {
        int count = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof LOTREntityNPC)) continue;
            int spawnCountValue = ((LOTREntityNPC)entity).getSpawnCountValue();
            count += spawnCountValue;
        }
        return count;
    }

    private static boolean canEntityGroupSpawnAtLocation(World world, int i, int j, int k) {
        if (!World.func_147466_a((IBlockAccess)world, (int)i, (int)(j - 1), (int)k)) {
            return false;
        }
        Block l = world.func_147439_a(i, j - 1, k);
        int l1 = world.func_72805_g(i, j - 1, k);
        boolean spawnBlock = l.canCreatureSpawn(EnumCreatureType.monster, (IBlockAccess)world, i, j - 1, k);
        return spawnBlock && l != Blocks.field_150357_h && !world.func_147439_a(i, j, k).func_149721_r() && !world.func_147439_a(i, j, k).func_149688_o().func_76224_d() && !world.func_147439_a(i, j + 1, k).func_149721_r();
    }

    private static BiomeGenBase.SpawnListEntry getRandomSpawnListEntry(World world, int i, int j, int k) {
        List list;
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (biome instanceof LOTRBiome && !(list = ((LOTRBiome)biome).getNPCSpawnList()).isEmpty()) {
            return (BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)list);
        }
        return null;
    }
}

