/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityBird;
import lotr.common.entity.npc.LOTREntityEnt;
import lotr.common.entity.npc.LOTREntityHuorn;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBigTrees;
import lotr.common.world.feature.LOTRWorldGenEntJars;
import lotr.common.world.feature.LOTRWorldGenFangornTrees;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class LOTRBiomeGenFangorn
extends LOTRBiome {
    private boolean isBirchFangorn = false;

    public LOTRBiomeGenFangorn(int i) {
        super(i);
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBird.class, 10, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityEnt.class, 10, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityHuorn.class, 20, 4, 4));
        this.spawnableEvilList.clear();
        this.setGoodEvilWeight(100, 0);
        this.hasPodzol = true;
        this.decorator.treesPerChunk = 12;
        this.decorator.flowersPerChunk = 4;
        this.decorator.doubleFlowersPerChunk = 1;
        this.decorator.grassPerChunk = 6;
        this.decorator.doubleGrassPerChunk = 6;
        this.decorator.enableFern = true;
        this.registerForestFlowers();
        this.canElvenTraderVisit = true;
    }

    public LOTRBiomeGenFangorn setBirchFangorn() {
        this.isBirchFangorn = true;
        return this;
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterFangorn;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.FANGORN;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(20) == 0) {
            int i1 = i + random.nextInt(16) + 8;
            int k1 = k + random.nextInt(16) + 8;
            int j1 = world.func_72976_f(i1, k1);
            new LOTRWorldGenEntJars().func_76484_a(world, random, i1, j1, k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(10) == 0) {
            if (this.isBirchFangorn) {
                return LOTRWorldGenFangornTrees.newBirch(false);
            }
            return random.nextInt(6) == 0 ? LOTRWorldGenFangornTrees.newBeech(false) : LOTRWorldGenFangornTrees.newOak(false);
        }
        if (this.isBirchFangorn && random.nextInt(4) != 0 || random.nextInt(15) == 0) {
            return new WorldGenForest(false, false);
        }
        if (random.nextInt(15) == 0) {
            return LOTRWorldGenBigTrees.newBeech(false);
        }
        if (random.nextInt(4) == 0) {
            return new WorldGenBigTree(false);
        }
        return random.nextInt(4) == 0 ? new WorldGenTrees(false) : new WorldGenTrees(false, 10 + random.nextInt(4), 0, 0, false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.1f;
    }
}

