/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityGondorArcher;
import lotr.common.entity.npc.LOTREntityGondorSoldier;
import lotr.common.entity.npc.LOTREntityMordorOrc;
import lotr.common.entity.npc.LOTREntityMordorOrcArcher;
import lotr.common.entity.npc.LOTREntityMordorOrcBombardier;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenSimpleTrees;
import lotr.common.world.structure.LOTRWorldGenGondorFortress;
import lotr.common.world.structure.LOTRWorldGenGondorObelisk;
import lotr.common.world.structure.LOTRWorldGenGondorRuin;
import lotr.common.world.structure.LOTRWorldGenGondorRuins;
import lotr.common.world.structure.LOTRWorldGenGondorSmithy;
import lotr.common.world.structure.LOTRWorldGenRuinedGondorTower;
import lotr.common.world.structure2.LOTRWorldGenGondorTurret;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenGondor
extends LOTRBiome {
    private WorldGenerator gondorRockVein = new WorldGenMinable(LOTRMod.rock, 1, 60, Blocks.field_150348_b);

    public LOTRBiomeGenGondor(int i) {
        super(i);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityHorse.class, 5, 2, 6));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityGondorSoldier.class, 20, 4, 6));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityGondorArcher.class, 10, 4, 6));
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrc.class, 20, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcArcher.class, 7, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcBombardier.class, 3, 1, 2));
        this.setGoodEvilWeight(70, 30);
        this.decorator.flowersPerChunk = 1;
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 1;
        this.decorator.generateAthelas = true;
        this.registerPlainsFlowers();
        this.decorator.addRandomStructure(new LOTRWorldGenGondorFortress(false), 800);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorSmithy(false), 800);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorRuins(), 600);
        this.decorator.addRandomStructure(new LOTRWorldGenRuinedGondorTower(false), 1000);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorObelisk(false), 1000);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorRuin(false), 1000);
        this.decorator.addRandomStructure(new LOTRWorldGenGondorTurret(false), 1000);
        this.canElvenTraderVisit = true;
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterGondor;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.GONDOR;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 2, this.gondorRockVein, 0, 64);
        super.func_76728_a(world, random, i, k);
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(300) == 0) {
            return random.nextBoolean() ? LOTRWorldGenSimpleTrees.newApple(false) : LOTRWorldGenSimpleTrees.newPear(false);
        }
        return super.func_150567_a(random);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.1f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 0.05f;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.02f;
    }
}

