/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityWildBoar;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityDwarfAxeThrower;
import lotr.common.entity.npc.LOTREntityDwarfMiner;
import lotr.common.entity.npc.LOTREntityDwarfWarrior;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRWorldGenDwarfHouse;
import lotr.common.world.structure.LOTRWorldGenDwarvenTower;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenIronHills
extends LOTRBiome {
    private WorldGenerator additionalIronGen = new WorldGenMinable(Blocks.field_150366_p, 4);
    private WorldGenerator additionalGoldGen = new WorldGenMinable(Blocks.field_150352_o, 4);
    private WorldGenerator additionalSilverGen = new WorldGenMinable(LOTRMod.oreSilver, 4);

    public LOTRBiomeGenIronHills(int i) {
        super(i);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(LOTREntityWildBoar.class, 50, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDwarf.class, 100, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDwarfMiner.class, 15, 1, 3));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDwarfWarrior.class, 20, 4, 4));
        this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDwarfAxeThrower.class, 10, 4, 4));
        this.setGoodEvilWeight(60, 40);
        this.decorator.treesPerChunk = 0;
        this.decorator.flowersPerChunk = 1;
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 1;
        this.decorator.generateWater = false;
        this.decorator.generateLava = false;
        this.decorator.generateCobwebs = false;
        this.registerMountainsFlowers();
        this.addFlower(LOTRMod.dwarfHerb, 0, 1);
        this.decorator.addRandomStructure(new LOTRWorldGenDwarvenTower(false), 300);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterIronHills;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.IRON_HILLS;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        int i1;
        int l;
        this.genStandardOre(world, random, i, k, 10, this.additionalIronGen, 0, 96);
        this.genStandardOre(world, random, i, k, 1, this.additionalGoldGen, 0, 48);
        this.genStandardOre(world, random, i, k, 1, this.additionalSilverGen, 0, 48);
        super.func_76728_a(world, random, i, k);
        for (l = 0; l < 4; ++l) {
            i1 = i + random.nextInt(16) + 8;
            int j1 = 70 + random.nextInt(60);
            int k1 = k + random.nextInt(16) + 8;
            new LOTRWorldGenDwarfHouse(false).func_76484_a(world, random, i1, j1, k1);
        }
        for (l = 0; l < 8; ++l) {
            int k1;
            i1 = i + random.nextInt(16) + 8;
            int j1 = world.func_72976_f(i1, k1 = k + random.nextInt(16) + 8);
            if (j1 <= 80) continue;
            this.func_150567_a(random).func_76484_a(world, random, i1, j1, k1);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            if (random.nextInt(8) == 0) {
                return new WorldGenMegaPineTree(false, true);
            }
            return new WorldGenMegaPineTree(false, false);
        }
        return new WorldGenTaiga2(false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.1f;
    }
}

