/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.animal.LOTREntityBird;
import lotr.common.entity.animal.LOTREntityButterfly;
import lotr.common.entity.npc.LOTREntityMirkwoodSpider;
import lotr.common.entity.npc.LOTREntityWoodElf;
import lotr.common.entity.npc.LOTREntityWoodElfScout;
import lotr.common.entity.npc.LOTREntityWoodElfWarrior;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenMirkOak;
import lotr.common.world.feature.LOTRWorldGenWebOfUngoliant;
import lotr.common.world.structure.LOTRWorldGenRuinedWoodElfTower;
import lotr.common.world.structure.LOTRWorldGenWoodElfHouse;
import lotr.common.world.structure.LOTRWorldGenWoodElfTower;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRBiomeGenMirkwood
extends LOTRBiome {
    public final boolean corrupted;

    public LOTRBiomeGenMirkwood(int i, boolean flag) {
        super(i);
        this.corrupted = flag;
        this.spawnableEvilList.clear();
        this.registerForestFlowers();
        if (this.corrupted) {
            this.field_76762_K.clear();
            this.field_76755_L.clear();
            this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMirkwoodSpider.class, 10, 4, 4));
            this.hasPodzol = true;
            this.decorator.treesPerChunk = 8;
            this.decorator.vinesPerChunk = 20;
            this.decorator.flowersPerChunk = 0;
            this.decorator.grassPerChunk = 6;
            this.decorator.doubleGrassPerChunk = 6;
            this.decorator.enableFern = true;
            this.decorator.mushroomsPerChunk = 4;
            this.decorator.generateCobwebs = false;
            this.decorator.addRandomStructure(new LOTRWorldGenRuinedWoodElfTower(false), 500);
            this.field_76759_H = 2630468;
        } else {
            this.field_82914_M.clear();
            this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityWoodElf.class, 10, 4, 4));
            this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityWoodElfScout.class, 2, 4, 4));
            this.spawnableGoodList.add(new BiomeGenBase.SpawnListEntry(LOTREntityWoodElfWarrior.class, 1, 4, 4));
            this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityBird.class, 10, 4, 4));
            this.setGoodEvilWeight(100, 0);
            this.decorator.treesPerChunk = 2;
            this.decorator.flowersPerChunk = 3;
            this.decorator.doubleFlowersPerChunk = 1;
            this.decorator.grassPerChunk = 4;
            this.decorator.enableFern = true;
            this.decorator.generateLava = false;
            this.decorator.generateCobwebs = false;
            this.decorator.addRandomStructure(new LOTRWorldGenWoodElfHouse(false), 6);
            this.decorator.addRandomStructure(new LOTRWorldGenWoodElfTower(false), 100);
        }
        this.spawnableLOTRAmbientList.add(new BiomeGenBase.SpawnListEntry(LOTREntityButterfly.class, 10, 4, 4));
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        if (this.corrupted) {
            return LOTRAchievement.enterMirkwoodCorrupted;
        }
        return LOTRAchievement.enterMirkwood;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        if (this.corrupted) {
            return LOTRWaypoint.Region.MIRKWOOD_CORRUPTED;
        }
        return LOTRWaypoint.Region.MIRKWOOD;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (this.corrupted) {
            int i1;
            int l;
            for (l = 0; l < this.decorator.treesPerChunk / 2; ++l) {
                i1 = i + random.nextInt(16) + 8;
                int k1 = k + random.nextInt(16) + 8;
                int j1 = world.func_72825_h(i1, k1);
                new LOTRWorldGenMirkOak(false, 8, 4, 0, 3).func_76484_a(world, random, i1, j1, k1);
            }
            for (l = 0; l < 6; ++l) {
                i1 = i + random.nextInt(16) + 8;
                int j1 = random.nextInt(128);
                int k1 = k + random.nextInt(16) + 8;
                new LOTRWorldGenWebOfUngoliant(false, 64).func_76484_a(world, random, i1, j1, k1);
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (this.corrupted) {
            return new LOTRWorldGenMirkOak(false, 16, 4, 1, 7).disableDecay().setHasVines();
        }
        if (random.nextInt(3) == 0) {
            return super.func_150567_a(random);
        }
        if (random.nextInt(5) == 0) {
            return new LOTRWorldGenMirkOak(false, 20, 30, 2, 12);
        }
        if (random.nextInt(30) == 0) {
            return new LOTRWorldGenMirkOak(false, 12, 6, 1, 6).setRed().disableDecay();
        }
        return new LOTRWorldGenMirkOak(false, 6, 5, 0, 2);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.5f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return this.corrupted ? super.getChanceToSpawnLavaLakes() : 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int i, int j, int k) {
        if (this.corrupted) {
            return 0x2B5B25;
        }
        return super.func_150558_b(i, j, k);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150571_c(int i, int j, int k) {
        if (this.corrupted) {
            return 2503461;
        }
        return super.func_150571_c(i, j, k);
    }

    @Override
    public Vec3 getFogColor(Vec3 fog) {
        if (this.corrupted) {
            fog.field_72450_a *= 0.2;
            fog.field_72448_b *= 0.4;
            fog.field_72449_c *= 0.5;
            return fog;
        }
        return super.getFogColor(fog);
    }
}

