/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.npc.LOTREntityMordorOrc;
import lotr.common.entity.npc.LOTREntityMordorOrcArcher;
import lotr.common.entity.npc.LOTREntityMordorOrcBombardier;
import lotr.common.entity.npc.LOTREntityMordorWarg;
import lotr.common.entity.npc.LOTREntityOlogHai;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenCharredTrees;
import lotr.common.world.feature.LOTRWorldGenMordorMoss;
import lotr.common.world.structure.LOTRWorldGenMordorCamp;
import lotr.common.world.structure.LOTRWorldGenMordorTower;
import lotr.common.world.structure.LOTRWorldGenMordorWargPit;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenMordor
extends LOTRBiome {
    private WorldGenerator nauriteGen = new WorldGenMinable(LOTRMod.oreNaurite, 12, LOTRMod.rock);
    private WorldGenerator morgulIronGen = new WorldGenMinable(LOTRMod.oreMorgulIron, 1, 8, LOTRMod.rock);
    private WorldGenerator guldurilGen = new WorldGenMinable(LOTRMod.oreGulduril, 1, 8, LOTRMod.rock);
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(LOTRMod.rock, 0, 2, 8).setSpawnBlock(LOTRMod.rock, 0);

    public LOTRBiomeGenMordor(int i) {
        super(i);
        this.field_76752_A = LOTRMod.rock;
        this.field_76753_B = LOTRMod.rock;
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrc.class, 20, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcArcher.class, 7, 4, 6));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorOrcBombardier.class, 3, 1, 2));
        if (this.isGorgoroth()) {
            this.func_76745_m();
            this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityMordorWarg.class, 10, 1, 3));
            this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityOlogHai.class, 10, 1, 3));
        }
        this.decorator.flowersPerChunk = 0;
        this.decorator.grassPerChunk = 0;
        this.decorator.generateWater = false;
        this.decorator.addRandomStructure(new LOTRWorldGenMordorCamp(), 60);
        this.decorator.addRandomStructure(new LOTRWorldGenMordorWargPit(false), 300);
        this.decorator.addRandomStructure(new LOTRWorldGenMordorTower(false), 400);
        this.field_76759_H = 4136967;
    }

    @Override
    public boolean hasSky() {
        return !this.isGorgoroth();
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterMordor;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.MORDOR;
    }

    public boolean isGorgoroth() {
        return true;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 20, this.nauriteGen, 0, 64);
        this.genStandardOre(world, random, i, k, 20, this.morgulIronGen, 0, 64);
        this.genStandardOre(world, random, i, k, 8, this.guldurilGen, 0, 32);
        super.func_76728_a(world, random, i, k);
        if (this.isGorgoroth()) {
            int k1;
            int j1;
            int i1;
            int k12;
            int l;
            if (random.nextInt(24) == 0) {
                for (l = 0; l < 6; ++l) {
                    int i12 = i + random.nextInt(16) + 8;
                    k12 = k + random.nextInt(16) + 8;
                    this.boulderGen.func_76484_a(world, random, i12, world.func_72976_f(i12, k12), k12);
                }
            }
            if (random.nextInt(60) == 0) {
                for (l = 0; l < 8; ++l) {
                    WorldGenAbstractTree trees = this.func_150567_a(random);
                    int i13 = i + random.nextInt(16) + 8;
                    int k13 = k + random.nextInt(16) + 8;
                    trees.func_76484_a(world, random, i13, world.func_72976_f(i13, k13), k13);
                }
            }
            if (random.nextInt(20) == 0) {
                for (l = 0; l < 6; ++l) {
                    int j12;
                    int i14 = i + random.nextInt(6) + 8;
                    if (world.func_147439_a(i14, (j12 = world.func_72976_f(i14, k12 = k + random.nextInt(6) + 8)) - 1, k12) != LOTRMod.rock || world.func_72805_g(i14, j12 - 1, k12) != 0 || !world.func_147437_c(i14, j12, k12)) continue;
                    world.func_147465_d(i14, j12, k12, LOTRMod.mordorThorn, 0, 2);
                }
            }
            if (random.nextInt(30) == 0 && world.func_147439_a(i1 = i + random.nextInt(16) + 8, (j1 = world.func_72976_f(i1, k1 = k + random.nextInt(16) + 8)) - 1, k1) == LOTRMod.rock && world.func_72805_g(i1, j1 - 1, k1) == 0 && world.func_147437_c(i1, j1, k1)) {
                new LOTRWorldGenMordorMoss().func_76484_a(world, random, i1, j1, k1);
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        return new LOTRWorldGenCharredTrees();
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.0f;
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.0f;
    }

    @Override
    public boolean canSpawnHostilesInDay() {
        return true;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.0f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int i, int j, int k) {
        return 5980459;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150571_c(int i, int j, int k) {
        return 6508333;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float f) {
        return 6303519;
    }

    @Override
    public Vec3 getCloudColor(Vec3 clouds) {
        if (this.isGorgoroth()) {
            clouds.field_72450_a *= 0.3;
            clouds.field_72448_b *= 0.15;
            clouds.field_72449_c *= 0.1;
            return clouds;
        }
        return super.getCloudColor(clouds);
    }

    @Override
    public Vec3 getFogColor(Vec3 fog) {
        if (this.isGorgoroth()) {
            fog.field_72450_a *= 0.2;
            fog.field_72448_b *= 0.15;
            fog.field_72449_c *= 0.1;
            return fog;
        }
        return super.getFogColor(fog);
    }
}

