/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.npc.LOTREntityNearHaradrim;
import lotr.common.entity.npc.LOTREntityNearHaradrimWarrior;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenDesertTrees;
import lotr.common.world.feature.LOTRWorldGenDoubleFlower;
import lotr.common.world.structure.LOTRWorldGenHaradObelisk;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenNearHaradFertile
extends LOTRBiome {
    private WorldGenerator dirtPatchGen = new WorldGenMinable(Blocks.field_150346_d, 1, 50, (Block)Blocks.field_150349_c);
    private WorldGenerator sandPatchGen = new WorldGenMinable(Blocks.field_150354_m, 0, 50, (Block)Blocks.field_150349_c);
    private WorldGenerator redSandPatchGen = new WorldGenMinable(Blocks.field_150354_m, 1, 50, (Block)Blocks.field_150349_c);

    public LOTRBiomeGenNearHaradFertile(int i) {
        super(i);
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityNearHaradrim.class, 10, 4, 4));
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityNearHaradrimWarrior.class, 2, 4, 4));
        this.setGoodEvilWeight(0, 100);
        this.decorator.flowersPerChunk = 1;
        this.decorator.doubleFlowersPerChunk = 1;
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 2;
        this.registerPlainsFlowers();
        this.decorator.addRandomStructure(new LOTRWorldGenHaradObelisk(false), 3000);
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterNearHarad;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.NEAR_HARAD_FERTILE;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        this.genStandardOre(world, random, i, k, 2, this.dirtPatchGen, 60, 90);
        this.genStandardOre(world, random, i, k, 2, this.sandPatchGen, 60, 90);
        if (random.nextInt(10) == 0) {
            this.genStandardOre(world, random, i, k, 2, this.redSandPatchGen, 60, 90);
        }
        super.func_76728_a(world, random, i, k);
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        return new LOTRWorldGenDesertTrees();
    }

    @Override
    public WorldGenerator getRandomWorldGenForDoubleFlower(Random random) {
        LOTRWorldGenDoubleFlower doubleFlowerGen = new LOTRWorldGenDoubleFlower();
        if (random.nextInt(5) == 0) {
            doubleFlowerGen.setFlowerType(3);
        } else {
            doubleFlowerGen.setFlowerType(2);
        }
        return doubleFlowerGen;
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.2f;
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.25f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.1f;
    }

    @Override
    public int spawnCountMultiplier() {
        return 3;
    }
}

