/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRWaypoint;
import lotr.common.entity.npc.LOTREntityDarkHuorn;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class LOTRBiomeGenOldForest
extends LOTRBiome {
    public LOTRBiomeGenOldForest(int i) {
        super(i);
        this.spawnableEvilList.clear();
        this.spawnableEvilList.add(new BiomeGenBase.SpawnListEntry(LOTREntityDarkHuorn.class, 10, 4, 4));
        this.hasPodzol = true;
        this.decorator.treesPerChunk = 15;
        this.decorator.flowersPerChunk = 1;
        this.decorator.grassPerChunk = 6;
        this.decorator.doubleGrassPerChunk = 5;
        this.decorator.enableFern = true;
        this.decorator.mushroomsPerChunk = 2;
        this.registerForestFlowers();
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterOldForest;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.OLD_FOREST;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenCanopyTree(false);
        }
        if (random.nextInt(4) == 0) {
            return new WorldGenBigTree(false);
        }
        if (random.nextInt(3) == 0) {
            return new WorldGenTrees(false);
        }
        return new WorldGenTrees(false, 8 + random.nextInt(8), 0, 0, false);
    }

    @Override
    public float getChanceToSpawnAnimals() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150558_b(int i, int j, int k) {
        return 4686398;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_150571_c(int i, int j, int k) {
        return 3172394;
    }
}

