/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRWaypoint;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenBoulder;
import lotr.common.world.feature.LOTRWorldGenDeadTrees;
import lotr.common.world.feature.LOTRWorldGenDesertTrees;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenerator;

public class LOTRBiomeGenPertorogwaith
extends LOTRBiome {
    private WorldGenerator boulderGen = new LOTRWorldGenBoulder(Blocks.field_150348_b, 0, 1, 3);
    private WorldGenerator deadMoundGen = new LOTRWorldGenBoulder(Blocks.field_150425_aM, 0, 1, 3);

    public LOTRBiomeGenPertorogwaith(int i) {
        super(i);
        this.field_76762_K.clear();
        this.spawnableEvilList.clear();
        this.setGoodEvilWeight(0, 100);
        this.decorator.grassPerChunk = 4;
        this.decorator.doubleGrassPerChunk = 4;
        this.decorator.flowersPerChunk = 0;
    }

    @Override
    public LOTRAchievement getBiomeAchievement() {
        return LOTRAchievement.enterPertorogwaith;
    }

    @Override
    public LOTRWaypoint.Region getBiomeWaypoints() {
        return LOTRWaypoint.Region.PERTOROGWAITH;
    }

    @Override
    public void func_76728_a(World world, Random random, int i, int k) {
        super.func_76728_a(world, random, i, k);
        if (random.nextInt(4) == 0) {
            int boulders = 1 + random.nextInt(4);
            for (int l = 0; l < boulders; ++l) {
                int i1 = i + random.nextInt(16) + 8;
                int k1 = k + random.nextInt(16) + 8;
                this.boulderGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
            }
        }
        if (random.nextInt(40) == 0) {
            for (int l = 0; l < 3; ++l) {
                int i1 = i + random.nextInt(16) + 8;
                int k1 = k + random.nextInt(16) + 8;
                this.deadMoundGen.func_76484_a(world, random, i1, world.func_72976_f(i1, k1), k1);
                for (int l1 = 0; l1 < 4; ++l1) {
                    int k2;
                    int j2;
                    int i2 = i1 - 4 + random.nextInt(9);
                    if (!LOTRMod.isOpaque(world, i2, (j2 = world.func_72976_f(i2, k2 = k1 - 4 + random.nextInt(9))) - 1, k2) || !world.func_147437_c(i2, j2, k2) && world.func_147439_a(i2, j2, k2) != Blocks.field_150329_H) continue;
                    world.func_147465_d(i2, j2, k2, Blocks.field_150465_bP, 1, 2);
                    TileEntity tileentity = world.func_147438_o(i2, j2, k2);
                    if (tileentity == null || !(tileentity instanceof TileEntitySkull)) continue;
                    TileEntitySkull skull = (TileEntitySkull)tileentity;
                    skull.func_145903_a(random.nextInt(16));
                }
            }
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) > 0) {
            if (random.nextInt(3) > 0) {
                return LOTRWorldGenDeadTrees.newAcacia();
            }
            return LOTRWorldGenDeadTrees.newOak();
        }
        if (random.nextInt(3) > 0) {
            return new WorldGenSavannaTree(false);
        }
        return new LOTRWorldGenDesertTrees();
    }

    @Override
    public float getTreeIncreaseChance() {
        return 0.25f;
    }

    @Override
    public float getChanceToSpawnLakes() {
        return 0.2f;
    }

    @Override
    public float getChanceToSpawnLavaLakes() {
        return 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float f) {
        return 8551538;
    }
}

