/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.feature;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.structure.LOTRWorldGenWoodElfPlatform;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRWorldGenMirkOak
extends WorldGenAbstractTree {
    private int trunkHeight;
    private int randomTrunkIncrease;
    private int trunkWidth;
    private int canopyRadius;
    private boolean isRed;
    private boolean disableDecay;
    private boolean hasVines;
    private boolean restrictions = true;

    public LOTRWorldGenMirkOak(boolean flag, int i, int j, int k, int l) {
        super(flag);
        this.trunkHeight = i;
        this.randomTrunkIncrease = j;
        this.trunkWidth = k;
        this.canopyRadius = l;
    }

    public LOTRWorldGenMirkOak setRed() {
        this.isRed = true;
        return this;
    }

    public LOTRWorldGenMirkOak disableDecay() {
        this.disableDecay = true;
        return this;
    }

    public LOTRWorldGenMirkOak setHasVines() {
        this.hasVines = true;
        return this;
    }

    public LOTRWorldGenMirkOak disableRestrictions() {
        this.restrictions = false;
        return this;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int height = random.nextInt(this.randomTrunkIncrease) + this.trunkHeight;
        boolean flag = true;
        if (!this.restrictions || j >= 1 && j + height + 1 <= 256) {
            int k1;
            int i1;
            int j1;
            if (this.restrictions) {
                for (j1 = j; j1 <= j + 1 + height; ++j1) {
                    int range = this.trunkWidth + 1;
                    if (j1 == j) {
                        range = this.trunkWidth;
                    }
                    if (j1 >= j + 1 + height - 2) {
                        range = this.canopyRadius + 1;
                    }
                    for (int i12 = i - range; i12 <= i + range && flag; ++i12) {
                        for (int k12 = k - range; k12 <= k + range && flag; ++k12) {
                            if (j1 >= 0 && j1 < 256) {
                                Block block = world.func_147439_a(i12, j1, k12);
                                if (block == Blocks.field_150350_a || block.isLeaves((IBlockAccess)world, i12, j1, k12) || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150395_bd || block.isWood((IBlockAccess)world, i12, j1, k12)) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                for (i1 = i - this.trunkWidth; i1 <= i + this.trunkWidth && flag; ++i1) {
                    for (k1 = k - this.trunkWidth; k1 <= k + this.trunkWidth && flag; ++k1) {
                        Block block = world.func_147439_a(i1, j - 1, k1);
                        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d) continue;
                        flag = false;
                    }
                }
                if (!flag) {
                    return false;
                }
            }
            if (this.restrictions) {
                for (i1 = i - this.trunkWidth; i1 <= i + this.trunkWidth; ++i1) {
                    for (k1 = k - this.trunkWidth; k1 <= k + this.trunkWidth; ++k1) {
                        this.func_150516_a(world, i1, j - 1, k1, Blocks.field_150346_d, 0);
                    }
                }
            }
            for (j1 = 0; j1 < height; ++j1) {
                for (int i13 = i - this.trunkWidth; i13 <= i + this.trunkWidth; ++i13) {
                    for (int k13 = k - this.trunkWidth; k13 <= k + this.trunkWidth; ++k13) {
                        this.func_150516_a(world, i13, j + j1, k13, LOTRMod.wood, 2);
                    }
                }
            }
            if (this.trunkWidth >= 2) {
                int angle = 0;
                while (angle < 360) {
                    float angleR = (float)(angle += 15 + random.nextInt(25)) / 180.0f * (float)Math.PI;
                    float sin = MathHelper.func_76126_a((float)angleR);
                    float cos = MathHelper.func_76134_b((float)angleR);
                    int boughLength = 8 + random.nextInt(8);
                    int boughThickness = Math.round((float)boughLength / 20.0f * 1.5f);
                    int boughBaseHeight = j + MathHelper.func_76128_c((double)((float)height * (0.9f + random.nextFloat() * 0.1f)));
                    int boughHeight = 3 + random.nextInt(4);
                    for (int l = 0; l < boughLength; ++l) {
                        int i14 = i + Math.round(sin * (float)l);
                        int k14 = k + Math.round(cos * (float)l);
                        int j12 = boughBaseHeight + Math.round((float)l / (float)boughLength * (float)boughHeight);
                        int range = boughThickness - Math.round((float)l / (float)boughLength * (float)boughThickness * 0.5f);
                        for (int i2 = i14 - range; i2 <= i14 + range; ++i2) {
                            for (int j2 = j12 - range; j2 <= j12 + range; ++j2) {
                                for (int k2 = k14 - range; k2 <= k14 + range; ++k2) {
                                    Block block = world.func_147439_a(i2, j2, k2);
                                    if (block.func_149688_o() != Material.field_151579_a && !block.isLeaves((IBlockAccess)world, i2, j2, k2)) continue;
                                    this.func_150516_a(world, i2, j2, k2, LOTRMod.wood, 14);
                                }
                            }
                        }
                        int branch_angle = angle + random.nextInt(360);
                        float branch_angleR = (float)branch_angle / 180.0f * (float)Math.PI;
                        float branch_sin = MathHelper.func_76126_a((float)branch_angleR);
                        float branch_cos = MathHelper.func_76134_b((float)branch_angleR);
                        int branchLength = 5 + random.nextInt(5);
                        int branchHeight = random.nextInt(6);
                        int leafRange = 3;
                        for (int l1 = 0; l1 < branchLength; ++l1) {
                            int j2;
                            int i2 = i14 + Math.round(branch_sin * (float)l1);
                            int k2 = k14 + Math.round(branch_cos * (float)l1);
                            for (int j3 = j2 = j12 + Math.round((float)l1 / (float)branchLength * (float)branchHeight); j3 >= j2 - 1; --j3) {
                                Block block = world.func_147439_a(i2, j3, k2);
                                if (block.func_149688_o() != Material.field_151579_a && !block.isLeaves((IBlockAccess)world, i2, j3, k2)) continue;
                                this.func_150516_a(world, i2, j3, k2, LOTRMod.wood, 14);
                            }
                            if (l1 != branchLength - 1) continue;
                            for (int i3 = i2 - leafRange; i3 <= i2 + leafRange; ++i3) {
                                for (int j3 = j2 - leafRange; j3 <= j2 + leafRange; ++j3) {
                                    for (int k3 = k2 - leafRange; k3 <= k2 + leafRange; ++k3) {
                                        Block block2;
                                        int i4 = i3 - i2;
                                        int j4 = j3 - j2;
                                        int k4 = k3 - k2;
                                        int dist = i4 * i4 + j4 * j4 + k4 * k4;
                                        if (dist >= (leafRange - 1) * (leafRange - 1) && (dist >= leafRange * leafRange || random.nextInt(3) == 0) || (block2 = world.func_147439_a(i3, j3, k3)).func_149688_o() != Material.field_151579_a && !block2.isLeaves((IBlockAccess)world, i3, j3, k3)) continue;
                                        this.func_150516_a(world, i3, j3, k3, LOTRMod.leaves, (this.isRed ? 3 : 2) | (this.disableDecay ? 4 : 0));
                                    }
                                }
                            }
                        }
                    }
                }
                int platforms = 0;
                if (random.nextInt(3) != 0) {
                    platforms = random.nextBoolean() ? 1 + random.nextInt(3) : 4 + random.nextInt(5);
                }
                for (int l = 0; l < platforms; ++l) {
                    int j13 = j + 10 + random.nextInt(height - 10);
                    new LOTRWorldGenWoodElfPlatform(false).func_76484_a(world, random, i, j13, k);
                }
            } else {
                Block block;
                int j14;
                int leafStart = 3;
                for (j14 = j + height - leafStart; j14 <= j + height; ++j14) {
                    int j2 = j14 - (j + height);
                    int range = this.canopyRadius - j2;
                    for (int i15 = i - range; i15 <= i + range; ++i15) {
                        for (int k15 = k - range; k15 <= k + range; ++k15) {
                            int i2 = i15 - i;
                            int k2 = k15 - k;
                            if (i2 * i2 + k2 * k2 >= range * range || (block = world.func_147439_a(i15, j14, k15)).func_149688_o() != Material.field_151579_a && !block.canBeReplacedByLeaves((IBlockAccess)world, i15, j14, k15)) continue;
                            this.func_150516_a(world, i15, j14, k15, LOTRMod.leaves, (this.isRed ? 3 : 2) | (this.disableDecay ? 4 : 0));
                            if (!this.hasVines) continue;
                            if (random.nextInt(20) == 0 && world.func_147437_c(i15 - 1, j14, k15)) {
                                this.growVines(world, random, i15 - 1, j14, k15, 8);
                            }
                            if (random.nextInt(20) == 0 && world.func_147437_c(i15 + 1, j14, k15)) {
                                this.growVines(world, random, i15 + 1, j14, k15, 2);
                            }
                            if (random.nextInt(20) == 0 && world.func_147437_c(i15, j14, k15 - 1)) {
                                this.growVines(world, random, i15, j14, k15 - 1, 1);
                            }
                            if (random.nextInt(20) != 0 || !world.func_147437_c(i15, j14, k15 + 1)) continue;
                            this.growVines(world, random, i15, j14, k15 + 1, 4);
                        }
                    }
                }
                for (j14 = 0; j14 < this.trunkWidth + 2; ++j14) {
                    int range = j14 + this.trunkWidth + 2;
                    for (int i16 = i - this.trunkWidth - range; i16 <= i + this.trunkWidth + range; ++i16) {
                        for (int k16 = k - this.trunkWidth - range; k16 <= k + this.trunkWidth + range; ++k16) {
                            int j2;
                            int k2;
                            int i2 = Math.abs(i16 - i) - this.trunkWidth - j14;
                            if (i2 * i2 + (k2 = Math.abs(k16 - k) - this.trunkWidth - j14) * k2 > range || (block = world.func_147439_a(i16, j2 = j + j14 + height - 4 - this.trunkWidth, k16)).func_149688_o() != Material.field_151579_a && !block.isLeaves((IBlockAccess)world, i16, j2, k16)) continue;
                            this.func_150516_a(world, i16, j2, k16, LOTRMod.wood, 14);
                        }
                    }
                }
            }
            if (this.trunkWidth > 0) {
                int roots = 4 + random.nextInt(5 * this.trunkWidth);
                for (int l = 0; l < roots; ++l) {
                    int i17 = i;
                    int j15 = j + 1 + random.nextInt(5);
                    int k17 = k;
                    int xDirection = 0;
                    int zDirection = 0;
                    int rootLength = 1 + random.nextInt(4);
                    if (random.nextBoolean()) {
                        if (random.nextBoolean()) {
                            i17 -= this.trunkWidth + 1;
                            xDirection = -1;
                        } else {
                            i17 += this.trunkWidth + 1;
                            xDirection = 1;
                        }
                        k17 -= this.trunkWidth + 1;
                        k17 += random.nextInt(this.trunkWidth * 2 + 2);
                    } else {
                        if (random.nextBoolean()) {
                            k17 -= this.trunkWidth + 1;
                            zDirection = -1;
                        } else {
                            k17 += this.trunkWidth + 1;
                            zDirection = 1;
                        }
                        i17 -= this.trunkWidth + 1;
                        i17 += random.nextInt(this.trunkWidth * 2 + 2);
                    }
                    for (int l1 = 0; l1 < rootLength; ++l1) {
                        int rootBlocks = 0;
                        int j2 = j15;
                        while (!LOTRMod.isOpaque(world, i17, j2, k17)) {
                            this.func_150516_a(world, i17, j2, k17, LOTRMod.wood, 14);
                            if (world.func_147439_a(i17, j2 - 1, k17) == Blocks.field_150349_c) {
                                this.func_150516_a(world, i17, j2 - 1, k17, Blocks.field_150346_d, 0);
                            }
                            if (++rootBlocks > 5) break;
                            --j2;
                        }
                        --j15;
                        if (!random.nextBoolean()) continue;
                        if (xDirection == -1) {
                            --i17;
                            continue;
                        }
                        if (xDirection == 1) {
                            ++i17;
                            continue;
                        }
                        if (zDirection == -1) {
                            --k17;
                            continue;
                        }
                        if (zDirection != 1) continue;
                        ++k17;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void growVines(World world, Random random, int i, int j, int k, int meta) {
        this.func_150516_a(world, i, j, k, Blocks.field_150395_bd, meta);
        int length = 4 + random.nextInt(8);
        while (world.func_147437_c(i, --j, k) && length > 0) {
            this.func_150516_a(world, i, j, k, Blocks.field_150395_bd, meta);
            --length;
        }
        return;
    }
}

