/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.feature;

import java.util.Random;
import lotr.common.LOTRMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRWorldGenSimpleTrees
extends WorldGenAbstractTree {
    private int minHeight;
    private int maxHeight;
    private Block woodID;
    private int woodMeta;
    private Block leafID;
    private int leafMeta;
    private int extraTrunkWidth;

    private LOTRWorldGenSimpleTrees(boolean flag, int i, int j, Block k, int l, Block i1, int j1) {
        super(flag);
        this.minHeight = i;
        this.maxHeight = j;
        this.woodID = k;
        this.woodMeta = l;
        this.leafID = i1;
        this.leafMeta = j1;
    }

    public LOTRWorldGenSimpleTrees setTrunkWidth(int i) {
        this.extraTrunkWidth = i - 1;
        return this;
    }

    public static LOTRWorldGenSimpleTrees newMallorn(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 9, 15, LOTRMod.wood, 1, LOTRMod.leaves, 1);
    }

    public static LOTRWorldGenSimpleTrees newApple(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 4, 7, LOTRMod.fruitWood, 0, LOTRMod.fruitLeaves, 0);
    }

    public static LOTRWorldGenSimpleTrees newPear(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 4, 5, LOTRMod.fruitWood, 1, LOTRMod.fruitLeaves, 1);
    }

    public static LOTRWorldGenSimpleTrees newCherry(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 4, 8, LOTRMod.fruitWood, 2, LOTRMod.fruitLeaves, 2);
    }

    public static LOTRWorldGenSimpleTrees newMango(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 4, 7, LOTRMod.fruitWood, 3, LOTRMod.fruitLeaves, 3);
    }

    public static LOTRWorldGenSimpleTrees newLebethron(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 5, 9, LOTRMod.wood2, 0, LOTRMod.leaves2, 0);
    }

    public static LOTRWorldGenSimpleTrees newLebethronLarge(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 11, 18, LOTRMod.wood2, 0, LOTRMod.leaves2, 0).setTrunkWidth(2);
    }

    public static LOTRWorldGenSimpleTrees newBeech(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 5, 9, LOTRMod.wood2, 1, LOTRMod.leaves2, 1);
    }

    public static LOTRWorldGenSimpleTrees newMaple(boolean flag) {
        return new LOTRWorldGenSimpleTrees(flag, 4, 8, LOTRMod.wood3, 0, LOTRMod.leaves3, 0);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int height = MathHelper.func_76136_a((Random)random, (int)this.minHeight, (int)this.maxHeight);
        boolean flag = true;
        if (j >= 1 && j + height + 1 <= 256) {
            int k1;
            int i1;
            for (int j1 = j; j1 <= j + 1 + height; ++j1) {
                int range = 1;
                if (j1 == j) {
                    range = 0;
                }
                if (j1 >= j + 1 + height - 2) {
                    range = 2;
                }
                for (int i12 = i - range; i12 <= i + range + this.extraTrunkWidth && flag; ++i12) {
                    for (int k12 = k - range; k12 <= k + range + this.extraTrunkWidth && flag; ++k12) {
                        if (j1 >= 0 && j1 < 256) {
                            Block block = world.func_147439_a(i12, j1, k12);
                            if (block.func_149688_o() == Material.field_151579_a || block.isLeaves((IBlockAccess)world, i12, j1, k12) || block == Blocks.field_150349_c || block == Blocks.field_150346_d || block.isWood((IBlockAccess)world, i12, j1, k12)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            boolean flag1 = true;
            for (i1 = i; i1 <= i + this.extraTrunkWidth && flag1; ++i1) {
                for (k1 = k; k1 <= k + this.extraTrunkWidth && flag1; ++k1) {
                    Block block = world.func_147439_a(i1, j - 1, k1);
                    flag1 = (block == Blocks.field_150349_c || block == Blocks.field_150346_d) && j < 256 - height - 1;
                }
            }
            if (flag1) {
                int j1;
                for (i1 = i; i1 <= i + this.extraTrunkWidth; ++i1) {
                    for (k1 = k; k1 <= k + this.extraTrunkWidth; ++k1) {
                        this.func_150516_a(world, i1, j - 1, k1, Blocks.field_150346_d, 0);
                    }
                }
                int leafStart = 3;
                int leafRangeMin = 0;
                for (j1 = j - leafStart + height; j1 <= j + height; ++j1) {
                    int j2 = j1 - (j + height);
                    int leafRange = leafRangeMin + 1 - j2 / 2;
                    for (int i13 = i - leafRange; i13 <= i + leafRange + this.extraTrunkWidth; ++i13) {
                        int i2 = i13 - i;
                        if (i2 > 0) {
                            i2 -= this.extraTrunkWidth;
                        }
                        for (int k13 = k - leafRange; k13 <= k + leafRange + this.extraTrunkWidth; ++k13) {
                            int k2 = k13 - k;
                            if (k2 > 0) {
                                k2 -= this.extraTrunkWidth;
                            }
                            Block block = world.func_147439_a(i13, j1, k13);
                            if (Math.abs(i2) == leafRange && Math.abs(k2) == leafRange && (random.nextInt(2) == 0 || j2 == 0) || !block.canBeReplacedByLeaves((IBlockAccess)world, i13, j1, k13)) continue;
                            this.func_150516_a(world, i13, j1, k13, this.leafID, this.leafMeta);
                        }
                    }
                }
                for (j1 = 0; j1 < height; ++j1) {
                    for (int i14 = i; i14 <= i + this.extraTrunkWidth; ++i14) {
                        for (int k14 = k; k14 <= k + this.extraTrunkWidth; ++k14) {
                            Block block = world.func_147439_a(i14, j + j1, k14);
                            if (block.func_149688_o() != Material.field_151579_a && !block.isLeaves((IBlockAccess)world, i14, j + j1, k14)) continue;
                            this.func_150516_a(world, i14, j + j1, k14, this.woodID, this.woodMeta);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

