/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.genlayer;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.genlayer.LOTRGenLayerBeach;
import lotr.common.world.genlayer.LOTRGenLayerBiomeFeatures;
import lotr.common.world.genlayer.LOTRGenLayerBiomeVariants;
import lotr.common.world.genlayer.LOTRGenLayerBiomeVariantsInit;
import lotr.common.world.genlayer.LOTRGenLayerBiomeVariantsSmall;
import lotr.common.world.genlayer.LOTRGenLayerRiver;
import lotr.common.world.genlayer.LOTRGenLayerRiverVariants;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;

public class LOTRGenLayerWorld
extends GenLayer {
    public static Map colorsToBiomeIDs = new HashMap();
    public static int[] biomeImageData;
    public static int originX;
    public static int originZ;
    public static int scale;
    public static int imageWidth;
    public static int imageHeight;

    public static GenLayer[] createWorld(long seed, WorldType worldType) {
        int scale = 3;
        GenLayer layer = new LOTRGenLayerWorld();
        layer = new GenLayerFuzzyZoom(2000L, layer);
        layer = new GenLayerZoom(2001L, layer);
        layer = new GenLayerZoom(2002L, layer);
        GenLayer rivers = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)layer, (int)1);
        rivers = new GenLayerRiverInit(100L, rivers);
        rivers = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)rivers, (int)10);
        rivers = new LOTRGenLayerRiver(1L, rivers);
        rivers = new GenLayerSmooth(1000L, rivers);
        LOTRGenLayerBiomeVariantsInit biomeVariants = new LOTRGenLayerBiomeVariantsInit(3000L);
        biomeVariants = GenLayerZoom.func_75915_a((long)3000L, (GenLayer)biomeVariants, (int)2);
        GenLayer biomes = new LOTRGenLayerWorld();
        biomes = new LOTRGenLayerBeach(1000L, biomes).setOcean();
        biomes = new LOTRGenLayerBiomeVariants(1000L, biomes, biomeVariants);
        biomes = new LOTRGenLayerBiomeVariantsSmall(500L, biomes);
        biomes = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)biomes, (int)2);
        biomes = new LOTRGenLayerBiomeFeatures(1000L, biomes);
        for (int i = 0; i < scale; ++i) {
            biomes = new GenLayerZoom(1000L + (long)i, biomes);
        }
        biomes = new GenLayerSmooth(1000L, biomes);
        layer = new LOTRGenLayerRiverVariants(100L, biomes, rivers);
        GenLayerVoronoiZoom layer1 = new GenLayerVoronoiZoom(10L, layer);
        layer.func_75905_a(seed + 1000L);
        layer1.func_75905_a(seed + 1000L);
        return new GenLayer[]{layer, layer1, layer};
    }

    public LOTRGenLayerWorld() {
        super(0L);
        if (biomeImageData == null) {
            try {
                BufferedImage biomeImage = null;
                ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)LOTRMod.instance);
                if (mc.getSource().isFile()) {
                    ZipFile zip = new ZipFile(mc.getSource());
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().equals("assets/lotr/map/map.png")) continue;
                        biomeImage = ImageIO.read(zip.getInputStream(entry));
                    }
                    zip.close();
                } else {
                    File file = new File(LOTRMod.class.getResource("/assets/lotr/map/map.png").toURI());
                    biomeImage = ImageIO.read(new FileInputStream(file));
                }
                if (biomeImage == null) {
                    throw new RuntimeException("Could not load LOTR biome map image");
                }
                imageWidth = biomeImage.getWidth();
                imageHeight = biomeImage.getHeight();
                int[] colors = biomeImage.getRGB(0, 0, imageWidth, imageHeight, null, 0, imageWidth);
                biomeImageData = new int[imageWidth * imageHeight];
                for (int i = 0; i < colors.length; ++i) {
                    int color = colors[i] & 0xFFFFFF;
                    Object obj = colorsToBiomeIDs.get(color);
                    LOTRGenLayerWorld.biomeImageData[i] = obj != null ? (Integer)obj : LOTRBiome.ocean.field_76756_M;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int[] func_75904_a(int i, int k, int xSize, int zSize) {
        int[] intArray = IntCache.func_76445_a((int)(xSize * zSize));
        for (int l = 0; l < zSize; ++l) {
            for (int l1 = 0; l1 < xSize; ++l1) {
                int i1 = i + l1 + originX;
                int k1 = k + l + originZ;
                intArray[l1 + l * xSize] = i1 < 0 || i1 >= imageWidth || k1 < 0 || k1 >= imageHeight ? LOTRBiome.ocean.field_76756_M : biomeImageData[i1 + k1 * imageWidth];
            }
        }
        return intArray;
    }

    static {
        originX = 810;
        originZ = 730;
        scale = 128;
    }
}

