/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityGondorArcher;
import lotr.common.entity.npc.LOTREntityGondorSoldier;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRWorldGenBeaconTower
extends LOTRWorldGenStructureBase {
    public LOTRWorldGenBeaconTower(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.generateWithSetHeightAndRotation(world, random, i, j, k, 7 + random.nextInt(4), random.nextInt(4));
    }

    public boolean generateWithSetHeightAndRotation(World world, Random random, int i, int j, int k, int height, int rotation) {
        int j1;
        int k1;
        int i1;
        if (this.restrictions && (world.func_147439_a(i, j - 1, k) != LOTRMod.rock || world.func_72805_g(i, j - 1, k) != 1)) {
            return false;
        }
        j += height;
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
            switch (rotation) {
                case 0: {
                    k += 3;
                    break;
                }
                case 1: {
                    i -= 3;
                    break;
                }
                case 2: {
                    k -= 3;
                    break;
                }
                case 3: {
                    i += 3;
                }
            }
        }
        if (this.restrictions) {
            for (i1 = i - 4; i1 <= i + 4; ++i1) {
                for (k1 = k - 4; k1 <= k + 4; ++k1) {
                    for (j1 = j; j1 <= j + 5; ++j1) {
                        if (world.func_147437_c(i1, j1, k1)) continue;
                        return false;
                    }
                }
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (k1 = k - 2; k1 <= k + 2; ++k1) {
                for (j1 = j; !LOTRMod.isOpaque(world, i1, j1, k1) && j1 >= 0; --j1) {
                    this.func_150516_a(world, i1, j1, k1, LOTRMod.brick, 1);
                    this.setGrassToDirt(world, i1, j1 - 1, k1);
                }
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k1 = k - 1; k1 <= k + 1; ++k1) {
                this.func_150516_a(world, i1, j, k1, LOTRMod.slabDouble, 2);
            }
        }
        this.func_150516_a(world, i, j + 1, k, LOTRMod.rock, 1);
        this.func_150516_a(world, i, j + 2, k, LOTRMod.beacon, 0);
        for (int j12 = j + 1; j12 <= j + 5; ++j12) {
            this.func_150516_a(world, i - 2, j12, k - 2, LOTRMod.brick, 1);
            this.func_150516_a(world, i - 2, j12, k + 2, LOTRMod.brick, 1);
            this.func_150516_a(world, i + 2, j12, k - 2, LOTRMod.brick, 1);
            this.func_150516_a(world, i + 2, j12, k + 2, LOTRMod.brick, 1);
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (k1 = k - 1; k1 <= k + 1; ++k1) {
                this.func_150516_a(world, i1, j + 5, k1, LOTRMod.slabSingle, 11);
            }
        }
        this.func_150516_a(world, i, j + 5, k - 2, LOTRMod.slabSingle, 11);
        this.func_150516_a(world, i, j + 5, k + 2, LOTRMod.slabSingle, 11);
        this.func_150516_a(world, i - 2, j + 5, k, LOTRMod.slabSingle, 11);
        this.func_150516_a(world, i + 2, j + 5, k, LOTRMod.slabSingle, 11);
        this.func_150516_a(world, i - 2, j + 5, k - 1, LOTRMod.stairsGondorBrick, 7);
        this.func_150516_a(world, i - 2, j + 5, k + 1, LOTRMod.stairsGondorBrick, 6);
        this.func_150516_a(world, i + 2, j + 5, k - 1, LOTRMod.stairsGondorBrick, 7);
        this.func_150516_a(world, i + 2, j + 5, k + 1, LOTRMod.stairsGondorBrick, 6);
        this.func_150516_a(world, i - 1, j + 5, k - 2, LOTRMod.stairsGondorBrick, 5);
        this.func_150516_a(world, i + 1, j + 5, k - 2, LOTRMod.stairsGondorBrick, 4);
        this.func_150516_a(world, i - 1, j + 5, k + 2, LOTRMod.stairsGondorBrick, 5);
        this.func_150516_a(world, i + 1, j + 5, k + 2, LOTRMod.stairsGondorBrick, 4);
        int soldiers = 1 + random.nextInt(2);
        for (int l = 0; l < soldiers; ++l) {
            LOTREntityGondorSoldier soldier = world.field_73012_v.nextInt(3) == 0 ? new LOTREntityGondorArcher(world) : new LOTREntityGondorSoldier(world);
            soldier.func_70012_b(i - 1 + l * 2, j + 1, k, 0.0f, 0.0f);
            soldier.spawnRidingHorse = false;
            soldier.func_110161_a(null);
            soldier.func_70062_b(4, new ItemStack(LOTRMod.helmetGondorWinged));
            soldier.isNPCPersistent = true;
            world.func_72838_d((Entity)soldier);
            soldier.func_110171_b(i, j, k, 16);
        }
        int ladderMetadata = 0;
        switch (rotation) {
            case 0: {
                k -= 3;
                ladderMetadata = 2;
                break;
            }
            case 1: {
                i += 3;
                ladderMetadata = 5;
                break;
            }
            case 2: {
                k += 3;
                ladderMetadata = 3;
                break;
            }
            case 3: {
                i -= 3;
                ladderMetadata = 4;
            }
        }
        for (int j13 = j; !LOTRMod.isOpaque(world, i, j13, k) && j13 >= 0; --j13) {
            this.func_150516_a(world, i, j13, k, Blocks.field_150468_ap, ladderMetadata);
        }
        if (this.restrictions) {
            LOTRLevelData.beaconTowerLocations.add(new ChunkCoordinates(i, j, k));
        }
        return true;
    }
}

