/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDunlending;
import lotr.common.entity.npc.LOTREntityDunlendingArcher;
import lotr.common.entity.npc.LOTREntityDunlendingWarlord;
import lotr.common.entity.npc.LOTREntityDunlendingWarrior;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenDunlendingHouse;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRWorldGenDunlandHillFort
extends LOTRWorldGenStructureBase {
    private Block plankBlock;
    private int plankMeta;
    private Block woodBlock;
    private int woodMeta;
    private Block slabBlock;
    private int slabMeta;
    private Block stairBlock;
    private Block floorBlock;
    private int floorMeta;

    public LOTRWorldGenDunlandHillFort(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int i1;
        int stairY;
        int j1;
        int k1;
        int i12;
        int k12;
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        switch (rotation) {
            case 0: {
                k += 8;
                break;
            }
            case 1: {
                i -= 8;
                break;
            }
            case 2: {
                k -= 8;
                break;
            }
            case 3: {
                i += 8;
            }
        }
        if (this.restrictions) {
            for (int i13 = i - 7; i13 <= i + 7; ++i13) {
                for (k12 = k - 7; k12 <= k + 7; ++k12) {
                    int j12 = world.func_72825_h(i13, k12);
                    Block block = world.func_147439_a(i13, j12 - 1, k12);
                    if (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150348_b) continue;
                    return false;
                }
            }
        }
        if (random.nextBoolean()) {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 0;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 0;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 0;
            this.stairBlock = Blocks.field_150476_ad;
        } else {
            this.plankBlock = Blocks.field_150344_f;
            this.plankMeta = 1;
            this.woodBlock = Blocks.field_150364_r;
            this.woodMeta = 1;
            this.slabBlock = Blocks.field_150376_bx;
            this.slabMeta = 1;
            this.stairBlock = Blocks.field_150485_bF;
        }
        Object[] obj = LOTRWorldGenDunlendingHouse.getRandomDunlandFloorBlock(random);
        this.floorBlock = (Block)obj[0];
        this.floorMeta = (Integer)obj[1];
        for (i12 = i - 7; i12 <= i + 7; ++i12) {
            for (k1 = k - 7; k1 <= k + 7; ++k1) {
                int j13;
                int i2 = Math.abs(i12 - i);
                int k2 = Math.abs(k1 - k);
                if (i2 == 7 && k2 == 7) {
                    for (j13 = j + 8; !(j13 < j && LOTRMod.isOpaque(world, i12, j13, k1) || j13 < 0); --j13) {
                        this.func_150516_a(world, i12, j13, k1, this.woodBlock, this.woodMeta);
                        this.setGrassToDirt(world, i12, j13 - 1, k1);
                    }
                } else if (i2 == 7 || k2 == 7) {
                    for (j13 = j + 5; !(j13 < j && LOTRMod.isOpaque(world, i12, j13, k1) || j13 < 0); --j13) {
                        this.func_150516_a(world, i12, j13, k1, this.plankBlock, this.plankMeta);
                        this.setGrassToDirt(world, i12, j13 - 1, k1);
                    }
                    if (i2 == 7 && k2 % 2 == 1 || k2 == 7 && i2 % 2 == 1) {
                        this.func_150516_a(world, i12, j + 6, k1, this.plankBlock, this.plankMeta);
                    } else {
                        this.func_150516_a(world, i12, j + 6, k1, this.slabBlock, this.slabMeta);
                    }
                } else {
                    for (j13 = j + 6; j13 >= j + 1; --j13) {
                        this.setAir(world, i12, j13, k1);
                    }
                    for (j13 = j; !(j13 < j && LOTRMod.isOpaque(world, i12, j13, k1) || j13 < 0); --j13) {
                        this.func_150516_a(world, i12, j13, k1, this.floorBlock, this.floorMeta);
                        this.setGrassToDirt(world, i12, j13 - 1, k1);
                    }
                }
                if (i2 >= 5 && i2 <= 6 || k2 >= 5 && k2 <= 6) {
                    this.func_150516_a(world, i12, j + 4, k1, this.plankBlock, this.plankMeta);
                }
                if ((i2 != 5 || k2 > 5) && (k2 != 5 || i2 > 5)) continue;
                this.func_150516_a(world, i12, j + 5, k1, Blocks.field_150422_aJ, 0);
            }
        }
        this.func_150516_a(world, i - 5, j + 6, k - 5, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 5, j + 6, k + 5, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 5, j + 6, k - 5, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 5, j + 6, k + 5, Blocks.field_150478_aa, 5);
        this.placeBanner(world, i - 7, j + 9, k - 7, rotation, 5);
        this.placeBanner(world, i - 7, j + 9, k + 7, rotation, 5);
        this.placeBanner(world, i + 7, j + 9, k - 7, rotation, 5);
        this.placeBanner(world, i + 7, j + 9, k + 7, rotation, 5);
        if (rotation == 0) {
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j, k - 7, this.floorBlock, this.floorMeta);
                this.setAir(world, i12, j + 1, k - 7);
                this.func_150516_a(world, i12, j + 2, k - 7, Blocks.field_150396_be, 0);
                this.setAir(world, i12, j + 3, k - 7);
                this.func_150516_a(world, i12, j + 4, k - 7, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i12, j + 4, k - 6, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i12, j + 6, k - 7, this.woodBlock, this.woodMeta);
            }
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                this.func_150516_a(world, i - 2, j1, k - 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 2, j1, k - 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i - 3, j1 + 2, k - 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 3, j1 + 2, k - 7, this.woodBlock, this.woodMeta);
            }
            this.func_150516_a(world, i - 2, j + 5, k - 7, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 2, j + 5, k - 7, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i, j + 5, k - 7, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i, j + 6, k - 8, Blocks.field_150465_bP, 2);
            this.func_150516_a(world, i, j + 6, k - 6, Blocks.field_150478_aa, 3);
            for (i12 = i - 3; i12 <= i - 2; ++i12) {
                this.setAir(world, i12, j + 5, k - 5);
                stairY = j + 4;
                for (int k13 = k - 4; k13 <= k - 1; ++k13) {
                    this.func_150516_a(world, i12, stairY, k13, this.stairBlock, 3);
                    --stairY;
                }
            }
            for (k12 = k - 4; k12 <= k - 1; ++k12) {
                for (i1 = i + 1; i1 <= i + 4; ++i1) {
                    this.func_150516_a(world, i1, j, k12, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i - 2, j + 2, k - 6, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i + 2, j + 2, k - 6, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i + 6, j + 1, k - 6, LOTRMod.dunlendingTable, 0);
            this.func_150516_a(world, i + 5, j + 1, k - 6, Blocks.field_150462_ai, 0);
            this.func_150516_a(world, i - 5, j + 1, k - 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 6, j + 1, k - 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 6, j + 1, k - 3, Blocks.field_150467_bQ, 0);
            this.func_150516_a(world, i - 6, j + 1, k - 2, Blocks.field_150467_bQ, 0);
            this.placeArmorStand(world, i + 2, j + 1, k + 6, 0, new ItemStack[]{new ItemStack(LOTRMod.helmetWarg), new ItemStack(LOTRMod.bodyWarg), new ItemStack(LOTRMod.legsWarg), new ItemStack(LOTRMod.bootsWarg)});
            this.func_150516_a(world, i + 4, j + 1, k + 6, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + 4, j + 1, k + 6, LOTRChestContents.DUNLENDING_HOUSE);
            for (j1 = j + 1; j1 <= j + 2; ++j1) {
                this.func_150516_a(world, i + 5, j1, k + 4, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 5, j1, k + 2, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 4, j1, k + 1, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 2, j1, k + 1, Blocks.field_150422_aJ, 0);
            }
            this.func_150516_a(world, i + 5, j + 2, k + 3, Blocks.field_150325_L, 12);
            this.func_150516_a(world, i + 3, j + 2, k + 1, Blocks.field_150325_L, 12);
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                for (i1 = i - 6; i1 <= i - 1; ++i1) {
                    this.func_150516_a(world, i1, j1, k + 2, this.plankBlock, this.plankMeta);
                }
                for (k1 = k + 3; k1 <= k + 6; ++k1) {
                    this.func_150516_a(world, i - 1, j1, k1, this.plankBlock, this.plankMeta);
                }
            }
            for (i12 = i - 4; i12 <= i - 1; ++i12) {
                this.func_150516_a(world, i12, j + 4, k + 2, this.slabBlock, this.slabMeta);
            }
            for (k12 = k + 3; k12 <= k + 4; ++k12) {
                this.func_150516_a(world, i - 1, j + 4, k12, this.slabBlock, this.slabMeta);
            }
            for (k12 = k + 3; k12 <= k + 5; ++k12) {
                for (i1 = i - 5; i1 <= i - 2; ++i1) {
                    this.func_150516_a(world, i1, j + 4, k12, this.plankBlock, this.plankMeta);
                    if (k12 == k + 3 || i1 == i - 2) {
                        this.func_150516_a(world, i1, j + 5, k12, Blocks.field_150422_aJ, 0);
                        continue;
                    }
                    this.setAir(world, i1, j + 6, k12);
                    this.setAir(world, i1, j + 5, k12);
                }
            }
            this.func_150516_a(world, i - 5, j + 6, k + 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 2, j + 6, k + 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 2, j + 6, k + 5, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 4, j + 1, k + 2, Blocks.field_150466_ao, 1);
            this.func_150516_a(world, i - 4, j + 2, k + 2, Blocks.field_150466_ao, 8);
            this.func_150516_a(world, i - 2, j + 2, k + 1, Blocks.field_150478_aa, 4);
            for (i12 = i - 6; i12 <= i - 2; i12 += 4) {
                this.func_150516_a(world, i12, j + 1, k + 4, Blocks.field_150324_C, 2);
                this.func_150516_a(world, i12, j + 1, k + 3, Blocks.field_150324_C, 10);
                this.func_150516_a(world, i12, j + 1, k + 5, Blocks.field_150324_C, 0);
                this.func_150516_a(world, i12, j + 1, k + 6, Blocks.field_150324_C, 8);
            }
            this.func_150516_a(world, i - 4, j + 1, k + 6, this.plankBlock, this.plankMeta);
            this.placeBarrel(world, random, i - 4, j + 2, k + 6, 2, LOTRFoods.DUNLENDING_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i - 6, j + 3, k + 3, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i - 2, j + 3, k + 3, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i - 6, j + 3, k + 6, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i - 2, j + 3, k + 6, Blocks.field_150478_aa, 4);
        } else if (rotation == 1) {
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i + 7, j, k12, this.floorBlock, this.floorMeta);
                this.setAir(world, i + 7, j + 1, k12);
                this.func_150516_a(world, i + 7, j + 2, k12, Blocks.field_150396_be, 1);
                this.setAir(world, i + 7, j + 3, k12);
                this.func_150516_a(world, i + 7, j + 4, k12, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i + 6, j + 4, k12, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i + 7, j + 6, k12, this.woodBlock, this.woodMeta);
            }
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                this.func_150516_a(world, i + 7, j1, k - 2, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 7, j1, k + 2, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 7, j1 + 2, k - 3, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 7, j1 + 2, k + 3, this.woodBlock, this.woodMeta);
            }
            this.func_150516_a(world, i + 7, j + 5, k - 2, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 7, j + 5, k + 2, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 7, j + 5, k, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i + 8, j + 6, k, Blocks.field_150465_bP, 5);
            this.func_150516_a(world, i + 6, j + 6, k, Blocks.field_150478_aa, 2);
            for (k12 = k - 3; k12 <= k - 2; ++k12) {
                this.setAir(world, i + 5, j + 5, k12);
                stairY = j + 4;
                for (int i14 = i + 4; i14 >= i + 1; --i14) {
                    this.func_150516_a(world, i14, stairY, k12, this.stairBlock, 0);
                    --stairY;
                }
            }
            for (i12 = i + 4; i12 >= i + 1; --i12) {
                for (k1 = k + 1; k1 <= k + 4; ++k1) {
                    this.func_150516_a(world, i12, j, k1, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i + 6, j + 2, k - 2, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i + 6, j + 2, k + 2, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i + 6, j + 1, k + 6, LOTRMod.dunlendingTable, 0);
            this.func_150516_a(world, i + 6, j + 1, k + 5, Blocks.field_150462_ai, 0);
            this.func_150516_a(world, i + 6, j + 1, k - 5, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i + 6, j + 1, k - 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i + 3, j + 1, k - 6, Blocks.field_150467_bQ, 3);
            this.func_150516_a(world, i + 2, j + 1, k - 6, Blocks.field_150467_bQ, 3);
            this.placeArmorStand(world, i - 6, j + 1, k + 2, 1, new ItemStack[]{new ItemStack(LOTRMod.helmetWarg), new ItemStack(LOTRMod.bodyWarg), new ItemStack(LOTRMod.legsWarg), new ItemStack(LOTRMod.bootsWarg)});
            this.func_150516_a(world, i - 6, j + 1, k + 4, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i - 6, j + 1, k + 4, LOTRChestContents.DUNLENDING_HOUSE);
            for (j1 = j + 1; j1 <= j + 2; ++j1) {
                this.func_150516_a(world, i - 4, j1, k + 5, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i - 2, j1, k + 5, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i - 1, j1, k + 4, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i - 1, j1, k + 2, Blocks.field_150422_aJ, 0);
            }
            this.func_150516_a(world, i - 3, j + 2, k + 5, Blocks.field_150325_L, 12);
            this.func_150516_a(world, i - 1, j + 2, k + 3, Blocks.field_150325_L, 12);
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                for (k1 = k - 6; k1 <= k - 1; ++k1) {
                    this.func_150516_a(world, i - 2, j1, k1, this.plankBlock, this.plankMeta);
                }
                for (i1 = i - 3; i1 >= i - 6; --i1) {
                    this.func_150516_a(world, i1, j1, k - 1, this.plankBlock, this.plankMeta);
                }
            }
            for (k12 = k - 4; k12 <= k - 1; ++k12) {
                this.func_150516_a(world, i - 2, j + 4, k12, this.slabBlock, this.slabMeta);
            }
            for (i12 = i - 3; i12 >= i - 4; --i12) {
                this.func_150516_a(world, i12, j + 4, k - 1, this.slabBlock, this.slabMeta);
            }
            for (i12 = i - 3; i12 >= i - 5; --i12) {
                for (k1 = k - 5; k1 <= k - 2; ++k1) {
                    this.func_150516_a(world, i12, j + 4, k1, this.plankBlock, this.plankMeta);
                    if (i12 == i - 3 || k1 == k - 2) {
                        this.func_150516_a(world, i12, j + 5, k1, Blocks.field_150422_aJ, 0);
                        continue;
                    }
                    this.setAir(world, i12, j + 6, k1);
                    this.setAir(world, i12, j + 5, k1);
                }
            }
            this.func_150516_a(world, i - 3, j + 6, k - 5, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 3, j + 6, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 5, j + 6, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 2, j + 1, k - 4, Blocks.field_150466_ao, 2);
            this.func_150516_a(world, i - 2, j + 2, k - 4, Blocks.field_150466_ao, 8);
            this.func_150516_a(world, i - 1, j + 2, k - 2, Blocks.field_150478_aa, 1);
            for (k12 = k - 6; k12 <= k - 2; k12 += 4) {
                this.func_150516_a(world, i - 4, j + 1, k12, Blocks.field_150324_C, 3);
                this.func_150516_a(world, i - 3, j + 1, k12, Blocks.field_150324_C, 11);
                this.func_150516_a(world, i - 5, j + 1, k12, Blocks.field_150324_C, 1);
                this.func_150516_a(world, i - 6, j + 1, k12, Blocks.field_150324_C, 9);
            }
            this.func_150516_a(world, i - 6, j + 1, k - 4, this.plankBlock, this.plankMeta);
            this.placeBarrel(world, random, i - 6, j + 2, k - 4, 5, LOTRFoods.DUNLENDING_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i - 3, j + 3, k - 6, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i - 3, j + 3, k - 2, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i - 6, j + 3, k - 6, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i - 6, j + 3, k - 2, Blocks.field_150478_aa, 1);
        } else if (rotation == 2) {
            for (i12 = i - 1; i12 <= i + 1; ++i12) {
                this.func_150516_a(world, i12, j, k + 7, this.floorBlock, this.floorMeta);
                this.setAir(world, i12, j + 1, k + 7);
                this.func_150516_a(world, i12, j + 2, k + 7, Blocks.field_150396_be, 2);
                this.setAir(world, i12, j + 3, k + 7);
                this.func_150516_a(world, i12, j + 4, k + 7, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i12, j + 4, k + 6, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i12, j + 6, k + 7, this.woodBlock, this.woodMeta);
            }
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                this.func_150516_a(world, i - 2, j1, k + 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 2, j1, k + 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i - 3, j1 + 2, k + 7, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i + 3, j1 + 2, k + 7, this.woodBlock, this.woodMeta);
            }
            this.func_150516_a(world, i - 2, j + 5, k + 7, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i + 2, j + 5, k + 7, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i, j + 5, k + 7, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i, j + 6, k + 8, Blocks.field_150465_bP, 3);
            this.func_150516_a(world, i, j + 6, k + 6, Blocks.field_150478_aa, 4);
            for (i12 = i - 3; i12 <= i - 2; ++i12) {
                this.setAir(world, i12, j + 5, k + 5);
                stairY = j + 4;
                for (int k14 = k + 4; k14 >= k + 1; --k14) {
                    this.func_150516_a(world, i12, stairY, k14, this.stairBlock, 2);
                    --stairY;
                }
            }
            for (k12 = k + 4; k12 >= k + 1; --k12) {
                for (i1 = i + 1; i1 <= i + 4; ++i1) {
                    this.func_150516_a(world, i1, j, k12, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i - 2, j + 2, k + 6, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i + 2, j + 2, k + 6, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i + 6, j + 1, k + 6, LOTRMod.dunlendingTable, 0);
            this.func_150516_a(world, i + 5, j + 1, k + 6, Blocks.field_150462_ai, 0);
            this.func_150516_a(world, i - 5, j + 1, k + 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 6, j + 1, k + 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 6, j + 1, k + 3, Blocks.field_150467_bQ, 0);
            this.func_150516_a(world, i - 6, j + 1, k + 2, Blocks.field_150467_bQ, 0);
            this.placeArmorStand(world, i + 2, j + 1, k - 6, 2, new ItemStack[]{new ItemStack(LOTRMod.helmetWarg), new ItemStack(LOTRMod.bodyWarg), new ItemStack(LOTRMod.legsWarg), new ItemStack(LOTRMod.bootsWarg)});
            this.func_150516_a(world, i + 4, j + 1, k - 6, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + 4, j + 1, k - 6, LOTRChestContents.DUNLENDING_HOUSE);
            for (j1 = j + 1; j1 <= j + 2; ++j1) {
                this.func_150516_a(world, i + 5, j1, k - 4, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 5, j1, k - 2, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 4, j1, k - 1, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 2, j1, k - 1, Blocks.field_150422_aJ, 0);
            }
            this.func_150516_a(world, i + 5, j + 2, k - 3, Blocks.field_150325_L, 12);
            this.func_150516_a(world, i + 3, j + 2, k - 1, Blocks.field_150325_L, 12);
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                for (i1 = i - 6; i1 <= i - 1; ++i1) {
                    this.func_150516_a(world, i1, j1, k - 2, this.plankBlock, this.plankMeta);
                }
                for (k1 = k - 3; k1 >= k - 6; --k1) {
                    this.func_150516_a(world, i - 1, j1, k1, this.plankBlock, this.plankMeta);
                }
            }
            for (i12 = i - 4; i12 <= i - 1; ++i12) {
                this.func_150516_a(world, i12, j + 4, k - 2, this.slabBlock, this.slabMeta);
            }
            for (k12 = k - 3; k12 >= k - 4; --k12) {
                this.func_150516_a(world, i - 1, j + 4, k12, this.slabBlock, this.slabMeta);
            }
            for (k12 = k - 3; k12 >= k - 5; --k12) {
                for (i1 = i - 5; i1 <= i - 2; ++i1) {
                    this.func_150516_a(world, i1, j + 4, k12, this.plankBlock, this.plankMeta);
                    if (k12 == k - 3 || i1 == i - 2) {
                        this.func_150516_a(world, i1, j + 5, k12, Blocks.field_150422_aJ, 0);
                        continue;
                    }
                    this.setAir(world, i1, j + 6, k12);
                    this.setAir(world, i1, j + 5, k12);
                }
            }
            this.func_150516_a(world, i - 5, j + 6, k - 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 2, j + 6, k - 3, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 2, j + 6, k - 5, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i - 4, j + 1, k - 2, Blocks.field_150466_ao, 3);
            this.func_150516_a(world, i - 4, j + 2, k - 2, Blocks.field_150466_ao, 8);
            this.func_150516_a(world, i - 2, j + 2, k - 1, Blocks.field_150478_aa, 3);
            for (i12 = i - 6; i12 <= i - 2; i12 += 4) {
                this.func_150516_a(world, i12, j + 1, k - 4, Blocks.field_150324_C, 0);
                this.func_150516_a(world, i12, j + 1, k - 3, Blocks.field_150324_C, 8);
                this.func_150516_a(world, i12, j + 1, k - 5, Blocks.field_150324_C, 2);
                this.func_150516_a(world, i12, j + 1, k - 6, Blocks.field_150324_C, 10);
            }
            this.func_150516_a(world, i - 4, j + 1, k - 6, this.plankBlock, this.plankMeta);
            this.placeBarrel(world, random, i - 4, j + 2, k - 6, 3, LOTRFoods.DUNLENDING_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i - 6, j + 3, k - 3, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i - 2, j + 3, k - 3, Blocks.field_150478_aa, 4);
            this.func_150516_a(world, i - 6, j + 3, k - 6, Blocks.field_150478_aa, 3);
            this.func_150516_a(world, i - 2, j + 3, k - 6, Blocks.field_150478_aa, 3);
        } else if (rotation == 3) {
            for (k12 = k - 1; k12 <= k + 1; ++k12) {
                this.func_150516_a(world, i - 7, j, k12, this.floorBlock, this.floorMeta);
                this.setAir(world, i - 7, j + 1, k12);
                this.func_150516_a(world, i - 7, j + 2, k12, Blocks.field_150396_be, 3);
                this.setAir(world, i - 7, j + 3, k12);
                this.func_150516_a(world, i - 7, j + 4, k12, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i - 6, j + 4, k12, this.slabBlock, this.slabMeta | 8);
                this.func_150516_a(world, i - 7, j + 6, k12, this.woodBlock, this.woodMeta);
            }
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                this.func_150516_a(world, i - 7, j1, k - 2, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i - 7, j1, k + 2, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i - 7, j1 + 2, k - 3, this.woodBlock, this.woodMeta);
                this.func_150516_a(world, i - 7, j1 + 2, k + 3, this.woodBlock, this.woodMeta);
            }
            this.func_150516_a(world, i - 7, j + 5, k - 2, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 7, j + 5, k + 2, this.woodBlock, this.woodMeta);
            this.func_150516_a(world, i - 7, j + 5, k, this.slabBlock, this.slabMeta | 8);
            this.func_150516_a(world, i - 8, j + 6, k, Blocks.field_150465_bP, 4);
            this.func_150516_a(world, i - 6, j + 6, k, Blocks.field_150478_aa, 1);
            for (k12 = k - 3; k12 <= k - 2; ++k12) {
                this.setAir(world, i - 5, j + 5, k12);
                stairY = j + 4;
                for (int i15 = i - 4; i15 <= i - 1; ++i15) {
                    this.func_150516_a(world, i15, stairY, k12, this.stairBlock, 1);
                    --stairY;
                }
            }
            for (i12 = i - 4; i12 <= i - 1; ++i12) {
                for (k1 = k + 1; k1 <= k + 4; ++k1) {
                    this.func_150516_a(world, i12, j, k1, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i - 6, j + 2, k - 2, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i - 6, j + 2, k + 2, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i - 6, j + 1, k + 6, LOTRMod.dunlendingTable, 0);
            this.func_150516_a(world, i - 6, j + 1, k + 5, Blocks.field_150462_ai, 0);
            this.func_150516_a(world, i - 6, j + 1, k - 5, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 6, j + 1, k - 6, Blocks.field_150460_al, 0);
            this.func_150516_a(world, i - 3, j + 1, k - 6, Blocks.field_150467_bQ, 3);
            this.func_150516_a(world, i - 2, j + 1, k - 6, Blocks.field_150467_bQ, 3);
            this.placeArmorStand(world, i + 6, j + 1, k + 2, 3, new ItemStack[]{new ItemStack(LOTRMod.helmetWarg), new ItemStack(LOTRMod.bodyWarg), new ItemStack(LOTRMod.legsWarg), new ItemStack(LOTRMod.bootsWarg)});
            this.func_150516_a(world, i + 6, j + 1, k + 4, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + 6, j + 1, k + 4, LOTRChestContents.DUNLENDING_HOUSE);
            for (j1 = j + 1; j1 <= j + 2; ++j1) {
                this.func_150516_a(world, i + 4, j1, k + 5, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 2, j1, k + 5, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 1, j1, k + 4, Blocks.field_150422_aJ, 0);
                this.func_150516_a(world, i + 1, j1, k + 2, Blocks.field_150422_aJ, 0);
            }
            this.func_150516_a(world, i + 3, j + 2, k + 5, Blocks.field_150325_L, 12);
            this.func_150516_a(world, i + 1, j + 2, k + 3, Blocks.field_150325_L, 12);
            for (j1 = j + 1; j1 <= j + 3; ++j1) {
                for (k1 = k - 6; k1 <= k - 1; ++k1) {
                    this.func_150516_a(world, i + 2, j1, k1, this.plankBlock, this.plankMeta);
                }
                for (i1 = i + 3; i1 <= i + 6; ++i1) {
                    this.func_150516_a(world, i1, j1, k - 1, this.plankBlock, this.plankMeta);
                }
            }
            for (k12 = k - 4; k12 <= k - 1; ++k12) {
                this.func_150516_a(world, i + 2, j + 4, k12, this.slabBlock, this.slabMeta);
            }
            for (i12 = i + 3; i12 <= i + 4; ++i12) {
                this.func_150516_a(world, i12, j + 4, k - 1, this.slabBlock, this.slabMeta);
            }
            for (i12 = i + 3; i12 <= i + 5; ++i12) {
                for (k1 = k - 5; k1 <= k - 2; ++k1) {
                    this.func_150516_a(world, i12, j + 4, k1, this.plankBlock, this.plankMeta);
                    if (i12 == i + 3 || k1 == k - 2) {
                        this.func_150516_a(world, i12, j + 5, k1, Blocks.field_150422_aJ, 0);
                        continue;
                    }
                    this.setAir(world, i12, j + 6, k1);
                    this.setAir(world, i12, j + 5, k1);
                }
            }
            this.func_150516_a(world, i + 3, j + 6, k - 5, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 3, j + 6, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 5, j + 6, k - 2, Blocks.field_150478_aa, 5);
            this.func_150516_a(world, i + 2, j + 1, k - 4, Blocks.field_150466_ao, 0);
            this.func_150516_a(world, i + 2, j + 2, k - 4, Blocks.field_150466_ao, 8);
            this.func_150516_a(world, i + 1, j + 2, k - 2, Blocks.field_150478_aa, 2);
            for (k12 = k - 6; k12 <= k - 2; k12 += 4) {
                this.func_150516_a(world, i + 4, j + 1, k12, Blocks.field_150324_C, 1);
                this.func_150516_a(world, i + 3, j + 1, k12, Blocks.field_150324_C, 9);
                this.func_150516_a(world, i + 5, j + 1, k12, Blocks.field_150324_C, 3);
                this.func_150516_a(world, i + 6, j + 1, k12, Blocks.field_150324_C, 11);
            }
            this.func_150516_a(world, i + 6, j + 1, k - 4, this.plankBlock, this.plankMeta);
            this.placeBarrel(world, random, i + 6, j + 2, k - 4, 4, LOTRFoods.DUNLENDING_DRINK.getRandomFood(random).func_77973_b());
            this.func_150516_a(world, i + 3, j + 3, k - 6, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 3, j + 3, k - 2, Blocks.field_150478_aa, 1);
            this.func_150516_a(world, i + 6, j + 3, k - 6, Blocks.field_150478_aa, 2);
            this.func_150516_a(world, i + 6, j + 3, k - 2, Blocks.field_150478_aa, 2);
        }
        LOTREntityDunlendingWarlord warlord = new LOTREntityDunlendingWarlord(world);
        warlord.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
        warlord.func_110161_a(null);
        warlord.func_110171_b(i, j, k, 8);
        world.func_72838_d((Entity)warlord);
        for (int l = 0; l < 8; ++l) {
            LOTREntityDunlendingWarrior dunlending = world.field_73012_v.nextInt(3) == 0 ? new LOTREntityDunlendingArcher(world) : new LOTREntityDunlendingWarrior(world);
            dunlending.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            ((LOTREntityDunlending)dunlending).func_110161_a(null);
            dunlending.func_110171_b(i, j, k, 16);
            dunlending.isNPCPersistent = true;
            world.func_72838_d((Entity)dunlending);
        }
        if (this.restrictions) {
            LOTRLevelData.dunlandHillFortLocations.add(new ChunkCoordinates(i, j, k));
        }
        return true;
    }
}

