/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LOTRWorldGenDwarvenMineEntrance
extends LOTRWorldGenStructureBase {
    private Block plankBlock;
    private int plankMeta;
    private static int[][] offsetsForRotation = new int[][]{{0, -1}, {1, 0}, {0, 1}, {-1, 0}};
    private static int[] rotationOpposites = new int[]{2, 3, 0, 1};

    public LOTRWorldGenDwarvenMineEntrance(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        return this.generateWithDwarvenForgeDirection(world, random, i, j, k, -1);
    }

    public boolean generateWithDwarvenForgeDirection(World world, Random random, int i, int j, int k, int dwarvenForgeDirection) {
        int i1;
        int j1;
        int j12;
        int k1;
        int i12;
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        --j;
        int rotation = -1;
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
            switch (rotation) {
                case 0: {
                    k += 5;
                    break;
                }
                case 1: {
                    i -= 5;
                    break;
                }
                case 2: {
                    k -= 5;
                    break;
                }
                case 3: {
                    i += 5;
                }
            }
        } else {
            int l;
            for (l = 0; l < 4; ++l) {
                i12 = offsetsForRotation[l][0] * 5;
                k1 = offsetsForRotation[l][1] * 5;
                if (!LOTRMod.isOpaque(world, i + i12, j, k + k1) || !world.func_147437_c(i + i12, j + 1, k + k1) || !world.func_147437_c(i + i12, j + 2, k + k1)) continue;
                rotation = l;
                break;
            }
            if (rotation == -1) {
                for (l = 0; l < 4; ++l) {
                    i12 = offsetsForRotation[l][0] * 5;
                    k1 = offsetsForRotation[l][1] * 5;
                    if (!world.func_147437_c(i + i12, j + 1, k + k1) || !world.func_147437_c(i + i12, j + 2, k + k1)) continue;
                    rotation = l;
                    break;
                }
            }
            if (rotation == -1) {
                rotation = random.nextInt(4);
            }
        }
        this.plankBlock = Blocks.field_150344_f;
        this.plankMeta = 1;
        int depth = 30;
        if (this.restrictions && j - depth <= 5) {
            return false;
        }
        if (this.usingPlayer == null) {
            depth = j - 40;
        }
        for (i12 = i - 4; i12 <= i + 4; ++i12) {
            for (k1 = k - 4; k1 <= k + 4; ++k1) {
                for (int j13 = j + 1; j13 <= j + 3; ++j13) {
                    this.func_150516_a(world, i12, j13, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i12, j, k1, this.plankBlock, this.plankMeta);
                if (i12 != i - 4 && i12 != i + 4 && k1 != k - 4 && k1 != k + 4) continue;
                this.func_150516_a(world, i12, j + 1, k1, Blocks.field_150422_aJ, 0);
                if (i12 != i - 1 && i12 != i + 1 && k1 != k - 1 && k1 != k + 1) continue;
                this.func_150516_a(world, i12, j + 2, k1, Blocks.field_150478_aa, 5);
            }
        }
        for (j12 = j + 1; j12 <= j + 3; ++j12) {
            this.func_150516_a(world, i - 4, j12, k - 4, LOTRMod.pillar, 0);
            this.func_150516_a(world, i - 4, j12, k + 4, LOTRMod.pillar, 0);
            this.func_150516_a(world, i + 4, j12, k - 4, LOTRMod.pillar, 0);
            this.func_150516_a(world, i + 4, j12, k + 4, LOTRMod.pillar, 0);
        }
        for (i12 = i - 4; i12 <= i + 4; ++i12) {
            for (k1 = k - 4; k1 <= k + 4; ++k1) {
                this.func_150516_a(world, i12, j + 4, k1, this.plankBlock, this.plankMeta);
            }
        }
        for (j12 = j - 1; j12 > j - depth && j12 >= 0; --j12) {
            for (int i13 = i - 4; i13 <= i + 4; ++i13) {
                for (int k12 = k - 4; k12 <= k + 4; ++k12) {
                    if (i13 == i - 4 || i13 == i + 4 || k12 == k - 4 || k12 == k + 4) {
                        this.func_150516_a(world, i13, j12, k12, LOTRMod.brick, 6);
                        continue;
                    }
                    this.func_150516_a(world, i13, j12, k12, Blocks.field_150350_a, 0);
                }
            }
            this.func_150516_a(world, i - 3, j12, k - 3, LOTRMod.pillar, 0);
            this.func_150516_a(world, i - 3, j12, k + 3, LOTRMod.pillar, 0);
            this.func_150516_a(world, i + 3, j12, k - 3, LOTRMod.pillar, 0);
            this.func_150516_a(world, i + 3, j12, k + 3, LOTRMod.pillar, 0);
            if ((depth - (j - j12)) % 6 != 3) continue;
            this.func_150516_a(world, i - 3, j12, k - 3, Blocks.field_150426_aN, 0);
            this.func_150516_a(world, i - 3, j12, k + 3, Blocks.field_150426_aN, 0);
            this.func_150516_a(world, i + 3, j12, k - 3, Blocks.field_150426_aN, 0);
            this.func_150516_a(world, i + 3, j12, k + 3, Blocks.field_150426_aN, 0);
        }
        if (j - depth >= 0) {
            for (i12 = i - 3; i12 <= i + 3; ++i12) {
                for (k1 = k - 3; k1 <= k + 3; ++k1) {
                    if (LOTRMod.isOpaque(world, i12, j - depth, k1)) continue;
                    this.func_150516_a(world, i12, j - depth, k1, Blocks.field_150348_b, 0);
                }
            }
            for (i12 = i - 2; i12 <= i + 2; ++i12) {
                for (k1 = k - 2; k1 <= k + 2; ++k1) {
                    this.func_150516_a(world, i12, j - depth, k1, LOTRMod.pillar, 0);
                }
            }
        }
        int ladderX = 0;
        int ladderZ = 0;
        int ladderMeta = 0;
        switch (rotation) {
            case 0: {
                ladderZ = 1;
                ladderMeta = 3;
                this.func_150516_a(world, i, j + 1, k - 4, Blocks.field_150396_be, 0);
                break;
            }
            case 1: {
                ladderX = -1;
                ladderMeta = 4;
                this.func_150516_a(world, i + 4, j + 1, k, Blocks.field_150396_be, 1);
                break;
            }
            case 2: {
                ladderZ = -1;
                ladderMeta = 2;
                this.func_150516_a(world, i, j + 1, k + 4, Blocks.field_150396_be, 2);
                break;
            }
            case 3: {
                ladderX = 1;
                ladderMeta = 5;
                this.func_150516_a(world, i - 4, j + 1, k, Blocks.field_150396_be, 3);
            }
        }
        for (j1 = j; j1 > j - depth && j1 >= 0; --j1) {
            this.func_150516_a(world, i, j1, k, this.plankBlock, this.plankMeta);
            this.func_150516_a(world, i + ladderX, j1, k + ladderZ, Blocks.field_150468_ap, ladderMeta);
        }
        for (j1 = j - depth + 1; j1 <= j - depth + 3; ++j1) {
            for (i1 = i - 1; i1 <= i + 1; ++i1) {
                this.func_150516_a(world, i1, j1, k - 4, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i1, j1, k + 4, Blocks.field_150350_a, 0);
            }
            for (int k13 = k - 1; k13 <= k + 1; ++k13) {
                this.func_150516_a(world, i - 4, j1, k13, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i + 4, j1, k13, Blocks.field_150350_a, 0);
            }
        }
        if (dwarvenForgeDirection == -1) {
            dwarvenForgeDirection = rotation;
        }
        for (int l = 0; l < 4; ++l) {
            if (l == rotationOpposites[dwarvenForgeDirection]) continue;
            i1 = i + offsetsForRotation[l][0] * 4;
            int k14 = k + offsetsForRotation[l][1] * 4;
            this.func_150516_a(world, i1, j - depth + 1, k14, LOTRMod.dwarvenForge, 0);
            if (i1 == i) {
                this.func_150516_a(world, i - 1, j - depth + 1, k14, LOTRMod.slabSingle, 15);
                this.func_150516_a(world, i + 1, j - depth + 1, k14, LOTRMod.slabSingle, 15);
            }
            if (k14 != k) continue;
            this.func_150516_a(world, i1, j - depth + 1, k - 1, LOTRMod.slabSingle, 15);
            this.func_150516_a(world, i1, j - depth + 1, k + 1, LOTRMod.slabSingle, 15);
        }
        return true;
    }
}

