/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class LOTRWorldGenHobbitHole
extends LOTRWorldGenStructureBase {
    private Block floorBlock;
    private int floorMeta;
    private Block floorStoneBlock;
    private int floorStoneMeta;
    private Block wallBlock;
    private int wallMeta;
    private Block wallStairBlock;
    private Block wallHalfBlock;
    private int wallHalfMeta;
    private Block rugBlock;
    private int rugMeta;
    private int chandelierMeta;
    private Block fenceBlock;
    private int fenceMeta;
    private boolean isWealthy;

    public LOTRWorldGenHobbitHole(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int i2;
        int i1;
        int k2;
        if (this.restrictions) {
            if (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
                return false;
            }
            if (world.func_72807_a(i, k) != LOTRBiome.shire) {
                return false;
            }
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        switch (rotation) {
            case 0: {
                k += 16;
                break;
            }
            case 1: {
                i -= 16;
                break;
            }
            case 2: {
                k -= 16;
                break;
            }
            case 3: {
                i += 16;
            }
        }
        int radius = 16;
        int height = 7;
        int extraRadius = 2;
        if (this.restrictions) {
            int minHeight = j;
            int maxHeight = j;
            for (int i12 = i - radius; i12 <= i + radius; ++i12) {
                for (int k1 = k - radius; k1 <= k + radius; ++k1) {
                    int i22 = i12 - i;
                    k2 = k1 - k;
                    if (i22 * i22 + k2 * k2 > radius * radius) continue;
                    int j1 = world.func_72825_h(i12, k1) - 1;
                    Block block = world.func_147439_a(i12, j1, k1);
                    if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150354_m) {
                        return false;
                    }
                    if (j1 < minHeight) {
                        minHeight = j1;
                    }
                    if (j1 <= maxHeight) continue;
                    maxHeight = j1;
                }
            }
            if (maxHeight - minHeight > 7) {
                return false;
            }
        }
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72314_b((double)(radius + 1), (double)(height + 1), (double)(radius + 1)));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i - radius; i1 <= i + radius; ++i1) {
            for (int j1 = j + height; j1 >= j; --j1) {
                for (int k1 = k - radius; k1 <= k + radius; ++k1) {
                    i2 = i1 - i;
                    int j2 = j1 - j + (radius - height);
                    k2 = k1 - k;
                    if (i2 * i2 + j2 * j2 + k2 * k2 > (radius + extraRadius) * (radius + extraRadius)) continue;
                    boolean grass = !LOTRMod.isOpaque(world, i1, j1 + 1, k1);
                    this.func_150516_a(world, i1, j1, k1, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                    if (world.func_147439_a(i1, j1 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        for (i1 = i - radius; i1 <= i + radius; ++i1) {
            for (int k1 = k - radius; k1 <= k + radius; ++k1) {
                for (int j1 = j - 1; !LOTRMod.isOpaque(world, i1, j1, k1) && j1 >= 0; --j1) {
                    i2 = i1 - i;
                    int k22 = k1 - k;
                    if (i2 * i2 + k22 * k22 > radius * radius) continue;
                    boolean grass = !LOTRMod.isOpaque(world, i1, j1 + 1, k1);
                    this.func_150516_a(world, i1, j1, k1, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                    if (world.func_147439_a(i1, j1 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j1 - 1, k1, Blocks.field_150346_d, 0);
                }
            }
        }
        this.func_150516_a(world, i, j + 8, k, Blocks.field_150336_V, 0);
        this.func_150516_a(world, i, j + 9, k, Blocks.field_150336_V, 0);
        this.func_150516_a(world, i, j + 10, k, Blocks.field_150457_bL, 0);
        this.floorBlock = LOTRMod.planks;
        this.floorMeta = 0;
        this.floorStoneBlock = random.nextBoolean() ? Blocks.field_150336_V : (random.nextBoolean() ? Blocks.field_150347_e : Blocks.field_150417_aV);
        this.floorStoneMeta = 0;
        this.wallBlock = Blocks.field_150344_f;
        this.wallMeta = random.nextInt(3);
        this.wallHalfBlock = Blocks.field_150376_bx;
        this.wallHalfMeta = this.wallMeta;
        this.rugBlock = Blocks.field_150404_cg;
        this.rugMeta = random.nextInt(16);
        this.chandelierMeta = 1;
        if (random.nextBoolean()) {
            if (random.nextBoolean()) {
                this.fenceBlock = Blocks.field_150422_aJ;
                this.fenceMeta = 0;
            } else {
                this.fenceBlock = LOTRMod.fence;
                this.fenceMeta = 0;
            }
        } else {
            this.fenceBlock = Blocks.field_150463_bK;
            this.fenceMeta = 0;
        }
        this.isWealthy = false;
        if (random.nextInt(5) == 0) {
            this.wallBlock = LOTRMod.planks;
            this.wallMeta = 4 + random.nextInt(3);
            this.wallHalfBlock = LOTRMod.woodSlabSingle;
            this.wallHalfMeta = this.wallMeta;
            this.chandelierMeta = random.nextInt(4) == 0 ? 3 : 2;
            this.isWealthy = true;
        }
        if (this.wallBlock == Blocks.field_150344_f) {
            switch (this.wallMeta) {
                case 0: {
                    this.wallStairBlock = Blocks.field_150476_ad;
                    break;
                }
                case 1: {
                    this.wallStairBlock = Blocks.field_150485_bF;
                    break;
                }
                case 2: {
                    this.wallStairBlock = Blocks.field_150487_bG;
                }
            }
        } else if (this.wallBlock == LOTRMod.planks) {
            switch (this.wallMeta) {
                case 4: {
                    this.wallStairBlock = LOTRMod.stairsApple;
                    break;
                }
                case 5: {
                    this.wallStairBlock = LOTRMod.stairsPear;
                    break;
                }
                case 6: {
                    this.wallStairBlock = LOTRMod.stairsCherry;
                }
            }
        }
        boolean generated = false;
        switch (rotation) {
            case 0: {
                generated = this.generateFacingSouth(world, i, j, k, random);
                break;
            }
            case 1: {
                generated = this.generateFacingWest(world, i, j, k, random);
                break;
            }
            case 2: {
                generated = this.generateFacingNorth(world, i, j, k, random);
                break;
            }
            case 3: {
                generated = this.generateFacingEast(world, i, j, k, random);
            }
        }
        if (generated) {
            int k1;
            int i13;
            int decorationRadius = radius - 4;
            int grass = 1 + random.nextInt(3);
            for (int l = 0; l < grass; ++l) {
                i13 = i - decorationRadius + random.nextInt(decorationRadius * 2);
                k1 = k - decorationRadius + random.nextInt(decorationRadius * 2);
                LOTRBiome.shire.func_76730_b(random).func_76484_a(world, random, i13, world.func_72976_f(i13, k1), k1);
            }
            int flowers = 1 + random.nextInt(3);
            for (int l = 0; l < flowers; ++l) {
                int i14 = i - decorationRadius + random.nextInt(decorationRadius * 2);
                int k12 = k - decorationRadius + random.nextInt(decorationRadius * 2);
                LOTRBiome.shire.plantFlower(world, random, i14, world.func_72976_f(i14, k12), k12);
            }
            if (random.nextInt(4) == 0) {
                i13 = i - decorationRadius + random.nextInt(decorationRadius * 2);
                k1 = k - decorationRadius + random.nextInt(decorationRadius * 2);
                WorldGenAbstractTree treeGen = LOTRBiome.shire.func_150567_a(random);
                treeGen.func_76484_a(world, random, i13, world.func_72976_f(i13, k1), k1);
            }
            String[] names = LOTRNames.getRandomHobbitCoupleNames(random);
            LOTREntityHobbit hobbitMale = new LOTREntityHobbit(world);
            hobbitMale.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            hobbitMale.setHobbitName(names[0]);
            hobbitMale.setHobbitMale(true);
            hobbitMale.func_110171_b(i, j + 1, k, MathHelper.func_76128_c((double)((double)radius * 1.5)));
            hobbitMale.func_110161_a(null);
            hobbitMale.isNPCPersistent = true;
            world.func_72838_d((Entity)hobbitMale);
            LOTREntityHobbit hobbitFemale = new LOTREntityHobbit(world);
            hobbitFemale.func_70012_b((double)i + 0.5, j + 1, (double)k + 0.5, 0.0f, 0.0f);
            hobbitFemale.setHobbitName(names[1]);
            hobbitFemale.setHobbitMale(false);
            hobbitFemale.func_110171_b(i, j + 1, k, MathHelper.func_76128_c((double)((double)radius * 1.5)));
            hobbitFemale.func_110161_a(null);
            hobbitFemale.isNPCPersistent = true;
            world.func_72838_d((Entity)hobbitFemale);
            int maxChildren = 1 + random.nextInt(4);
            hobbitMale.func_70062_b(4, new ItemStack(LOTRMod.hobbitRing));
            hobbitMale.hobbitSpouseUniqueID = hobbitFemale.getPersistentID();
            hobbitMale.setHobbitAge(18000 + random.nextInt(12001));
            hobbitMale.maxChildren = maxChildren;
            hobbitFemale.func_70062_b(4, new ItemStack(LOTRMod.hobbitRing));
            hobbitFemale.hobbitSpouseUniqueID = hobbitMale.getPersistentID();
            hobbitFemale.setHobbitAge(18000 + random.nextInt(12001));
            hobbitFemale.maxChildren = maxChildren;
        }
        return generated;
    }

    private boolean generateFacingSouth(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int j12;
        int i12;
        int k1;
        for (k1 = k - 12; k1 >= k - 16; --k1) {
            for (int j13 = j + 1; j13 <= j + 4; ++j13) {
                for (i12 = i - 3; i12 <= i + 3; ++i12) {
                    this.func_150516_a(world, i12, j13, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k - 12; k1 >= k - 16; --k1) {
            for (int i13 = i - 4; i13 <= i + 4; ++i13) {
                for (j12 = j; j12 == j || !LOTRMod.isOpaque(world, i13, j12, k1) && j12 >= 0; --j12) {
                    boolean grass = j12 == j;
                    this.func_150516_a(world, i13, j12, k1, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                }
            }
        }
        for (k1 = k - 12; k1 >= k - 15; --k1) {
            this.func_150516_a(world, i + 3, j + 1, k1, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i - 3, j + 1, k1, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i, j, k1, Blocks.field_150351_n, 0);
        }
        this.func_150516_a(world, i, j, k - 11, Blocks.field_150351_n, 0);
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 15, this.fenceBlock, this.fenceMeta);
        }
        this.func_150516_a(world, i, j + 1, k - 15, Blocks.field_150396_be, 0);
        for (k1 = 0; k1 <= 2; ++k1) {
            BlockFlower flower = k1 == 1 ? Blocks.field_150328_O : Blocks.field_150327_N;
            this.func_150516_a(world, i + 1, j + 1, k - 12 - k1, (Block)flower, 0);
            this.func_150516_a(world, i - 1, j + 1, k - 12 - k1, (Block)flower, 0);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int i14 = i - 2; i14 <= i + 2; ++i14) {
                if (j1 >= j + 3 && Math.abs(i14 - i) >= 2) continue;
                this.func_150516_a(world, i14, j1, k - 11, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 1, j + 1, k - 11, this.wallStairBlock, 1);
        this.func_150516_a(world, i, j + 1, k - 11, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 1, j + 1, k - 11, this.wallStairBlock, 0);
        this.func_150516_a(world, i - 1, j + 2, k - 11, this.wallStairBlock, 5);
        this.func_150516_a(world, i, j + 2, k - 11, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 1, j + 2, k - 11, this.wallStairBlock, 4);
        for (k1 = k - 10; k1 <= k + 1; ++k1) {
            int j14;
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                for (i12 = i - 2; i12 <= i + 2; ++i12) {
                    if (k1 == k - 10) {
                        this.func_150516_a(world, i12, j14, k1, this.wallBlock, this.wallMeta);
                        continue;
                    }
                    this.func_150516_a(world, i12, j14, k1, Blocks.field_150350_a, 0);
                }
            }
            this.func_150516_a(world, i + 1, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i, j, k1, this.floorBlock, this.floorMeta);
            this.func_150516_a(world, i - 1, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            if (k1 == k - 10) continue;
            this.func_150516_a(world, i + 2, j + 1, k1, this.wallHalfBlock, this.wallHalfMeta);
            this.func_150516_a(world, i - 2, j + 1, k1, this.wallHalfBlock, this.wallHalfMeta);
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i + 3, j14, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i - 3, j14, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 2, j + 3, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 2, j + 3, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 1, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i - 1, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i, j + 1, k - 10, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i, j + 2, k - 10, Blocks.field_150466_ao, 8);
        for (k1 = k - 8; k1 <= k; k1 += 4) {
            this.func_150516_a(world, i, j + 3, k1, LOTRMod.chandelier, this.chandelierMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int i15 = i - 2; i15 <= i + 2; ++i15) {
                this.func_150516_a(world, i15, j1, k + 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i, j, k + 2, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k + 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i, j + 2, k + 2, Blocks.field_150350_a, 0);
        for (k1 = k + 3; k1 <= k + 9; ++k1) {
            for (int i16 = i - 3; i16 <= i + 3; ++i16) {
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i16, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i16, j + 4, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i16, j, k1, this.floorBlock, this.floorMeta);
            }
        }
        this.func_150516_a(world, i, j + 3, k + 6, LOTRMod.chandelier, this.chandelierMeta);
        for (k1 = k + 5; k1 <= k + 7; ++k1) {
            for (int i17 = i - 1; i17 <= i + 1; ++i17) {
                this.func_150516_a(world, i17, j + 1, k1, this.rugBlock, this.rugMeta);
            }
        }
        if (this.isWealthy && random.nextInt(4) == 0) {
            this.func_150516_a(world, i, j, k + 6, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i, j, k + 6, LOTRChestContents.HOBBIT_HOLE_TREASURE);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                this.func_150516_a(world, i1, j15, k + 10, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int j16 = j + 2; j16 <= j + 3; ++j16) {
                this.func_150516_a(world, i1, j16, k + 10, Blocks.field_150410_aZ, 0);
                this.func_150516_a(world, i1, j16, k + 10, Blocks.field_150410_aZ, 0);
                for (int k12 = k + 11; k12 <= k + 14; ++k12) {
                    this.func_150516_a(world, i1, j16, k12, Blocks.field_150350_a, 0);
                    if (world.func_147439_a(i1, j16 - 1, k12) != Blocks.field_150346_d) continue;
                    this.func_150516_a(world, i1, j16 - 1, k12, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i1, j + 4, k + 10, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k + 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j1, k + 3, this.wallBlock, this.wallMeta);
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 3, k + 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k + 4; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i - 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        this.func_150516_a(world, i - 3, j + 1, k + 8, Blocks.field_150476_ad, 1);
        this.func_150516_a(world, i + 3, j + 1, k + 8, Blocks.field_150476_ad, 0);
        for (k1 = k + 4; k1 <= k + 9; ++k1) {
            for (int j17 = j + 1; j17 <= j + 3; ++j17) {
                this.func_150516_a(world, i - 4, j17, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 4, j17, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 4, j + 1, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 4, j + 2, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 4, j + 1, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 4, j + 2, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 3, j + 2, k + 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 2, k + 4, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 2, k + 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 3, j + 2, k + 9, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 2, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 2, j, k - 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 3, j, k - 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 3, j + 1, k - 6, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 3, j + 2, k - 6, Blocks.field_150466_ao, 8);
        for (k1 = k - 8; k1 <= k - 3; ++k1) {
            for (int i18 = i + 4; i18 <= i + 8; ++i18) {
                if (i18 == i + 8 && k1 == k - 8) continue;
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i18, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i18, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                if (i18 >= i + 7 && k1 <= k - 7) continue;
                this.func_150516_a(world, i18, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i + 4; i1 <= i + 7; ++i1) {
            for (int j18 = j + 1; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i1, j18, k - 2, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j18, k - 8, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k - 7, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k - 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 7; k1 <= k - 3; ++k1) {
            for (int j19 = j + 1; j19 <= j + 3; ++j19) {
                this.func_150516_a(world, i + 8, j19, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            for (int i19 = i + 5; i19 <= i + 6; ++i19) {
                this.func_150516_a(world, i19, j1, k - 8, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i19, j1, k - 9, Blocks.field_150342_X, 0);
            }
            for (int k13 = k - 6; k13 <= k - 4; ++k13) {
                this.func_150516_a(world, i + 8, j1, k13, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i + 9, j1, k13, Blocks.field_150342_X, 0);
            }
        }
        this.func_150516_a(world, i + 6, j + 3, k - 5, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 5, j + 1, k - 5, Blocks.field_150476_ad, 3);
        this.func_150516_a(world, i + 5, j + 1, k - 3, (Block)Blocks.field_150376_bx, 8);
        this.func_150516_a(world, i + 7, j + 1, k - 3, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i + 7, j + 1, k - 3, LOTRChestContents.HOBBIT_HOLE_STUDY);
        this.func_150516_a(world, i - 2, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 2, j, k - 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 3, j, k - 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 3, j + 1, k - 6, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 3, j + 2, k - 6, Blocks.field_150466_ao, 8);
        for (k1 = k - 7; k1 <= k - 4; ++k1) {
            for (int i110 = i - 4; i110 >= i - 7; --i110) {
                this.func_150516_a(world, i110, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i110, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i110, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 4; i1 >= i - 7; --i1) {
            for (int j110 = j + 1; j110 <= j + 3; ++j110) {
                this.func_150516_a(world, i1, j110, k - 8, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j110, k - 3, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k - 7, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k - 4, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 7; k1 <= k - 3; ++k1) {
            for (int j111 = j + 1; j111 <= j + 3; ++j111) {
                this.func_150516_a(world, i - 8, j111, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 7; k1 <= k - 6; ++k1) {
            for (int i111 = i - 5; i111 >= i - 6; --i111) {
                this.func_150516_a(world, i111, j + 1, k1, this.rugBlock, this.rugMeta);
            }
        }
        for (i1 = i - 5; i1 >= i - 6; --i1) {
            this.func_150516_a(world, i1, j, k - 8, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i1, j + 1, k - 8, (Block)Blocks.field_150376_bx, 8);
            this.func_150516_a(world, i1, j + 2, k - 8, Blocks.field_150342_X, 0);
            this.func_150516_a(world, i1, j + 1, k - 9, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 4, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 7, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 2, k - 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 7, j + 2, k - 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 5, j + 1, k - 5, Blocks.field_150324_C, 0);
        this.func_150516_a(world, i - 5, j + 1, k - 4, Blocks.field_150324_C, 8);
        this.func_150516_a(world, i - 6, j + 1, k - 5, Blocks.field_150324_C, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 4, Blocks.field_150324_C, 8);
        this.func_150516_a(world, i + 4, j, k + 6, this.floorBlock, this.floorMeta);
        for (i1 = i + 5; i1 <= i + 6; ++i1) {
            this.func_150516_a(world, i1, j, k + 6, this.floorStoneBlock, this.floorStoneMeta);
            for (int j112 = j + 1; j112 <= j + 3; ++j112) {
                this.func_150516_a(world, i1, j112, k + 6, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k + 6, this.wallBlock, this.wallMeta);
        }
        for (i1 = i + 5; i1 <= i + 7; ++i1) {
            this.func_150516_a(world, i1, j, k + 5, this.floorStoneBlock, this.floorStoneMeta);
            for (int j113 = j + 1; j113 <= j + 3; ++j113) {
                this.func_150516_a(world, i1, j113, k + 5, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k + 5, this.wallBlock, this.wallMeta);
        }
        for (i1 = i + 5; i1 <= i + 8; ++i1) {
            this.func_150516_a(world, i1, j, k + 4, this.floorStoneBlock, this.floorStoneMeta);
            for (int j114 = j + 1; j114 <= j + 3; ++j114) {
                this.func_150516_a(world, i1, j114, k + 4, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k + 4, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 7, j1, k + 6, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 8, j1, k + 5, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 9, j1, k + 4, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 7, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 8, j + 2, k + 4, Blocks.field_150478_aa, 2);
        for (k1 = k + 3; k1 >= k - 1; --k1) {
            for (int i112 = i + 4; i112 <= i + 9; ++i112) {
                this.func_150516_a(world, i112, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i112, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i112, j + 4, k1, this.wallBlock, this.wallMeta);
            }
            for (int j115 = j + 1; j115 <= j + 3; ++j115) {
                this.func_150516_a(world, i + 3, j115, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 10, j115, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 4, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 9, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k + 2; k1 >= k; --k1) {
            this.func_150516_a(world, i + 4, j + 1, k1, Blocks.field_150476_ad, 1);
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        this.func_150516_a(world, i + 6, j + 3, k + 1, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 7, j + 3, k + 1, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 6, j + 1, k + 2, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 7, j + 1, k + 2, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 6, j + 1, k + 1, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i + 7, j + 1, k + 1, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i + 6, j + 1, k, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 7, j + 1, k, Blocks.field_150344_f, 1);
        for (i1 = i + 6; i1 <= i + 7; ++i1) {
            for (int k14 = k + 2; k14 >= k; --k14) {
                this.placePlate(world, i1, j + 2, k14, random, LOTRFoods.HOBBIT);
            }
        }
        this.func_150516_a(world, i + 5, j + 3, k + 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 6, j + 3, k + 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 7, j + 3, k + 5, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 8, j + 3, k + 4, this.wallHalfBlock, this.wallHalfMeta | 8);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            int i113;
            for (i113 = i + 5; i113 <= i + 6; ++i113) {
                this.func_150516_a(world, i113, j1, k + 7, this.wallBlock, this.wallMeta);
            }
            for (i113 = i + 8; i113 <= i + 9; ++i113) {
                this.func_150516_a(world, i113, j1, k - 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 4, j, k + 6, this.floorBlock, this.floorMeta);
        for (k1 = k + 7; k1 >= k + 3; --k1) {
            for (int i114 = i - 5; i114 >= i - 7; --i114) {
                this.func_150516_a(world, i114, j, k1, (Block)Blocks.field_150334_T, 0);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i114, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i114, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k + 6; k1 >= k + 3; --k1) {
            for (int i115 = i - 5; i115 >= i - 6; --i115) {
                this.func_150516_a(world, i115, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            }
        }
        this.func_150516_a(world, i - 5, j + 1, k + 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 5, j + 2, k + 8, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k + 8, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 5, j + 2, k + 9, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 6, j + 2, k + 9, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 5, j + 3, k + 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 6, j + 3, k + 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 7, j + 3, k + 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 7, j + 1, k + 8, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 7, j + 2, k + 8, this.wallBlock, this.wallMeta);
        for (k1 = k + 6; k1 <= k + 7; ++k1) {
            for (int j116 = j + 1; j116 <= j + 3; ++j116) {
                this.func_150516_a(world, i - 8, j116, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k + 3; k1 <= k + 5; ++k1) {
            this.func_150516_a(world, i - 8, j, k1, (Block)Blocks.field_150334_T, 0);
            this.func_150516_a(world, i - 8, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 9, j + 2, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 8, j + 3, k1, (Block)Blocks.field_150334_T, 0);
        }
        this.func_150516_a(world, i - 8, j + 1, k + 4, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 8, j + 1, k + 5, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i - 8, j + 1, k + 3, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i - 8, j + 1, k + 4, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i - 6, j + 3, k + 5, LOTRMod.chandelier, this.chandelierMeta);
        for (i1 = i - 4; i1 >= i - 9; --i1) {
            for (int j117 = j + 1; j117 <= j + 3; ++j117) {
                this.func_150516_a(world, i1, j117, k + 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j, k + 2, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 6, j + 1, k + 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k + 2, Blocks.field_150350_a, 0);
        for (k1 = k + 1; k1 >= k - 2; --k1) {
            for (int i116 = i - 4; i116 >= i - 9; --i116) {
                this.func_150516_a(world, i116, j, k1, this.floorBlock, this.floorMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i116, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i116, j + 4, k1, (Block)Blocks.field_150334_T, 0);
            }
            this.func_150516_a(world, i - 4, j + 1, k1, (Block)Blocks.field_150376_bx, 8);
            for (int j118 = j + 1; j118 <= j + 3; ++j118) {
                this.func_150516_a(world, i - 10, j118, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j + 2, k - 2, Blocks.field_150478_aa, 3);
        int pastries = 1 + random.nextInt(5);
        for (int l = 0; l < pastries; ++l) {
            Block block = LOTRWorldGenHobbitHole.getRandomFoodBlock(random);
            this.func_150516_a(world, i - 4, j + 2, k - 2 + random.nextInt(4), block, 0);
        }
        for (int j119 = j + 1; j119 <= j + 3; ++j119) {
            this.func_150516_a(world, i - 9, j119, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 4, j119, k + 3, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 8, j + 1, k - 2, (Block)Blocks.field_150486_ae, 3);
        this.func_150516_a(world, i - 9, j + 1, k - 2, (Block)Blocks.field_150486_ae, 3);
        this.func_150516_a(world, i - 8, j + 1, k + 1, (Block)Blocks.field_150486_ae, 2);
        this.func_150516_a(world, i - 9, j + 1, k + 1, (Block)Blocks.field_150486_ae, 2);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k - 2, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k - 2, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k + 1, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k + 1, LOTRChestContents.HOBBIT_HOLE_LARDER);
        return true;
    }

    private boolean generateFacingWest(World world, int i, int j, int k, Random random) {
        int j1;
        int k1;
        int j12;
        int k12;
        int i1;
        for (i1 = i + 12; i1 <= i + 16; ++i1) {
            for (int j13 = j + 1; j13 <= j + 4; ++j13) {
                for (k12 = k - 3; k12 <= k + 3; ++k12) {
                    this.func_150516_a(world, i1, j13, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i + 12; i1 <= i + 16; ++i1) {
            for (int k13 = k - 4; k13 <= k + 4; ++k13) {
                for (j12 = j; j12 == j || !LOTRMod.isOpaque(world, i1, j12, k13) && j12 >= 0; --j12) {
                    boolean grass = j12 == j;
                    this.func_150516_a(world, i1, j12, k13, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                }
            }
        }
        for (i1 = i + 12; i1 <= i + 15; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 3, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i1, j + 1, k - 3, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i1, j, k, Blocks.field_150351_n, 0);
        }
        this.func_150516_a(world, i + 11, j, k, Blocks.field_150351_n, 0);
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i + 15, j + 1, k1, this.fenceBlock, this.fenceMeta);
        }
        this.func_150516_a(world, i + 15, j + 1, k, Blocks.field_150396_be, 1);
        for (i1 = 0; i1 <= 2; ++i1) {
            BlockFlower flower = i1 == 1 ? Blocks.field_150328_O : Blocks.field_150327_N;
            this.func_150516_a(world, i + 12 + i1, j + 1, k + 1, (Block)flower, 0);
            this.func_150516_a(world, i + 12 + i1, j + 1, k - 1, (Block)flower, 0);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int k14 = k - 2; k14 <= k + 2; ++k14) {
                if (j1 >= j + 3 && Math.abs(k14 - k) >= 2) continue;
                this.func_150516_a(world, i + 11, j1, k14, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 11, j + 1, k - 1, this.wallStairBlock, 3);
        this.func_150516_a(world, i + 11, j + 1, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 11, j + 1, k + 1, this.wallStairBlock, 2);
        this.func_150516_a(world, i + 11, j + 2, k - 1, this.wallStairBlock, 7);
        this.func_150516_a(world, i + 11, j + 2, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 11, j + 2, k + 1, this.wallStairBlock, 6);
        for (i1 = i + 10; i1 >= i - 1; --i1) {
            int j14;
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                for (k12 = k - 2; k12 <= k + 2; ++k12) {
                    if (i1 == i + 10) {
                        this.func_150516_a(world, i1, j14, k12, this.wallBlock, this.wallMeta);
                        continue;
                    }
                    this.func_150516_a(world, i1, j14, k12, Blocks.field_150350_a, 0);
                }
            }
            this.func_150516_a(world, i1, j, k + 1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i1, j, k, this.floorBlock, this.floorMeta);
            this.func_150516_a(world, i1, j, k - 1, this.floorStoneBlock, this.floorStoneMeta);
            if (i1 == i + 10) continue;
            this.func_150516_a(world, i1, j + 1, k + 2, this.wallHalfBlock, this.wallHalfMeta);
            this.func_150516_a(world, i1, j + 1, k - 2, this.wallHalfBlock, this.wallHalfMeta);
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i1, j14, k + 3, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j14, k - 3, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 2, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k - 2, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k + 1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k - 1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 4, k, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 10, j + 1, k, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 10, j + 2, k, Blocks.field_150466_ao, 8);
        for (i1 = i + 8; i1 >= i; i1 -= 4) {
            this.func_150516_a(world, i1, j + 3, k, LOTRMod.chandelier, this.chandelierMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int k15 = k - 2; k15 <= k + 2; ++k15) {
                this.func_150516_a(world, i - 2, j1, k15, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 2, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 2, j + 1, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 2, j + 2, k, Blocks.field_150350_a, 0);
        for (i1 = i - 3; i1 >= i - 9; --i1) {
            for (int k16 = k - 3; k16 <= k + 3; ++k16) {
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k16, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k16, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j, k16, this.floorBlock, this.floorMeta);
            }
        }
        this.func_150516_a(world, i - 6, j + 3, k, LOTRMod.chandelier, this.chandelierMeta);
        for (i1 = i - 5; i1 >= i - 7; --i1) {
            for (int k17 = k - 1; k17 <= k + 1; ++k17) {
                this.func_150516_a(world, i1, j + 1, k17, this.rugBlock, this.rugMeta);
            }
        }
        if (this.isWealthy && random.nextInt(4) == 0) {
            this.func_150516_a(world, i - 6, j, k, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i - 6, j, k, LOTRChestContents.HOBBIT_HOLE_TREASURE);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                this.func_150516_a(world, i - 10, j15, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (int j16 = j + 2; j16 <= j + 3; ++j16) {
                this.func_150516_a(world, i - 10, j16, k1, Blocks.field_150410_aZ, 0);
                this.func_150516_a(world, i - 10, j16, k1, Blocks.field_150410_aZ, 0);
                for (int i12 = i - 11; i12 >= i - 14; --i12) {
                    this.func_150516_a(world, i12, j16, k1, Blocks.field_150350_a, 0);
                    if (world.func_147439_a(i12, j16 - 1, k1) != Blocks.field_150346_d) continue;
                    this.func_150516_a(world, i12, j16 - 1, k1, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i - 10, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 3, j1, k + 3, this.wallBlock, this.wallMeta);
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 4; i1 >= i - 9; --i1) {
            this.func_150516_a(world, i1, j + 3, k - 3, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i - 9, j + 1, k1, Blocks.field_150476_ad, 1);
        }
        this.func_150516_a(world, i - 8, j + 1, k - 3, Blocks.field_150476_ad, 3);
        this.func_150516_a(world, i - 8, j + 1, k + 3, Blocks.field_150476_ad, 2);
        for (i1 = i - 4; i1 >= i - 9; --i1) {
            for (int j17 = j + 1; j17 <= j + 3; ++j17) {
                this.func_150516_a(world, i1, j17, k - 4, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j17, k + 4, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j + 1, k - 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k + 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 4, j + 2, k - 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 4, j + 2, k + 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 9, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 9, j + 2, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 6, j + 1, k + 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 6, j, k + 2, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 6, j, k + 3, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 6, j + 1, k + 3, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i + 6, j + 2, k + 3, Blocks.field_150466_ao, 8);
        for (i1 = i + 8; i1 >= i + 3; --i1) {
            for (int k18 = k + 4; k18 <= k + 8; ++k18) {
                if (i1 == i + 8 && k18 == k + 8) continue;
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k18, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j, k18, this.floorStoneBlock, this.floorStoneMeta);
                if (i1 >= i + 7 && k18 >= k + 7) continue;
                this.func_150516_a(world, i1, j + 4, k18, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k + 4; k1 <= k + 7; ++k1) {
            for (int j18 = j + 1; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i + 2, j18, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 8, j18, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 7, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i + 7; i1 >= i + 3; --i1) {
            for (int j19 = j + 1; j19 <= j + 3; ++j19) {
                this.func_150516_a(world, i1, j19, k + 8, this.wallBlock, this.wallMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            for (int k19 = k + 5; k19 <= k + 6; ++k19) {
                this.func_150516_a(world, i + 8, j1, k19, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i + 9, j1, k19, Blocks.field_150342_X, 0);
            }
            for (int i13 = i + 6; i13 >= i + 4; --i13) {
                this.func_150516_a(world, i13, j1, k + 8, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i13, j1, k + 9, Blocks.field_150342_X, 0);
            }
        }
        this.func_150516_a(world, i + 5, j + 3, k + 6, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 5, j + 1, k + 5, Blocks.field_150476_ad, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 5, (Block)Blocks.field_150376_bx, 8);
        this.func_150516_a(world, i + 3, j + 1, k + 7, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i + 3, j + 1, k + 7, LOTRChestContents.HOBBIT_HOLE_STUDY);
        this.func_150516_a(world, i + 6, j + 1, k - 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 6, j, k - 2, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 6, j, k - 3, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 6, j + 1, k - 3, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i + 6, j + 2, k - 3, Blocks.field_150466_ao, 8);
        for (i1 = i + 7; i1 >= i + 4; --i1) {
            for (int k110 = k - 4; k110 >= k - 7; --k110) {
                this.func_150516_a(world, i1, j, k110, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k110, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k110, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 4; k1 >= k - 7; --k1) {
            for (int j110 = j + 1; j110 <= j + 3; ++j110) {
                this.func_150516_a(world, i + 8, j110, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 3, j110, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 7, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 4, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i + 7; i1 >= i + 3; --i1) {
            for (int j111 = j + 1; j111 <= j + 3; ++j111) {
                this.func_150516_a(world, i1, j111, k - 8, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i + 7; i1 >= i + 6; --i1) {
            for (int k111 = k - 5; k111 >= k - 6; --k111) {
                this.func_150516_a(world, i1, j + 1, k111, this.rugBlock, this.rugMeta);
            }
        }
        for (k1 = k - 5; k1 >= k - 6; --k1) {
            this.func_150516_a(world, i + 8, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i + 8, j + 1, k1, (Block)Blocks.field_150376_bx, 8);
            this.func_150516_a(world, i + 8, j + 2, k1, Blocks.field_150342_X, 0);
            this.func_150516_a(world, i + 9, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 4, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 4, j + 1, k - 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 4, j + 2, k - 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 4, j + 2, k - 7, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i + 5, j + 1, k - 5, Blocks.field_150324_C, 1);
        this.func_150516_a(world, i + 4, j + 1, k - 5, Blocks.field_150324_C, 9);
        this.func_150516_a(world, i + 5, j + 1, k - 6, Blocks.field_150324_C, 1);
        this.func_150516_a(world, i + 4, j + 1, k - 6, Blocks.field_150324_C, 9);
        this.func_150516_a(world, i - 6, j, k + 4, this.floorBlock, this.floorMeta);
        for (k1 = k + 5; k1 <= k + 6; ++k1) {
            this.func_150516_a(world, i - 6, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j112 = j + 1; j112 <= j + 3; ++j112) {
                this.func_150516_a(world, i - 6, j112, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i - 6, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (k1 = k + 5; k1 <= k + 7; ++k1) {
            this.func_150516_a(world, i - 5, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j113 = j + 1; j113 <= j + 3; ++j113) {
                this.func_150516_a(world, i - 5, j113, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i - 5, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (k1 = k + 5; k1 <= k + 8; ++k1) {
            this.func_150516_a(world, i - 4, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j114 = j + 1; j114 <= j + 3; ++j114) {
                this.func_150516_a(world, i - 4, j114, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i - 4, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 6, j1, k + 7, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 5, j1, k + 8, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 4, j1, k + 9, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 5, j + 2, k + 7, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 4, j + 2, k + 8, Blocks.field_150478_aa, 4);
        for (i1 = i - 3; i1 <= i + 1; ++i1) {
            for (int k112 = k + 4; k112 <= k + 9; ++k112) {
                this.func_150516_a(world, i1, j, k112, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k112, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k112, this.wallBlock, this.wallMeta);
            }
            for (int j115 = j + 1; j115 <= j + 3; ++j115) {
                this.func_150516_a(world, i1, j115, k + 3, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j115, k + 10, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 4, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 9, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 2; i1 <= i; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 4, Blocks.field_150476_ad, 3);
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        this.func_150516_a(world, i - 1, j + 3, k + 6, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i - 1, j + 3, k + 7, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i - 2, j + 1, k + 6, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 2, j + 1, k + 7, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i - 1, j + 1, k + 6, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i - 1, j + 1, k + 7, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i, j + 1, k + 6, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i, j + 1, k + 7, Blocks.field_150344_f, 1);
        for (i1 = i - 2; i1 <= i; ++i1) {
            for (int k113 = k + 6; k113 <= k + 7; ++k113) {
                this.placePlate(world, i1, j + 2, k113, random, LOTRFoods.HOBBIT);
            }
        }
        this.func_150516_a(world, i - 6, j + 3, k + 5, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i - 6, j + 3, k + 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i - 5, j + 3, k + 7, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i - 4, j + 3, k + 8, this.wallHalfBlock, this.wallHalfMeta | 8);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            int k114;
            for (k114 = k + 5; k114 <= k + 6; ++k114) {
                this.func_150516_a(world, i - 7, j1, k114, this.wallBlock, this.wallMeta);
            }
            for (k114 = k + 8; k114 <= k + 9; ++k114) {
                this.func_150516_a(world, i + 2, j1, k114, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j, k - 4, this.floorBlock, this.floorMeta);
        for (i1 = i - 7; i1 <= i - 3; ++i1) {
            for (int k115 = k - 5; k115 >= k - 7; --k115) {
                this.func_150516_a(world, i1, j, k115, (Block)Blocks.field_150334_T, 0);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k115, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k115, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 6; i1 <= i - 3; ++i1) {
            for (int k116 = k - 5; k116 >= k - 6; --k116) {
                this.func_150516_a(world, i1, j, k116, this.floorStoneBlock, this.floorStoneMeta);
            }
        }
        this.func_150516_a(world, i - 8, j + 1, k - 5, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 8, j + 1, k - 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 8, j + 2, k - 5, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 8, j + 2, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 9, j + 2, k - 5, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 9, j + 2, k - 6, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 8, j + 3, k - 5, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 8, j + 3, k - 6, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 8, j + 3, k - 7, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 8, j + 1, k - 7, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 8, j + 2, k - 7, this.wallBlock, this.wallMeta);
        for (i1 = i - 6; i1 >= i - 7; --i1) {
            for (int j116 = j + 1; j116 <= j + 3; ++j116) {
                this.func_150516_a(world, i1, j116, k - 8, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 3; i1 >= i - 5; --i1) {
            this.func_150516_a(world, i1, j, k - 8, (Block)Blocks.field_150334_T, 0);
            this.func_150516_a(world, i1, j + 2, k - 8, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 2, k - 9, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k - 8, (Block)Blocks.field_150334_T, 0);
        }
        this.func_150516_a(world, i - 4, j + 1, k - 8, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 5, j + 1, k - 8, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i - 3, j + 1, k - 8, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i - 4, j + 1, k - 8, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i - 5, j + 3, k - 6, LOTRMod.chandelier, this.chandelierMeta);
        for (k1 = k - 4; k1 >= k - 9; --k1) {
            for (int j117 = j + 1; j117 <= j + 3; ++j117) {
                this.func_150516_a(world, i - 2, j117, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 2, j, k - 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 2, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 2, j + 2, k - 6, Blocks.field_150350_a, 0);
        for (i1 = i - 1; i1 <= i + 2; ++i1) {
            for (int k117 = k - 4; k117 >= k - 9; --k117) {
                this.func_150516_a(world, i1, j, k117, this.floorBlock, this.floorMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k117, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k117, (Block)Blocks.field_150334_T, 0);
            }
            this.func_150516_a(world, i1, j + 1, k - 4, (Block)Blocks.field_150376_bx, 8);
            for (int j118 = j + 1; j118 <= j + 3; ++j118) {
                this.func_150516_a(world, i1, j118, k - 10, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 2, j + 2, k - 6, Blocks.field_150478_aa, 2);
        int pastries = 1 + random.nextInt(5);
        for (int l = 0; l < pastries; ++l) {
            Block block = LOTRWorldGenHobbitHole.getRandomFoodBlock(random);
            this.func_150516_a(world, i + 2 - random.nextInt(4), j + 2, k - 4, block, 0);
        }
        for (int j119 = j + 1; j119 <= j + 3; ++j119) {
            this.func_150516_a(world, i + 3, j119, k - 9, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 3, j119, k - 4, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 2, j + 1, k - 8, (Block)Blocks.field_150486_ae, 4);
        this.func_150516_a(world, i + 2, j + 1, k - 9, (Block)Blocks.field_150486_ae, 4);
        this.func_150516_a(world, i - 1, j + 1, k - 8, (Block)Blocks.field_150486_ae, 5);
        this.func_150516_a(world, i - 1, j + 1, k - 9, (Block)Blocks.field_150486_ae, 5);
        LOTRChestContents.fillChest(world, random, i + 2, j + 1, k - 8, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i + 2, j + 1, k - 9, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 1, j + 1, k - 8, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 1, j + 1, k - 9, LOTRChestContents.HOBBIT_HOLE_LARDER);
        return true;
    }

    private boolean generateFacingNorth(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int j12;
        int i12;
        int k1;
        for (k1 = k + 12; k1 <= k + 16; ++k1) {
            for (int j13 = j + 1; j13 <= j + 4; ++j13) {
                for (i12 = i - 3; i12 <= i + 3; ++i12) {
                    this.func_150516_a(world, i12, j13, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k + 12; k1 <= k + 16; ++k1) {
            for (int i13 = i - 4; i13 <= i + 4; ++i13) {
                for (j12 = j; j12 == j || !LOTRMod.isOpaque(world, i13, j12, k1) && j12 >= 0; --j12) {
                    boolean grass = j12 == j;
                    this.func_150516_a(world, i13, j12, k1, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                }
            }
        }
        for (k1 = k + 12; k1 <= k + 15; ++k1) {
            this.func_150516_a(world, i + 3, j + 1, k1, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i - 3, j + 1, k1, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i, j, k1, Blocks.field_150351_n, 0);
        }
        this.func_150516_a(world, i, j, k + 11, Blocks.field_150351_n, 0);
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 15, this.fenceBlock, this.fenceMeta);
        }
        this.func_150516_a(world, i, j + 1, k + 15, Blocks.field_150396_be, 0);
        for (k1 = 0; k1 <= 2; ++k1) {
            BlockFlower flower = k1 == 1 ? Blocks.field_150328_O : Blocks.field_150327_N;
            this.func_150516_a(world, i + 1, j + 1, k + 12 + k1, (Block)flower, 0);
            this.func_150516_a(world, i - 1, j + 1, k + 12 + k1, (Block)flower, 0);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int i14 = i - 2; i14 <= i + 2; ++i14) {
                if (j1 >= j + 3 && Math.abs(i14 - i) >= 2) continue;
                this.func_150516_a(world, i14, j1, k + 11, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 1, j + 1, k + 11, this.wallStairBlock, 1);
        this.func_150516_a(world, i, j + 1, k + 11, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 1, j + 1, k + 11, this.wallStairBlock, 0);
        this.func_150516_a(world, i - 1, j + 2, k + 11, this.wallStairBlock, 5);
        this.func_150516_a(world, i, j + 2, k + 11, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 1, j + 2, k + 11, this.wallStairBlock, 4);
        for (k1 = k + 10; k1 >= k - 1; --k1) {
            int j14;
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                for (i12 = i - 2; i12 <= i + 2; ++i12) {
                    if (k1 == k + 10) {
                        this.func_150516_a(world, i12, j14, k1, this.wallBlock, this.wallMeta);
                        continue;
                    }
                    this.func_150516_a(world, i12, j14, k1, Blocks.field_150350_a, 0);
                }
            }
            this.func_150516_a(world, i + 1, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i, j, k1, this.floorBlock, this.floorMeta);
            this.func_150516_a(world, i - 1, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            if (k1 == k + 10) continue;
            this.func_150516_a(world, i + 2, j + 1, k1, this.wallHalfBlock, this.wallHalfMeta);
            this.func_150516_a(world, i - 2, j + 1, k1, this.wallHalfBlock, this.wallHalfMeta);
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i + 3, j14, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i - 3, j14, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 2, j + 3, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 2, j + 3, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 1, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i - 1, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i, j + 1, k + 10, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i, j + 2, k + 10, Blocks.field_150466_ao, 8);
        for (k1 = k + 8; k1 >= k; k1 -= 4) {
            this.func_150516_a(world, i, j + 3, k1, LOTRMod.chandelier, this.chandelierMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int i15 = i - 2; i15 <= i + 2; ++i15) {
                this.func_150516_a(world, i15, j1, k - 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i, j, k - 2, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i, j + 1, k - 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i, j + 2, k - 2, Blocks.field_150350_a, 0);
        for (k1 = k - 3; k1 >= k - 9; --k1) {
            for (int i16 = i - 3; i16 <= i + 3; ++i16) {
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i16, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i16, j + 4, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i16, j, k1, this.floorBlock, this.floorMeta);
            }
        }
        this.func_150516_a(world, i, j + 3, k - 6, LOTRMod.chandelier, this.chandelierMeta);
        for (k1 = k - 5; k1 >= k - 7; --k1) {
            for (int i17 = i - 1; i17 <= i + 1; ++i17) {
                this.func_150516_a(world, i17, j + 1, k1, this.rugBlock, this.rugMeta);
            }
        }
        if (this.isWealthy && random.nextInt(4) == 0) {
            this.func_150516_a(world, i, j, k - 6, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i, j, k - 6, LOTRChestContents.HOBBIT_HOLE_TREASURE);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                this.func_150516_a(world, i1, j15, k - 10, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int j16 = j + 2; j16 <= j + 3; ++j16) {
                this.func_150516_a(world, i1, j16, k - 10, Blocks.field_150410_aZ, 0);
                this.func_150516_a(world, i1, j16, k - 10, Blocks.field_150410_aZ, 0);
                for (int k12 = k - 11; k12 >= k - 14; --k12) {
                    this.func_150516_a(world, i1, j16, k12, Blocks.field_150350_a, 0);
                    if (world.func_147439_a(i1, j16 - 1, k12) != Blocks.field_150346_d) continue;
                    this.func_150516_a(world, i1, j16 - 1, k12, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i1, j + 4, k - 10, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j1, k - 3, this.wallBlock, this.wallMeta);
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 3, k - 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 4; k1 >= k - 9; --k1) {
            this.func_150516_a(world, i - 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 9, Blocks.field_150476_ad, 3);
        }
        this.func_150516_a(world, i - 3, j + 1, k - 8, Blocks.field_150476_ad, 1);
        this.func_150516_a(world, i + 3, j + 1, k - 8, Blocks.field_150476_ad, 0);
        for (k1 = k - 4; k1 >= k - 9; --k1) {
            for (int j17 = j + 1; j17 <= j + 3; ++j17) {
                this.func_150516_a(world, i - 4, j17, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 4, j17, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 4, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 4, j + 2, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 4, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 4, j + 2, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 3, j + 2, k - 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 2, k - 4, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 3, j + 2, k - 9, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 3, j + 2, k - 9, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 2, j + 1, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 2, j, k + 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 3, j, k + 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i + 3, j + 1, k + 6, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 3, j + 2, k + 6, Blocks.field_150466_ao, 8);
        for (k1 = k + 8; k1 >= k + 3; --k1) {
            for (int i18 = i + 4; i18 <= i + 8; ++i18) {
                if (i18 == i + 8 && k1 == k + 8) continue;
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i18, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i18, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                if (i18 >= i + 7 && k1 >= k + 7) continue;
                this.func_150516_a(world, i18, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i + 4; i1 <= i + 7; ++i1) {
            for (int j18 = j + 1; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i1, j18, k + 2, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j18, k + 8, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 7, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k + 7; k1 >= k + 3; --k1) {
            for (int j19 = j + 1; j19 <= j + 3; ++j19) {
                this.func_150516_a(world, i + 8, j19, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            for (int i19 = i + 5; i19 <= i + 6; ++i19) {
                this.func_150516_a(world, i19, j1, k + 8, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i19, j1, k + 9, Blocks.field_150342_X, 0);
            }
            for (int k13 = k + 6; k13 >= k + 4; --k13) {
                this.func_150516_a(world, i + 8, j1, k13, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i + 9, j1, k13, Blocks.field_150342_X, 0);
            }
        }
        this.func_150516_a(world, i + 6, j + 3, k + 5, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 5, j + 1, k + 5, Blocks.field_150476_ad, 2);
        this.func_150516_a(world, i + 5, j + 1, k + 3, (Block)Blocks.field_150376_bx, 8);
        this.func_150516_a(world, i + 7, j + 1, k + 3, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i + 7, j + 1, k + 3, LOTRChestContents.HOBBIT_HOLE_STUDY);
        this.func_150516_a(world, i - 2, j + 1, k + 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 2, j, k + 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 3, j, k + 6, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 3, j + 1, k + 6, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 3, j + 2, k + 6, Blocks.field_150466_ao, 8);
        for (k1 = k + 7; k1 >= k + 4; --k1) {
            for (int i110 = i - 4; i110 >= i - 7; --i110) {
                this.func_150516_a(world, i110, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i110, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i110, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 4; i1 >= i - 7; --i1) {
            for (int j110 = j + 1; j110 <= j + 3; ++j110) {
                this.func_150516_a(world, i1, j110, k + 8, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j110, k + 3, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 7, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 4, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k + 7; k1 >= k + 3; --k1) {
            for (int j111 = j + 1; j111 <= j + 3; ++j111) {
                this.func_150516_a(world, i - 8, j111, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k + 7; k1 >= k + 6; --k1) {
            for (int i111 = i - 5; i111 >= i - 6; --i111) {
                this.func_150516_a(world, i111, j + 1, k1, this.rugBlock, this.rugMeta);
            }
        }
        for (i1 = i - 5; i1 >= i - 6; --i1) {
            this.func_150516_a(world, i1, j, k + 8, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i1, j + 1, k + 8, (Block)Blocks.field_150376_bx, 8);
            this.func_150516_a(world, i1, j + 2, k + 8, Blocks.field_150342_X, 0);
            this.func_150516_a(world, i1, j + 1, k + 9, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 4, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 7, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 2, k + 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 7, j + 2, k + 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 5, j + 1, k + 5, Blocks.field_150324_C, 2);
        this.func_150516_a(world, i - 5, j + 1, k + 4, Blocks.field_150324_C, 10);
        this.func_150516_a(world, i - 6, j + 1, k + 5, Blocks.field_150324_C, 2);
        this.func_150516_a(world, i - 6, j + 1, k + 4, Blocks.field_150324_C, 10);
        this.func_150516_a(world, i + 4, j, k - 6, this.floorBlock, this.floorMeta);
        for (i1 = i + 5; i1 <= i + 6; ++i1) {
            this.func_150516_a(world, i1, j, k - 6, this.floorStoneBlock, this.floorStoneMeta);
            for (int j112 = j + 1; j112 <= j + 3; ++j112) {
                this.func_150516_a(world, i1, j112, k - 6, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k - 6, this.wallBlock, this.wallMeta);
        }
        for (i1 = i + 5; i1 <= i + 7; ++i1) {
            this.func_150516_a(world, i1, j, k - 5, this.floorStoneBlock, this.floorStoneMeta);
            for (int j113 = j + 1; j113 <= j + 3; ++j113) {
                this.func_150516_a(world, i1, j113, k - 5, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k - 5, this.wallBlock, this.wallMeta);
        }
        for (i1 = i + 5; i1 <= i + 8; ++i1) {
            this.func_150516_a(world, i1, j, k - 4, this.floorStoneBlock, this.floorStoneMeta);
            for (int j114 = j + 1; j114 <= j + 3; ++j114) {
                this.func_150516_a(world, i1, j114, k - 4, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j + 4, k - 4, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 7, j1, k - 6, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 8, j1, k - 5, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 9, j1, k - 4, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 7, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 8, j + 2, k - 4, Blocks.field_150478_aa, 0);
        for (k1 = k - 3; k1 <= k + 1; ++k1) {
            for (int i112 = i + 4; i112 <= i + 9; ++i112) {
                this.func_150516_a(world, i112, j, k1, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i112, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i112, j + 4, k1, this.wallBlock, this.wallMeta);
            }
            for (int j115 = j + 1; j115 <= j + 3; ++j115) {
                this.func_150516_a(world, i + 3, j115, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i + 10, j115, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i + 4, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i + 9, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 2; k1 <= k; ++k1) {
            this.func_150516_a(world, i + 4, j + 1, k1, Blocks.field_150476_ad, 1);
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        this.func_150516_a(world, i + 6, j + 3, k - 1, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 7, j + 3, k - 1, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 6, j + 1, k - 2, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 7, j + 1, k - 2, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 6, j + 1, k - 1, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i + 7, j + 1, k - 1, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i + 6, j + 1, k, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 7, j + 1, k, Blocks.field_150344_f, 1);
        for (i1 = i + 6; i1 <= i + 7; ++i1) {
            for (int k14 = k - 2; k14 <= k; ++k14) {
                this.placePlate(world, i1, j + 2, k14, random, LOTRFoods.HOBBIT);
            }
        }
        this.func_150516_a(world, i + 5, j + 3, k - 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 6, j + 3, k - 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 7, j + 3, k - 5, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 8, j + 3, k - 4, this.wallHalfBlock, this.wallHalfMeta | 8);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            int i113;
            for (i113 = i + 5; i113 <= i + 6; ++i113) {
                this.func_150516_a(world, i113, j1, k - 7, this.wallBlock, this.wallMeta);
            }
            for (i113 = i + 8; i113 <= i + 9; ++i113) {
                this.func_150516_a(world, i113, j1, k + 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 4, j, k - 6, this.floorBlock, this.floorMeta);
        for (k1 = k - 7; k1 <= k - 3; ++k1) {
            for (int i114 = i - 5; i114 >= i - 7; --i114) {
                this.func_150516_a(world, i114, j, k1, (Block)Blocks.field_150334_T, 0);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i114, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i114, j + 4, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 6; k1 <= k - 3; ++k1) {
            for (int i115 = i - 5; i115 >= i - 6; --i115) {
                this.func_150516_a(world, i115, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            }
        }
        this.func_150516_a(world, i - 5, j + 1, k - 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 6, j + 1, k - 8, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 8, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 8, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 5, j + 2, k - 9, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 6, j + 2, k - 9, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 5, j + 3, k - 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 6, j + 3, k - 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 7, j + 3, k - 8, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i - 7, j + 1, k - 8, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 7, j + 2, k - 8, this.wallBlock, this.wallMeta);
        for (k1 = k - 6; k1 >= k - 7; --k1) {
            for (int j116 = j + 1; j116 <= j + 3; ++j116) {
                this.func_150516_a(world, i - 8, j116, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 3; k1 >= k - 5; --k1) {
            this.func_150516_a(world, i - 8, j, k1, (Block)Blocks.field_150334_T, 0);
            this.func_150516_a(world, i - 8, j + 2, k1, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i - 9, j + 2, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 8, j + 3, k1, (Block)Blocks.field_150334_T, 0);
        }
        this.func_150516_a(world, i - 8, j + 1, k - 4, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i - 8, j + 1, k - 5, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i - 8, j + 1, k - 3, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i - 8, j + 1, k - 4, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i - 6, j + 3, k - 5, LOTRMod.chandelier, this.chandelierMeta);
        for (i1 = i - 4; i1 >= i - 9; --i1) {
            for (int j117 = j + 1; j117 <= j + 3; ++j117) {
                this.func_150516_a(world, i1, j117, k - 2, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j, k - 2, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 6, j + 1, k - 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j + 2, k - 2, Blocks.field_150350_a, 0);
        for (k1 = k - 1; k1 <= k + 2; ++k1) {
            for (int i116 = i - 4; i116 >= i - 9; --i116) {
                this.func_150516_a(world, i116, j, k1, this.floorBlock, this.floorMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i116, j12, k1, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i116, j + 4, k1, (Block)Blocks.field_150334_T, 0);
            }
            this.func_150516_a(world, i - 4, j + 1, k1, (Block)Blocks.field_150376_bx, 8);
            for (int j118 = j + 1; j118 <= j + 3; ++j118) {
                this.func_150516_a(world, i - 10, j118, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 6, j + 2, k + 2, Blocks.field_150478_aa, 4);
        int pastries = 1 + random.nextInt(5);
        for (int l = 0; l < pastries; ++l) {
            Block block = LOTRWorldGenHobbitHole.getRandomFoodBlock(random);
            this.func_150516_a(world, i - 4, j + 2, k + 2 - random.nextInt(4), block, 0);
        }
        for (int j119 = j + 1; j119 <= j + 3; ++j119) {
            this.func_150516_a(world, i - 9, j119, k + 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i - 4, j119, k - 3, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 8, j + 1, k + 2, (Block)Blocks.field_150486_ae, 2);
        this.func_150516_a(world, i - 9, j + 1, k + 2, (Block)Blocks.field_150486_ae, 2);
        this.func_150516_a(world, i - 8, j + 1, k - 1, (Block)Blocks.field_150486_ae, 3);
        this.func_150516_a(world, i - 9, j + 1, k - 1, (Block)Blocks.field_150486_ae, 3);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k + 2, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k + 2, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 8, j + 1, k - 1, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 9, j + 1, k - 1, LOTRChestContents.HOBBIT_HOLE_LARDER);
        return true;
    }

    private boolean generateFacingEast(World world, int i, int j, int k, Random random) {
        int j1;
        int k1;
        int j12;
        int k12;
        int i1;
        for (i1 = i - 12; i1 >= i - 16; --i1) {
            for (int j13 = j + 1; j13 <= j + 4; ++j13) {
                for (k12 = k - 3; k12 <= k + 3; ++k12) {
                    this.func_150516_a(world, i1, j13, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i - 12; i1 >= i - 16; --i1) {
            for (int k13 = k - 4; k13 <= k + 4; ++k13) {
                for (j12 = j; j12 == j || !LOTRMod.isOpaque(world, i1, j12, k13) && j12 >= 0; --j12) {
                    boolean grass = j12 == j;
                    this.func_150516_a(world, i1, j12, k13, (Block)(grass ? Blocks.field_150349_c : Blocks.field_150346_d), 0);
                }
            }
        }
        for (i1 = i - 12; i1 >= i - 15; --i1) {
            this.func_150516_a(world, i1, j + 1, k + 3, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i1, j + 1, k - 3, this.fenceBlock, this.fenceMeta);
            this.func_150516_a(world, i1, j, k, Blocks.field_150351_n, 0);
        }
        this.func_150516_a(world, i - 11, j, k, Blocks.field_150351_n, 0);
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 15, j + 1, k1, this.fenceBlock, this.fenceMeta);
        }
        this.func_150516_a(world, i - 15, j + 1, k, Blocks.field_150396_be, 1);
        for (i1 = 0; i1 <= 2; ++i1) {
            BlockFlower flower = i1 == 1 ? Blocks.field_150328_O : Blocks.field_150327_N;
            this.func_150516_a(world, i - 12 - i1, j + 1, k + 1, (Block)flower, 0);
            this.func_150516_a(world, i - 12 - i1, j + 1, k - 1, (Block)flower, 0);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int k14 = k - 2; k14 <= k + 2; ++k14) {
                if (j1 >= j + 3 && Math.abs(k14 - k) >= 2) continue;
                this.func_150516_a(world, i - 11, j1, k14, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 11, j + 1, k - 1, this.wallStairBlock, 3);
        this.func_150516_a(world, i - 11, j + 1, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 11, j + 1, k + 1, this.wallStairBlock, 2);
        this.func_150516_a(world, i - 11, j + 2, k - 1, this.wallStairBlock, 7);
        this.func_150516_a(world, i - 11, j + 2, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 11, j + 2, k + 1, this.wallStairBlock, 6);
        for (i1 = i - 10; i1 <= i + 1; ++i1) {
            int j14;
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                for (k12 = k - 2; k12 <= k + 2; ++k12) {
                    if (i1 == i - 10) {
                        this.func_150516_a(world, i1, j14, k12, this.wallBlock, this.wallMeta);
                        continue;
                    }
                    this.func_150516_a(world, i1, j14, k12, Blocks.field_150350_a, 0);
                }
            }
            this.func_150516_a(world, i1, j, k + 1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i1, j, k, this.floorBlock, this.floorMeta);
            this.func_150516_a(world, i1, j, k - 1, this.floorStoneBlock, this.floorStoneMeta);
            if (i1 == i - 10) continue;
            this.func_150516_a(world, i1, j + 1, k + 2, this.wallHalfBlock, this.wallHalfMeta);
            this.func_150516_a(world, i1, j + 1, k - 2, this.wallHalfBlock, this.wallHalfMeta);
            for (j14 = j + 1; j14 <= j + 3; ++j14) {
                this.func_150516_a(world, i1, j14, k + 3, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j14, k - 3, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 2, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k - 2, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k + 1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k - 1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 4, k, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 10, j + 1, k, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 10, j + 2, k, Blocks.field_150466_ao, 8);
        for (i1 = i - 8; i1 <= i; i1 += 4) {
            this.func_150516_a(world, i1, j + 3, k, LOTRMod.chandelier, this.chandelierMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            for (int k15 = k - 2; k15 <= k + 2; ++k15) {
                this.func_150516_a(world, i + 2, j1, k15, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 2, j, k, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 2, j + 1, k, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 2, j + 2, k, Blocks.field_150350_a, 0);
        for (i1 = i + 3; i1 <= i + 9; ++i1) {
            for (int k16 = k - 3; k16 <= k + 3; ++k16) {
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k16, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k16, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j, k16, this.floorBlock, this.floorMeta);
            }
        }
        this.func_150516_a(world, i + 6, j + 3, k, LOTRMod.chandelier, this.chandelierMeta);
        for (i1 = i + 5; i1 <= i + 7; ++i1) {
            for (int k17 = k - 1; k17 <= k + 1; ++k17) {
                this.func_150516_a(world, i1, j + 1, k17, this.rugBlock, this.rugMeta);
            }
        }
        if (this.isWealthy && random.nextInt(4) == 0) {
            this.func_150516_a(world, i + 6, j, k, (Block)Blocks.field_150486_ae, 0);
            LOTRChestContents.fillChest(world, random, i + 6, j, k, LOTRChestContents.HOBBIT_HOLE_TREASURE);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                this.func_150516_a(world, i + 10, j15, k1, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            for (int j16 = j + 2; j16 <= j + 3; ++j16) {
                this.func_150516_a(world, i + 10, j16, k1, Blocks.field_150410_aZ, 0);
                this.func_150516_a(world, i + 10, j16, k1, Blocks.field_150410_aZ, 0);
                for (int i12 = i + 11; i12 <= i + 14; ++i12) {
                    this.func_150516_a(world, i12, j16, k1, Blocks.field_150350_a, 0);
                    if (world.func_147439_a(i12, j16 - 1, k1) != Blocks.field_150346_d) continue;
                    this.func_150516_a(world, i12, j16 - 1, k1, (Block)Blocks.field_150349_c, 0);
                }
            }
            this.func_150516_a(world, i + 10, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 3, j1, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j1, k + 3, this.wallBlock, this.wallMeta);
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i + 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i + 4; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 3, k - 3, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 3, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        this.func_150516_a(world, i + 8, j + 1, k - 3, Blocks.field_150476_ad, 3);
        this.func_150516_a(world, i + 8, j + 1, k + 3, Blocks.field_150476_ad, 2);
        for (i1 = i + 4; i1 <= i + 9; ++i1) {
            for (int j17 = j + 1; j17 <= j + 3; ++j17) {
                this.func_150516_a(world, i1, j17, k - 4, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j17, k + 4, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 6, j + 1, k - 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 6, j + 2, k - 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 6, j + 1, k + 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 6, j + 2, k + 4, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 4, j + 2, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 4, j + 2, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 9, j + 2, k - 3, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 9, j + 2, k + 3, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 6, j + 1, k + 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j, k + 2, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 6, j, k + 3, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 6, j + 1, k + 3, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i - 6, j + 2, k + 3, Blocks.field_150466_ao, 8);
        for (i1 = i - 8; i1 <= i - 3; ++i1) {
            for (int k18 = k + 4; k18 <= k + 8; ++k18) {
                if (i1 == i - 8 && k18 == k + 8) continue;
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k18, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j, k18, this.floorStoneBlock, this.floorStoneMeta);
                if (i1 <= i - 7 && k18 >= k + 7) continue;
                this.func_150516_a(world, i1, j + 4, k18, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k + 4; k1 <= k + 7; ++k1) {
            for (int j18 = j + 1; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i - 2, j18, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i - 8, j18, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i - 7, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i - 3, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 7; i1 <= i - 3; ++i1) {
            for (int j19 = j + 1; j19 <= j + 3; ++j19) {
                this.func_150516_a(world, i1, j19, k + 8, this.wallBlock, this.wallMeta);
            }
        }
        for (j1 = j + 1; j1 <= j + 2; ++j1) {
            for (int k19 = k + 5; k19 <= k + 6; ++k19) {
                this.func_150516_a(world, i - 8, j1, k19, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i - 9, j1, k19, Blocks.field_150342_X, 0);
            }
            for (int i13 = i - 6; i13 <= i - 4; ++i13) {
                this.func_150516_a(world, i13, j1, k + 8, Blocks.field_150350_a, 0);
                this.func_150516_a(world, i13, j1, k + 9, Blocks.field_150342_X, 0);
            }
        }
        this.func_150516_a(world, i - 5, j + 3, k + 6, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i - 5, j + 1, k + 5, Blocks.field_150476_ad, 1);
        this.func_150516_a(world, i - 3, j + 1, k + 5, (Block)Blocks.field_150376_bx, 8);
        this.func_150516_a(world, i - 3, j + 1, k + 7, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i - 3, j + 1, k + 7, LOTRChestContents.HOBBIT_HOLE_STUDY);
        this.func_150516_a(world, i - 6, j + 1, k - 2, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i - 6, j, k - 2, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 6, j, k - 3, this.floorStoneBlock, this.floorStoneMeta);
        this.func_150516_a(world, i - 6, j + 1, k - 3, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i - 6, j + 2, k - 3, Blocks.field_150466_ao, 8);
        for (i1 = i - 7; i1 <= i - 4; ++i1) {
            for (int k110 = k - 4; k110 >= k - 7; --k110) {
                this.func_150516_a(world, i1, j, k110, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k110, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k110, this.wallBlock, this.wallMeta);
            }
        }
        for (k1 = k - 4; k1 >= k - 7; --k1) {
            for (int j110 = j + 1; j110 <= j + 3; ++j110) {
                this.func_150516_a(world, i - 8, j110, k1, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i - 3, j110, k1, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i - 7, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i - 4, j + 3, k1, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i - 7; i1 <= i - 3; ++i1) {
            for (int j111 = j + 1; j111 <= j + 3; ++j111) {
                this.func_150516_a(world, i1, j111, k - 8, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i - 7; i1 <= i - 6; ++i1) {
            for (int k111 = k - 5; k111 >= k - 6; --k111) {
                this.func_150516_a(world, i1, j + 1, k111, this.rugBlock, this.rugMeta);
            }
        }
        for (k1 = k - 5; k1 >= k - 6; --k1) {
            this.func_150516_a(world, i - 8, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            this.func_150516_a(world, i - 8, j + 1, k1, (Block)Blocks.field_150376_bx, 8);
            this.func_150516_a(world, i - 8, j + 2, k1, Blocks.field_150342_X, 0);
            this.func_150516_a(world, i - 9, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 4, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 1, k - 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 2, k - 4, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 4, j + 2, k - 7, Blocks.field_150478_aa, 5);
        this.func_150516_a(world, i - 5, j + 1, k - 5, Blocks.field_150324_C, 3);
        this.func_150516_a(world, i - 4, j + 1, k - 5, Blocks.field_150324_C, 11);
        this.func_150516_a(world, i - 5, j + 1, k - 6, Blocks.field_150324_C, 3);
        this.func_150516_a(world, i - 4, j + 1, k - 6, Blocks.field_150324_C, 11);
        this.func_150516_a(world, i + 6, j, k + 4, this.floorBlock, this.floorMeta);
        for (k1 = k + 5; k1 <= k + 6; ++k1) {
            this.func_150516_a(world, i + 6, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j112 = j + 1; j112 <= j + 3; ++j112) {
                this.func_150516_a(world, i + 6, j112, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i + 6, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (k1 = k + 5; k1 <= k + 7; ++k1) {
            this.func_150516_a(world, i + 5, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j113 = j + 1; j113 <= j + 3; ++j113) {
                this.func_150516_a(world, i + 5, j113, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i + 5, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (k1 = k + 5; k1 <= k + 8; ++k1) {
            this.func_150516_a(world, i + 4, j, k1, this.floorStoneBlock, this.floorStoneMeta);
            for (int j114 = j + 1; j114 <= j + 3; ++j114) {
                this.func_150516_a(world, i + 4, j114, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i + 4, j + 4, k1, this.wallBlock, this.wallMeta);
        }
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 6, j1, k + 7, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 5, j1, k + 8, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 4, j1, k + 9, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 5, j + 2, k + 7, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 4, j + 2, k + 8, Blocks.field_150478_aa, 4);
        for (i1 = i + 3; i1 >= i - 1; --i1) {
            for (int k112 = k + 4; k112 <= k + 9; ++k112) {
                this.func_150516_a(world, i1, j, k112, this.floorStoneBlock, this.floorStoneMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k112, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k112, this.wallBlock, this.wallMeta);
            }
            for (int j115 = j + 1; j115 <= j + 3; ++j115) {
                this.func_150516_a(world, i1, j115, k + 3, this.wallBlock, this.wallMeta);
                this.func_150516_a(world, i1, j115, k + 10, this.wallBlock, this.wallMeta);
            }
            this.func_150516_a(world, i1, j + 3, k + 4, this.wallHalfBlock, this.wallHalfMeta | 8);
            this.func_150516_a(world, i1, j + 3, k + 9, this.wallHalfBlock, this.wallHalfMeta | 8);
        }
        for (i1 = i + 2; i1 >= i; --i1) {
            this.func_150516_a(world, i1, j + 1, k + 4, Blocks.field_150476_ad, 3);
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        this.func_150516_a(world, i + 1, j + 3, k + 6, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 1, j + 3, k + 7, LOTRMod.chandelier, this.chandelierMeta);
        this.func_150516_a(world, i + 2, j + 1, k + 6, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 2, j + 1, k + 7, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i + 1, j + 1, k + 6, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i + 1, j + 1, k + 7, (Block)Blocks.field_150376_bx, 9);
        this.func_150516_a(world, i, j + 1, k + 6, Blocks.field_150344_f, 1);
        this.func_150516_a(world, i, j + 1, k + 7, Blocks.field_150344_f, 1);
        for (i1 = i + 2; i1 >= i; --i1) {
            for (int k113 = k + 6; k113 <= k + 7; ++k113) {
                this.placePlate(world, i1, j + 2, k113, random, LOTRFoods.HOBBIT);
            }
        }
        this.func_150516_a(world, i + 6, j + 3, k + 5, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 6, j + 3, k + 6, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 5, j + 3, k + 7, this.wallHalfBlock, this.wallHalfMeta | 8);
        this.func_150516_a(world, i + 4, j + 3, k + 8, this.wallHalfBlock, this.wallHalfMeta | 8);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            int k114;
            for (k114 = k + 5; k114 <= k + 6; ++k114) {
                this.func_150516_a(world, i + 7, j1, k114, this.wallBlock, this.wallMeta);
            }
            for (k114 = k + 8; k114 <= k + 9; ++k114) {
                this.func_150516_a(world, i - 2, j1, k114, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 6, j, k - 4, this.floorBlock, this.floorMeta);
        for (i1 = i + 7; i1 >= i + 3; --i1) {
            for (int k115 = k - 5; k115 >= k - 7; --k115) {
                this.func_150516_a(world, i1, j, k115, (Block)Blocks.field_150334_T, 0);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k115, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k115, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i + 6; i1 >= i + 3; --i1) {
            for (int k116 = k - 5; k116 >= k - 6; --k116) {
                this.func_150516_a(world, i1, j, k116, this.floorStoneBlock, this.floorStoneMeta);
            }
        }
        this.func_150516_a(world, i + 8, j + 1, k - 5, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 8, j + 1, k - 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 8, j + 2, k - 5, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 8, j + 2, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 9, j + 2, k - 5, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i + 9, j + 2, k - 6, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i + 8, j + 3, k - 5, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i + 8, j + 3, k - 6, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i + 8, j + 3, k - 7, (Block)Blocks.field_150334_T, 0);
        this.func_150516_a(world, i + 8, j + 1, k - 7, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i + 8, j + 2, k - 7, this.wallBlock, this.wallMeta);
        for (i1 = i + 6; i1 <= i + 7; ++i1) {
            for (int j116 = j + 1; j116 <= j + 3; ++j116) {
                this.func_150516_a(world, i1, j116, k - 8, this.wallBlock, this.wallMeta);
            }
        }
        for (i1 = i + 3; i1 <= i + 5; ++i1) {
            this.func_150516_a(world, i1, j, k - 8, (Block)Blocks.field_150334_T, 0);
            this.func_150516_a(world, i1, j + 2, k - 8, Blocks.field_150350_a, 0);
            this.func_150516_a(world, i1, j + 2, k - 9, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 3, k - 8, (Block)Blocks.field_150334_T, 0);
        }
        this.func_150516_a(world, i + 4, j + 1, k - 8, this.wallBlock, this.wallMeta);
        this.func_150516_a(world, i + 5, j + 1, k - 8, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i + 3, j + 1, k - 8, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i + 4, j + 1, k - 8, (Block)Blocks.field_150383_bp, 3);
        this.func_150516_a(world, i + 5, j + 3, k - 6, LOTRMod.chandelier, this.chandelierMeta);
        for (k1 = k - 4; k1 >= k - 9; --k1) {
            for (int j117 = j + 1; j117 <= j + 3; ++j117) {
                this.func_150516_a(world, i + 2, j117, k1, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i + 2, j, k - 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 2, j + 1, k - 6, Blocks.field_150350_a, 0);
        this.func_150516_a(world, i + 2, j + 2, k - 6, Blocks.field_150350_a, 0);
        for (i1 = i + 1; i1 >= i - 2; --i1) {
            for (int k117 = k - 4; k117 >= k - 9; --k117) {
                this.func_150516_a(world, i1, j, k117, this.floorBlock, this.floorMeta);
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k117, Blocks.field_150350_a, 0);
                }
                this.func_150516_a(world, i1, j + 4, k117, (Block)Blocks.field_150334_T, 0);
            }
            this.func_150516_a(world, i1, j + 1, k - 4, (Block)Blocks.field_150376_bx, 8);
            for (int j118 = j + 1; j118 <= j + 3; ++j118) {
                this.func_150516_a(world, i1, j118, k - 10, this.wallBlock, this.wallMeta);
            }
        }
        this.func_150516_a(world, i - 2, j + 2, k - 6, Blocks.field_150478_aa, 1);
        int pastries = 1 + random.nextInt(5);
        for (int l = 0; l < pastries; ++l) {
            Block block = LOTRWorldGenHobbitHole.getRandomFoodBlock(random);
            this.func_150516_a(world, i - 2 + random.nextInt(4), j + 2, k - 4, block, 0);
        }
        for (int j119 = j + 1; j119 <= j + 3; ++j119) {
            this.func_150516_a(world, i - 3, j119, k - 9, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j119, k - 4, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 2, j + 1, k - 8, (Block)Blocks.field_150486_ae, 5);
        this.func_150516_a(world, i - 2, j + 1, k - 9, (Block)Blocks.field_150486_ae, 5);
        this.func_150516_a(world, i + 1, j + 1, k - 8, (Block)Blocks.field_150486_ae, 4);
        this.func_150516_a(world, i + 1, j + 1, k - 9, (Block)Blocks.field_150486_ae, 4);
        LOTRChestContents.fillChest(world, random, i - 2, j + 1, k - 8, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i - 2, j + 1, k - 9, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i + 1, j + 1, k - 8, LOTRChestContents.HOBBIT_HOLE_LARDER);
        LOTRChestContents.fillChest(world, random, i + 1, j + 1, k - 9, LOTRChestContents.HOBBIT_HOLE_LARDER);
        return true;
    }

    public static Block getRandomFoodBlock(Random random) {
        int i = random.nextInt(3);
        if (i == 0) {
            return Blocks.field_150414_aQ;
        }
        if (i == 1) {
            return LOTRMod.appleCrumble;
        }
        if (i == 2) {
            return LOTRMod.cherryPie;
        }
        return Blocks.field_150414_aQ;
    }
}

