/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure;

import java.util.List;
import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTREntityHobbitBartender;
import lotr.common.entity.npc.LOTREntityHobbitDrunkard;
import lotr.common.entity.npc.LOTREntityHobbitShirriffChief;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRWorldGenStructureBase;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRWorldGenHobbitTavern
extends LOTRWorldGenStructureBase {
    private Block stairBlock;
    private Block pillarBlock;
    private int pillarMeta;
    private Block wallBlock;
    private int wallMeta;
    private Block floorBlock;
    private int floorMeta;
    private Item drink;

    public LOTRWorldGenHobbitTavern(boolean flag) {
        super(flag);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.restrictions) {
            if (world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
                return false;
            }
            if (world.func_72807_a(i, k) != LOTRBiome.shire) {
                return false;
            }
        }
        --j;
        int rotation = random.nextInt(4);
        if (!this.restrictions && this.usingPlayer != null) {
            rotation = this.usingPlayerRotation();
        }
        int minHeight = j;
        int maxHeight = j;
        switch (rotation) {
            case 0: {
                Block block;
                int j1;
                int i1;
                int k1;
                k += 8;
                i += 6;
                if (!this.restrictions) break;
                for (k1 = k - 7; k1 <= k + 7; ++k1) {
                    for (i1 = i - 10; i1 <= i + 10; ++i1) {
                        j1 = world.func_72825_h(i1, k1) - 1;
                        block = world.func_147439_a(i1, j1, k1);
                        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150354_m) {
                            return false;
                        }
                        if (j1 < minHeight) {
                            minHeight = j1;
                        }
                        if (j1 <= maxHeight) continue;
                        maxHeight = j1;
                    }
                }
                break;
            }
            case 1: {
                int k1;
                int i1;
                Block block;
                int j1;
                i -= 8;
                k += 6;
                if (!this.restrictions) break;
                for (i1 = i - 7; i1 <= i + 7; ++i1) {
                    for (k1 = k - 10; k1 <= k + 10; ++k1) {
                        j1 = world.func_72825_h(i1, k1) - 1;
                        block = world.func_147439_a(i1, j1, k1);
                        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150354_m) {
                            return false;
                        }
                        if (j1 < minHeight) {
                            minHeight = j1;
                        }
                        if (j1 <= maxHeight) continue;
                        maxHeight = j1;
                    }
                }
                break;
            }
            case 2: {
                Block block;
                int j1;
                int i1;
                int k1;
                k -= 8;
                i += 6;
                if (!this.restrictions) break;
                for (k1 = k - 7; k1 <= k + 7; ++k1) {
                    for (i1 = i - 10; i1 <= i + 10; ++i1) {
                        j1 = world.func_72825_h(i1, k1) - 1;
                        block = world.func_147439_a(i1, j1, k1);
                        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150354_m) {
                            return false;
                        }
                        if (j1 < minHeight) {
                            minHeight = j1;
                        }
                        if (j1 <= maxHeight) continue;
                        maxHeight = j1;
                    }
                }
                break;
            }
            case 3: {
                int k1;
                int i1;
                Block block;
                int j1;
                i += 8;
                k += 6;
                if (!this.restrictions) break;
                for (i1 = i - 7; i1 <= i + 7; ++i1) {
                    for (k1 = k - 10; k1 <= k + 10; ++k1) {
                        j1 = world.func_72825_h(i1, k1) - 1;
                        block = world.func_147439_a(i1, j1, k1);
                        if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b && block != Blocks.field_150354_m) {
                            return false;
                        }
                        if (j1 < minHeight) {
                            minHeight = j1;
                        }
                        if (j1 <= maxHeight) continue;
                        maxHeight = j1;
                    }
                }
                break;
            }
        }
        if (this.restrictions && maxHeight - minHeight > 5) {
            return false;
        }
        this.stairBlock = Blocks.field_150476_ad;
        int randomWood = random.nextInt(4);
        switch (randomWood) {
            case 0: {
                this.pillarBlock = Blocks.field_150364_r;
                this.pillarMeta = 0;
                this.wallBlock = Blocks.field_150344_f;
                this.wallMeta = 0;
                this.stairBlock = Blocks.field_150476_ad;
                break;
            }
            case 1: {
                this.pillarBlock = Blocks.field_150364_r;
                this.pillarMeta = 1;
                this.wallBlock = Blocks.field_150344_f;
                this.wallMeta = 1;
                this.stairBlock = Blocks.field_150485_bF;
                break;
            }
            case 2: {
                this.pillarBlock = Blocks.field_150364_r;
                this.pillarMeta = 2;
                this.wallBlock = Blocks.field_150344_f;
                this.wallMeta = 2;
                this.stairBlock = Blocks.field_150487_bG;
                break;
            }
            case 3: {
                this.pillarBlock = LOTRMod.wood;
                this.pillarMeta = 0;
                this.wallBlock = LOTRMod.planks;
                this.wallMeta = 0;
                this.stairBlock = LOTRMod.stairsShirePine;
            }
        }
        int randomFloor = random.nextInt(3);
        switch (randomFloor) {
            case 0: {
                this.floorBlock = Blocks.field_150347_e;
                this.floorMeta = 0;
                break;
            }
            case 1: {
                this.floorBlock = Blocks.field_150417_aV;
                this.floorMeta = 0;
                break;
            }
            case 2: {
                this.floorBlock = Blocks.field_150336_V;
                this.floorMeta = 0;
            }
        }
        this.drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(random).func_77973_b();
        switch (rotation) {
            case 0: {
                this.generateFacingSouth(world, random, i, j, k);
                break;
            }
            case 1: {
                this.generateFacingWest(world, random, i, j, k);
                break;
            }
            case 2: {
                this.generateFacingNorth(world, random, i, j, k);
                break;
            }
            case 3: {
                this.generateFacingEast(world, random, i, j, k);
            }
        }
        int hobbits = 3 + random.nextInt(5);
        for (int l = 0; l < hobbits; ++l) {
            LOTREntityHobbit hobbit = new LOTREntityHobbit(world);
            hobbit.func_70012_b(i, j + 1, k, 0.0f, 0.0f);
            hobbit.func_110171_b(i, j + 1, k, 16);
            hobbit.func_110161_a(null);
            hobbit.isNPCPersistent = true;
            world.func_72838_d((Entity)hobbit);
        }
        LOTREntityHobbitDrunkard drunkard = new LOTREntityHobbitDrunkard(world);
        drunkard.func_70012_b(i, j + 1, k, 0.0f, 0.0f);
        drunkard.func_110171_b(i, j + 1, k, 7);
        drunkard.func_110161_a(null);
        drunkard.isNPCPersistent = true;
        world.func_72838_d((Entity)drunkard);
        drunkard.func_70062_b(0, new ItemStack(this.drink, 1, 3 + random.nextInt(2)));
        if (random.nextBoolean()) {
            LOTREntityHobbitShirriffChief shirriff = new LOTREntityHobbitShirriffChief(world);
            shirriff.func_70012_b(i, j + 1, k, 0.0f, 0.0f);
            shirriff.func_110171_b(i, j + 1, k, 7);
            shirriff.spawnRidingHorse = false;
            shirriff.func_110161_a(null);
            world.func_72838_d((Entity)shirriff);
        }
        return true;
    }

    private void generateFacingSouth(World world, Random random, int i, int j, int k) {
        int i1;
        int j1;
        int k1;
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72314_b(11.0, 6.0, 8.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (k1 = k - 7; k1 <= k + 7; ++k1) {
            for (int i12 = i - 10; i12 <= i + 10; ++i12) {
                int j12;
                for (j12 = j; !(j12 != j && LOTRMod.isOpaque(world, i12, j12, k1) || j12 < 0); --j12) {
                    if (Math.abs(i12 - i) == 10 && Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i12, j12, k1, this.pillarBlock, this.pillarMeta);
                    } else if (Math.abs(i12 - i) == 10 || Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i12, j12, k1, this.wallBlock, this.wallMeta);
                    } else {
                        this.func_150516_a(world, i12, j12, k1, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i12, j12 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i12, j12 - 1, k1, Blocks.field_150346_d, 0);
                }
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i12, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k - 6; k1 <= k + 6; ++k1) {
            for (int i13 = i - 9; i13 <= i + 9; ++i13) {
                this.func_150516_a(world, i13, j, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 7; k1 <= k + 7; ++k1) {
            for (int i14 = i - 10; i14 <= i + 10; ++i14) {
                for (int j13 = j + 1; j13 <= j + 3; ++j13) {
                    if (Math.abs(i14 - i) == 10 && Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i14, j13, k1, this.pillarBlock, this.pillarMeta);
                        continue;
                    }
                    if (Math.abs(i14 - i) != 10 && Math.abs(k1 - k) != 7) continue;
                    this.func_150516_a(world, i14, j13, k1, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (k1 = k - 7; k1 <= k + 7; ++k1) {
            for (int i15 = i - 10; i15 <= i + 10; ++i15) {
                for (int j14 = j + 4; j14 <= j + 5; ++j14) {
                    this.func_150516_a(world, i15, j14, k1, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (int l = 1; l >= 0; --l) {
            for (int k12 = k - 7 - l; k12 <= k + 7 + l; ++k12) {
                this.func_150516_a(world, i - 10 - l, j + 4 + (1 - l), k12, this.stairBlock, 0);
                this.func_150516_a(world, i + 10 + l, j + 4 + (1 - l), k12, this.stairBlock, 1);
            }
            for (int i16 = i - 9 - l; i16 <= i + 9 + l; ++i16) {
                this.func_150516_a(world, i16, j + 4 + (1 - l), k - 7 - l, this.stairBlock, 2);
                this.func_150516_a(world, i16, j + 4 + (1 - l), k + 7 + l, this.stairBlock, 3);
            }
        }
        for (k1 = k - 6; k1 <= k + 6; ++k1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                for (int i17 = i - 9; i17 <= (j15 == j + 3 ? i - 8 : i - 9); ++i17) {
                    this.func_150516_a(world, i17, j15, k1, this.wallBlock, this.wallMeta);
                }
            }
            this.func_150516_a(world, i - 8, j + 2, k1, (Block)Blocks.field_150479_bC, 3);
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            for (int j16 = j + 1; j16 <= j + 7; ++j16) {
                for (int i18 = i - 9; i18 <= i - 7; ++i18) {
                    this.func_150516_a(world, i18, j16, k1, Blocks.field_150336_V, 0);
                }
            }
        }
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            int j17;
            for (j17 = j + 1; j17 <= j + 6; ++j17) {
                this.func_150516_a(world, i - 8, j17, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i - 8, j, k1, LOTRMod.hearth, 0);
            this.func_150516_a(world, i - 8, j + 1, k1, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i - 8, j + 8, k1, Blocks.field_150457_bL, 0);
            for (j17 = j + 1; j17 <= j + 2; ++j17) {
                this.func_150516_a(world, i - 7, j17, k1, Blocks.field_150411_aY, 0);
            }
        }
        for (k1 = k - 2; k1 <= k + 2; ++k1) {
            this.func_150516_a(world, i - 9, j + 7, k1, Blocks.field_150389_bf, 0);
            this.func_150516_a(world, i - 7, j + 7, k1, Blocks.field_150389_bf, 1);
        }
        this.func_150516_a(world, i - 8, j + 7, k - 2, Blocks.field_150389_bf, 2);
        this.func_150516_a(world, i - 8, j + 7, k + 2, Blocks.field_150389_bf, 3);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k - 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k - 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 9, j1, k - 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 9, j1, k + 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k + 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 5, j1, k + 6, this.pillarBlock, this.pillarMeta);
        }
        for (i1 = i; i1 <= i + 2; ++i1) {
            for (int j18 = j + 2; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i1, j18, k - 7, Blocks.field_150410_aZ, 0);
            }
        }
        for (j1 = j + 2; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 1, j1, k - 7, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 3, j1, k - 7, this.pillarBlock, this.pillarMeta);
        }
        for (i1 = i - 2; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 6, Blocks.field_150476_ad, 3);
        }
        for (i1 = i + 6; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 6, Blocks.field_150476_ad, 3);
        }
        for (k1 = k - 5; k1 <= k - 3; ++k1) {
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (k1 = k + 2; k1 <= k + 6; ++k1) {
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (i1 = i + 6; i1 <= i + 8; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 6, Blocks.field_150476_ad, 2);
        }
        this.func_150516_a(world, i + 6, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k - 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k - 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k + 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k + 3, Blocks.field_150344_f, 0);
        this.placePlate(world, i + 6, j + 2, k - 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k - 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k - 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k - 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k + 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k + 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k + 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k + 3, random, LOTRFoods.HOBBIT);
        this.func_150516_a(world, i - 5, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 5, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 8, j + 2, k + 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 8, j + 2, k - 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 3, j + 2, k - 5, Blocks.field_150478_aa, 3);
        for (i1 = i - 3; i1 <= i + 3; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k, Blocks.field_150422_aJ, 0);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 2, this.wallBlock, this.wallMeta);
        }
        for (k1 = k + 3; k1 <= k + 6; ++k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 3, j + 1, k + 4, Blocks.field_150396_be, 1);
        this.placeBarrel(world, random, i - 2, j + 2, k + 2, 3, this.drink);
        this.placeBarrel(world, random, i + 2, j + 2, k + 2, 3, this.drink);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeMug(world, random, i1, j + 2, k + 2, 0, this.drink);
        }
        this.func_150516_a(world, i - 3, j + 2, k + 6, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 3, j + 2, k + 6, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 1, k + 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 2, j + 1, k + 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i, j + 1, k + 6, this.wallBlock, this.wallMeta);
        this.placeFlowerPot(world, i, j + 2, k + 6, this.getRandomPlant(random));
        this.func_150516_a(world, i - 1, j + 1, k + 6, LOTRMod.hobbitOven, 2);
        this.func_150516_a(world, i + 1, j + 1, k + 6, LOTRMod.hobbitOven, 2);
        this.func_150516_a(world, i - 5, j + 3, k + 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i, j + 3, k + 4, LOTRMod.chandelier, 3);
        this.func_150516_a(world, i + 5, j + 3, k + 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 5, j + 3, k - 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i, j + 3, k - 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 5, j + 3, k - 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 6, j, k - 7, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 6, j + 1, k - 7, Blocks.field_150466_ao, 1);
        this.func_150516_a(world, i - 6, j + 2, k - 7, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 7, j + 2, k - 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 5, j + 2, k - 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 6, j + 3, k - 8, Blocks.field_150444_as, 2);
        String[] name = LOTRNames.getRandomHobbitTavernName(random);
        TileEntity tileentity = world.func_147438_o(i - 6, j + 3, k - 8);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        this.spawnBartender(world, i, j + 1, k + 4, name);
    }

    private void generateFacingWest(World world, Random random, int i, int j, int k) {
        int k1;
        int j1;
        int i1;
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72314_b(8.0, 6.0, 11.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i + 7; i1 >= i - 7; --i1) {
            for (int k12 = k - 10; k12 <= k + 10; ++k12) {
                int j12;
                for (j12 = j; !LOTRMod.isOpaque(world, i1, j12, k12) && j12 >= 0; --j12) {
                    if (Math.abs(i1 - i) == 7 && Math.abs(k12 - k) == 10) {
                        this.func_150516_a(world, i1, j12, k12, this.pillarBlock, this.pillarMeta);
                    } else if (Math.abs(i1 - i) == 7 || Math.abs(k12 - k) == 10) {
                        this.func_150516_a(world, i1, j12, k12, this.wallBlock, this.wallMeta);
                    } else {
                        this.func_150516_a(world, i1, j12, k12, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j12 - 1, k12) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j12 - 1, k12, Blocks.field_150346_d, 0);
                }
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i + 6; i1 >= i - 6; --i1) {
            for (int k13 = k - 9; k13 <= k + 9; ++k13) {
                this.func_150516_a(world, i1, j, k13, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 7; i1 <= i + 7; ++i1) {
            for (int k14 = k - 10; k14 <= k + 10; ++k14) {
                for (int j13 = j + 1; j13 <= j + 3; ++j13) {
                    if (Math.abs(i1 - i) == 7 && Math.abs(k14 - k) == 10) {
                        this.func_150516_a(world, i1, j13, k14, this.pillarBlock, this.pillarMeta);
                        continue;
                    }
                    if (Math.abs(i1 - i) != 7 && Math.abs(k14 - k) != 10) continue;
                    this.func_150516_a(world, i1, j13, k14, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (i1 = i + 7; i1 >= i - 7; --i1) {
            for (int k15 = k - 10; k15 <= k + 10; ++k15) {
                for (int j14 = j + 4; j14 <= j + 5; ++j14) {
                    this.func_150516_a(world, i1, j14, k15, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (int l = 1; l >= 0; --l) {
            for (int i12 = i + 7 + l; i12 >= i - 7 - l; --i12) {
                this.func_150516_a(world, i12, j + 4 + (1 - l), k - 10 - l, this.stairBlock, 2);
                this.func_150516_a(world, i12, j + 4 + (1 - l), k + 10 + l, this.stairBlock, 3);
            }
            for (int k16 = k - 9 - l; k16 <= k + 9 + l; ++k16) {
                this.func_150516_a(world, i + 7 + l, j + 4 + (1 - l), k16, this.stairBlock, 1);
                this.func_150516_a(world, i - 7 - l, j + 4 + (1 - l), k16, this.stairBlock, 0);
            }
        }
        for (i1 = i + 6; i1 >= i - 6; --i1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                for (int k17 = k - 9; k17 <= (j15 == j + 3 ? k - 8 : k - 9); ++k17) {
                    this.func_150516_a(world, i1, j15, k17, this.wallBlock, this.wallMeta);
                }
            }
            this.func_150516_a(world, i1, j + 2, k - 8, (Block)Blocks.field_150479_bC, 0);
        }
        for (i1 = i + 2; i1 >= i - 2; --i1) {
            for (int j16 = j + 1; j16 <= j + 7; ++j16) {
                for (int k18 = k - 9; k18 <= k - 7; ++k18) {
                    this.func_150516_a(world, i1, j16, k18, Blocks.field_150336_V, 0);
                }
            }
        }
        for (i1 = i + 1; i1 >= i - 1; --i1) {
            int j17;
            for (j17 = j + 1; j17 <= j + 6; ++j17) {
                this.func_150516_a(world, i1, j17, k - 8, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j, k - 8, LOTRMod.hearth, 0);
            this.func_150516_a(world, i1, j + 1, k - 8, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i1, j + 8, k - 8, Blocks.field_150457_bL, 0);
            for (j17 = j + 1; j17 <= j + 2; ++j17) {
                this.func_150516_a(world, i1, j17, k - 7, Blocks.field_150411_aY, 0);
            }
        }
        for (i1 = i + 2; i1 >= i - 2; --i1) {
            this.func_150516_a(world, i1, j + 7, k - 9, Blocks.field_150389_bf, 2);
            this.func_150516_a(world, i1, j + 7, k - 7, Blocks.field_150389_bf, 3);
        }
        this.func_150516_a(world, i + 2, j + 7, k - 8, Blocks.field_150389_bf, 1);
        this.func_150516_a(world, i - 2, j + 7, k - 8, Blocks.field_150389_bf, 0);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 6, j1, k - 3, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 6, j1, k + 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 2, j1, k + 9, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 1, j1, k + 9, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 6, j1, k + 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 6, j1, k - 5, this.pillarBlock, this.pillarMeta);
        }
        for (k1 = k; k1 <= k + 2; ++k1) {
            for (int j18 = j + 2; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i + 7, j18, k1, Blocks.field_150410_aZ, 0);
            }
        }
        for (j1 = j + 2; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i + 7, j1, k - 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 7, j1, k + 3, this.pillarBlock, this.pillarMeta);
        }
        for (k1 = k - 2; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i + 6, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (k1 = k + 6; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i + 6, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (i1 = i + 5; i1 >= i + 3; --i1) {
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        for (i1 = i - 2; i1 >= i - 6; --i1) {
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        for (k1 = k + 6; k1 <= k + 8; ++k1) {
            this.func_150516_a(world, i - 6, j + 1, k1, Blocks.field_150476_ad, 1);
        }
        this.func_150516_a(world, i + 4, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 4, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 3, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 3, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.placePlate(world, i + 4, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 4, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 3, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 3, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 4, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 4, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 3, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 3, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.func_150516_a(world, i - 5, j + 2, k - 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 1, j + 2, k + 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 2, j + 2, k + 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i + 5, j + 2, k + 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k - 3, Blocks.field_150478_aa, 2);
        for (k1 = k - 3; k1 <= k + 3; k1 += 2) {
            this.func_150516_a(world, i, j + 1, k1, Blocks.field_150422_aJ, 0);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i - 2, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        for (i1 = i - 3; i1 >= i - 6; --i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 1, k + 3, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 4, j + 1, k - 3, Blocks.field_150396_be, 0);
        this.placeBarrel(world, random, i - 2, j + 2, k - 2, 4, this.drink);
        this.placeBarrel(world, random, i - 2, j + 2, k + 2, 4, this.drink);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeMug(world, random, i - 2, j + 2, k1, 1, this.drink);
        }
        this.func_150516_a(world, i - 6, j + 2, k - 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 6, j + 2, k + 3, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 6, j + 1, k - 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 6, j + 1, k + 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i - 6, j + 1, k, this.wallBlock, this.wallMeta);
        this.placeFlowerPot(world, i - 6, j + 2, k, this.getRandomPlant(random));
        this.func_150516_a(world, i - 6, j + 1, k - 1, LOTRMod.hobbitOven, 5);
        this.func_150516_a(world, i - 6, j + 1, k + 1, LOTRMod.hobbitOven, 5);
        this.func_150516_a(world, i - 3, j + 3, k - 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 4, j + 3, k, LOTRMod.chandelier, 3);
        this.func_150516_a(world, i - 3, j + 3, k + 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 3, j + 3, k - 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 3, j + 3, k, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 3, j + 3, k + 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 7, j, k - 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i + 7, j + 1, k - 6, Blocks.field_150466_ao, 2);
        this.func_150516_a(world, i + 7, j + 2, k - 6, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i + 8, j + 2, k - 7, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 8, j + 2, k - 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i + 8, j + 3, k - 6, Blocks.field_150444_as, 5);
        String[] name = LOTRNames.getRandomHobbitTavernName(random);
        TileEntity tileentity = world.func_147438_o(i + 8, j + 3, k - 6);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        this.spawnBartender(world, i - 4, j + 1, k, name);
    }

    private void generateFacingNorth(World world, Random random, int i, int j, int k) {
        int i1;
        int j1;
        int k1;
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72314_b(11.0, 6.0, 8.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (k1 = k + 7; k1 >= k - 7; --k1) {
            for (int i12 = i - 10; i12 <= i + 10; ++i12) {
                int j12;
                for (j12 = j; !LOTRMod.isOpaque(world, i12, j12, k1) && j12 >= 0; --j12) {
                    if (Math.abs(i12 - i) == 10 && Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i12, j12, k1, this.pillarBlock, this.pillarMeta);
                    } else if (Math.abs(i12 - i) == 10 || Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i12, j12, k1, this.wallBlock, this.wallMeta);
                    } else {
                        this.func_150516_a(world, i12, j12, k1, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i12, j12 - 1, k1) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i12, j12 - 1, k1, Blocks.field_150346_d, 0);
                }
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i12, j12, k1, Blocks.field_150350_a, 0);
                }
            }
        }
        for (k1 = k + 6; k1 >= k - 6; --k1) {
            for (int i13 = i - 9; i13 <= i + 9; ++i13) {
                this.func_150516_a(world, i13, j, k1, this.floorBlock, this.floorMeta);
            }
        }
        for (k1 = k - 7; k1 <= k + 7; ++k1) {
            for (int i14 = i - 10; i14 <= i + 10; ++i14) {
                for (int j13 = j + 1; j13 <= j + 3; ++j13) {
                    if (Math.abs(i14 - i) == 10 && Math.abs(k1 - k) == 7) {
                        this.func_150516_a(world, i14, j13, k1, this.pillarBlock, this.pillarMeta);
                        continue;
                    }
                    if (Math.abs(i14 - i) != 10 && Math.abs(k1 - k) != 7) continue;
                    this.func_150516_a(world, i14, j13, k1, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (k1 = k + 7; k1 >= k - 7; --k1) {
            for (int i15 = i - 10; i15 <= i + 10; ++i15) {
                for (int j14 = j + 4; j14 <= j + 5; ++j14) {
                    this.func_150516_a(world, i15, j14, k1, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (int l = 1; l >= 0; --l) {
            for (int k12 = k + 7 + l; k12 >= k - 7 - l; --k12) {
                this.func_150516_a(world, i - 10 - l, j + 4 + (1 - l), k12, this.stairBlock, 0);
                this.func_150516_a(world, i + 10 + l, j + 4 + (1 - l), k12, this.stairBlock, 1);
            }
            for (int i16 = i - 9 - l; i16 <= i + 9 + l; ++i16) {
                this.func_150516_a(world, i16, j + 4 + (1 - l), k + 7 + l, this.stairBlock, 3);
                this.func_150516_a(world, i16, j + 4 + (1 - l), k - 7 - l, this.stairBlock, 2);
            }
        }
        for (k1 = k + 6; k1 >= k - 6; --k1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                for (int i17 = i - 9; i17 <= (j15 == j + 3 ? i - 8 : i - 9); ++i17) {
                    this.func_150516_a(world, i17, j15, k1, this.wallBlock, this.wallMeta);
                }
            }
            this.func_150516_a(world, i - 8, j + 2, k1, (Block)Blocks.field_150479_bC, 3);
        }
        for (k1 = k + 2; k1 >= k - 2; --k1) {
            for (int j16 = j + 1; j16 <= j + 7; ++j16) {
                for (int i18 = i - 9; i18 <= i - 7; ++i18) {
                    this.func_150516_a(world, i18, j16, k1, Blocks.field_150336_V, 0);
                }
            }
        }
        for (k1 = k + 1; k1 >= k - 1; --k1) {
            int j17;
            for (j17 = j + 1; j17 <= j + 6; ++j17) {
                this.func_150516_a(world, i - 8, j17, k1, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i - 8, j, k1, LOTRMod.hearth, 0);
            this.func_150516_a(world, i - 8, j + 1, k1, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i - 8, j + 8, k1, Blocks.field_150457_bL, 0);
            for (j17 = j + 1; j17 <= j + 2; ++j17) {
                this.func_150516_a(world, i - 7, j17, k1, Blocks.field_150411_aY, 0);
            }
        }
        for (k1 = k + 2; k1 >= k - 2; --k1) {
            this.func_150516_a(world, i - 9, j + 7, k1, Blocks.field_150389_bf, 0);
            this.func_150516_a(world, i - 7, j + 7, k1, Blocks.field_150389_bf, 1);
        }
        this.func_150516_a(world, i - 8, j + 7, k + 2, Blocks.field_150389_bf, 3);
        this.func_150516_a(world, i - 8, j + 7, k - 2, Blocks.field_150389_bf, 2);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 3, j1, k + 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k + 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 9, j1, k + 2, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 9, j1, k - 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 5, j1, k - 6, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 5, j1, k - 6, this.pillarBlock, this.pillarMeta);
        }
        for (i1 = i; i1 <= i + 2; ++i1) {
            for (int j18 = j + 2; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i1, j18, k + 7, Blocks.field_150410_aZ, 0);
            }
        }
        for (j1 = j + 2; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 1, j1, k + 7, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 3, j1, k + 7, this.pillarBlock, this.pillarMeta);
        }
        for (i1 = i - 2; i1 <= i + 4; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 6, Blocks.field_150476_ad, 2);
        }
        for (i1 = i + 6; i1 <= i + 9; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 6, Blocks.field_150476_ad, 2);
        }
        for (k1 = k + 5; k1 >= k + 3; --k1) {
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (k1 = k - 2; k1 >= k - 6; --k1) {
            this.func_150516_a(world, i + 9, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        for (i1 = i + 6; i1 <= i + 8; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 6, Blocks.field_150476_ad, 3);
        }
        this.func_150516_a(world, i + 6, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k + 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k + 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k + 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k - 4, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 6, j + 1, k - 3, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 7, j + 1, k - 3, Blocks.field_150344_f, 0);
        this.placePlate(world, i + 6, j + 2, k + 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k + 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k + 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k + 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k - 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k - 4, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 6, j + 2, k - 3, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 7, j + 2, k - 3, random, LOTRFoods.HOBBIT);
        this.func_150516_a(world, i - 5, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 5, j + 2, k - 5, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 8, j + 2, k - 1, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 8, j + 2, k + 2, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k + 5, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 3, j + 2, k + 5, Blocks.field_150478_aa, 4);
        for (i1 = i - 3; i1 <= i + 3; i1 += 2) {
            this.func_150516_a(world, i1, j + 1, k, Blocks.field_150422_aJ, 0);
        }
        for (i1 = i - 3; i1 <= i + 3; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 2, this.wallBlock, this.wallMeta);
        }
        for (k1 = k - 3; k1 >= k - 6; --k1) {
            this.func_150516_a(world, i - 3, j + 1, k1, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i + 3, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i - 3, j + 1, k - 4, Blocks.field_150396_be, 1);
        this.placeBarrel(world, random, i - 2, j + 2, k - 2, 2, this.drink);
        this.placeBarrel(world, random, i + 2, j + 2, k - 2, 2, this.drink);
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            this.placeMug(world, random, i1, j + 2, k - 2, 2, this.drink);
        }
        this.func_150516_a(world, i - 3, j + 2, k - 6, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i + 3, j + 2, k - 6, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 2, j + 1, k - 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 2, j + 1, k - 6, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i, j + 1, k - 6, this.wallBlock, this.wallMeta);
        this.placeFlowerPot(world, i, j + 2, k - 6, this.getRandomPlant(random));
        this.func_150516_a(world, i - 1, j + 1, k - 6, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i + 1, j + 1, k - 6, LOTRMod.hobbitOven, 3);
        this.func_150516_a(world, i - 5, j + 3, k - 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i, j + 3, k - 4, LOTRMod.chandelier, 3);
        this.func_150516_a(world, i + 5, j + 3, k - 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 5, j + 3, k + 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i, j + 3, k + 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 5, j + 3, k + 3, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 6, j, k + 7, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 6, j + 1, k + 7, Blocks.field_150466_ao, 3);
        this.func_150516_a(world, i - 6, j + 2, k + 7, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 7, j + 2, k + 8, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 5, j + 2, k + 8, Blocks.field_150478_aa, 3);
        this.func_150516_a(world, i - 6, j + 3, k + 8, Blocks.field_150444_as, 3);
        String[] name = LOTRNames.getRandomHobbitTavernName(random);
        TileEntity tileentity = world.func_147438_o(i - 6, j + 3, k + 8);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        this.spawnBartender(world, i, j + 1, k - 4, name);
    }

    private void generateFacingEast(World world, Random random, int i, int j, int k) {
        int k1;
        int j1;
        int i1;
        if (this.restrictions) {
            List intersectingCreatures = world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72332_a().func_72299_a((double)i, (double)j, (double)k, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0).func_72314_b(8.0, 6.0, 11.0));
            for (Object obj : intersectingCreatures) {
                ((EntityLiving)obj).func_70106_y();
            }
        }
        for (i1 = i - 7; i1 <= i + 7; ++i1) {
            for (int k12 = k - 10; k12 <= k + 10; ++k12) {
                int j12;
                for (j12 = j; !LOTRMod.isOpaque(world, i1, j12, k12) && j12 >= 0; --j12) {
                    if (Math.abs(i1 - i) == 7 && Math.abs(k12 - k) == 10) {
                        this.func_150516_a(world, i1, j12, k12, this.pillarBlock, this.pillarMeta);
                    } else if (Math.abs(i1 - i) == 7 || Math.abs(k12 - k) == 10) {
                        this.func_150516_a(world, i1, j12, k12, this.wallBlock, this.wallMeta);
                    } else {
                        this.func_150516_a(world, i1, j12, k12, Blocks.field_150346_d, 0);
                    }
                    if (world.func_147439_a(i1, j12 - 1, k12) != Blocks.field_150349_c) continue;
                    this.func_150516_a(world, i1, j12 - 1, k12, Blocks.field_150346_d, 0);
                }
                for (j12 = j + 1; j12 <= j + 3; ++j12) {
                    this.func_150516_a(world, i1, j12, k12, Blocks.field_150350_a, 0);
                }
            }
        }
        for (i1 = i - 6; i1 <= i + 6; ++i1) {
            for (int k13 = k - 9; k13 <= k + 9; ++k13) {
                this.func_150516_a(world, i1, j, k13, this.floorBlock, this.floorMeta);
            }
        }
        for (i1 = i - 7; i1 <= i + 7; ++i1) {
            for (int k14 = k - 10; k14 <= k + 10; ++k14) {
                for (int j13 = j + 1; j13 <= j + 3; ++j13) {
                    if (Math.abs(i1 - i) == 7 && Math.abs(k14 - k) == 10) {
                        this.func_150516_a(world, i1, j13, k14, this.pillarBlock, this.pillarMeta);
                        continue;
                    }
                    if (Math.abs(i1 - i) != 7 && Math.abs(k14 - k) != 10) continue;
                    this.func_150516_a(world, i1, j13, k14, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (i1 = i - 7; i1 <= i + 7; ++i1) {
            for (int k15 = k - 10; k15 <= k + 10; ++k15) {
                for (int j14 = j + 4; j14 <= j + 5; ++j14) {
                    this.func_150516_a(world, i1, j14, k15, this.wallBlock, this.wallMeta);
                }
            }
        }
        for (int l = 1; l >= 0; --l) {
            for (int i12 = i - 7 - l; i12 <= i + 7 + l; ++i12) {
                this.func_150516_a(world, i12, j + 4 + (1 - l), k - 10 - l, this.stairBlock, 2);
                this.func_150516_a(world, i12, j + 4 + (1 - l), k + 10 + l, this.stairBlock, 3);
            }
            for (int k16 = k - 9 - l; k16 <= k + 9 + l; ++k16) {
                this.func_150516_a(world, i - 7 - l, j + 4 + (1 - l), k16, this.stairBlock, 0);
                this.func_150516_a(world, i + 7 + l, j + 4 + (1 - l), k16, this.stairBlock, 1);
            }
        }
        for (i1 = i - 6; i1 <= i + 6; ++i1) {
            for (int j15 = j + 1; j15 <= j + 3; ++j15) {
                for (int k17 = k - 9; k17 <= (j15 == j + 3 ? k - 8 : k - 9); ++k17) {
                    this.func_150516_a(world, i1, j15, k17, this.wallBlock, this.wallMeta);
                }
            }
            this.func_150516_a(world, i1, j + 2, k - 8, (Block)Blocks.field_150479_bC, 0);
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            for (int j16 = j + 1; j16 <= j + 7; ++j16) {
                for (int k18 = k - 9; k18 <= k - 7; ++k18) {
                    this.func_150516_a(world, i1, j16, k18, Blocks.field_150336_V, 0);
                }
            }
        }
        for (i1 = i - 1; i1 <= i + 1; ++i1) {
            int j17;
            for (j17 = j + 1; j17 <= j + 6; ++j17) {
                this.func_150516_a(world, i1, j17, k - 8, Blocks.field_150350_a, 0);
            }
            this.func_150516_a(world, i1, j, k - 8, LOTRMod.hearth, 0);
            this.func_150516_a(world, i1, j + 1, k - 8, (Block)Blocks.field_150480_ab, 0);
            this.func_150516_a(world, i1, j + 8, k - 8, Blocks.field_150457_bL, 0);
            for (j17 = j + 1; j17 <= j + 2; ++j17) {
                this.func_150516_a(world, i1, j17, k - 7, Blocks.field_150411_aY, 0);
            }
        }
        for (i1 = i - 2; i1 <= i + 2; ++i1) {
            this.func_150516_a(world, i1, j + 7, k - 9, Blocks.field_150389_bf, 2);
            this.func_150516_a(world, i1, j + 7, k - 7, Blocks.field_150389_bf, 3);
        }
        this.func_150516_a(world, i - 2, j + 7, k - 8, Blocks.field_150389_bf, 0);
        this.func_150516_a(world, i + 2, j + 7, k - 8, Blocks.field_150389_bf, 1);
        for (j1 = j + 1; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 6, j1, k - 3, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 6, j1, k + 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 2, j1, k + 9, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 1, j1, k + 9, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 6, j1, k + 5, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i + 6, j1, k - 5, this.pillarBlock, this.pillarMeta);
        }
        for (k1 = k; k1 <= k + 2; ++k1) {
            for (int j18 = j + 2; j18 <= j + 3; ++j18) {
                this.func_150516_a(world, i - 7, j18, k1, Blocks.field_150410_aZ, 0);
            }
        }
        for (j1 = j + 2; j1 <= j + 3; ++j1) {
            this.func_150516_a(world, i - 7, j1, k - 1, this.pillarBlock, this.pillarMeta);
            this.func_150516_a(world, i - 7, j1, k + 3, this.pillarBlock, this.pillarMeta);
        }
        for (k1 = k - 2; k1 <= k + 4; ++k1) {
            this.func_150516_a(world, i - 6, j + 1, k1, Blocks.field_150476_ad, 1);
        }
        for (k1 = k + 6; k1 <= k + 9; ++k1) {
            this.func_150516_a(world, i - 6, j + 1, k1, Blocks.field_150476_ad, 1);
        }
        for (i1 = i - 5; i1 <= i - 3; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        for (i1 = i + 2; i1 <= i + 6; ++i1) {
            this.func_150516_a(world, i1, j + 1, k + 9, Blocks.field_150476_ad, 2);
        }
        for (k1 = k + 6; k1 <= k + 8; ++k1) {
            this.func_150516_a(world, i + 6, j + 1, k1, Blocks.field_150476_ad, 0);
        }
        this.func_150516_a(world, i - 4, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 4, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 3, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i - 3, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 4, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 4, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 6, Blocks.field_150344_f, 0);
        this.func_150516_a(world, i + 3, j + 1, k + 7, Blocks.field_150344_f, 0);
        this.placePlate(world, i - 4, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 4, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 3, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i - 3, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 4, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 4, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 3, j + 2, k + 6, random, LOTRFoods.HOBBIT);
        this.placePlate(world, i + 3, j + 2, k + 7, random, LOTRFoods.HOBBIT);
        this.func_150516_a(world, i + 5, j + 2, k - 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 5, j + 2, k + 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 1, j + 2, k + 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 2, j + 2, k + 8, Blocks.field_150478_aa, 4);
        this.func_150516_a(world, i - 5, j + 2, k + 5, Blocks.field_150478_aa, 1);
        this.func_150516_a(world, i - 5, j + 2, k - 3, Blocks.field_150478_aa, 1);
        for (k1 = k - 3; k1 <= k + 3; k1 += 2) {
            this.func_150516_a(world, i, j + 1, k1, Blocks.field_150422_aJ, 0);
        }
        for (k1 = k - 3; k1 <= k + 3; ++k1) {
            this.func_150516_a(world, i + 2, j + 1, k1, this.wallBlock, this.wallMeta);
        }
        for (i1 = i + 3; i1 <= i + 6; ++i1) {
            this.func_150516_a(world, i1, j + 1, k - 3, this.wallBlock, this.wallMeta);
            this.func_150516_a(world, i1, j + 1, k + 3, this.wallBlock, this.wallMeta);
        }
        this.func_150516_a(world, i + 4, j + 1, k - 3, Blocks.field_150396_be, 0);
        this.placeBarrel(world, random, i + 2, j + 2, k - 2, 5, this.drink);
        this.placeBarrel(world, random, i + 2, j + 2, k + 2, 5, this.drink);
        for (k1 = k - 1; k1 <= k + 1; ++k1) {
            this.placeMug(world, random, i + 2, j + 2, k1, 3, this.drink);
        }
        this.func_150516_a(world, i + 6, j + 2, k - 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 6, j + 2, k + 3, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i + 6, j + 1, k - 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 6, j + 1, k + 2, Blocks.field_150462_ai, 0);
        this.func_150516_a(world, i + 6, j + 1, k, this.wallBlock, this.wallMeta);
        this.placeFlowerPot(world, i + 6, j + 2, k, this.getRandomPlant(random));
        this.func_150516_a(world, i + 6, j + 1, k - 1, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i + 6, j + 1, k + 1, LOTRMod.hobbitOven, 4);
        this.func_150516_a(world, i + 3, j + 3, k - 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i + 4, j + 3, k, LOTRMod.chandelier, 3);
        this.func_150516_a(world, i + 3, j + 3, k + 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 3, j + 3, k - 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 3, j + 3, k, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 3, j + 3, k + 5, LOTRMod.chandelier, 0);
        this.func_150516_a(world, i - 7, j, k - 6, this.floorBlock, this.floorMeta);
        this.func_150516_a(world, i - 7, j + 1, k - 6, Blocks.field_150466_ao, 0);
        this.func_150516_a(world, i - 7, j + 2, k - 6, Blocks.field_150466_ao, 8);
        this.func_150516_a(world, i - 8, j + 2, k - 7, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 8, j + 2, k - 5, Blocks.field_150478_aa, 2);
        this.func_150516_a(world, i - 8, j + 3, k - 6, Blocks.field_150444_as, 4);
        String[] name = LOTRNames.getRandomHobbitTavernName(random);
        TileEntity tileentity = world.func_147438_o(i - 8, j + 3, k - 6);
        if (tileentity != null && tileentity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileentity;
            sign.field_145915_a[1] = name[0];
            sign.field_145915_a[2] = name[1];
        }
        this.spawnBartender(world, i + 4, j + 1, k, name);
    }

    private void spawnBartender(World world, int i, int j, int k, String[] tavernName) {
        LOTREntityHobbitBartender bartender = new LOTREntityHobbitBartender(world);
        bartender.func_70012_b((double)i + 0.5, j, (double)k + 0.5, 0.0f, 0.0f);
        bartender.setSpecificLocationName(tavernName[0] + " " + tavernName[1]);
        bartender.func_110161_a(null);
        world.func_72838_d((Entity)bartender);
        bartender.func_110171_b(i, j, k, 2);
    }

    private ItemStack getRandomPlant(Random random) {
        int i = random.nextInt(4);
        switch (i) {
            case 0: {
                return new ItemStack((Block)Blocks.field_150328_O);
            }
            case 1: {
                return new ItemStack((Block)Blocks.field_150327_N);
            }
            case 2: {
                return new ItemStack(LOTRMod.bluebell);
            }
            case 3: {
                return new ItemStack(LOTRMod.shireHeather);
            }
        }
        return null;
    }
}

